/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.core.sqlexpr;

import com.hp.hpl.jena.sdb.core.sqlexpr.S_Regex;
import com.hp.hpl.jena.sdb.core.sqlexpr.SqlColumn;
import com.hp.hpl.jena.sdb.core.sqlexpr.SqlConstant;
import com.hp.hpl.jena.sdb.core.sqlexpr.SqlExpr;
import com.hp.hpl.jena.sdb.core.sqlexpr.SqlExpr1;
import com.hp.hpl.jena.sdb.core.sqlexpr.SqlExpr2;
import com.hp.hpl.jena.sdb.core.sqlexpr.SqlExprVisitor;
import com.hp.hpl.jena.sdb.core.sqlexpr.SqlFunction1;
import com.hp.hpl.jena.sdb.sql.SQLUtils;
import com.hp.hpl.jena.sdb.util.RegexUtils;
import com.hp.hpl.jena.sparql.util.IndentedWriter;

public class SqlExprGenerateSQL
implements SqlExprVisitor {
    private IndentedWriter out;
    public String RegexOperator = "REGEXP";

    SqlExprGenerateSQL(IndentedWriter out) {
        this.out = out;
    }

    public void visit(SqlColumn column) {
        this.out.print((Object)column.asString());
    }

    public void visit(SqlConstant constant) {
        this.out.print((Object)constant.asSqlString());
    }

    public void visit(SqlFunction1 expr) {
        this.out.print((Object)expr.getFuncSymbol());
        this.out.print((Object)"(");
        expr.getExpr().visit(this);
        this.out.print((Object)")");
    }

    public void visit(SqlExpr1 expr) {
        this.printExpr(expr.getExpr());
        this.out.print((Object)" ");
        this.out.print((Object)expr.getExprSymbol());
    }

    public void visit(SqlExpr2 expr) {
        this.printExpr(expr.getLeft());
        this.out.print((Object)" ");
        this.out.print((Object)expr.getOpSymbol());
        this.out.print((Object)" ");
        this.printExpr(expr.getRight());
    }

    public void visit(S_Regex regex) {
        regex.getExpr().visit(this);
        String pattern = regex.getPattern();
        String patternLike = RegexUtils.regexToLike(pattern);
        if (patternLike != null) {
            this.out.print((Object)" LIKE ");
            this.out.print((Object)SQLUtils.quoteStr(patternLike));
            return;
        }
        this.out.print((Object)" ");
        this.out.print((Object)this.RegexOperator);
        this.out.print((Object)" ");
        if (regex.flags != null && !regex.flags.equals("i")) {
            this.out.print((Object)"BINARY ");
        }
        this.out.print((Object)SQLUtils.quoteStr(regex.getPattern()));
    }

    private void printExpr(SqlExpr expr) {
        boolean atomic;
        boolean bl = atomic = expr.isColumn() || expr.isConstant();
        if (!atomic) {
            this.out.print((Object)"( ");
        }
        expr.visit(this);
        if (!atomic) {
            this.out.print((Object)" )");
        }
    }
}

