/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.compiler;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sdb.compiler.OpSQL;
import com.hp.hpl.jena.sdb.compiler.QuadBlock;
import com.hp.hpl.jena.sdb.compiler.QuadBlockCompiler;
import com.hp.hpl.jena.sdb.compiler.SDBConstraint;
import com.hp.hpl.jena.sdb.compiler.SDB_QC;
import com.hp.hpl.jena.sdb.compiler.SqlBuilder;
import com.hp.hpl.jena.sdb.core.SDBRequest;
import com.hp.hpl.jena.sdb.core.ScopeEntry;
import com.hp.hpl.jena.sdb.core.sqlexpr.SqlColumn;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlNode;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlSelectBlock;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlTable;
import com.hp.hpl.jena.sdb.iterator.SetUtils;
import com.hp.hpl.jena.sdb.iterator.Stream;
import com.hp.hpl.jena.sdb.layout2.TableDescQuads;
import com.hp.hpl.jena.sdb.layout2.expr.RegexCompiler;
import com.hp.hpl.jena.sdb.shared.SDBInternalError;
import com.hp.hpl.jena.sdb.store.SQLBridge;
import com.hp.hpl.jena.sdb.store.SQLBridgeFactory;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.TransformCopy;
import com.hp.hpl.jena.sparql.algebra.op.Op1;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpDatasetNames;
import com.hp.hpl.jena.sparql.algebra.op.OpDistinct;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpLeftJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpOrder;
import com.hp.hpl.jena.sparql.algebra.op.OpProject;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.algebra.op.OpReduced;
import com.hp.hpl.jena.sparql.algebra.op.OpSlice;
import com.hp.hpl.jena.sparql.algebra.op.OpTable;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformSDB
extends TransformCopy {
    private static Log log = LogFactory.getLog(TransformSDB.class);
    private SDBRequest request;
    private QuadBlockCompiler quadBlockCompiler;
    private boolean translateConstraints = true;

    public TransformSDB(SDBRequest request, QuadBlockCompiler quadBlockCompiler) {
        this.request = request;
        this.quadBlockCompiler = quadBlockCompiler;
    }

    public Op transform(OpBGP opBGP) {
        throw new SDBInternalError("OpBGP should not appear");
    }

    public Op transform(OpQuadPattern quadPattern) {
        QuadBlock qBlk = new QuadBlock(quadPattern);
        SqlNode node = this.quadBlockCompiler.compile(qBlk);
        return new OpSQL(node, (Op)quadPattern, this.request);
    }

    public Op transform(OpJoin opJoin, Op left, Op right) {
        if (!SDB_QC.isOpSQL(left) || !SDB_QC.isOpSQL(right)) {
            return super.transform(opJoin, left, right);
        }
        SqlNode sqlLeft = ((OpSQL)left).getSqlNode();
        SqlNode sqlRight = ((OpSQL)right).getSqlNode();
        return new OpSQL(SqlBuilder.innerJoin(this.request, sqlLeft, sqlRight), (Op)opJoin, this.request);
    }

    public Op transform(OpLeftJoin opJoin, Op left, Op right) {
        Set<Var> rightOptVars;
        if (!this.request.LeftJoinTranslation) {
            return super.transform(opJoin, left, right);
        }
        if (!SDB_QC.isOpSQL(left) || !SDB_QC.isOpSQL(right)) {
            return super.transform(opJoin, left, right);
        }
        if (opJoin.getExprs() != null) {
            return super.transform(opJoin, left, right);
        }
        SqlNode sqlLeft = ((OpSQL)left).getSqlNode();
        SqlNode sqlRight = ((OpSQL)right).getSqlNode();
        Set<ScopeEntry> scopes = sqlLeft.getIdScope().findScopes();
        Set<ScopeEntry> scopes2 = Stream.toSet(Stream.filter(scopes, ScopeEntry.OptionalFilter));
        Set<Var> leftOptVars = Stream.toSet(Stream.map(scopes2, ScopeEntry.ToVar));
        Set<Var> coalesceVars = SetUtils.intersection(leftOptVars, rightOptVars = sqlRight.getIdScope().getVars());
        if (coalesceVars.size() > 0) {
            String alias = this.request.genId("M");
            SqlNode sqlNode = SqlBuilder.leftJoinCoalesce(this.request, alias, sqlLeft, sqlRight, coalesceVars);
            return new OpSQL(sqlNode, (Op)opJoin, this.request);
        }
        return new OpSQL(SqlBuilder.leftJoin(this.request, sqlLeft, sqlRight, null), (Op)opJoin, this.request);
    }

    public Op transform(OpFilter opFilter, Op op) {
        return super.transform(opFilter, op);
    }

    public Op transform(OpTable opTable) {
        if (!opTable.isJoinIdentity()) {
            log.fatal((Object)"OpTable : Not join identity");
        }
        return super.transform(opTable);
    }

    public Op transform(OpDistinct opDistinct, Op subOp) {
        if (!SDB_QC.isOpSQL(subOp)) {
            return super.transform(opDistinct, subOp);
        }
        if (!this.request.DistinctOnCLOB) {
            return super.transform(opDistinct, subOp);
        }
        OpSQL opSubSQL = (OpSQL)subOp;
        SqlNode sqlSubOp = opSubSQL.getSqlNode();
        SqlNode n = SqlSelectBlock.distinct(this.request, sqlSubOp);
        OpSQL opSQL = new OpSQL(n, (Op)opDistinct, this.request);
        opSQL.setBridge(opSubSQL.getBridge());
        return opSQL;
    }

    public Op transform(OpProject opProject, Op subOp) {
        if (!SDB_QC.isOpSQL(subOp)) {
            return super.transform(opProject, subOp);
        }
        List vars = opProject.getVars();
        return TransformSDB.doBridge(this.request, (OpSQL)subOp, vars, (Op)opProject);
    }

    private static OpSQL doBridge(SDBRequest request, OpSQL opSQL, List<Var> projectVars, Op original) {
        SqlNode sqlNode = opSQL.getSqlNode();
        SQLBridgeFactory f = request.getStore().getSQLBridgeFactory();
        SQLBridge bridge = f.create(request, sqlNode, projectVars);
        bridge.build();
        sqlNode = bridge.getSqlNode();
        opSQL = new OpSQL(sqlNode, original, request);
        opSQL.setBridge(bridge);
        opSQL.resetSqlNode(sqlNode);
        return opSQL;
    }

    public Op transform(OpSlice opSlice, Op subOp) {
        if (!this.request.LimitOffsetTranslation) {
            return super.transform(opSlice, subOp);
        }
        boolean canHandle = false;
        if (SDB_QC.isOpSQL(subOp)) {
            canHandle = true;
        } else if (SDB_QC.isOpSQL(TransformSDB.sub((Op1)TransformSDB.asProject(subOp)))) {
            return this.transformSliceProject(opSlice, (OpProject)subOp);
        }
        if (!SDB_QC.isOpSQL(subOp)) {
            return super.transform(opSlice, subOp);
        }
        return this.transformSlice(opSlice, ((OpSQL)subOp).getSqlNode());
    }

    private Op transformSlice(OpSlice opSlice, SqlNode sqlSubOp) {
        SqlNode n = SqlSelectBlock.slice(this.request, sqlSubOp, opSlice.getStart(), opSlice.getLength());
        OpSQL x = new OpSQL(n, (Op)opSlice, this.request);
        return x;
    }

    public Op transformSliceProject(OpSlice opSlice, OpProject opProject) {
        Op subOp = opProject.getSubOp();
        if (!SDB_QC.isOpSQL(subOp)) {
            return super.transform(opSlice, (Op)opProject);
        }
        SqlNode sqlSubOp = ((OpSQL)subOp).getSqlNode();
        List pv = opProject.getVars();
        SqlNode n = SqlSelectBlock.slice(this.request, sqlSubOp, opSlice.getStart(), opSlice.getLength());
        OpSQL x = new OpSQL(n, (Op)opProject, this.request);
        return new OpProject((Op)x, pv);
    }

    private SDBConstraint transformFilter(OpFilter opFilter) {
        if (!this.translateConstraints) {
            return null;
        }
        ExprList exprs = opFilter.getExprs();
        List x = exprs.getList();
        Iterator i$ = x.iterator();
        while (i$.hasNext()) {
            RegexCompiler cc = new RegexCompiler();
            Expr expr = (Expr)i$.next();
            SDBConstraint psc = cc.recognize(expr);
            if (psc == null) continue;
            return psc;
        }
        return null;
    }

    private Set<Var> getVarsInFilter(Expr expr) {
        Set vars = expr.getVarsMentioned();
        return vars;
    }

    public Op transform(OpDatasetNames opDatasetNames) {
        Node g = opDatasetNames.getGraphNode();
        if (!Var.isVar((Node)g)) {
            throw new SDBInternalError("OpDatasetNames - not a variable: " + g);
        }
        Var v = Var.alloc((Node)g);
        TableDescQuads quads = this.request.getStore().getQuadTableDesc();
        SqlTable sqlTableQ = new SqlTable(quads.getTableName());
        sqlTableQ.setIdColumnForVar(v, new SqlColumn(sqlTableQ, quads.getGraphColName()));
        SqlNode sqlNodeQ = SqlSelectBlock.distinct(this.request, sqlTableQ);
        return new OpSQL(sqlNodeQ, (Op)opDatasetNames, this.request);
    }

    public static Op sub(Op1 op) {
        return op == null ? null : op.getSubOp();
    }

    public static boolean isProject(Op op) {
        return op instanceof OpProject;
    }

    public static OpProject asProject(Op op) {
        return TransformSDB.isProject(op) ? (OpProject)op : null;
    }

    public static boolean isDistinct(Op op) {
        return op instanceof OpDistinct;
    }

    public static OpDistinct asDistinct(Op op) {
        return TransformSDB.isDistinct(op) ? (OpDistinct)op : null;
    }

    public static boolean isReduced(Op op) {
        return op instanceof OpReduced;
    }

    public static OpReduced asReduced(Op op) {
        return TransformSDB.isReduced(op) ? (OpReduced)op : null;
    }

    public static boolean isOrder(Op op) {
        return op instanceof OpOrder;
    }

    public static OpOrder asOrder(Op op) {
        return TransformSDB.isOrder(op) ? (OpOrder)op : null;
    }

    public static boolean isSlice(Op op) {
        return op instanceof OpSlice;
    }

    public static OpSlice asSlice(Op op) {
        return TransformSDB.isSlice(op) ? (OpSlice)op : null;
    }
}

