/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.compiler;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sdb.compiler.QuadBlock;
import com.hp.hpl.jena.sdb.core.SDBRequest;
import com.hp.hpl.jena.sdb.core.ScopeEntry;
import com.hp.hpl.jena.sdb.core.sqlexpr.S_Equal;
import com.hp.hpl.jena.sdb.core.sqlexpr.SqlColumn;
import com.hp.hpl.jena.sdb.core.sqlexpr.SqlExprList;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlNode;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlTable;
import com.hp.hpl.jena.sparql.core.Var;

public abstract class SlotCompiler {
    private SDBRequest request;

    public abstract SqlNode start(QuadBlock var1);

    public abstract SqlNode finish(SqlNode var1, QuadBlock var2);

    public SlotCompiler(SDBRequest request) {
        this.request = request;
    }

    protected SDBRequest getRequest() {
        return this.request;
    }

    public final void processSlot(SDBRequest request, SqlTable table, SqlExprList conditions, Node node, String colName) {
        SqlColumn thisCol = new SqlColumn(table, colName);
        if (!node.isVariable()) {
            this.constantSlot(request, node, thisCol, conditions);
            return;
        }
        Var var = Var.alloc((Node)node);
        if (table.getIdScope().hasColumnForVar(var)) {
            ScopeEntry e = table.getIdScope().findScopeForVar(var);
            SqlColumn otherCol = e.getColumn();
            S_Equal c = new S_Equal(otherCol, thisCol);
            conditions.add(c);
            c.addNote("processVar: " + node);
            return;
        }
        table.setIdColumnForVar(var, thisCol);
    }

    protected abstract void constantSlot(SDBRequest var1, Node var2, SqlColumn var3, SqlExprList var4);
}

