/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.compiler;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.SortCondition;
import com.hp.hpl.jena.sdb.SDB;
import com.hp.hpl.jena.sdb.compiler.OpSQL;
import com.hp.hpl.jena.sdb.core.SDBRequest;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlNode;
import com.hp.hpl.jena.sdb.iterator.Stream;
import com.hp.hpl.jena.sdb.iterator.Transform;
import com.hp.hpl.jena.sdb.sql.ResultSetJDBC;
import com.hp.hpl.jena.sdb.sql.SDBExceptionSQL;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDB_QC {
    private static Log log = LogFactory.getLog(SDB_QC.class);
    public static boolean fetchPrint = false;
    public static boolean PrintSQL = false;
    private static Transform<String, Var> StringToVar = new Transform<String, Var>(){

        @Override
        public Var convert(String varName) {
            return Var.alloc((String)varName);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QueryIterator exec(OpSQL opSQL, SDBRequest request, Binding binding, ExecutionContext execCxt) {
        String sqlStmtStr = SDB_QC.toSqlString(opSQL, request);
        if (PrintSQL) {
            System.out.println(sqlStmtStr);
        }
        String str = null;
        if (execCxt != null) {
            str = execCxt.getContext().getAsString(SDB.jdbcFetchSize);
        }
        int fetchSize = -1;
        if (str != null) {
            try {
                fetchSize = Integer.parseInt(str);
            }
            catch (NumberFormatException ex) {
                log.warn((Object)("Bad number for fetch size: " + str));
            }
        }
        ResultSetJDBC jdbcResultSet = request.getStore().getConnection().execQuery(sqlStmtStr, fetchSize);
        try {
            if (opSQL.getBridge() == null) {
                log.fatal((Object)"Null bridge");
            }
            QueryIterator queryIterator = opSQL.getBridge().assembleResults(jdbcResultSet, binding, execCxt);
            jdbcResultSet = null;
            return queryIterator;
        }
        catch (Throwable throwable) {
            try {
                jdbcResultSet = null;
                throw throwable;
            }
            catch (SQLException ex) {
                throw new SDBExceptionSQL("SQLException in executing SQL statement", ex);
            }
        }
    }

    public static String toSqlString(OpSQL opSQL, SDBRequest request) {
        SqlNode sqlNode = opSQL.getSqlNode();
        String sqlStmt = request.getStore().getSQLGenerator().generateSQL(request, sqlNode);
        return sqlStmt;
    }

    public static List<Var> queryOutVars(Query query2) {
        List orderConditions;
        List<Var> vars = Stream.toList(Stream.map(query2.getResultVars(), StringToVar));
        if (vars.size() == 0) {
            LogFactory.getLog(SDB_QC.class).warn((Object)"No project variables");
        }
        if ((orderConditions = query2.getOrderBy()) != null) {
            for (SortCondition sc : orderConditions) {
                Set x = sc.getExpression().getVarsMentioned();
                for (Var v : x) {
                    if (vars.contains(v)) continue;
                    vars.add(v);
                }
            }
        }
        return vars;
    }

    public static boolean isOpSQL(Op x) {
        return x instanceof OpSQL;
    }
}

