/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.compiler;

import com.hp.hpl.jena.sdb.SDB;
import com.hp.hpl.jena.sdb.Store;
import com.hp.hpl.jena.sdb.compiler.QueryCompiler;
import com.hp.hpl.jena.sdb.core.SDBRequest;
import com.hp.hpl.jena.sdb.util.StoreUtils;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.core.Substitute;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.util.Context;

public class SDBCompile {
    public static Op compile(Store store, Op op) {
        return SDBCompile.compile(store, op, null);
    }

    public static Op compile(Store store, Op op, Context context) {
        if (context == null) {
            context = SDB.getContext();
        }
        SDBRequest request = new SDBRequest(store, null, context);
        return SDBCompile.compile(store, op, null, context, request);
    }

    public static Op compile(Store store, Op op, Binding binding, Context context, SDBRequest request) {
        if (binding != null && !binding.isEmpty()) {
            op = Substitute.substitute((Op)op, (Binding)binding);
        }
        if (StoreUtils.isHSQL(store)) {
            request.LeftJoinTranslation = false;
            request.LimitOffsetTranslation = false;
        }
        if (StoreUtils.isH2(store)) {
            request.LeftJoinTranslation = false;
            request.LimitOffsetTranslation = false;
        }
        if (StoreUtils.isDerby(store)) {
            request.DistinctOnCLOB = false;
        }
        if (StoreUtils.isPostgreSQL(store)) {
            request.LimitOffsetTranslation = true;
        }
        if (StoreUtils.isMySQL(store)) {
            request.LimitOffsetTranslation = true;
        }
        if (StoreUtils.isSQLServer(store)) {
            request.DistinctOnCLOB = false;
        }
        if (StoreUtils.isOracle(store)) {
            request.DistinctOnCLOB = false;
        }
        if (StoreUtils.isDB2(store)) {
            request.DistinctOnCLOB = false;
        }
        QueryCompiler queryCompiler = store.getQueryCompilerFactory().createQueryCompiler(request);
        Op op2 = queryCompiler.compile(op);
        return op2;
    }
}

