/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.compiler;

import com.hp.hpl.jena.sdb.SDB;
import com.hp.hpl.jena.sdb.compiler.ConditionCompiler;
import com.hp.hpl.jena.sdb.compiler.OpSQL;
import com.hp.hpl.jena.sdb.compiler.QuadBlockCompiler;
import com.hp.hpl.jena.sdb.compiler.QueryCompiler;
import com.hp.hpl.jena.sdb.compiler.SDB_QC;
import com.hp.hpl.jena.sdb.compiler.TransformSDB;
import com.hp.hpl.jena.sdb.compiler.rewrite.QuadBlockRewriteCompiler;
import com.hp.hpl.jena.sdb.core.SDBRequest;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlNode;
import com.hp.hpl.jena.sdb.store.SQLBridge;
import com.hp.hpl.jena.sdb.store.SQLBridgeFactory;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVars;
import com.hp.hpl.jena.sparql.algebra.OpVisitor;
import com.hp.hpl.jena.sparql.algebra.OpVisitorBase;
import com.hp.hpl.jena.sparql.algebra.OpWalker;
import com.hp.hpl.jena.sparql.algebra.Transform;
import com.hp.hpl.jena.sparql.algebra.Transformer;
import com.hp.hpl.jena.sparql.algebra.op.OpExt;
import com.hp.hpl.jena.sparql.algebra.op.OpModifier;
import com.hp.hpl.jena.sparql.core.Var;
import java.util.ArrayList;
import java.util.Set;

public abstract class QueryCompilerMain
implements QueryCompiler {
    protected SDBRequest request;

    public QueryCompilerMain(SDBRequest request) {
        this.request = request;
    }

    public Op compile(Op op) {
        Op op2;
        QuadBlockCompiler quadCompiler = this.createQuadBlockCompiler();
        if (this.request.getContext().isTrue(SDB.useQuadRewrite)) {
            quadCompiler = new QuadBlockRewriteCompiler(this.request, quadCompiler);
        }
        TransformSDB t = new TransformSDB(this.request, quadCompiler);
        Op patternOp = op2 = Transformer.transform((Transform)t, (Op)op);
        while (patternOp instanceof OpModifier) {
            patternOp = ((OpModifier)patternOp).getSubOp();
        }
        boolean patternIsOneSQLStatement = SDB_QC.isOpSQL(patternOp);
        OpWalker.walk((Op)op2, (OpVisitor)new SqlNodesFinisher(patternIsOneSQLStatement));
        return op2;
    }

    public abstract QuadBlockCompiler createQuadBlockCompiler();

    public ConditionCompiler getConditionCompiler() {
        return null;
    }

    private class SqlNodesFinisher
    extends OpVisitorBase {
        private boolean justProjectVars;

        SqlNodesFinisher(boolean justProjectVars) {
            this.justProjectVars = justProjectVars;
        }

        public void visit(OpExt op) {
            if (!(op instanceof OpSQL)) {
                super.visit(op);
                return;
            }
            OpSQL opSQL = (OpSQL)op;
            if (opSQL.getBridge() != null) {
                return;
            }
            ArrayList<Var> projectVars = null;
            if (this.justProjectVars && QueryCompilerMain.this.request.getQuery() != null) {
                projectVars = SDB_QC.queryOutVars(QueryCompilerMain.this.request.getQuery());
            } else {
                Set tmp = OpVars.patternVars((Op)opSQL.getOriginal());
                projectVars = new ArrayList(tmp);
            }
            SqlNode sqlNode = opSQL.getSqlNode();
            SQLBridgeFactory f = QueryCompilerMain.this.request.getStore().getSQLBridgeFactory();
            SQLBridge bridge = f.create(QueryCompilerMain.this.request, sqlNode, projectVars);
            bridge.build();
            sqlNode = bridge.getSqlNode();
            opSQL.setBridge(bridge);
            opSQL.resetSqlNode(sqlNode);
        }
    }
}

