/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.compiler;

import com.hp.hpl.jena.sdb.compiler.QueryIterOpSQL;
import com.hp.hpl.jena.sdb.compiler.SDB_QC;
import com.hp.hpl.jena.sdb.core.SDBRequest;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlNode;
import com.hp.hpl.jena.sdb.store.SQLBridge;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.op.OpExt;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingRoot;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import com.hp.hpl.jena.sparql.util.NodeIsomorphismMap;

public class OpSQL
extends OpExt {
    private SqlNode sqlNode;
    private Op originalOp;
    private SQLBridge bridge = null;
    private SDBRequest request;

    public OpSQL(SqlNode sqlNode, Op original, SDBRequest request) {
        this.request = request;
        this.sqlNode = sqlNode;
        this.originalOp = original;
        this.bridge = null;
    }

    public QueryIterator eval(QueryIterator input, ExecutionContext execCxt) {
        return new QueryIterOpSQL(this, input, execCxt);
    }

    public QueryIterator exec(ExecutionContext execCxt) {
        return this.exec(BindingRoot.create(), execCxt);
    }

    public QueryIterator exec(Binding parent, ExecutionContext execCxt) {
        if (parent == null) {
            parent = BindingRoot.create();
        }
        QueryIterator qIter = SDB_QC.exec(this, this.getRequest(), parent, execCxt);
        return qIter;
    }

    public Op getOriginal() {
        return this.originalOp;
    }

    public Op effectiveOp() {
        return this.originalOp;
    }

    public int hashCode() {
        return this.sqlNode.hashCode() ^ 1;
    }

    public boolean equalTo(Op other, NodeIsomorphismMap labelMap) {
        if (!(other instanceof OpSQL)) {
            return false;
        }
        OpSQL opSQL = (OpSQL)other;
        return this.sqlNode.equals(opSQL.sqlNode);
    }

    public SDBRequest getRequest() {
        return this.request;
    }

    public void output(IndentedWriter out) {
        out.print((Object)"(");
        out.println((Object)"OpSQL --------");
        out.incIndent();
        this.sqlNode.output(out);
        out.decIndent();
        out.ensureStartOfLine();
        out.print((Object)"--------");
        out.print((Object)")");
    }

    public String toSQL() {
        return SDB_QC.toSqlString(this, this.request);
    }

    public SqlNode getSqlNode() {
        return this.sqlNode;
    }

    public void resetSqlNode(SqlNode sqlNode2) {
        this.sqlNode = sqlNode2;
    }

    public SQLBridge getBridge() {
        return this.bridge;
    }

    public void setBridge(SQLBridge bridge) {
        this.bridge = bridge;
    }

    public String getSubTag() {
        return "SQL";
    }

    public void outputArgs(IndentedWriter out, SerializationContext sCxt) {
        out.print((Object)"'''");
        this.sqlNode.output(out);
        out.print((Object)"'''");
    }
}

