/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.assembler;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.assemblers.AssemblerBase;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sdb.SDBFactory;
import com.hp.hpl.jena.sdb.StoreDesc;
import com.hp.hpl.jena.sdb.assembler.AssemblerVocab;
import com.hp.hpl.jena.sdb.assembler.BadDescriptionException;
import com.hp.hpl.jena.sdb.assembler.DatasetStoreAssembler;
import com.hp.hpl.jena.sdb.assembler.MissingException;
import com.hp.hpl.jena.sparql.util.graph.GraphUtils;

public class SDBModelAssembler
extends AssemblerBase
implements Assembler {
    DatasetStoreAssembler datasetAssem = new DatasetStoreAssembler();

    public Model open(Assembler a, Resource root, Mode mode) {
        Resource dataset = GraphUtils.getResourceValue((Resource)root, (Property)AssemblerVocab.pDataset);
        if (dataset == null) {
            throw new MissingException(root, "No dataset for model or graph");
        }
        StoreDesc storeDesc = this.datasetAssem.openStore(a, dataset, mode);
        Resource x = GraphUtils.getResourceValue((Resource)root, (Property)AssemblerVocab.pNamedGraph);
        if (x != null && !x.isURIResource()) {
            throw new BadDescriptionException(root, "Graph name not a URI: " + x);
        }
        Object g = null;
        if (x == null) {
            return SDBFactory.connectDefaultModel(storeDesc);
        }
        return SDBFactory.connectNamedModel(storeDesc, x);
    }
}

