/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb;

import com.hp.hpl.jena.assembler.assemblers.AssemblerGroup;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.sdb.SDBFactory;
import com.hp.hpl.jena.sdb.Store;
import com.hp.hpl.jena.sdb.StoreDesc;
import com.hp.hpl.jena.sdb.assembler.AssemblerVocab;
import com.hp.hpl.jena.sdb.core.SDBConstants;
import com.hp.hpl.jena.sdb.engine.QueryEngineSDB;
import com.hp.hpl.jena.sdb.modify.UpdateProcessorSDB;
import com.hp.hpl.jena.sdb.sql.SDBConnection;
import com.hp.hpl.jena.sdb.store.DatabaseType;
import com.hp.hpl.jena.sdb.store.LayoutType;
import com.hp.hpl.jena.sdb.util.DerbyUtils;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.core.assembler.AssemblerUtils;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.Symbol;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;

public class SDB {
    public static final String namespace = "http://jena.hpl.hp.com/2007/sdb#";
    public static final String symbolPrefix = "sdb";
    public static final String symbolSpace = "http://jena.hpl.hp.com/SDB/symbol#";
    public static final Symbol useQuadRewrite = SDBConstants.allocSymbol("useQuadRewrite");
    public static final Symbol unionDefaultGraph = SDBConstants.allocSymbol("unionDefaultGraph");
    public static final Symbol streamGraphAPI = SDBConstants.allocSymbol("streamGraphAPI");
    public static final Symbol jdbcStream = SDBConstants.allocSymbol("jdbcStream");
    public static final Symbol jdbcFetchSize = SDBConstants.allocSymbol("jdbcFetchSize");
    public static final Symbol annotateGeneratedSQL = SDBConstants.allocSymbol("annotateGeneratedSQL");
    private static boolean initialized;
    private static final String rdfPrefix;
    private static final String rdfsPrefix;
    private static final String owlPrefix;
    private static final String xsdPrefix = "http://www.w3.org/2001/XMLSchema#";
    protected static PrefixMapping globalPrefixMap;
    public static final String PATH = "com.hp.hpl.jena.sdb";
    public static final String NAME = "SDB";
    public static final String WEBSITE = "http://jena.sourceforge.net/";
    public static final String VERSION = "1.2.0";
    public static final String MAJOR_VERSION = "1";
    public static final String MINOR_VERSION = "2";
    public static final String VERSION_STATUS = "";
    public static final String BUILD_DATE = "2009-01-15 10:17 +0000";

    public static Context getContext() {
        return ARQ.getContext();
    }

    public static void init() {
    }

    public static void whenRequiredByAssembler(AssemblerGroup g) {
        AssemblerUtils.init();
        AssemblerVocab.register(g);
    }

    private static synchronized void initWorker() {
        if (initialized) {
            return;
        }
        initialized = true;
        ARQ.getContext().set(ARQ.filterPlacement, false);
        DerbyUtils.setDerbyPageCacheSize(10000);
        QueryEngineSDB.register();
        UpdateProcessorSDB.register();
        SDB.getContext().setIfUndef(useQuadRewrite, (Object)false);
        SDB.getContext().setIfUndef(streamGraphAPI, (Object)false);
        SDB.getContext().setIfUndef(jdbcStream, (Object)true);
        SDB.getContext().setIfUndef(annotateGeneratedSQL, (Object)true);
    }

    public static PrefixMapping getGlobalPrefixMapping() {
        return globalPrefixMap;
    }

    public static Symbol allocSymbol(String shortName) {
        if (shortName.startsWith("http://jena.hpl.hp.com/ARQ#")) {
            throw new ARQInternalErrorException("Symbol short name begins with the ARQ namespace name: " + shortName);
        }
        return Symbol.create((String)("http://jena.hpl.hp.com/ARQ#" + shortName));
    }

    public static Store createInMemoryStore() {
        SDBConnection conn = SDBFactory.createConnection("jdbc:h2:mem:", VERSION_STATUS, VERSION_STATUS);
        StoreDesc desc = new StoreDesc(LayoutType.LayoutTripleNodesHash, DatabaseType.H2);
        Store store = SDBFactory.connectStore(conn, desc);
        store.getTableFormatter().create();
        return store;
    }

    static {
        SDB.initWorker();
        initialized = false;
        rdfPrefix = RDF.getURI();
        rdfsPrefix = RDFS.getURI();
        owlPrefix = OWL.getURI();
        globalPrefixMap = new PrefixMappingImpl();
        globalPrefixMap.setNsPrefix("rdf", rdfPrefix);
        globalPrefixMap.setNsPrefix("rdfs", rdfsPrefix);
        globalPrefixMap.setNsPrefix("xsd", xsdPrefix);
        globalPrefixMap.setNsPrefix("owl", owlPrefix);
        globalPrefixMap.setNsPrefix(symbolPrefix, namespace);
    }
}

