/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.optimizer.core;

import com.hp.hpl.jena.graph.Triple;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GraphNode {
    private int oid = Integer.MIN_VALUE;
    private Triple triple = null;
    private double weight = Double.MIN_VALUE;
    private static Log log = LogFactory.getLog((Class)GraphNode.class);

    public GraphNode(int oid, Triple triple, double weight) {
        this.oid = oid;
        this.triple = triple;
        this.weight = weight;
        log.debug((Object)("Create GraphNode: " + oid + "\t" + triple.toString() + "\t" + weight));
    }

    public int oid() {
        return this.oid;
    }

    public double weight() {
        return this.weight;
    }

    public Triple triple() {
        return this.triple;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GraphNode)) {
            return false;
        }
        GraphNode node = (GraphNode)other;
        return this.triple.matches(node.triple());
    }
}

