/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.table;

import com.hp.hpl.jena.sparql.algebra.table.TableBase;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterNullIterator;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import com.hp.hpl.jena.sparql.expr.ExprList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TableN
extends TableBase {
    protected List rows = new ArrayList();
    protected List vars = new ArrayList();

    public TableN() {
    }

    public TableN(QueryIterator qIter) {
        this.materialize(qIter);
    }

    public void materialize(QueryIterator qIter) {
        while (qIter.hasNext()) {
            Binding binding = qIter.nextBinding();
            this.addBinding(binding);
        }
        qIter.close();
    }

    public void addBinding(Binding binding) {
        Iterator names = binding.vars();
        while (names.hasNext()) {
            Var v = (Var)((Object)names.next());
            if (this.vars.contains((Object)v)) continue;
            this.vars.add(v);
        }
        this.rows.add(binding);
    }

    public int size() {
        return this.rows.size();
    }

    public boolean isEmpty() {
        return this.rows.isEmpty();
    }

    public QueryIterator matchRightLeft(Binding bindingLeft, boolean includeOnNoMatch, ExprList conditions, ExecutionContext execContext) {
        ArrayList<Binding> out = new ArrayList<Binding>();
        Iterator iter = this.rows.iterator();
        while (iter.hasNext()) {
            Binding bindingRight = (Binding)iter.next();
            Binding r = TableN.merge(bindingLeft, bindingRight);
            if (r == null || conditions != null && !conditions.isSatisfied(r, execContext)) continue;
            out.add(r);
        }
        if (out.size() == 0 && includeOnNoMatch) {
            out.add(bindingLeft);
        }
        if (out.size() == 0) {
            return new QueryIterNullIterator(execContext);
        }
        return new QueryIterPlainWrapper(out.iterator(), execContext);
    }

    public QueryIterator iterator(ExecutionContext execCxt) {
        return new QueryIterPlainWrapper(this.rows.iterator(), execCxt);
    }

    public void closeTable() {
        this.rows = null;
    }

    public List getVarNames() {
        return this.vars;
    }

    public List getVars() {
        return Var.varNames(this.vars);
    }
}

