/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.xmloutput.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.xmloutput.test.TestXMLFeatures;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.regex.Pattern;

public class PrettyWriterTest
extends ModelTestBase {
    public PrettyWriterTest(String name) {
        super(name);
    }

    private void check(String filename, String regex) throws IOException {
        this.check(filename, regex, true);
    }

    private void checkNoMatch(String filename, String regex) throws IOException {
        this.check(filename, regex, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void check(String filename, String regex, boolean match) throws IOException {
        String contents = null;
        try {
            Model m = PrettyWriterTest.createMemModel();
            m.read(filename);
            StringWriter sw = new StringWriter();
            m.write((Writer)sw, "RDF/XML-ABBREV", filename);
            sw.close();
            contents = sw.toString();
            Model m2 = PrettyWriterTest.createMemModel();
            m2.read((Reader)new StringReader(contents), filename);
            PrettyWriterTest.assertTrue((boolean)m.isIsomorphicWith(m2));
            PrettyWriterTest.assertTrue((String)("Looking for /" + regex + "/ "), (match == Pattern.compile(regex, 32).matcher(contents).find() ? 1 : 0) != 0);
            contents = null;
            if (contents != null) {
                System.err.println("Incorrect contents:");
                System.err.println(contents);
            }
        }
        catch (Throwable throwable) {
            if (contents != null) {
                System.err.println("Incorrect contents:");
                System.err.println(contents);
            }
            throw throwable;
        }
    }

    public void testConsistency() throws IOException {
        this.checkNoMatch("file:testing/abbreviated/consistency.rdf", "rdf:resource");
    }

    public void testAnonDamlClass() throws IOException {
        this.check("file:testing/abbreviated/daml.rdf", "rdf:parseType=[\"']daml:collection[\"']");
    }

    public void testRDFCollection() throws IOException {
        this.check("file:testing/abbreviated/collection.rdf", "rdf:parseType=[\"']Collection[\"']");
    }

    public void testOWLPrefix() throws IOException {
    }

    public void testLi() throws IOException {
        this.check("file:testing/abbreviated/container.rdf", "<rdf:li.*<rdf:li.*<rdf:li.*<rdf:li");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test803804() {
        String sourceT = "<rdf:RDF  xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#' xmlns:rdfs='http://www.w3.org/2000/01/rdf-schema#' xmlns:owl=\"http://www.w3.org/2002/07/owl#\"> <owl:ObjectProperty rdf:about='http://example.org/foo#p'> </owl:ObjectProperty></rdf:RDF>";
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM_RULE_INF, null);
        m.read((InputStream)new ByteArrayInputStream(sourceT.getBytes()), "http://example.org/foo");
        Model m0 = ModelFactory.createModelForGraph((Graph)m.getGraph());
        TestXMLFeatures.blockLogger();
        try {
            m0.write(new OutputStream(){

                public void write(int b) throws IOException {
                }
            }, "RDF/XML-ABBREV");
        }
        finally {
            PrettyWriterTest.assertTrue((boolean)TestXMLFeatures.unblockLogger());
        }
    }
}

