/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.mem;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.TripleStore;
import com.hp.hpl.jena.mem.NodeToTriplesMapBase;
import com.hp.hpl.jena.mem.ObjectIterator;
import com.hp.hpl.jena.mem.StoreTripleIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.Iterator;

public abstract class GraphTripleStoreBase
implements TripleStore {
    protected final Graph parent;
    protected NodeToTriplesMapBase subjects;
    protected NodeToTriplesMapBase predicates;
    protected NodeToTriplesMapBase objects;

    protected GraphTripleStoreBase(Graph parent, NodeToTriplesMapBase subjects, NodeToTriplesMapBase predicates, NodeToTriplesMapBase objects) {
        this.parent = parent;
        this.subjects = subjects;
        this.objects = objects;
        this.predicates = predicates;
    }

    public void close() {
        this.objects = null;
        this.predicates = null;
        this.subjects = null;
    }

    public void add(Triple t) {
        if (this.subjects.add(t)) {
            this.predicates.add(t);
            this.objects.add(t);
        }
    }

    public void delete(Triple t) {
        if (this.subjects.remove(t)) {
            this.predicates.remove(t);
            this.objects.remove(t);
        }
    }

    public void clear() {
        this.subjects.clear();
        this.predicates.clear();
        this.objects.clear();
    }

    public int size() {
        return this.subjects.size();
    }

    public boolean isEmpty() {
        return this.subjects.isEmpty();
    }

    public ExtendedIterator listSubjects() {
        return WrappedIterator.createNoRemove(this.subjects.domain());
    }

    public ExtendedIterator listPredicates() {
        return WrappedIterator.createNoRemove(this.predicates.domain());
    }

    public ExtendedIterator listObjects() {
        return new ObjectIterator(this.objects.domain()){

            protected Iterator iteratorFor(Object y) {
                return GraphTripleStoreBase.this.objects.iteratorForIndexed(y);
            }
        };
    }

    public boolean contains(Triple t) {
        return this.subjects.containsBySameValueAs(t);
    }

    public boolean containsByEquality(Triple t) {
        return this.subjects.contains(t);
    }

    public ExtendedIterator find(TripleMatch tm) {
        Triple t = tm.asTriple();
        Node pm = t.getPredicate();
        Node om = t.getObject();
        Node sm = t.getSubject();
        if (sm.isConcrete()) {
            return new StoreTripleIterator(this.parent, this.subjects.iterator(sm, pm, om), this.subjects, this.predicates, this.objects);
        }
        if (om.isConcrete()) {
            return new StoreTripleIterator(this.parent, this.objects.iterator(om, sm, pm), this.objects, this.subjects, this.predicates);
        }
        if (pm.isConcrete()) {
            return new StoreTripleIterator(this.parent, this.predicates.iterator(pm, om, sm), this.predicates, this.subjects, this.objects);
        }
        return new StoreTripleIterator(this.parent, this.subjects.iterateAll(), this.subjects, this.predicates, this.objects);
    }
}

