/******************************************************************
 * File:        TestCapabilities.java
 * Created by:  Dave Reynolds
 * Created on:  29-Nov-2004
 * 
 * (c) Copyright 2004, 2005, 2006, 2007, 2008 Hewlett-Packard Development Company, LP
 * [See end of file]
 * $Id: TestCapabilities.java,v 1.5 2008/01/02 12:08:19 andy_seaborne Exp $
 *****************************************************************/

package com.hp.hpl.jena.reasoner.rulesys.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import com.hp.hpl.jena.reasoner.rulesys.DAMLMicroReasonerFactory;

import junit.framework.TestCase;
import junit.framework.TestSuite;

/**
 * Test harness for checking that graphs generated by the main
 * reasoners report the correct capabilities to things like the RDF writer.
 * 
 * @author <a href="mailto:der@hplb.hpl.hp.com">Dave Reynolds</a>
 * @version $Revision: 1.5 $
 */

public class TestCapabilities extends TestCase {

    /**
     * Boilerplate for junit
     */ 
    public TestCapabilities( String name ) {
        super( name ); 
    }
    
    /**
     * Boilerplate for junit.
     * This is its own test suite
     */
    public static TestSuite suite() {
        return new TestSuite( TestCapabilities.class );
    }  

    /**
     * Test capability returns.
     */
    public void testCapabilityValues() {
        Object[][] testSpec = new Object[][] {
                {ReasonerRegistry.getOWLMicroReasoner(), Boolean.TRUE},
                {ReasonerRegistry.getOWLMiniReasoner(), Boolean.TRUE},
                {ReasonerRegistry.getOWLReasoner(), Boolean.FALSE},
                {ReasonerRegistry.getDIGReasoner(), Boolean.FALSE},
                {ReasonerRegistry.getRDFSReasoner(), Boolean.TRUE},
                {ReasonerRegistry.getRDFSSimpleReasoner(), Boolean.TRUE},
                {DAMLMicroReasonerFactory.theInstance().create(null), Boolean.TRUE},
        };
        Model data = ModelFactory.createDefaultModel();
        for (int i = 0; i < testSpec.length; i++) {
            Object[] test = testSpec[i];
            Reasoner r = (Reasoner)test[0];
            Boolean safe = (Boolean)test[1];
            InfGraph ig = r.bind(data.getGraph());
            assertEquals(r.toString(), safe.booleanValue(), ig.getCapabilities().findContractSafe());
        }
    }
}


/*
    (c) Copyright 2004, 2005, 2006, 2007, 2008 Hewlett-Packard Development Company, LP
    All rights reserved.

    Redistribution and use in source and binary forms, with or without
    modification, are permitted provided that the following conditions
    are met:

    1. Redistributions of source code must retain the above copyright
       notice, this list of conditions and the following disclaimer.

    2. Redistributions in binary form must reproduce the above copyright
       notice, this list of conditions and the following disclaimer in the
       documentation and/or other materials provided with the distribution.

    3. The name of the author may not be used to endorse or promote products
       derived from this software without specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
    IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
    OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
    IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
    INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
    NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
    DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
    THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
    (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
    THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
