/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.impl;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.ReificationWrapper;
import com.hp.hpl.jena.graph.impl.SimpleEventManager;
import com.hp.hpl.jena.graph.impl.WrappedGraph;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;

public final class ReificationWrapperGraph
extends WrappedGraph {
    protected final ReificationStyle style;
    private static int count = 0;
    private int index = count++;

    public ReificationWrapperGraph(Graph base, ReificationStyle style) {
        super(base);
        this.style = style;
        this.reifier = new ReificationWrapper(this, style);
    }

    public Graph getBase() {
        return this.base;
    }

    public ExtendedIterator find(TripleMatch tm) {
        return this.find(tm.asTriple());
    }

    public ExtendedIterator find(Node s, Node p, Node o) {
        return this.find(Triple.create(s, p, o));
    }

    private ExtendedIterator find(Triple t) {
        ExtendedIterator found = this.base.find(t);
        ExtendedIterator result = this.reifier.getStyle().conceals() ? found.filterDrop(ReificationWrapper.isReificationTriple) : found;
        return SimpleEventManager.notifyingRemove(this, result);
    }

    public int size() {
        ReificationWrapper br = (ReificationWrapper)this.reifier;
        return this.base.size() - br.countConcealed();
    }

    public String toString() {
        return "<rwg " + this.index + ">";
    }
}

