/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.impl.ReificationWrapperGraph;
import com.hp.hpl.jena.graph.test.AbstractTestGraph;
import com.hp.hpl.jena.graph.test.AbstractTestReifier;
import com.hp.hpl.jena.graph.test.MetaTestGraph;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.shared.ReificationStyle;
import junit.framework.Test;
import junit.framework.TestSuite;

public class TestReificationWrapper
extends AbstractTestReifier {
    protected final Class graphClass;
    protected final ReificationStyle style;

    public TestReificationWrapper(Class graphClass, String name, ReificationStyle style) {
        super(name);
        this.graphClass = graphClass;
        this.style = style;
    }

    public static TestSuite suite() {
        TestSuite result = new TestSuite();
        result.addTest((Test)MetaTestGraph.suite(TestReificationWrapper.class, ReificationWrapperGraph.class, ReificationStyle.Standard));
        result.addTestSuite(TestReificationWrapperGraph.class);
        return result;
    }

    public Graph getGraph() {
        return this.getGraph(this.style);
    }

    public Graph getGraph(ReificationStyle style) {
        return new ReificationWrapperGraph((Graph)new GraphMem(Standard), style);
    }

    public static class TestReificationWrapperGraph
    extends AbstractTestGraph {
        public TestReificationWrapperGraph(String name) {
            super(name);
        }

        public Graph getGraph() {
            Graph base = Factory.createDefaultGraph();
            return new ReificationWrapperGraph(base, ReificationStyle.Standard);
        }
    }
}

