/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.test;

import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.ModelRDB;
import com.hp.hpl.jena.db.impl.IRDBDriver;
import com.hp.hpl.jena.db.test.TestConnection;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Selector;
import com.hp.hpl.jena.rdf.model.SimpleSelector;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.DB;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestMultiModel
extends TestCase {
    String DefModel = "DEFAULT";
    Model model = null;
    ModelRDB dmod1 = null;
    ModelRDB dmod2 = null;
    ModelRDB nmod1 = null;
    ModelRDB nmod2 = null;
    IDBConnection conn = null;
    IRDBDriver dbDriver;

    public TestMultiModel(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestMultiModel.class);
    }

    protected void setUp() throws Exception {
        this.conn = TestConnection.makeAndCleanTestConnection();
        this.dbDriver = this.conn.getDriver();
        this.model = ModelRDB.createModel((IDBConnection)this.conn);
        this.conn.getDriver().setStoreWithModel(this.DefModel);
        this.dmod1 = ModelRDB.createModel((IDBConnection)this.conn, (String)"Def_Model_1");
        this.conn.getDriver().setStoreWithModel("Def_Model_1");
        this.dmod2 = ModelRDB.createModel((IDBConnection)this.conn, (String)"Def_Model_2");
        this.conn.getDriver().setStoreWithModel(null);
        this.nmod1 = ModelRDB.createModel((IDBConnection)this.conn, (String)"Named_Model_1");
        this.conn.getDriver().setStoreWithModel("Named_Model_1");
        this.nmod2 = ModelRDB.createModel((IDBConnection)this.conn, (String)"Named_Model_2");
    }

    protected void tearDown() throws Exception {
        this.dmod1.close();
        this.dmod2.close();
        this.nmod1.close();
        this.nmod2.close();
        this.conn.cleanDB();
        this.conn.close();
        this.conn = null;
    }

    public void addToDBGraphProp(Model model, Property prop, String val) {
        StmtIterator iter = model.listStatements((Selector)new SimpleSelector(null, DB.graphName, (RDFNode)null));
        TestMultiModel.assertTrue((boolean)iter.hasNext());
        Statement stmt = iter.nextStatement();
        TestMultiModel.assertTrue((!iter.hasNext() ? 1 : 0) != 0);
        Resource graphURI = stmt.getSubject();
        Literal l = model.createLiteral(val);
        Statement s = model.createStatement(graphURI, prop, (RDFNode)l);
        model.add(s);
        TestMultiModel.assertTrue((boolean)model.contains(s));
    }

    private void addOnModel(Model model, Statement stmt) {
        model.add(stmt);
        TestMultiModel.assertTrue((boolean)model.contains(stmt));
        model.add(stmt);
        TestMultiModel.assertTrue((boolean)model.contains(stmt));
    }

    private void rmvOnModel(Model model, Statement stmt) {
        TestMultiModel.assertTrue((boolean)model.contains(stmt));
        model.remove(stmt);
        TestMultiModel.assertTrue((!model.contains(stmt) ? 1 : 0) != 0);
        model.add(stmt);
        TestMultiModel.assertTrue((boolean)model.contains(stmt));
        model.remove(stmt);
        TestMultiModel.assertTrue((!model.contains(stmt) ? 1 : 0) != 0);
    }

    private void addRemove(Statement stmt) {
        long cnt = this.model.size();
        this.addOnModel(this.model, stmt);
        this.addOnModel((Model)this.dmod1, stmt);
        this.addOnModel((Model)this.dmod2, stmt);
        this.addOnModel((Model)this.nmod1, stmt);
        this.addOnModel((Model)this.nmod2, stmt);
        TestMultiModel.assertTrue((this.model.size() == cnt + 1L ? 1 : 0) != 0);
        TestMultiModel.assertTrue((this.dmod1.size() == 1L ? 1 : 0) != 0);
        TestMultiModel.assertTrue((this.dmod2.size() == 1L ? 1 : 0) != 0);
        TestMultiModel.assertTrue((this.nmod1.size() == 1L ? 1 : 0) != 0);
        TestMultiModel.assertTrue((this.nmod2.size() == 1L ? 1 : 0) != 0);
        this.rmvOnModel((Model)this.nmod2, stmt);
        this.rmvOnModel((Model)this.nmod1, stmt);
        this.rmvOnModel((Model)this.dmod2, stmt);
        this.rmvOnModel((Model)this.dmod1, stmt);
        this.rmvOnModel(this.model, stmt);
        TestMultiModel.assertTrue((this.model.size() == cnt ? 1 : 0) != 0);
        TestMultiModel.assertTrue((this.dmod1.size() == 0L ? 1 : 0) != 0);
        TestMultiModel.assertTrue((this.dmod2.size() == 0L ? 1 : 0) != 0);
        TestMultiModel.assertTrue((this.nmod1.size() == 0L ? 1 : 0) != 0);
        TestMultiModel.assertTrue((this.nmod2.size() == 0L ? 1 : 0) != 0);
    }

    public void testAddRemoveURI() {
        Resource s = this.model.createResource("test#subject");
        Property p = this.model.createProperty("test#predicate");
        Resource o = this.model.createResource("test#object");
        this.addRemove(this.model.createStatement(s, p, (RDFNode)o));
    }

    public void testAddRemoveLiteral() {
        Resource s = this.model.createResource("test#subject");
        Property p = this.model.createProperty("test#predicate");
        Literal l = this.model.createLiteral("testLiteral");
        this.addRemove(this.model.createStatement(s, p, (RDFNode)l));
    }

    public void testSetLongObjectLenFailure() {
        try {
            int len = this.dbDriver.getLongObjectLength();
            this.dbDriver.setLongObjectLength(len / 2);
            TestMultiModel.assertTrue((boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testLongObjectLen() {
        Statement stmt;
        Literal l;
        long longLen = this.dbDriver.getLongObjectLength();
        TestMultiModel.assertTrue((longLen > 0L && longLen < 100000L ? 1 : 0) != 0);
        String base = ".";
        StringBuffer buffer = new StringBuffer(1024 + (int)longLen);
        long minLongLen = longLen - 32L;
        long maxLongLen = longLen + 32L;
        TestMultiModel.assertTrue((minLongLen > 0L ? 1 : 0) != 0);
        Resource s = this.model.createResource("test#subject");
        Property p = this.model.createProperty("test#predicate");
        while ((long)buffer.length() < minLongLen) {
            buffer.append(base);
        }
        long modelSizeBeg = this.model.size();
        while ((long)buffer.length() < maxLongLen) {
            l = this.model.createLiteral(buffer.toString());
            stmt = this.model.createStatement(s, p, (RDFNode)l);
            this.model.add(stmt);
            TestMultiModel.assertTrue((boolean)this.model.contains(stmt));
            TestMultiModel.assertTrue((boolean)stmt.getObject().equals(l));
            buffer.append(base);
        }
        TestMultiModel.assertTrue((this.model.size() == modelSizeBeg + maxLongLen - minLongLen ? 1 : 0) != 0);
        while ((long)buffer.length() > minLongLen) {
            buffer.deleteCharAt(0);
            l = this.model.createLiteral(buffer.toString());
            stmt = this.model.createStatement(s, p, (RDFNode)l);
            TestMultiModel.assertTrue((boolean)this.model.contains(stmt));
            this.model.remove(stmt);
            TestMultiModel.assertTrue((!this.model.contains(stmt) ? 1 : 0) != 0);
        }
        TestMultiModel.assertTrue((this.model.size() == modelSizeBeg ? 1 : 0) != 0);
    }

    public void testSetLongObjectLen() {
        int len = this.dbDriver.getLongObjectLength();
        int len2 = len - 2;
        try {
            this.tearDown();
            this.conn = TestConnection.makeTestConnection();
            this.dbDriver = this.conn.getDriver();
            len = this.dbDriver.getLongObjectLength();
            this.dbDriver.setLongObjectLength(len2);
            this.model = ModelRDB.createModel((IDBConnection)this.conn);
        }
        catch (Exception e) {
            TestMultiModel.assertTrue((boolean)false);
        }
        this.testLongObjectLen();
        this.model.close();
        try {
            this.conn.close();
            this.conn = TestConnection.makeTestConnection();
            this.dbDriver = this.conn.getDriver();
            TestMultiModel.assertTrue((len == this.dbDriver.getLongObjectLength() ? 1 : 0) != 0);
            this.model = ModelRDB.open((IDBConnection)this.conn);
            TestMultiModel.assertTrue((len2 == this.dbDriver.getLongObjectLength() ? 1 : 0) != 0);
        }
        catch (Exception e) {
            TestMultiModel.assertTrue((boolean)false);
        }
    }

    public void testAddRemoveHugeLiteral() {
        String base = "This is a huge string that repeats. \u00ce\u00b1\u00ce\u00b2\u00ce\u00b3\u00ce\u00b4\u00ce\u00b5 \u00ef\u00bf\u00bd \u00d7\u2018\u00d7\u2019\u00d7\u201c\u00d7\u201d \u00d8\u00a7\u00d8\u00a8\u00d8\u00a9\u00d8\u00aa\u00d8\u00ab";
        StringBuffer buffer = new StringBuffer(4096);
        while (buffer.length() < 4000) {
            buffer.append(base);
        }
        Resource s = this.model.createResource("test#subject");
        Property p = this.model.createProperty("test#predicate");
        Literal l = this.model.createLiteral(buffer.toString());
        this.addRemove(this.model.createStatement(s, p, (RDFNode)l));
    }

    public void testAddRemoveDatatype() {
        Resource s = this.model.createResource("test#subject");
        Property p = this.model.createProperty("test#predicate");
        Literal l = this.model.createTypedLiteral("stringType");
        this.addRemove(this.model.createStatement(s, p, (RDFNode)l));
    }

    public void testAddRemoveHugeDatatype() {
        String base = "This is a huge string that repeats. \u00ce\u00b1\u00ce\u00b2\u00ce\u00b3\u00ce\u00b4\u00ce\u00b5 \u00ef\u00bf\u00bd \u00d7\u2018\u00d7\u2019\u00d7\u201c\u00d7\u201d \u00d8\u00a7\u00d8\u00a8\u00d8\u00a9\u00d8\u00aa\u00d8\u00ab";
        StringBuffer buffer = new StringBuffer(4096);
        while (buffer.length() < 4000) {
            buffer.append(base);
        }
        Resource s = this.model.createResource("test#subject");
        Property p = this.model.createProperty("test#predicate");
        Literal l2 = this.model.createTypedLiteral(buffer.toString());
        this.addRemove(this.model.createStatement(s, p, (RDFNode)l2));
    }

    public void testAddRemoveBNode() {
        Resource s = this.model.createResource();
        Property p = this.model.createProperty("test#predicate");
        Resource o = this.model.createResource();
        this.addRemove(this.model.createStatement(s, p, (RDFNode)o));
    }

    public void testBNodeIdentityPreservation() {
        Resource s = this.model.createResource();
        Property p = this.model.createProperty("test#predicate");
        Resource o = this.model.createResource();
        Statement spo = this.model.createStatement(s, p, (RDFNode)o);
        Statement ops = this.model.createStatement(o, p, (RDFNode)s);
        this.model.add(spo);
        this.addRemove(ops);
        TestMultiModel.assertTrue((boolean)this.model.contains(spo));
        this.model.remove(spo);
    }
}

