/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.suites.optimizer;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.engine.optimizer.core.BasicPatternGraph;
import com.hp.hpl.jena.sparql.engine.optimizer.core.GraphNode;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.ProbabilityFactory;
import com.hp.hpl.jena.sparql.engine.optimizer.util.Constants;
import com.hp.hpl.jena.sparql.suites.optimizer.Util;
import com.hp.hpl.jena.sparql.util.Context;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestHeuristicWeightNode
extends TestCase {
    private double weight;
    private String heuristic;
    private BasicPattern pattern;
    private static Model testsM;
    private static Model graphM;
    private static Context context;
    private static final String testDataFileName = "testing/Optimizer/Test-data.n3";
    private static final String testCaseFileName = "testing/Optimizer/TestHeuristicWeightNode-manifest.n3";

    public TestHeuristicWeightNode(String title, String heuristic, BasicPattern pattern, double weight) {
        super(title);
        this.heuristic = heuristic;
        this.pattern = pattern;
        this.weight = weight;
    }

    public static void oneTimeSetUp() {
        context.set(Constants.PF, (Object)ProbabilityFactory.createDefaultModel((Model)Util.readModel(testDataFileName), null));
    }

    public static void oneTimeTearDown() {
        graphM.close();
        testsM.close();
    }

    public void runTest() {
        BasicPatternGraph graph = new BasicPatternGraph(this.pattern, Util.getHeuristic(this.heuristic, context, graphM.getGraph()));
        GraphNode node = (GraphNode)graph.getComponent(0).getNodes().iterator().next();
        TestHeuristicWeightNode.assertTrue((node.weight() == this.weight ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Test suite() {
        TestSuite ts = new TestSuite("TestHeuristicWeightNode");
        testsM = Util.readModel(testCaseFileName);
        graphM = Util.readModel(testDataFileName);
        QueryExecution qe = QueryExecutionFactory.create((String)TestHeuristicWeightNode.queryTestCases(), (Model)testsM);
        try {
            ResultSet rs = qe.execSelect();
            while (rs.hasNext()) {
                QuerySolution solution = rs.nextSolution();
                String title = solution.getLiteral("title").getLexicalForm();
                String heuristic = solution.getLiteral("heuristic").getLexicalForm();
                String node = solution.getLiteral("node").getLexicalForm();
                double weight = solution.getLiteral("weight").getDouble();
                BasicPattern pattern = TestHeuristicWeightNode.getBasicPattern(node);
                ts.addTest((Test)new TestHeuristicWeightNode(title, heuristic, pattern, weight));
            }
        }
        finally {
            qe.close();
        }
        TestSetup wrapper = new TestSetup((Test)ts){

            protected void setUp() {
                TestHeuristicWeightNode.oneTimeSetUp();
            }

            protected void tearDown() {
                TestHeuristicWeightNode.oneTimeTearDown();
            }
        };
        return wrapper;
    }

    private static BasicPattern getBasicPattern(String node) {
        BasicPattern pattern = new BasicPattern();
        String[] triple = node.split(" ");
        pattern.add(new Triple(Util.createNode(triple[0]), Util.createNode(triple[1]), Util.createNode(triple[2])));
        return pattern;
    }

    private static String queryTestCases() {
        return "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>PREFIX dc: <http://purl.org/dc/elements/1.1/>PREFIX : <http://www.w3.org/2006/03/test-description#>SELECT ?title ?heuristic ?node ?weight WHERE {?tc rdf:type :TestCase .?tc dc:title ?title .?tc :heuristic ?heuristic .?tc :node ?node .?tc :weight ?weight .}ORDER BY ASC(?title)";
    }

    static {
        context = ARQ.getContext();
    }
}

