/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.suites;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.nodevalue.XSDFuncOp;
import com.hp.hpl.jena.sparql.util.Utils;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestNodeValue
extends TestCase {
    static final double doubleAccuracy = 1.0E-8;

    public static TestSuite suite() {
        TestSuite ts = new TestSuite(TestNodeValue.class);
        ts.setName(Utils.classShortName((Class)TestNodeValue.class));
        return ts;
    }

    public void testInt1() {
        NodeValue v = NodeValue.makeInteger((long)5L);
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not an integer: " + v), (boolean)v.isInteger());
        TestNodeValue.assertFalse((String)("Is a node: " + v), (boolean)v.hasNode());
    }

    public void testInt2() {
        NodeValue v = NodeValue.makeNodeInteger((long)5L);
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not an integer: " + v), (boolean)v.isInteger());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
    }

    public void testInt3() {
        NodeValue v1 = NodeValue.makeNodeInteger((long)5L);
        NodeValue v2 = NodeValue.makeInteger((long)5L);
        TestNodeValue.assertTrue((String)("Not same integer: " + v1 + " & " + v2), (boolean)v1.getInteger().equals(v2.getInteger()));
    }

    public void testFloat1() {
        NodeValue v = NodeValue.makeFloat((float)5.0f);
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not a float: " + v), (boolean)v.isFloat());
        TestNodeValue.assertTrue((String)("Float not a double: " + v), (boolean)v.isDouble());
        TestNodeValue.assertFalse((String)("No node: " + v), (boolean)v.hasNode());
    }

    public void testFloat2() {
        NodeValue v = NodeValue.makeNodeFloat((float)5.0f);
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not a float: " + v), (boolean)v.isDouble());
        TestNodeValue.assertTrue((String)("Float not a double: " + v), (boolean)v.isDouble());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
    }

    public void testFloat3() {
        NodeValue v1 = NodeValue.makeNodeFloat((float)5.7f);
        NodeValue v2 = NodeValue.makeFloat((float)5.7f);
        TestNodeValue.assertTrue((String)("Not same float: " + v1 + " & " + v2), (v1.getFloat() == v2.getFloat() ? 1 : 0) != 0);
        TestNodeValue.assertTrue((String)("Not same float as double: " + v1 + " & " + v2), (v1.getDouble() == v2.getDouble() ? 1 : 0) != 0);
    }

    public void testDouble1() {
        NodeValue v = NodeValue.makeDouble((double)5.0);
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not a double: " + v), (boolean)v.isDouble());
        TestNodeValue.assertFalse((String)("No node: " + v), (boolean)v.hasNode());
    }

    public void testDouble2() {
        NodeValue v = NodeValue.makeNodeDouble((double)5.0);
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not a double: " + v), (boolean)v.isDouble());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
    }

    public void testDouble3() {
        NodeValue v1 = NodeValue.makeNodeDouble((double)5.7);
        NodeValue v2 = NodeValue.makeDouble((double)5.7);
        TestNodeValue.assertTrue((String)("Not same double: " + v1 + " & " + v2), (v1.getDouble() == v2.getDouble() ? 1 : 0) != 0);
    }

    public void testDecimal1() {
        NodeValue v = NodeValue.makeDecimal((BigDecimal)new BigDecimal("1.3"));
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not a double: " + v), (boolean)v.isDecimal());
        TestNodeValue.assertFalse((String)("Is a node: " + v), (boolean)v.hasNode());
    }

    public void testDecimal2() {
        NodeValue v = NodeValue.makeNodeDecimal((String)"1.3");
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not a double: " + v), (boolean)v.isDecimal());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
    }

    public void testDecimal3() {
        NodeValue v1 = NodeValue.makeDecimal((BigDecimal)new BigDecimal("1.3"));
        NodeValue v2 = NodeValue.makeNodeDecimal((String)"1.3");
        TestNodeValue.assertTrue((String)("Not same decimal: " + v1 + " & " + v2), (v1.getDecimal().compareTo(v2.getDecimal()) == 0 ? 1 : 0) != 0);
        TestNodeValue.assertEquals((String)("Not same decimal by equals: " + v1 + " & " + v2), (Object)v1, (Object)v2);
    }

    public void testDateTime1() {
        GregorianCalendar cal = new GregorianCalendar();
        ((Calendar)cal).setTimeZone(TimeZone.getTimeZone("GMT"));
        cal.setTimeInMillis(0L);
        cal.set(2005, 1, 18, 20, 39, 10);
        NodeValue v = NodeValue.makeDateTime((Calendar)cal);
        TestNodeValue.assertTrue((String)("Not a dateTime: " + v), (boolean)v.isDateTime());
        TestNodeValue.assertFalse((String)("A date: " + v), (boolean)v.isDate());
    }

    public void testDateTime2() {
        NodeValue v = NodeValue.makeNodeDateTime((String)"2005-02-18T20:39:10Z");
        TestNodeValue.assertTrue((String)("Not a dateTime: " + v), (boolean)v.isDateTime());
        TestNodeValue.assertFalse((String)("A date: " + v), (boolean)v.isDate());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
    }

    public void testDateTime3() {
        NodeValue v1 = NodeValue.makeDateTime((String)"2005-02-18T20:39:10Z");
        NodeValue v2 = NodeValue.makeNodeDateTime((String)"2005-02-18T20:39:10Z");
        TestNodeValue.assertEquals((String)"Not Calendar.equals: ", (Object)v1.getDateTime(), (Object)v2.getDateTime());
    }

    public void testDateTime4() {
        GregorianCalendar cal1 = new GregorianCalendar();
        ((Calendar)cal1).setTimeZone(TimeZone.getTimeZone("GMT"));
        cal1.setTimeInMillis(0L);
        cal1.set(2005, 1, 18, 20, 39, 10);
        NodeValue v = NodeValue.makeNode((String)"2005-02-18T20:39:10Z", (XSDDatatype)XSDDatatype.XSDdateTime);
        TestNodeValue.assertTrue((String)("Not a dateTime: " + v), (boolean)v.isDateTime());
        TestNodeValue.assertFalse((String)("A date: " + v), (boolean)v.isDate());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
        Calendar cal2 = v.getDateTime().asCalendar();
        TestNodeValue.assertEquals((String)("Not equal: " + v), (Object)cal1, (Object)cal2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDateTime5() {
        boolean b = NodeValue.VerboseWarnings;
        try {
            NodeValue.VerboseWarnings = false;
            NodeValue v = NodeValue.makeNode((String)"2005-02-18", (XSDDatatype)XSDDatatype.XSDdateTime);
            TestNodeValue.assertFalse((String)("Date!: " + v), (boolean)v.isDate());
            TestNodeValue.assertFalse((String)("Datetime!: " + v), (boolean)v.isDateTime());
        }
        finally {
            NodeValue.VerboseWarnings = b;
        }
    }

    public void testDate1() {
        GregorianCalendar cal = new GregorianCalendar();
        ((Calendar)cal).setTimeZone(TimeZone.getTimeZone("GMT"));
        cal.setTimeInMillis(0L);
        cal.set(2005, 1, 18, 0, 0, 0);
        NodeValue v = NodeValue.makeDate((Calendar)cal);
        TestNodeValue.assertTrue((String)("Not a date: " + v), (boolean)v.isDate());
        TestNodeValue.assertFalse((String)("A dateTime: " + v), (boolean)v.isDateTime());
    }

    public void testDate2() {
        NodeValue v = NodeValue.makeNodeDate((String)"2005-02-18");
        TestNodeValue.assertTrue((String)("Not a date: " + v), (boolean)v.isDate());
        TestNodeValue.assertFalse((String)("A dateTime: " + v), (boolean)v.isDateTime());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
    }

    public void testDate3() {
        NodeValue v1 = NodeValue.makeDate((String)"2005-02-18+01:00");
        NodeValue v2 = NodeValue.makeNodeDate((String)"2005-02-18+01:00");
        TestNodeValue.assertEquals((String)"Not Calendar.equals: ", (Object)v1.getDate(), (Object)v2.getDate());
    }

    public void testDate4() {
        GregorianCalendar cal1 = new GregorianCalendar();
        ((Calendar)cal1).setTimeZone(TimeZone.getTimeZone("GMT"));
        cal1.setTimeInMillis(0L);
        cal1.set(2005, 1, 18, 0, 0, 0);
        NodeValue v = NodeValue.makeNode((String)"2005-02-18Z", (XSDDatatype)XSDDatatype.XSDdate);
        TestNodeValue.assertTrue((String)("Not a date: " + v), (boolean)v.isDate());
        TestNodeValue.assertFalse((String)("A dateTime: " + v), (boolean)v.isDateTime());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
        Calendar cal2 = v.getDate().asCalendar();
        TestNodeValue.assertEquals((String)("Not equal: " + v), (Object)cal1, (Object)cal2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDate5() {
        boolean b = NodeValue.VerboseWarnings;
        try {
            NodeValue.VerboseWarnings = false;
            NodeValue v = NodeValue.makeNode((String)"2005-02-18T20:39:10Z", (XSDDatatype)XSDDatatype.XSDdate);
            TestNodeValue.assertFalse((String)("Datetime!: " + v), (boolean)v.isDateTime());
            TestNodeValue.assertFalse((String)("Date!: " + v), (boolean)v.isDate());
        }
        finally {
            NodeValue.VerboseWarnings = b;
        }
    }

    public void testNodeInt1() {
        NodeValue v = NodeValue.makeNode((String)"57", (XSDDatatype)XSDDatatype.XSDinteger);
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not an integer: " + v), (boolean)v.isInteger());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
    }

    public void testNodeInt2() {
        NodeValue v = NodeValue.makeNode((String)"57", (XSDDatatype)XSDDatatype.XSDdouble);
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not a double: " + v), (boolean)v.isDouble());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
    }

    public void testNodeInt3() {
        NodeValue v = NodeValue.makeNode((String)"57", (XSDDatatype)XSDDatatype.XSDinteger);
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not an integer: " + v), (boolean)v.isInteger());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
        String actualStr = v.asQuotedString();
        TestNodeValue.assertEquals((String)"Print form mismatch", (String)"57", (String)actualStr);
    }

    public void testNodeInt4() {
        NodeValue v = NodeValue.makeNodeInteger((long)18L);
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not an integer: " + v), (boolean)v.isInteger());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
        String actualStr = v.asQuotedString();
        TestNodeValue.assertEquals((String)"Print form mismatch", (String)"18", (String)actualStr);
    }

    public void testNodeInt5() {
        NodeValue v = NodeValue.makeNodeInteger((String)"018");
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not an integer: " + v), (boolean)v.isInteger());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
        String actualStr = v.asQuotedString();
        TestNodeValue.assertEquals((String)"Print form mismatch", (String)"018", (String)actualStr);
    }

    public void testNodeFloat1() {
        NodeValue v = NodeValue.makeNode((String)"57.0", (XSDDatatype)XSDDatatype.XSDfloat);
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not a float: " + v), (boolean)v.isFloat());
        TestNodeValue.assertTrue((String)("Not a double(float): " + v), (boolean)v.isDouble());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
        String actualStr = v.asQuotedString();
        TestNodeValue.assertEquals((String)"Print form mismatch", (String)("\"57.0\"^^<" + XSDDatatype.XSDfloat.getURI() + ">"), (String)actualStr);
    }

    public void testNodeDouble1() {
        NodeValue v = NodeValue.makeNode((String)"57.0e0", (XSDDatatype)XSDDatatype.XSDdouble);
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not a double: " + v), (boolean)v.isDouble());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
        String actualStr = v.asQuotedString();
        TestNodeValue.assertEquals((String)"Print form mismatch", (String)"57.0e0", (String)actualStr);
    }

    public void testNodeDouble2() {
        NodeValue v = NodeValue.makeNode((String)"57", (XSDDatatype)XSDDatatype.XSDdouble);
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not a double: " + v), (boolean)v.isDouble());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
        String actualStr = v.asQuotedString();
        TestNodeValue.assertEquals((String)"Print form mismatch", (String)("\"57\"^^<" + XSDDatatype.XSDdouble.getURI() + ">"), (String)actualStr);
    }

    public void testNodeDouble3() {
        NodeValue v = NodeValue.makeNode((String)"057.0e0", (XSDDatatype)XSDDatatype.XSDdouble);
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not a double: " + v), (boolean)v.isDouble());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
        String actualStr = v.asQuotedString();
        TestNodeValue.assertEquals((String)"Print form mismatch", (String)"057.0e0", (String)actualStr);
    }

    public void testNodeBool1() {
        NodeValue v = NodeValue.makeNode((String)"true", (XSDDatatype)XSDDatatype.XSDboolean);
        TestNodeValue.assertTrue((String)("Not a boolean: " + v), (boolean)v.isBoolean());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
        TestNodeValue.assertTrue((String)("Not satisfied: " + v), (boolean)v.getBoolean());
    }

    public void testNodeBool2() {
        NodeValue v = NodeValue.makeNode((String)"false", (XSDDatatype)XSDDatatype.XSDboolean);
        TestNodeValue.assertTrue((String)("Not a boolean: " + v), (boolean)v.isBoolean());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
        TestNodeValue.assertFalse((String)("Satisfied: " + v), (boolean)v.getBoolean());
    }

    public void testNodeBool3() {
        NodeValue v = NodeValue.makeBoolean((boolean)true);
        TestNodeValue.assertTrue((String)("Not a boolean: " + v), (boolean)v.isBoolean());
        TestNodeValue.assertTrue((String)("Not true: " + v), (boolean)v.getBoolean());
        TestNodeValue.assertTrue((String)("Not true: " + v), (boolean)XSDFuncOp.booleanEffectiveValue((NodeValue)v));
    }

    public void testNodeBool4() {
        NodeValue v = NodeValue.makeBoolean((boolean)false);
        TestNodeValue.assertTrue((String)("Not a boolean: " + v), (boolean)v.isBoolean());
        TestNodeValue.assertFalse((String)("Not false: " + v), (boolean)v.getBoolean());
        TestNodeValue.assertFalse((String)("Not false: " + v), (boolean)XSDFuncOp.booleanEffectiveValue((NodeValue)v));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBadLexcial1() {
        boolean b = NodeValue.VerboseWarnings;
        try {
            NodeValue.VerboseWarnings = false;
            NodeValue v = NodeValue.makeNodeInteger((String)"abc");
            TestNodeValue.assertFalse((String)("Good integer: " + v), (boolean)v.isInteger());
            TestNodeValue.assertFalse((String)("Good number: " + v), (boolean)v.isNumber());
        }
        finally {
            NodeValue.VerboseWarnings = b;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBadLexcial2() {
        boolean b = NodeValue.VerboseWarnings;
        try {
            NodeValue.VerboseWarnings = false;
            NodeValue v = NodeValue.makeNodeInteger((String)"1.8");
            TestNodeValue.assertFalse((String)("Good integer: " + v), (boolean)v.isInteger());
            TestNodeValue.assertFalse((String)("Good number: " + v), (boolean)v.isNumber());
        }
        finally {
            NodeValue.VerboseWarnings = b;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBadLexcial3() {
        boolean b = NodeValue.VerboseWarnings;
        try {
            NodeValue.VerboseWarnings = false;
            NodeValue v = NodeValue.makeDateTime((String)"2005-10-34T00:00:01Z");
            TestNodeValue.assertFalse((String)("Good date: " + v), (boolean)v.isDateTime());
        }
        finally {
            NodeValue.VerboseWarnings = b;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBadLexcial4() {
        boolean b = NodeValue.VerboseWarnings;
        try {
            String s = "2005-10-14T 09:30:23+01:00";
            NodeValue.VerboseWarnings = false;
            NodeValue v1 = NodeValue.makeDateTime((String)s);
            TestNodeValue.assertFalse((String)("Good date: " + v1), (boolean)v1.isDateTime());
            s = s.replaceAll(" ", "");
            NodeValue v2 = NodeValue.makeDateTime((String)s);
            TestNodeValue.assertTrue((String)("Bad date: " + v2), (boolean)v2.isDateTime());
        }
        finally {
            NodeValue.VerboseWarnings = b;
        }
    }

    public void testEBV1() {
        TestNodeValue.assertTrue((String)"Not a boolean", (boolean)NodeValue.TRUE.isBoolean());
        TestNodeValue.assertTrue((String)"Not true", (boolean)NodeValue.TRUE.getBoolean());
        TestNodeValue.assertTrue((String)"Not true", (boolean)XSDFuncOp.booleanEffectiveValue((NodeValue)NodeValue.TRUE));
    }

    public void testEBV2() {
        TestNodeValue.assertTrue((String)"Not a boolean", (boolean)NodeValue.FALSE.isBoolean());
        TestNodeValue.assertFalse((String)"Not false", (boolean)NodeValue.FALSE.getBoolean());
        TestNodeValue.assertFalse((String)"Not false", (boolean)XSDFuncOp.booleanEffectiveValue((NodeValue)NodeValue.FALSE));
    }

    public void testEBV3() {
        NodeValue v = NodeValue.makeInteger((long)1L);
        TestNodeValue.assertFalse((String)("It's a boolean: " + v), (boolean)v.isBoolean());
        try {
            v.getBoolean();
            TestNodeValue.fail((String)"getBoolean should fail");
        }
        catch (ExprEvalException exprEvalException) {
            // empty catch block
        }
        TestNodeValue.assertTrue((String)("Not EBV true: " + v), (boolean)XSDFuncOp.booleanEffectiveValue((NodeValue)v));
    }

    public void testEBV4() {
        NodeValue v = NodeValue.makeInteger((long)0L);
        TestNodeValue.assertFalse((String)("It's a boolean: " + v), (boolean)v.isBoolean());
        try {
            v.getBoolean();
            TestNodeValue.fail((String)"getBoolean should fail");
        }
        catch (ExprEvalException exprEvalException) {
            // empty catch block
        }
        TestNodeValue.assertFalse((String)("Not EBV false: " + v), (boolean)XSDFuncOp.booleanEffectiveValue((NodeValue)v));
    }

    public void testEBV5() {
        NodeValue v = NodeValue.makeString((String)"xyz");
        TestNodeValue.assertFalse((String)("It's a boolean: " + v), (boolean)v.isBoolean());
        try {
            v.getBoolean();
            TestNodeValue.fail((String)"getBoolean should fail");
        }
        catch (ExprEvalException exprEvalException) {
            // empty catch block
        }
        TestNodeValue.assertTrue((String)("Not EBV true: " + v), (boolean)XSDFuncOp.booleanEffectiveValue((NodeValue)v));
    }

    public void testEBV6() {
        NodeValue v = NodeValue.makeString((String)"");
        TestNodeValue.assertFalse((String)("It's a boolean: " + v), (boolean)v.isBoolean());
        try {
            v.getBoolean();
            TestNodeValue.fail((String)"getBoolean should fail");
        }
        catch (ExprEvalException exprEvalException) {
            // empty catch block
        }
        TestNodeValue.assertFalse((String)("Not EBV false: " + v), (boolean)XSDFuncOp.booleanEffectiveValue((NodeValue)v));
    }

    public void testFloatDouble1() {
        NodeValue v1 = NodeValue.makeNodeDouble((String)"1.5");
        NodeValue v2 = NodeValue.makeNode((String)"1.5", (XSDDatatype)XSDDatatype.XSDfloat);
        TestNodeValue.assertTrue((String)"Should be equal: 1.5 float and 1.5 double", (boolean)NodeValue.sameAs((NodeValue)v1, (NodeValue)v2));
    }

    public void testFloatDouble5() {
        NodeValue v1 = NodeValue.makeNodeDouble((String)"1.3");
        NodeValue v2 = NodeValue.makeNode((String)"1.3", (XSDDatatype)XSDDatatype.XSDfloat);
        TestNodeValue.assertFalse((String)"Should not be equal: 1.3 float and 1.3 double", (boolean)NodeValue.sameAs((NodeValue)v1, (NodeValue)v2));
    }

    public void testString1() {
        NodeValue v = NodeValue.makeString((String)"string");
        TestNodeValue.assertTrue((String)("Not a string: " + v), (boolean)v.isString());
        TestNodeValue.assertFalse((String)("Is a node: " + v), (boolean)v.hasNode());
    }

    public void testNodeString1() {
        NodeValue v = NodeValue.makeNode((String)"string", null, (String)null);
        TestNodeValue.assertTrue((String)("Not a string: " + v), (boolean)v.isString());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
    }

    public void testNodeString2() {
        NodeValue v = NodeValue.makeNode((String)"string", null, (String)null);
        TestNodeValue.assertTrue((String)("Not a string: " + v), (boolean)v.isString());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
        String actualStr = v.asQuotedString();
        TestNodeValue.assertEquals((String)"Print form mismatch", (String)"\"string\"", (String)actualStr);
    }

    public void testNodeString3() {
        NodeValue v = NodeValue.makeNode((String)"string", (XSDDatatype)XSDDatatype.XSDstring);
        TestNodeValue.assertTrue((String)("Not a string: " + v), (boolean)v.isString());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.hasNode());
        String actualStr = v.asQuotedString();
        TestNodeValue.assertEquals((String)"Print form mismatch", (String)("\"string\"^^<" + XSDDatatype.XSDstring.getURI() + ">"), (String)actualStr);
    }

    public void testSameValue1() {
        NodeValue nv1 = NodeValue.makeInteger((long)5L);
        NodeValue nv2 = NodeValue.makeInteger((long)7L);
        TestNodeValue.assertTrue((String)("Same values (" + nv1 + "," + nv2 + ")"), (boolean)NodeValue.notSameAs((NodeValue)nv1, (NodeValue)nv2));
        TestNodeValue.assertFalse((String)("Same values (" + nv1 + "," + nv2 + ")"), (boolean)NodeValue.sameAs((NodeValue)nv1, (NodeValue)nv2));
        NodeValue nv3 = NodeValue.makeInteger((long)5L);
        TestNodeValue.assertTrue((String)("Different values (" + nv1 + "," + nv3 + ")"), (boolean)NodeValue.sameAs((NodeValue)nv1, (NodeValue)nv3));
        TestNodeValue.assertFalse((String)("Different values - notNotSame (" + nv1 + "," + nv3 + ")"), (boolean)NodeValue.notSameAs((NodeValue)nv1, (NodeValue)nv3));
    }

    public void testSameValue2() {
        NodeValue nv1 = NodeValue.makeInteger((long)5L);
        NodeValue nv2 = NodeValue.makeNodeInteger((long)7L);
        TestNodeValue.assertTrue((String)("Same values (" + nv1 + "," + nv2 + ")"), (boolean)NodeValue.notSameAs((NodeValue)nv1, (NodeValue)nv2));
        TestNodeValue.assertFalse((String)("Same values (" + nv1 + "," + nv2 + ")"), (boolean)NodeValue.sameAs((NodeValue)nv1, (NodeValue)nv2));
        NodeValue nv3 = NodeValue.makeNodeInteger((long)5L);
        TestNodeValue.assertTrue((String)("Different values (" + nv1 + "," + nv3 + ")"), (boolean)NodeValue.sameAs((NodeValue)nv1, (NodeValue)nv3));
        TestNodeValue.assertFalse((String)("Different values - notNotSame (" + nv1 + "," + nv3 + ")"), (boolean)NodeValue.notSameAs((NodeValue)nv1, (NodeValue)nv3));
    }

    public void testSameValue3() {
        NodeValue nv1 = NodeValue.makeDecimal((String)"1.5");
        NodeValue nv2 = NodeValue.makeDecimal((String)"1.6");
        TestNodeValue.assertTrue((String)("Same values (" + nv1 + "," + nv2 + ")"), (boolean)NodeValue.notSameAs((NodeValue)nv1, (NodeValue)nv2));
        TestNodeValue.assertFalse((String)("Same values (" + nv1 + "," + nv2 + ")"), (boolean)NodeValue.sameAs((NodeValue)nv1, (NodeValue)nv2));
        NodeValue nv3 = NodeValue.makeDecimal((String)"1.50");
        TestNodeValue.assertTrue((String)("Different values (" + nv1 + "," + nv3 + ")"), (boolean)NodeValue.sameAs((NodeValue)nv1, (NodeValue)nv3));
        TestNodeValue.assertFalse((String)("Different values - notNotSame (" + nv1 + "," + nv3 + ")"), (boolean)NodeValue.notSameAs((NodeValue)nv1, (NodeValue)nv3));
    }

    public void testSameValue4() {
        NodeValue nv1 = NodeValue.makeDecimal((String)"3");
        NodeValue nv2 = NodeValue.makeInteger((long)4L);
        TestNodeValue.assertTrue((String)("Same values (" + nv1 + "," + nv2 + ")"), (boolean)NodeValue.notSameAs((NodeValue)nv1, (NodeValue)nv2));
        TestNodeValue.assertFalse((String)("Same values (" + nv1 + "," + nv2 + ")"), (boolean)NodeValue.sameAs((NodeValue)nv1, (NodeValue)nv2));
        NodeValue nv3 = NodeValue.makeInteger((long)3L);
        TestNodeValue.assertTrue((String)("Different values (" + nv1 + "," + nv3 + ")"), (boolean)NodeValue.sameAs((NodeValue)nv1, (NodeValue)nv3));
        TestNodeValue.assertFalse((String)("Different values - notNotSame (" + nv1 + "," + nv3 + ")"), (boolean)NodeValue.notSameAs((NodeValue)nv1, (NodeValue)nv3));
    }

    public void testSameValue5() {
        NodeValue nv1 = NodeValue.makeDecimal((String)"-1.5");
        NodeValue nv2 = NodeValue.makeDouble((double)1.5);
        TestNodeValue.assertTrue((String)("Same values (" + nv1 + "," + nv2 + ")"), (boolean)NodeValue.notSameAs((NodeValue)nv1, (NodeValue)nv2));
        TestNodeValue.assertFalse((String)("Same values (" + nv1 + "," + nv2 + ")"), (boolean)NodeValue.sameAs((NodeValue)nv1, (NodeValue)nv2));
        NodeValue nv3 = NodeValue.makeDouble((double)-1.5);
        TestNodeValue.assertTrue((String)("Different values (" + nv1 + "," + nv3 + ")"), (boolean)NodeValue.sameAs((NodeValue)nv1, (NodeValue)nv3));
        TestNodeValue.assertFalse((String)("Different values - notNotSame (" + nv1 + "," + nv3 + ")"), (boolean)NodeValue.notSameAs((NodeValue)nv1, (NodeValue)nv3));
    }

    public void testSameValue6() {
        NodeValue nv1 = NodeValue.makeNodeInteger((long)17L);
        NodeValue nv2 = NodeValue.makeDouble((double)34.0);
        TestNodeValue.assertTrue((String)("Same values (" + nv1 + "," + nv2 + ")"), (boolean)NodeValue.notSameAs((NodeValue)nv1, (NodeValue)nv2));
        TestNodeValue.assertFalse((String)("Same values (" + nv1 + "," + nv2 + ")"), (boolean)NodeValue.sameAs((NodeValue)nv1, (NodeValue)nv2));
        NodeValue nv3 = NodeValue.makeDouble((double)17.0);
        TestNodeValue.assertTrue((String)("Different values (" + nv1 + "," + nv3 + ")"), (boolean)NodeValue.sameAs((NodeValue)nv1, (NodeValue)nv3));
        TestNodeValue.assertFalse((String)("Different values - notNotSame (" + nv1 + "," + nv3 + ")"), (boolean)NodeValue.notSameAs((NodeValue)nv1, (NodeValue)nv3));
    }

    public void testSameValue7() {
        NodeValue nv1 = NodeValue.makeBoolean((boolean)true);
        NodeValue nv2 = NodeValue.makeString((String)"a");
        TestNodeValue.assertTrue((String)("Same values (" + nv1 + "," + nv2 + ")"), (boolean)NodeValue.notSameAs((NodeValue)nv1, (NodeValue)nv2));
        TestNodeValue.assertFalse((String)("Same values (" + nv1 + "," + nv2 + ")"), (boolean)NodeValue.sameAs((NodeValue)nv1, (NodeValue)nv2));
        NodeValue nv3 = NodeValue.makeNodeBoolean((boolean)true);
        TestNodeValue.assertTrue((String)("Different values (" + nv1 + "," + nv3 + ")"), (boolean)NodeValue.sameAs((NodeValue)nv1, (NodeValue)nv3));
        TestNodeValue.assertFalse((String)("Different values - notNotSame (" + nv1 + "," + nv3 + ")"), (boolean)NodeValue.notSameAs((NodeValue)nv1, (NodeValue)nv3));
    }

    public void testLang1() {
        Node n1 = Node.createLiteral((String)"xyz", (String)"en", null);
        NodeValue nv1 = NodeValue.makeNode((Node)n1);
        Node n2 = Node.createLiteral((String)"xyz", (String)"en", null);
        NodeValue nv2 = NodeValue.makeNode((Node)n2);
        TestNodeValue.assertTrue((boolean)NodeValue.sameAs((NodeValue)nv1, (NodeValue)nv2));
    }

    public void testLang2() {
        Node n1 = Node.createLiteral((String)"xyz", (String)"en", null);
        NodeValue nv1 = NodeValue.makeNode((Node)n1);
        Node n2 = Node.createLiteral((String)"xyz", (String)"EN", null);
        NodeValue nv2 = NodeValue.makeNode((Node)n2);
        TestNodeValue.assertTrue((boolean)NodeValue.sameAs((NodeValue)nv1, (NodeValue)nv2));
        TestNodeValue.assertFalse((boolean)nv1.equals((Object)nv2));
    }

    public void testLang3() {
        Node n1 = Node.createLiteral((String)"xyz", (String)"en", null);
        NodeValue nv1 = NodeValue.makeNode((Node)n1);
        Node n2 = Node.createLiteral((String)"xyz", (String)"en", null);
        NodeValue nv2 = NodeValue.makeNode((Node)n2);
        TestNodeValue.assertFalse((boolean)NodeValue.notSameAs((NodeValue)nv1, (NodeValue)nv2));
    }

    public void testLang4() {
        Node n1 = Node.createLiteral((String)"xyz", (String)"en", null);
        NodeValue nv1 = NodeValue.makeNode((Node)n1);
        Node n2 = Node.createLiteral((String)"xyz", (String)"EN", null);
        NodeValue nv2 = NodeValue.makeNode((Node)n2);
        TestNodeValue.assertFalse((boolean)NodeValue.notSameAs((NodeValue)nv1, (NodeValue)nv2));
        TestNodeValue.assertFalse((boolean)nv1.equals((Object)nv2));
    }

    public void testEquals1() {
        NodeValue nv1 = NodeValue.makeInteger((long)1L);
        NodeValue nv2 = NodeValue.makeInteger((long)1L);
        TestNodeValue.assertEquals((String)"Not NodeValue.equals()", (Object)nv1, (Object)nv2);
    }

    public void testEquals2() {
        NodeValue nv1 = NodeValue.makeNodeInteger((long)1L);
        NodeValue nv2 = NodeValue.makeInteger((long)1L);
        TestNodeValue.assertEquals((String)"Not NodeValue.equals()", (Object)nv1, (Object)nv2);
    }

    public void testEquals3() {
        NodeValue nv1 = NodeValue.makeInteger((long)1L);
        NodeValue nv2 = NodeValue.makeNodeInteger((long)1L);
        TestNodeValue.assertEquals((String)"Not NodeValue.equals()", (Object)nv1, (Object)nv2);
    }

    public void testEquals4() {
        NodeValue nv1 = NodeValue.makeNode((Node)Node.createURI((String)"http://example"));
        NodeValue nv2 = NodeValue.makeNode((Node)Node.createURI((String)"http://example"));
        TestNodeValue.assertEquals((String)"Not NodeValue.equals()", (Object)nv1, (Object)nv2);
    }

    public void testNotEquals1() {
        NodeValue nv1 = NodeValue.makeInteger((long)1L);
        NodeValue nv2 = NodeValue.makeInteger((long)2L);
        TestNodeValue.assertFalse((String)"NodeValue.equals()", (boolean)nv1.equals((Object)nv2));
    }

    public void testNotEquals2() {
        NodeValue nv1 = NodeValue.makeNodeInteger((long)1L);
        NodeValue nv2 = NodeValue.makeNodeString((String)"1");
        TestNodeValue.assertFalse((String)"NodeValue.equals()", (boolean)nv1.equals((Object)nv2));
    }

    public void testNotEquals3() {
        NodeValue nv1 = NodeValue.makeNode((Node)Node.createURI((String)"http://example"));
        NodeValue nv2 = NodeValue.makeNode((Node)Node.createLiteral((String)"http://example"));
        TestNodeValue.assertFalse((String)"NodeValue.equals()", (boolean)nv1.equals((Object)nv2));
    }
}

