/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.suites;

import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.sparql.lang.ParserBase;
import com.hp.hpl.jena.sparql.util.Utils;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestEsc
extends TestCase {
    public static TestSuite suite() {
        TestSuite ts = new TestSuite(TestEsc.class);
        ts.setName(Utils.classShortName((Class)TestEsc.class));
        return ts;
    }

    public void testEsc01() {
        this.execTest("x\\uabcd", "x\uabcd");
    }

    public void testEsc02() {
        this.execTest("\\uabcdx", "\uabcdx");
    }

    public void testEsc03() {
        this.execTest("1234\\uabcd1234", "1234\uabcd1234");
    }

    public void testEsc04() {
        this.execTestFail("\\X");
    }

    public void testEsc05() {
        this.execTestFail("\\Xz");
    }

    public void testEsc06() {
        this.execTestFail("a\\X");
    }

    public void testEscUni01() {
        this.execTestFail("\\uabck");
    }

    public void testEscUni02() {
        this.execTestFail("\\uab");
    }

    public void testEscUni03() {
        this.execTestFail("\\uabc");
    }

    public void testEscUni04() {
        this.execTestFail("\\ua");
    }

    public void testEscUni05() {
        this.execTestFail("\\u");
    }

    public void testEscUni06() {
        this.execTestFail("\\");
    }

    public void testEscUni07() {
        this.execTest("\\u0020", " ");
    }

    public void testEscUni08() {
        this.execTest("\\uFFFF", "\uffff");
    }

    public void testEscUni09() {
        this.execTest("\\u0000", "\u0000");
    }

    public void testEscUni10() {
        this.execTestFail("\\U0000");
    }

    public void testEscUni11() {
        this.execTestFail("\\U0000A");
    }

    public void testEscUni12() {
        this.execTestFail("\\U0000AB");
    }

    public void testEscUni13() {
        this.execTestFail("\\U0000ABC");
    }

    public void testEscUni14() {
        this.execTest("\\U0000ABCD", "\uabcd");
    }

    public void testEscUni15() {
        this.execTestFail("\\U0000");
    }

    public void testEscUni16() {
        this.execTest("\\U00000000", "\u0000");
    }

    public void testEscUni17() {
        this.execTest("x\\tx\\nx\\r", "x\tx\nx\r");
    }

    public void testEscUni18() {
        this.execTest("x\\t\\n\\r", "x\t\n\r");
    }

    private void execTestFail(String input) {
        try {
            String s = ParserBase.testUnescapeStr((String)input);
            TestEsc.fail((String)("Unescaping succeeded on " + input));
        }
        catch (QueryParseException ex) {
            return;
        }
    }

    private void execTest(String input, String outcome) {
        String result = ParserBase.testUnescapeStr((String)input);
        TestEsc.assertEquals((String)("Unescaped string does not match (" + input + ")"), (String)outcome, (String)result);
    }
}

