/*
 * Decompiled with CFR 0.152.
 */
package Rules.helper;

import Rules.helper.DomainObjectHolder;
import java.lang.reflect.Field;
import java.util.List;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;

public abstract class ReflectionHelper {
    Object[] convertArgs(List argsAsString, DomainObjectHolder holder, Class[] argTypes, Class domainObjectClass) throws IllegalAccessException {
        Object[] convertedArgs = new Object[argTypes.length];
        for (int i = 0; i < argTypes.length; ++i) {
            Object arg;
            Class targetClass = argTypes[i];
            String argText = (String)argsAsString.get(i);
            Object staticField = ReflectionHelper.findStaticField(new Class[]{targetClass, domainObjectClass}, argText);
            convertedArgs[i] = staticField != null ? staticField : (holder.containsKey(argText) ? holder.getObject(argText) : (arg = ConvertUtils.convert((String)((String)argsAsString.get(i)), (Class)argTypes[i])));
        }
        return convertedArgs;
    }

    public static String convertEnglishToCamel(String english) {
        if (english.indexOf(" ") == -1) {
            return english;
        }
        String properCase = WordUtils.capitalize((String)english);
        String titleCase = ReflectionHelper.decapitaliseFirst(properCase);
        return ReflectionHelper.removeSpaces(titleCase);
    }

    private static String removeSpaces(String titleCase) {
        return StringUtils.replace((String)titleCase, (String)" ", (String)"");
    }

    public static String decapitaliseFirst(String s) {
        char head = s.charAt(0);
        String tail = s.substring(1);
        return Character.toLowerCase(head) + tail;
    }

    static Object findStaticField(Class[] classes, String fieldName) throws IllegalArgumentException, IllegalAccessException {
        for (int i = 0; i < classes.length; ++i) {
            Object obj = ReflectionHelper.findStaticField(classes[i], fieldName);
            if (obj == null) continue;
            return obj;
        }
        return null;
    }

    public static Object findStaticField(Class clazz, String fieldName) throws IllegalArgumentException, IllegalAccessException {
        String name = ReflectionHelper.convertFieldNameSpaces(fieldName);
        Field[] fields = clazz.getFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].getName().equalsIgnoreCase(name)) continue;
            return fields[i].get(null);
        }
        return null;
    }

    static String convertFieldNameSpaces(String fieldName) {
        String name = fieldName;
        if (fieldName.indexOf(" ") != -1) {
            name = fieldName.replace(' ', '_');
        }
        return name;
    }
}

