/*
 * Decompiled with CFR 0.152.
 */
package Rules.helper;

import Rules.helper.ConvertType;
import Rules.helper.DomainObjectHolder;
import Rules.helper.MethodTextParser;
import Rules.helper.ReflectionHelper;
import Rules.helper.ReturnedObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.beanutils.ConvertUtils;

public class MethodReflectionHelper
extends ReflectionHelper {
    private Object _domainObject;

    public MethodReflectionHelper(Object obj) {
        ConvertType.setupConverters();
        this._domainObject = obj;
    }

    public ReturnedObject invokeMethod(String methodName) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method method = this.getMethod(methodName, 0);
        return new ReturnedObject(method.invoke(this._domainObject, new Object[0]));
    }

    public ReturnedObject invokeMethod(String methodName, List argsAsString, DomainObjectHolder holder) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method method = this.getMethod(methodName, argsAsString.size());
        Class[] argTypes = method.getParameterTypes();
        Object[] convertedArgs = this.convertArgs(argsAsString, holder, argTypes, this._domainObject.getClass());
        return new ReturnedObject(method.invoke(this._domainObject, convertedArgs));
    }

    public ReturnedObject invokeMethod(String methodName, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method method = this.getMethod(methodName, 1);
        Class<?> targetClass = method.getParameterTypes()[0];
        Object convertedVal = ConvertUtils.convert((String)value, targetClass);
        Object returnObj = method.invoke(this._domainObject, convertedVal);
        return new ReturnedObject(returnObj);
    }

    public ReturnedObject invokeMethodNoConversion(String methodName, Object value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method method = this.getMethod(methodName, 1);
        Object returnObj = method.invoke(this._domainObject, value);
        return new ReturnedObject(returnObj);
    }

    public ReturnedObject invokeMethodNoConversion(String methodName, Object value, int index) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method method = this.getMethod(methodName, 2);
        Class<?>[] targets = method.getParameterTypes();
        Object returnObj = targets[0] == Integer.class ? method.invoke(this._domainObject, new Integer(index), value) : method.invoke(this._domainObject, value, new Integer(index));
        return new ReturnedObject(returnObj);
    }

    public ReturnedObject invokeMethod(String methodName, String value, int index) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object returnObj;
        Method method = this.getMethod(methodName, 2);
        Class<?>[] targets = method.getParameterTypes();
        if (targets[0] == Integer.class) {
            Object convertedVal = ConvertUtils.convert((String)value, targets[1]);
            returnObj = method.invoke(this._domainObject, new Integer(index), convertedVal);
        } else {
            Object convertedVal = ConvertUtils.convert((String)value, targets[0]);
            returnObj = method.invoke(this._domainObject, convertedVal, new Integer(index));
        }
        return new ReturnedObject(returnObj);
    }

    private Method getMethod(String methodName, int parameterCount) {
        return MethodTextParser.getMethod(methodName, parameterCount, this._domainObject);
    }
}

