/*
 * Decompiled with CFR 0.152.
 */
package Rules.helper;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class DomainObjectHolder {
    private Map domainObjects = new HashMap();
    private static ThreadLocal _thread = new ThreadLocal();

    private DomainObjectHolder() {
    }

    public static DomainObjectHolder getInstance() {
        DomainObjectHolder instance = (DomainObjectHolder)_thread.get();
        if (instance == null) {
            instance = new DomainObjectHolder();
            _thread.set(instance);
        }
        return instance;
    }

    public void addObject(Object obj, String key) {
        String keyUpper = key.toUpperCase();
        if (this.domainObjects.containsKey(keyUpper)) {
            throw new IllegalArgumentException("The domain object key '" + key + "' already exists, chose another ");
        }
        this.domainObjects.put(keyUpper, obj);
    }

    public Object getObject(String key) {
        String keyUpper = key.toUpperCase();
        if (!this.domainObjects.containsKey(keyUpper)) {
            throw new IllegalArgumentException("No domain object for key '" + key + "' exists");
        }
        return this.domainObjects.get(keyUpper);
    }

    public boolean containsKey(String key) {
        String keyUpper = key.toUpperCase();
        return this.domainObjects.containsKey(keyUpper);
    }

    public void reset() {
        this.domainObjects.clear();
    }

    public Collection all() {
        return this.domainObjects.values();
    }
}

