/*
 * Decompiled with CFR 0.152.
 */
package Rules.helper;

import Rules.helper.ConstructorReflectionHelper;
import Rules.helper.DomainObjectHolder;
import Rules.helper.MethodReflectionHelper;
import Rules.helper.MethodTextParser;
import Rules.helper.ReturnedObject;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DomainObjectHandler {
    private DomainObjectHolder _holder;

    public DomainObjectHandler(DomainObjectHolder holder) {
        this._holder = holder;
    }

    public ReturnedObject callMethodFromFit(String objectKey, String methodText, String valueText) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object obj = this._holder.getObject(objectKey);
        MethodReflectionHelper helper = new MethodReflectionHelper(obj);
        List args = this.getArgumentList(methodText, valueText);
        String method = MethodReflectionHelper.convertEnglishToCamel(MethodTextParser.removeIndexText(methodText));
        return helper.invokeMethod(method, args, this._holder);
    }

    public Object constructObjectFromFit(String className, String argText) throws ClassNotFoundException, IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class<?> clazz = Class.forName(className);
        List args = this.getArgumentList(argText);
        ConstructorReflectionHelper helper = new ConstructorReflectionHelper(clazz);
        return helper.createNewInstance(args, this._holder);
    }

    List getArgumentList(String valueText) {
        ArrayList list = new ArrayList();
        String[] args = valueText.split(",");
        for (int i = 0; i < args.length; ++i) {
            this.addValueTextToArgumentList(args[i].trim(), list);
        }
        return list;
    }

    List getArgumentList(String methodText, String valueText) {
        ArrayList<String> list = new ArrayList<String>();
        if (methodText.indexOf("(") == -1) {
            this.addValueTextToArgumentList(valueText, list);
        } else {
            String[] args = MethodTextParser.getIndexValue(methodText);
            for (int i = 0; i < args.length; ++i) {
                list.add(args[i].trim());
            }
            this.addValueTextToArgumentList(valueText, list);
        }
        return list;
    }

    private void addValueTextToArgumentList(String valueText, List list) {
        if (valueText != null && !valueText.equals("")) {
            list.add(valueText.trim());
        }
    }

    private String[] appendToArray(String[] args, String valueText) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(valueText);
        list.add(Arrays.asList(args));
        return (String[])list.toArray();
    }
}

