/*
 * Decompiled with CFR 0.152.
 */
package Rules.fixture;

import Rules.fixture.AbstractRulesTestingFixture;
import Rules.helper.DomainObjectHandler;
import Rules.helper.MethodReflectionHelper;
import Rules.helper.ReflectionHelper;
import Rules.helper.ReturnedObject;
import fit.Parse;
import java.lang.reflect.InvocationTargetException;

public class Setup
extends AbstractRulesTestingFixture {
    void processRow(Parse cell) {
        String text = cell.text();
        String constructorParams = null;
        if (cell.more.more != null) {
            constructorParams = cell.more.more.text();
        }
        String className = ReflectionHelper.decapitaliseFirst(text);
        try {
            Object domainObj = null;
            if (className.indexOf(32) > 0) {
                ReturnedObject ro = (ReturnedObject)this.loadDomainObjectFromMethod(className);
                domainObj = ro.getReturnedObject();
            } else {
                domainObj = constructorParams != null && !constructorParams.trim().equals("") ? this.loadDomainObjectWithConstructor(className, constructorParams) : this.loadDomainObject(className);
            }
            this.addDomainObjectInstance(cell.more.text(), domainObj);
            super.right(cell);
            super.right(cell.more);
        }
        catch (InstantiationException e) {
            super.wrong(cell, "Unable to create new domain object.");
        }
        catch (IllegalAccessException e) {
            super.wrong(cell, "Not allowed to create new domain object.");
        }
        catch (ClassNotFoundException e) {
            super.wrong(cell, "Unable to find domain class.");
        }
        catch (IllegalArgumentException e) {
            super.wrong(cell, "Illegal argument");
        }
        catch (SecurityException e) {
            super.wrong(cell, "Security exception");
        }
        catch (InvocationTargetException e) {
            super.wrong(cell, "Invocation exception");
        }
        catch (NoSuchMethodException e) {
            super.wrong(cell, "Unable to find the method");
        }
    }

    Object loadDomainObjectFromMethod(String className) throws IllegalAccessException, InstantiationException, ClassNotFoundException, InvocationTargetException {
        String clazz = className.substring(0, className.indexOf(32));
        int startPos = className.indexOf(32);
        int endPos = className.length();
        String methodText = className.substring(startPos, endPos);
        Object domainObject = this.getDomainObjects().getObject(clazz);
        MethodReflectionHelper helper = new MethodReflectionHelper(domainObject);
        String method = MethodReflectionHelper.convertEnglishToCamel(methodText);
        return helper.invokeMethod(method);
    }

    private void addDomainObjectInstance(String text, Object domainObj) {
        this.getDomainObjects().addObject(domainObj, text);
    }

    private Object loadDomainObject(String className) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return Class.forName(className).newInstance();
    }

    private Object loadDomainObjectWithConstructor(String className, String params) throws IllegalArgumentException, SecurityException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        DomainObjectHandler handler = new DomainObjectHandler(this.getDomainObjects());
        return handler.constructObjectFromFit(className, params);
    }

    Object loadDomainObject(String className, String constructorParams) throws IllegalArgumentException, SecurityException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (constructorParams != null && !constructorParams.equals("")) {
            return this.loadDomainObjectWithConstructor(className, constructorParams);
        }
        return this.loadDomainObject(className);
    }
}

