/*
 * Decompiled with CFR 0.152.
 */
package fit;

import fit.Fixture;
import fit.Parse;
import fit.TypeAdapter;

public class ColumnFixture
extends Fixture {
    protected TypeAdapter[] columnBindings;
    protected boolean hasExecuted = false;

    public void doRows(Parse parse) {
        this.bind(parse.parts);
        super.doRows(parse.more);
    }

    public void doRow(Parse parse) {
        this.hasExecuted = false;
        try {
            this.reset();
            super.doRow(parse);
            if (!this.hasExecuted) {
                this.execute();
            }
        }
        catch (Exception exception) {
            this.exception(parse.leaf(), exception);
        }
    }

    public void doCell(Parse parse, int n) {
        TypeAdapter typeAdapter = this.columnBindings[n];
        try {
            String string = parse.text();
            if (string.equals("")) {
                this.check(parse, typeAdapter);
            } else if (typeAdapter == null) {
                this.ignore(parse);
            } else if (typeAdapter.field != null) {
                typeAdapter.set(typeAdapter.parse(string));
            } else if (typeAdapter.method != null) {
                this.check(parse, typeAdapter);
            }
        }
        catch (Exception exception) {
            this.exception(parse, exception);
        }
    }

    public void check(Parse parse, TypeAdapter typeAdapter) {
        if (!this.hasExecuted) {
            try {
                this.execute();
            }
            catch (Exception exception) {
                this.exception(parse, exception);
            }
            this.hasExecuted = true;
        }
        super.check(parse, typeAdapter);
    }

    public void reset() throws Exception {
    }

    public void execute() throws Exception {
    }

    protected void bind(Parse parse) {
        this.columnBindings = new TypeAdapter[parse.size()];
        int n = 0;
        while (parse != null) {
            String string = parse.text();
            String string2 = "()";
            try {
                this.columnBindings[n] = string.equals("") ? null : (string.endsWith(string2) ? this.bindMethod(string.substring(0, string.length() - string2.length())) : this.bindField(string));
            }
            catch (Exception exception) {
                this.exception(parse, exception);
            }
            ++n;
            parse = parse.more;
        }
    }

    protected TypeAdapter bindMethod(String string) throws Exception {
        return TypeAdapter.on((Fixture)this, this.getTargetClass().getMethod(ColumnFixture.camel(string), new Class[0]));
    }

    protected TypeAdapter bindField(String string) throws Exception {
        return TypeAdapter.on((Fixture)this, this.getTargetClass().getField(ColumnFixture.camel(string)));
    }

    protected Class getTargetClass() {
        return this.getClass();
    }
}

