/*
 * Decompiled with CFR 0.152.
 */
package eg.music;

import eg.music.Music;
import eg.music.MusicLibrary;
import eg.music.Simulator;

public class MusicPlayer {
    static Music playing = null;
    static double paused = 0.0;

    static void play(Music music) {
        if (paused == 0.0) {
            Music.status = "loading";
            double d = music == playing ? 0.3 : 2.5;
            Simulator.nextPlayStarted = Simulator.schedule(d);
        } else {
            Music.status = "playing";
            Simulator.nextPlayComplete = Simulator.schedule(paused);
            paused = 0.0;
        }
    }

    static void pause() {
        Music.status = "pause";
        if (playing != null && paused == 0.0) {
            paused = (double)(Simulator.nextPlayComplete - Simulator.time) / 1000.0;
            Simulator.nextPlayComplete = 0L;
        }
    }

    static void stop() {
        Simulator.nextPlayStarted = 0L;
        Simulator.nextPlayComplete = 0L;
        MusicPlayer.playComplete();
    }

    static double secondsRemaining() {
        if (paused != 0.0) {
            return paused;
        }
        if (playing != null) {
            return (double)(Simulator.nextPlayComplete - Simulator.time) / 1000.0;
        }
        return 0.0;
    }

    static double minutesRemaining() {
        return (double)Math.round(MusicPlayer.secondsRemaining() / 0.6) / 100.0;
    }

    static void playStarted() {
        Music.status = "playing";
        playing = MusicLibrary.looking;
        Simulator.nextPlayComplete = Simulator.schedule(MusicPlayer.playing.seconds);
    }

    static void playComplete() {
        Music.status = "ready";
        playing = null;
    }
}

