{
Author:  Prof1983 <prof1983@yandex.ru>
Created: 15.05.2011
LastMod: 09.06.2011
Version: 0.3.1
}
unit DocumAssistantMonolitBoot;

{$I Defines.inc}

interface

uses
  AssistantConsts,
  ACollections03,
  ADocuments03, ADocuments0,
  AEntities03, AEntities0,
  ARuntime03,
  ASettings03,
  AStrings03,
  ASystem03, ASystem0,
  AUI03, AUI0,
  AUISettings03,
  AUISplash03,
  AUtils03,
  APlugins03,
  AUIWorkbench03, 
  DocumUI,
  ABaseUtils;

procedure Assistant_Boot;
procedure Assistant_Init;
procedure Assistant_Run;
procedure Assistant_Done;

implementation

{$IFDEF FPC}
  {$I DocumAssistant_en.inc}
{$ELSE}
  {$I DocumAssistant_ru.inc}
{$ENDIF}

procedure Assistant_Boot;
begin
  Runtime_Boot;

  // --- Register core modules ---

  Collections_Boot;
  Plugins_Boot;
  Settings_Boot;
  System_Boot;
  UI_Boot;
  UISettings_Boot;
  Utils_Boot;

  UISplash_Boot;
  UIWorkbench_Boot;

  // --- Register DocumAssistant modules ---

  Documents_Boot;
  Entities_Boot;
  DocumUI_Boot;

  ASystem.PrepareW(ATitle, AProgramName, AProgramVersion, AProductName, AProductVersion, '', ACopyright, AUrl, ADescription, '.\Data\');
//  Plugins_Find(Runtime_GetExePath+'Plugins\');
end;

procedure Assistant_Done;
begin
  Runtime_Done;
end;

procedure Assistant_Init;
begin
  Runtime_Init;

  DocumUI_Init;

  // --- Init core modules ---

  UISplash_Init;
  UI_Init;

  UI.InitMainTrayIcon;
  UI.InitMainMenu;
  UI.InitMenus;

  UIWorkbench_Init;
  UISettings_Init;

  Documents_Init;

  Plugins_Init;
end;

procedure Assistant_Run;
var
  I: Integer;
  //J: Integer;
  //Entity: AEntityType;
  //S: string;
type
  AEntityTypeData_Type = packed record
    ParamCount: Integer;
    Param1_Type: Integer;
    Param1_Name_Len: Integer;
    Param1_Name: Char;
    Param1_DefValue: Integer;
    Param1_Tags_Count: Integer;
  end;
const
  AEntityTypeData: AEntityTypeData_Type = (
    ParamCount: 1;
    Param1_Type: 0;
    Param1_Name_Len: 0;
    Param1_Name: #0;
    Param1_DefValue: 0;
    Param1_Tags_Count: 0;
    //Data = ParamDescriptionCount ParamDescription*.
    //ParamDescriptionCount = Integer.
    //ParamDescription = ParamType ParamName ParamDefValue ParamTags.
    );
begin
  //    
  ADocuments.LoadFromFileW(Runtime_GetDataPath+'Example.adb');

  //       ( )
  I := AEntities.FindEntityById(ADescriptTypeId);
  if (I < 0) then
  begin
    I := AEntities.AddEntityA(ADescriptTypeId, ADescriptTypeId, Addr(AEntityTypeData), SizeOf(AEntityTypeData));
    if (I < 0) then
    begin
      Runtime_ShowMessage('     1');
      Exit;
    end;
  end;

  // --    --
  {
  //Runtime_ShowMessage('- : '+Utils_IntToStr(Entities_Count));
  for I := 0 to Entities_Count - 1 do
  begin
    if not(Entities_GetEntityByIndex(I, Entity)) then
    begin
      Runtime_ShowMessage(' ');
      Exit;
    end;
    S := '';
    for J := 0 to Entity.DataSize - 1 do
      S := S + ' ' + ByteToHex(Byte(Pointer(Integer(Entity.Data) + J)^));
    Runtime_ShowMessage(' '+Utils_IntToStr(I)+#13#10+
        'ID: '+Utils_IntToStr(Entity.ID)+#13#10+
        'Type: '+Utils_IntToStr(Entity.Typ)+#13#10+
        'DataSize: '+Utils_IntToStr(Entity.DataSize)+#13#10+
        'Data: '+S);
  end;
  }

  //      
  DocumUI_Refresh;

  Runtime_Run;
  //  
  ADocuments.SaveToFileW(Runtime_GetDataPath+'Example.adb');
end;

end.
 
