{
Author:  Prof1983 <prof1983@yandex.ru>
Created: 30.09.2009
LastMod: 09.06.2011
Version: 0.3.1
}
unit AUtils03;

interface

uses
  ABase0, ABaseUtils, ARuntime0, AUtils0, AStrings0, ASystem0, AUtils, AUtilsExp;

//    
function A_Utils_FloatToStr(Value: AFloat; out Res: AString_Type): AInteger; stdcall;
//     c    
function A_Utils_FloatToStrA(Value: AFloat; Digits: Integer {= 2}; out Res: AString_Type): AInteger; stdcall;
//         (SQL).  SQL   - .
function A_Utils_FloatToStrB(Value: AFloat; Digits: Integer {= 2}; out Res: AString_Type): AInteger; stdcall;
function A_Utils_FloatToStrC(Value: AFloat; Digits: Integer {= 2}; out Res: AString_Type): AInteger; stdcall;
function A_Utils_FloatToStrD(Value: AFloat; out Res: AString_Type): AInteger; stdcall;
function A_Utils_NormalizeFloat(Value: AFloat): AFloat; stdcall;
//       #
function A_Utils_NormalizeStr(const Value: AString_Type; out Res: AString_Type): AInteger; stdcall;
//       ,   #13#10    
function A_Utils_NormalizeStrSpace(const Value: AString_Type; out Res: AString_Type): AInteger; stdcall;

{               .
    DecimalSeparator ,    . }
function A_Utils_ReplaceComma(const S: AString_Type; DecimalSeparator: AChar {= #0};
    ClearSpace: ABoolean {= True}; out Res: AString_Type): AInteger; stdcall;
function A_Utils_StrToFloat1(const S: AString_Type; DefValue: AFloat = 0): AFloat; stdcall;
function A_Utils_StrToInt1(const S: AString_Type; DefValue: AInteger = 0): AInteger; stdcall;
function A_Utils_TryStrToFloat32(const S: AString_Type; var Value: AFloat32): ABoolean; stdcall;
function A_Utils_TryStrToFloat64(const S: AString_Type; var Value: AFloat64): ABoolean; stdcall;
function A_Utils_FileExists(const FileName: AString_Type): ABoolean; stdcall;
procedure A_Utils_Sleep(Milliseconds: AUInt); stdcall;
function A_Utils_Time_Now: TDateTime; stdcall;
function A_Utils_IntToStr(Value: AInteger; out Res: AString_Type): AInteger; stdcall;
function A_Utils_StrToFloat(const Value: AString_Type): AFloat; stdcall;
function A_Utils_StrToInt(const Value: AString_Type): AInteger; stdcall;
function A_Utils_ExtractFilePath(const FileName: AString_Type; out Res: AString_Type): AInteger; stdcall;
//   Base   Exponent
function A_Utils_Power(Base, Exponent: AFloat): AFloat; stdcall;
function A_Utils_TryStrToDate(const S: AString_Type; var Value: TDateTime): ABoolean; stdcall;
function A_Utils_TryStrToFloat(const S: AString_Type; var Value: AFloat): ABoolean; stdcall;
function A_Utils_TryStrToInt(const S: AString_Type; var Value: AInteger): ABoolean; stdcall;

function A_Utils_ExtractFileExt(const FileName: AString_Type; out Res: AString_Type): AInteger; stdcall;
{ Trims leading and trailing spaces and control characters from a string.
       }
function A_Utils_Trim(const S: AString_Type; out Res: AString_Type): AInteger; stdcall;
function A_Utils_UpperString(const S: AString_Type; out Res: AString_Type): AInteger; stdcall;
function A_Utils_FormatFloat(Value: AFloat; Count, Digits: AInteger; out Res: AString_Type): AInteger; stdcall;
function A_Utils_FormatInt(Value, Count: AInteger; out Res: AString_Type): AInteger; stdcall;
function A_Utils_FormatStr(const Value: AString_Type; Len: AInteger; out Res: AString_Type): AInteger; stdcall;
function A_Utils_StrToDate(const Value: AString_Type): TDateTime; stdcall;

{ Module }

function Utils_Boot: AInteger; stdcall;
function Utils_Init: AInteger; stdcall;
function Utils_Done: AInteger; stdcall;

implementation

const
  UtilsProcs: AUtilsProcs_Type = (
    FloatToStrA: Utils_FloatToStrA;
    FloatToStrB: Utils_FloatToStrB;
    FloatToStrC: Utils_FloatToStrC;
    FloatToStrD: Utils_FloatToStrD;
    NormalizeFloat: Utils_NormalizeFloat;
    NormalizeStr: Utils_NormalizeStr;

    FileExists: Utils_FileExists;
    Sleep: Utils_Sleep;
    Time_Now: Utils_Time_Now;
    IntToStr: Utils_IntToStr;
    StrToFloat: Utils_StrToFloat;
    StrToInt: Utils_StrToInt;
    ExtractFilePath: Utils_ExtractFilePath;
    Power: Utils_Power;
    ReplaceComma: Utils_ReplaceComma;
    StrToFloat1: Utils_StrToFloat1;
    StrToInt1: Utils_StrToInt1;
    TryStrToFloat: Utils_TryStrToFloat;
    TryStrToFloat32: Utils_TryStrToFloat32;
    TryStrToFloat64: Utils_TryStrToFloat64;
    TryStrToDate: Utils_TryStrToDate;
    TryStrToInt: Utils_TryStrToInt;

    FloatToStr: Utils_FloatToStr;
    Trim: Utils_Trim;
    UpperString: Utils_UpperString;
    ExtractFileExt: Utils_ExtractFileExt;

    FormatFloat: Utils_FormatFloat;
    FormatInt: Utils_FormatInt;
    StrToDate: Utils_StrToDate;

    FormatStr: Utils_FormatStr;
    Reserved30: 0; //Strings_Add: Strings_Add;
    Reserved31: 0; //Strings_Clear: Strings_Clear;

    Reserved32: 0;
    Reserved33: 0;
    Reserved34: 0;
    Reserved35: 0;
    Reserved36: 0;
    Reserved37: 0;
    Reserved38: 0;
    Reserved39: 0;
    Reserved40: 0;
    Reserved41: 0;
    Reserved42: 0;
    Reserved43: 0;
    Reserved44: 0;
    Reserved45: 0;
    Reserved46: 0;
    Reserved47: 0;

    Reserved48: 0;
    Reserved49: 0;
    Reserved50: 0;
    Reserved51: 0;
    Reserved52: 0;
    Reserved53: 0;
    Reserved54: 0;
    Reserved55: 0;
    Reserved56: 0;
    Reserved57: 0;
    Reserved58: 0;
    Reserved59: 0;
    Reserved60: 0;
    Reserved61: 0;
    Reserved62: 0;
    Reserved63: 0;
    );

const
  Module: AModule_Type = (
    Version: AUtils_Version;
    Uid: AUtils_Uid;
    Name: AUtils_Name;
    Description: nil;
    Init: Utils_Init;
    Done: Utils_Done;
    Reserved06: 0;
    Procs: Addr(UtilsProcs);
    );

var
  FInitialized: Boolean;

{ Utils }

function A_Utils_ExtractFileExt(const FileName: AString_Type; out Res: AString_Type): AInteger; stdcall;
begin
  try
    Result := AStrings.String_AssignW(Res,
        Utils_ExtractFileExt(AStrings.String_ToWideString(FileName))
        );
  except
    Result := 0;
  end;
end;

function A_Utils_ExtractFilePath(const FileName: AString_Type; out Res: AString_Type): AInteger; stdcall;
begin
  try
    Result := AStrings.String_AssignW(Res,
        Utils_ExtractFilePath(AStrings.String_ToWideString(FileName))
        );
  except
    Result := 0;
  end;
end;

function A_Utils_FileExists(const FileName: AString_Type): ABoolean; stdcall;
begin
  try
    Result := Utils_FileExists(AStrings.String_ToWideString(FileName));
  except
    Result := False;
  end;
end;

function A_Utils_FloatToStr(Value: AFloat; out Res: AString_Type): AInteger; stdcall;
begin
  try
    Result := AStrings.String_AssignW(Res, Utils_FloatToStr(Value));
  except
    Result := 0;
  end;
end;

function A_Utils_FloatToStrA(Value: AFloat; Digits: AInteger {= 2}; out Res: AString_Type): AInteger; stdcall;
begin
  try
    Result := AStrings.String_AssignW(Res, Utils_FloatToStrA(Value, Digits));
  except
    Result := 0;
  end;
end;

function A_Utils_FloatToStrB(Value: AFloat; Digits: AInteger; out Res: AString_Type): AInteger; stdcall;
begin
  try
    Result := AStrings.String_AssignW(Res, Utils_FloatToStrB(Value, Digits));
  except
    Result := 0;
  end;
end;

function A_Utils_FloatToStrC(Value: AFloat; Digits: AInteger; out Res: AString_Type): AInteger; stdcall;
begin
  try
    Result := AStrings.String_AssignW(Res, Utils_FloatToStrC(Value, Digits));
  except
    Result := 0;
  end;
end;

function A_Utils_FloatToStrD(Value: AFloat; out Res: AString_Type): AInteger; stdcall;
begin
  try
    Result := AStrings.String_AssignW(Res, Utils_FloatToStrD(Value));
  except
    Result := 0;
  end;
end;

function A_Utils_FormatFloat(Value: AFloat; Count, Digits: AInteger; out Res: AString_Type): AInteger; stdcall;
begin
  try
    Result := AStrings.String_AssignW(Res, Utils_FormatFloat(Value, Count, Digits));
  except
    Result := 0;
  end;
end;

function A_Utils_FormatInt(Value, Count: AInteger; out Res: AString_Type): AInteger; stdcall;
begin
  try
    Result := AStrings.String_AssignW(Res, Utils_FormatInt(Value, Count));
  except
    Result := 0;
  end;
end;

function A_Utils_FormatStr(const Value: AString_Type; Len: AInteger; out Res: AString_Type): AInteger; stdcall;
begin
  try
    Result := AStrings.String_AssignW(Res,
        Utils_FormatStr(AStrings.String_ToWideString(Value), Len)
        );
  except
    Result := 0;
  end;
end;

function A_Utils_IntToStr(Value: AInteger; out Res: AString_Type): AInteger; stdcall;
begin
  try
    Result := AStrings.String_AssignW(Res, Utils_IntToStr(Value));
  except
    Result := 0;
  end;
end;

function A_Utils_NormalizeFloat(Value: AFloat): AFloat; stdcall;
begin
  try
    Result := Utils_StrToFloat(Utils_FloatToStrA(Value));
  except
    Result := 0;
  end;
end;

function A_Utils_NormalizeStr(const Value: AString_Type; out Res: AString_Type): AInteger; stdcall;
begin
  try
    Result := AStrings.String_AssignW(Res,
        Utils_NormalizeStr(AStrings.String_ToWideString(Value))
        );
  except
    Result := 0;
  end;
end;

function A_Utils_NormalizeStrSpace(const Value: AString_Type; out Res: AString_Type): AInteger; stdcall;
begin
  try
    Result := AStrings.String_AssignW(Res,
        Utils_NormalizeStrSpace(AStrings.String_ToWideString(Value))
        );
  except
    Result := 0;
  end;
end;

function A_Utils_Power(Base, Exponent: AFloat): AFloat; stdcall;
begin
  Result := Exp(Exponent * Ln(Base));
end;

function A_Utils_ReplaceComma(const S: AString_Type; DecimalSeparator: AChar;
    ClearSpace: ABoolean; out Res: AString_Type): AInteger; stdcall;
begin
  try
    Result := AStrings.String_AssignW(Res,
        Utils_ReplaceComma(AStrings.String_ToWideString(S), DecimalSeparator, ClearSpace)
        );
  except
    Result := 0;
  end;
end;

procedure A_Utils_Sleep(Milliseconds: AUInt); stdcall;
begin
  try
    Utils_Sleep(Milliseconds);
  except
  end;
end;

function A_Utils_StrToDate(const Value: AString_Type): TDateTime; stdcall;
begin
  try
    Result := Utils_StrToDate(AStrings.String_ToWideString(Value));
  except
    Result := 0;
  end;
end;

function A_Utils_StrToFloat(const Value: AString_Type): AFloat; stdcall;
begin
  try
    Result := Utils_StrToFloat(AStrings.String_ToWideString(Value));
  except
    Result := 0;
  end;
end;

function A_Utils_StrToFloat1(const S: AString_Type; DefValue: AFloat): AFloat; stdcall;
begin
  try
    Result := Utils_StrToFloat1(AStrings.String_ToWideString(S), DefValue);
  except
    Result := 0;
  end;
end;

function A_Utils_StrToInt(const Value: AString_Type): AInteger; stdcall;
begin
  try
    Result := Utils_StrToInt(AStrings.String_ToWideString(Value));
  except
    Result := 0;
  end;
end;

function A_Utils_StrToInt1(const S: AString_Type; DefValue: AInteger): AInteger; stdcall;
begin
  try
    Result := Utils_StrToInt1(AStrings.String_ToWideString(S), DefValue);
  except
    Result := 0;
  end;
end;

function A_Utils_Time_Now: TDateTime; stdcall;
begin
  try
    Result := Utils_Time_Now;
  except
    Result := 0;
  end;
end;

function A_Utils_Trim(const S: AString_Type; out Res: AString_Type): AInteger; stdcall;
begin
  try
    Result := AStrings.String_AssignW(Res, Utils_Trim(AStrings.String_ToWideString(S)));
  except
    Result := 0;
  end;
end;

function A_Utils_TryStrToDate(const S: AString_Type; var Value: TDateTime): ABoolean; stdcall;
begin
  try
    Result := Utils_TryStrToDate(AStrings.String_ToWideString(S), Value);
  except
    Result := False;
  end;
end;

function A_Utils_TryStrToFloat(const S: AString_Type; var Value: AFloat): ABoolean; stdcall;
begin
  try
    Result := Utils_TryStrToFloat(AStrings.String_ToWideString(S), Value);
  except
    Result := False;
  end;
end;

function A_Utils_TryStrToFloat32(const S: AString_Type; var Value: AFloat32): ABoolean; stdcall;
begin
  try
    Result := Utils_TryStrToFloat32(AStrings.String_ToWideString(S), Value);
  except
    Result := False;
  end;
end;

function A_Utils_TryStrToFloat64(const S: AString_Type; var Value: AFloat64): ABoolean; stdcall;
begin
  try
    Result := Utils_TryStrToFloat64(AStrings.String_ToWideString(S), Value);
  except
    Result := False;
  end;
end;

function A_Utils_TryStrToInt(const S: AString_Type; var Value: AInteger): ABoolean; stdcall;
begin
  try
    Result := Utils_TryStrToInt(AStrings.String_ToWideString(S), Value);
  except
    Result := False;
  end;
end;

function A_Utils_UpperString(const S: AString_Type; out Res: AString_Type): AInteger; stdcall;
begin
  try
    Result := AStrings.String_AssignW(Res, Utils_UpperString(AStrings.String_ToWideString(S)));
  except
    Result := 0;
  end;
end;

{ Modules }

function Utils_Boot: AInteger; stdcall;
begin
  Utils_SetProcs(Addr(UtilsProcs));
  Result := ARuntime.Module_Register(Addr(Module));
end;

function Utils_Done: AInteger; stdcall;
begin
  Result := 0;
end;

function Utils_Init: AInteger; stdcall;
begin
  Result := 0;
  if FInitialized then Exit;
  ARuntime.Modules_InitByUid(ASystem_Uid);
end;

initialization
  Utils_SetProcs(Addr(UtilsProcs));
end.

