{
Author:  Prof1983 <prof1983@yandex.ru>
Created: 30.09.2009
LastMod: 08.06.2011
Version: 0.2.6+0.3.1
}
unit AUtils;

interface

uses
  SysUtils, {$IFNDEF FPC}Windows,{$ENDIF}
  ABase0, ABaseUtils, AUtils0, ASystem0;

//    
function Utils_FloatToStr(Value: AFloat): AWideString; stdcall;
//     c    
function Utils_FloatToStrA(Value: AFloat; Digits: Integer = 2): AWideString; stdcall;
//         (SQL).  SQL   - .
function Utils_FloatToStrB(Value: AFloat; Digits: Integer = 2): AWideString; stdcall;
function Utils_FloatToStrC(Value: AFloat; Digits: Integer = 2): AWideString; stdcall;
function Utils_FloatToStrD(Value: AFloat): AWideString; stdcall;
function Utils_NormalizeFloat(Value: AFloat): AFloat; stdcall;
//       #
function Utils_NormalizeStr(const Value: AWideString): AWideString; stdcall;
//       ,   #13#10    
function Utils_NormalizeStrSpace(const Value: AWideString): AWideString; stdcall;

{               .
    DecimalSeparator ,    . }
function Utils_ReplaceComma(const S: AWideString; DecimalSeparator: AChar = #0; ClearSpace: ABoolean = True): AWideString; stdcall;
function Utils_StrToFloat1(const S: AWideString; DefValue: AFloat = 0): AFloat; stdcall;
function Utils_StrToInt1(const S: AWideString; DefValue: AInteger = 0): AInteger; stdcall;
function Utils_TryStrToFloat32(const S: AWideString; var Value: AFloat32): ABoolean; stdcall;
function Utils_TryStrToFloat64(const S: AWideString; var Value: AFloat64): ABoolean; stdcall;
function Utils_FileExists(const FileName: AWideString): ABoolean; stdcall;
procedure Utils_Sleep(Milliseconds: AUInt); stdcall;
function Utils_Time_Now: TDateTime; stdcall;
function Utils_IntToStr(Value: AInteger): AWideString; stdcall;
function Utils_StrToFloat(const Value: AWideString): AFloat; stdcall;
function Utils_StrToInt(const Value: AWideString): AInteger; stdcall;
function Utils_ExtractFilePath(const FileName: AWideString): AWideString; stdcall;
//   Base   Exponent
function Utils_Power(Base, Exponent: AFloat): AFloat; stdcall;
function Utils_TryStrToDate(const S: AWideString; var Value: TDateTime): ABoolean; stdcall;
function Utils_TryStrToFloat(const S: AWideString; var Value: AFloat): ABoolean; stdcall;
function Utils_TryStrToInt(const S: AWideString; var Value: AInteger): ABoolean; stdcall;

{ Testing }

function Utils_ExtractFileExt(const FileName: AWideString): AWideString; stdcall;
{ Trims leading and trailing spaces and control characters from a string.
       }
function Utils_Trim(const S: AWideString): AWideString; stdcall;
function Utils_UpperString(const S: AWideString): AWideString; stdcall;
function Utils_FormatFloat(Value: AFloat; Count, Digits: AInteger): AWideString; stdcall;
function Utils_FormatInt(Value, Count: AInteger): AWideString; stdcall;
function Utils_FormatStr(const Value: AWideString; Len: AInteger): AWideString; stdcall;
function Utils_StrToDate(const Value: AWideString): TDateTime; stdcall;

{ Private }

type //   
  TWinVersion = (wvUnknown, wv95, wv98, wvME, wvNT3, wvNT4, wvW2K, wvXP, wv2003);

{$IFNDEF FPC}
//       
//   Result:      
function WinVersion: TWinVersion;
{$ENDIF}

implementation

{ Private procs }

{$IFNDEF FPC}
function WinVersion: TWinVersion;
var
  OSVersionInfo: TOSVersionInfo;
begin
  Result := wvUnknown;
  OSVersionInfo.dwOSVersionInfoSize := SizeOf(TOSVersionInfo);
  if GetVersionEx(OSVersionInfo) then
  begin
    case OSVersionInfo.DwMajorVersion of
      3: Result := wvNT3;
      4: case OSVersionInfo.DwMinorVersion of
           0: if (OSVersionInfo.dwPlatformId = VER_PLATFORM_WIN32_NT) then
                Result := wvNT4
              else
                Result := wv95;
           10: Result := wv98;
           90: Result := wvME;
         end;
      5: case OSVersionInfo.DwMinorVersion of
           0: Result := wvW2K;
           1: Result := wvXP;
           2: Result := wv2003;
         end;
    end;
  end;
end;
{$ENDIF}

{ Utils }

function Utils_ExtractFileExt(const FileName: AWideString): AWideString; stdcall;
begin
  Result := ExtractFileExt(FileName);
end;

function Utils_ExtractFilePath(const FileName: AWideString): AWideString; stdcall;
begin
  Result := ExtractFilePath(FileName);
end;

function Utils_FileExists(const FileName: AWideString): ABoolean; stdcall;
begin
  Result := FileExists(FileName);
end;

function Utils_FloatToStr(Value: AFloat): AWideString; stdcall;
begin
  Result := FloatToStr(Value);
end;

function Utils_FloatToStrA(Value: AFloat; Digits: AInteger = 2): AWideString; stdcall;
begin
  Result := FloatToStrF(Value, ffFixed, 10, Digits);
end;

function Utils_FloatToStrB(Value: AFloat; Digits: AInteger): AWideString; stdcall;
begin
  Result := Utils_ReplaceComma(FloatToStrF(Value, ffFixed, 10, Digits), '.');
end;

function Utils_FloatToStrC(Value: AFloat; Digits: AInteger): AWideString; stdcall;
begin
  case Digits of
    0: Result := FormatFloat('### ### ### ##0', Value);
    1: Result := FormatFloat('### ### ### ##0.0', Value);
    2: Result := FormatFloat('### ### ### ##0.00', Value);
    3: Result := FormatFloat('### ### ### ##0.000', Value);
    4: Result := FormatFloat('### ### ### ##0.0000', Value);
    5: Result := FormatFloat('### ### ### ##0.00000', Value);
  else
    Result := FormatFloat('### ### ### ##0.00', Value);
  end;
end;

function Utils_FloatToStrD(Value: AFloat): AWideString; stdcall;
begin
  Result := FormatFloat(',0.00', Value);
end;

function Utils_FormatFloat(Value: AFloat; Count, Digits: AInteger): AWideString; stdcall;
var
  FormatS: string;
begin
  if (Count >= 0) and (Count <= 9) and (Digits >= 0) and (Digits <= 9) then
  begin
    FormatS := '%' + Chr(Ord('0')+Count) + '.' + Chr(Ord('0')+Digits) + 'f';
    Result := Format(FormatS,[Value]);
  end
  else
    Result := Utils_FloatToStrB(Value, Digits);
end;

function Utils_FormatInt(Value, Count: AInteger): AWideString; stdcall;
begin
  if (Count > 0) and (Count <= 9) then
    Result := Format('%'+Chr(Ord('0')+Count)+'d',[Value])
  else
    Result := IntToStr(Value);
end;

function Utils_FormatStr(const Value: AWideString; Len: AInteger): AWideString; stdcall;
var
  Form: string;
  S: string;
begin
  if (Len > 0) and (Len < High(Byte)) then
  begin
    Form := '%'+ByteToStr(Byte(Len))+'s';
    S := string(Value);
    Result := Format(Form, [S])
  end
  else
    Result := Value;
end;

function Utils_IntToStr(Value: AInteger): AWideString; stdcall;
begin
  Result := IntToStr(Value);
end;

function Utils_NormalizeFloat(Value: AFloat): AFloat; stdcall;
begin
  Result := Utils_StrToFloat(Utils_FloatToStrA(Value));
end;

function Utils_NormalizeStr(const Value: AWideString): AWideString; stdcall;
var
  I: Integer;
  S: string;
begin
  S := Value;
  for I := 1 to Length(S) do
  begin
    if (Ord(S[I]) < 31) then // 
      S[I] := '#';
  end;
  Result := S;
end;

// Prof1983: 20.05.2011a
function Utils_NormalizeStrSpace(const Value: AWideString): AWideString; stdcall;
var
  I: Integer;
  J: Integer;
begin
  SetLength(Result, Length(Value));
  I := 0;
  J := 0;
  while (I < Length(Value)) do
  begin
    Inc(I);
    Inc(J);
    if (I < Length(Value)) and (Value[I] = #13) and (Value[I+1] = #10) then
    begin
      Result[J] := ' ';
      Inc(I);
    end
    else if (Ord(Result[I]) < 31) then // 
      Result[J] := ' '
    else
      Result[J] := Value[I];
  end;
  SetLength(Result, J);
end;

function Utils_Power(Base, Exponent: AFloat): AFloat; stdcall;
begin
  Result := Exp(Exponent * Ln(Base));
end;

function Utils_ReplaceComma(const S: AWideString; DecimalSeparator: AChar; ClearSpace: ABoolean): AWideString; stdcall;
var
  ic: Integer;
  SS: AWideString;
begin
  if (DecimalSeparator = #0) then
    DecimalSeparator := AChar(SysUtils.DecimalSeparator);
  if (DecimalSeparator <> '.') and (DecimalSeparator <> ',') then
    raise Exception.Create('  ReplaceComma().  DecimalSeparator     .');

  // 44 - ; 46 - 
  ic := 1;
  SS := '';
  while (ic <= (Length(S))) do
  begin
    if not(ClearSpace) or (S[ic] <> ' ') then
    begin
      if (DecimalSeparator = '.') then
      begin
        if S[ic] = ',' then
          SS := SS + '.'
        else
          SS := SS + S[ic];
      end
      else
      begin
        if (S[ic] = '.') then
          SS := SS + ','
        else
          SS := SS + S[ic];
      end;
    end;
    ic := ic + 1;
  end;
  Result := SS;
end;

procedure Utils_Sleep(Milliseconds: AUInt); stdcall;
begin
  Runtime_ProcessMessages;
  Sleep(Milliseconds);
end;

function Utils_StrToDate(const Value: AWideString): TDateTime; stdcall;
begin
  Result := StrToDate(Value);
end;

function Utils_StrToFloat(const Value: AWideString): AFloat; stdcall;
begin
  Result := StrToFloat(Value);
end;

function Utils_StrToFloat1(const S: AWideString; DefValue: AFloat): AFloat; stdcall;
var
  Value: Real;
begin
  if Utils_TryStrToFloat32(S, Value) then
    Result := Value
  else
    Result := DefValue;
end;

function Utils_StrToInt(const Value: AWideString): AInteger; stdcall;
begin
  Result := StrToInt(Value);
end;

function Utils_StrToInt1(const S: AWideString; DefValue: AInteger): AInteger; stdcall;
begin
  if not(Utils_TryStrToInt(S, Result)) then
    Result := DefValue;
end;

function Utils_Time_Now: TDateTime; stdcall;
begin
  Result := Now;
end;

function Utils_Trim(const S: AWideString): AWideString; stdcall;
begin
  Result := SysUtils.Trim(S);
end;

function Utils_TryStrToDate(const S: AWideString; var Value: TDateTime): Boolean; stdcall;
begin
  Result := TryStrToDate(S, Value);
end;

function Utils_TryStrToFloat(const S: AWideString; var Value: AFloat): ABoolean; stdcall;
begin
  Result := Utils_TryStrToFloat64(S, Value);
end;

function Utils_TryStrToFloat32(const S: AWideString; var Value: AFloat32): ABoolean;
var
  Value1: Extended;
  S1: string;
begin
  S1 := Trim(Utils_ReplaceComma(S));
  if (S1 <> '') then
  begin
    Result := TryStrToFloat(S1, Value1);
    if Result then
      Value := Value1;
  end
  else
    Result := False;
end;

function Utils_TryStrToFloat64(const S: AWideString; var Value: AFloat64): ABoolean;
var
  Value1: Extended;
  S1: string;
begin
  S1 := Trim(Utils_ReplaceComma(S));
  if (S1 <> '') then
  begin
    Result := TryStrToFloat(Trim(Utils_ReplaceComma(S)), Value1);
    if Result then
      Value := Value1;
  end
  else
    Result := False;
end;

function Utils_TryStrToInt(const S: AWideString; var Value: AInteger): ABoolean; stdcall;
begin
  Result := TryStrToInt(Trim(S), Value);
end;

function Utils_UpperString(const S: AWideString): AWideString; stdcall;
begin
  Result := AnsiUpperCase(S);
end;

end.

