{
Author:  Prof1983 <prof1983@yandex.ru>
Created: 26.08.2009
LastMod: 09.06.2011
Version: 0.3.1
}
unit AUIWorkbench03;

interface

uses
  ABase0, ARuntime0, AUI0, AUIWorkbench0, AUIWorkbench;

{ Protected }

function UIWorkbench_Boot: AInteger; stdcall;
function UIWorkbench_Init: AInteger; stdcall;
function UIWorkbench_Done: AInteger; stdcall;

implementation

exports
  UIWorkbench_AddPage;

const
  UIWorkbenchProcs: AUIWorkbenchProcs_Type = (
    AddPage: UIWorkbench_AddPage;
    Reserved01: 0;
    Reserved02: 0;
    Reserved03: 0;
    Reserved04: 0;
    Reserved05: 0;
    Reserved06: 0;
    Reserved07: 0;
    Reserved08: 0;
    Reserved09: 0;
    Reserved10: 0;
    Reserved11: 0;
    Reserved12: 0;
    Reserved13: 0;
    Reserved14: 0;
    Reserved15: 0;
    );

const
  Module: AModule_Type = (
    Version: AUIWorkbench_Version;
    Uid: AUIWorkbench_Uid;
    Name: AUIWorkbench_Name;
    Description: nil;
    Init: UIWorkbench_Init;
    Done: UIWorkbench_Done;
    Reserved06: 0;
    Procs: Addr(UIWorkbenchProcs);
    );

{ UIWorkbench }

function UIWorkbench_Boot: AInteger; stdcall;
begin
  if (ARuntime.Modules_FindByUid(AUIWorkbench_Uid) >= 0) then
  begin
    Result := -1;
    Exit;
  end;

  if (ARuntime.Modules_FindByName(AUIWorkbench_Name) >= 0) then
  begin
    Result := -1;
    Exit;
  end;

  Result := ARuntime.Module_Register(Addr(Module));
end;

function UIWorkbench_Done: AInteger; stdcall;
begin
  ARuntime.Modules_DeleteByUid(AUIWorkbench_Uid);
  Result := UIWorkbench_DoneA;
end;

function UIWorkbench_Init: AInteger; stdcall;
var
  Module: AModule_Type;
begin
  if FInitialized then
  begin
    Result := 0;
    Exit;
  end;

  // --- Init request modules ---

  {$IFDEF A02}
  if (ARuntime.Modules_InitByName(AUI_Name) < 0) then
  begin
    Result := -2;
    Exit;
  end;
  if (ARuntime.Modules_GetByName(AUI_Name, Addr(Module)) < 0) then
  begin
    Result := -1;
    Exit;
  end;
  UI_SetProcs(Module.Procs);
  {$ELSE}
  if (ARuntime.Modules_InitByUid(AUI_Uid) < 0) then
  begin
    Result := -2;
    Exit;
  end;
  if (ARuntime.Modules_GetByUid(AUI_Uid, Addr(Module)) < 0) then
  begin
    Result := -1;
    Exit;
  end;
  UI_SetProcs(Module.Procs);
  {$ENDIF}

  Result := UIWorkbench_InitA;
end;

initialization
  UIWorkbench_SetProcs(Addr(UIWorkbenchProcs));
end.
