{
Author:  Prof1983 <prof1983@yandex.ru>
Created: 26.08.2009
LastMod: 09.06.2011
Version: 0.3.1
}
unit AUIWorkbench;

interface

uses
  ABase0, ARuntime0, AUI0, AUIWorkbench0;

function UIWorkbench_DoneA: AInteger; stdcall;
function UIWorkbench_InitA: AInteger; stdcall;

{       . :
  0 -   ,     (   ) }
function UIWorkbench_AddPage(const Name, Text: AWideString): AControl; stdcall;
procedure UIWorkbench_SetOnChange(OnChange: ACallbackProc); stdcall;

var
  FInitialized: Boolean;

implementation

var
  FPageControl: AControl;

{ UIWorkbench }

function UIWorkbench_AddPage(const Name, Text: AWideString): AControl; stdcall;
begin
  Result := UI.PageControl_AddPageW(FPageControl, Name, Text);
end;

function UIWorkbench_DoneA: AInteger; stdcall;
begin
  FInitialized := False;
  Result := 0;
end;

function UIWorkbench_InitA: AInteger; stdcall;
begin
  FPageControl := UI.PageControl_New(UI_MainWindow_GetMainContainer);
  FInitialized := True;
  Result := 0;
end;

procedure UIWorkbench_SetOnChange(OnChange: ACallbackProc); stdcall;
begin
  if FInitialized then
    UI_Control_SetOnChange(FPageControl, OnChange);
end;

end.
