{
Author:  Prof1983 <prof1983@yandex.ru>
Created: 13.10.2008
LastMod: 06.06.2011
Version: 0.1.2+0.2.6+0.3.1
}
unit AUIMainWindow;

interface

uses
  Classes, ComCtrls, Controls, ExtCtrls, Forms, Graphics, Menus, StdCtrls, SysUtils, {$IFNDEF UNIX}Windows,{$ENDIF}
  {$IFDEF OLDMAINFORM}fMain,{$ENDIF}
  ABase0, AUI0, {AString0,}
  AUIForm;

type
  TMainWindowFormat = type Integer;
const
  MainWindowFormatCreateMenu = $00000001;
  MainWindowFormatCreateToolBar = $00000002;
  MainWindowFormatCreateStatusBar = $00000004;
  MainWindowFormatCreatePanels = $00000008;
  MainWindowFormatCreateAll = $000000FF;

function MainWindow_GetLeftContainer: AControl;
function MainWindow_GetMainContainer: AControl;
function MainWindow_GetRightContainer: AControl;

procedure MainWindow_LoadConfig(Config: AConfig);
procedure MainWindow_SaveConfig(Config: AConfig);

procedure MainWindow_Create(Form: TForm; Format: TMainWindowFormat; Config: AConfig);
procedure MainWindow_Init;
procedure MainWindow_Set(Window: AWindow; ToolBar, StatusBar: AControl; Config: AConfig);
procedure MainWindow_Shutdown;
function MainWindow_ToolBar: AControl;
procedure MainWindow_ToolBar_Set(ToolBar: AControl);

const
  {$IFDEF UNIX}
  miAboutCaption = 'About...';
  miHelpCaption = 'Help';
  {$ELSE}
  miAboutCaption = ' ...';
  miHelpCaption = '';
  {$ENDIF}

var
  DefWindowState: TWindowState;

implementation

var
  FConfig: AConfig;
  MainWindow: AWindow;
  MainMenu: TMainMenu;
  LeftPanel: TPanel;
  LeftSplitter: TSplitter;
  BasePanel: TPanel;
  RightPanel: TPanel;
  RightSplitter: TSplitter;
  MainPanel: TPanel;
  BottomPanel: TPanel;
  BottomSplitter: TSplitter;
  FStatusBar: AControl; //TStatusBar;
  FMainToolBar: AControl;

(*
const
  STR_DockOrientation: array[TDockOrientation] of AString = (
    'NoOrient',
    'Horizontal',
    'Vertical'
    {$IFDEF FPC},'Pages'{$ENDIF}
    );
*)

{
function StrToDockOrientation(S: WideString): TDockOrientation;
var
  I: TDockOrientation;
begin
  for I := Low(TDockOrientation) to High(TDockOrientation) do
    if (STR_DockOrientation[I] = S) then
    begin
      Result := I;
      Exit;
    end;
  Result := doNoOrient;
end;
}

{ MainWindow }

procedure MainWindow_Create(Form: TForm; Format: TMainWindowFormat; Config: AConfig);
var
  MainStatusBar: TStatusBar;
  MainToolBar: AControl;
begin
  if (Format and MainWindowFormatCreateToolBar = MainWindowFormatCreateToolBar) then
  begin
    MainToolBar := UI_ToolBar_New(AWindow(Form));
    UI_Control_SetVisible(MainToolBar, False);
  end
  else
    MainToolBar := 0;

  if (Format and MainWindowFormatCreateStatusBar = MainWindowFormatCreateStatusBar) then
  begin
    MainStatusBar := TStatusBar.Create(Form);
    MainStatusBar.Parent := Form;
  end
  else
    MainStatusBar := nil;

  if (Format and MainWindowFormatCreatePanels = MainWindowFormatCreatePanels) then
  begin
    LeftPanel := TPanel(UI_Box_New(AWindow(Form),0));
    LeftPanel.Align := alLeft;
    LeftPanel.Width := 50;
    LeftPanel.DockSite := True;
    LeftPanel.DragMode := dmAutomatic;
    LeftPanel.Visible := False;

    LeftSplitter := TSplitter(UI_Splitter_New(AWindow(Form),0));
    LeftSplitter.Align := alLeft;
    LeftSplitter.Width := 3;
    LeftSplitter.Visible := False;

    BasePanel := TPanel(UI_Box_New(AWindow(Form),0));
    BasePanel.Align := alClient;
    BasePanel.BevelInner := bvNone;
    BasePanel.BevelOuter := bvNone;

      RightPanel := TPanel(UI_Box_New(AControl(BasePanel),0));
      RightPanel.Align := alRight;
      RightPanel.Width := 50;
      RightPanel.DockSite := True;
      RightPanel.DragMode := dmAutomatic;
      RightPanel.Visible := False;

      RightSplitter := TSplitter(UI_Splitter_New(AControl(BasePanel),0));
      RightSplitter.Align := alRight;
      RightSplitter.Width := 3;
      RightSplitter.Visible := False;

      MainPanel := TPanel(UI_Box_New(AControl(BasePanel),0));
      MainPanel.Align := alClient;
      MainPanel.BevelInner := bvNone;
      MainPanel.BevelOuter := bvNone;

        BottomPanel := TPanel(UI_Box_New(AControl(MainPanel),0));
        BottomPanel.Align := alBottom;
        BottomPanel.Height := 50;
        BottomPanel.DockSite := True;
        BottomPanel.DragMode := dmAutomatic;
        BottomPanel.Visible := False;

        BottomSplitter := TSplitter(UI_Splitter_New(AControl(MainPanel),0));
        BottomSplitter.Align := alBottom;
        BottomSplitter.Height := 3;
  end;

  if (Format and MainWindowFormatCreateMenu = MainWindowFormatCreateMenu) then
  begin
    MainMenu := TMainMenu.Create(Form);
    Form.Menu := MainMenu;
  end;
  UI_MainWindow_SetA(AWindow(Form), MainToolBar, AControl(MainStatusBar), Config);
end;

function MainWindow_GetLeftContainer: AControl;
begin
  Result := Integer(LeftPanel);
end;

function MainWindow_GetMainContainer: AControl;
begin
  Result := Integer(MainPanel);
end;

function MainWindow_GetRightContainer: AControl;
begin
  Result := Integer(RightPanel);
end;

procedure MainWindow_Init;
begin
  if (FConfig <> 0) then
    MainWindow_LoadConfig(FConfig);
end;

procedure MainWindow_LoadConfig(Config: AConfig);

  (*
  function FindControlByTag(C: TWinControl; ControlTag: Integer): TWinControl;
  var
    I: Integer;
  begin
    for I := 0 to C.ControlCount - 1 do
    begin
      if (C.Controls[I] is TWinControl) and (C.Controls[I].Tag = ControlTag) then
      begin
        Result := TWinControl(C.Controls[I]);
        Exit;
      end;
    end;
    Result := nil;
  end;

  procedure ReadDockClient(C: TWinControl; Name: WideString; DockSite: TWinControl);
  var
    Client: TWinControl;
    TempTag: Integer;
    Rect: TRect;
    S: WideString;
  begin
    TempTag := Settings.ReadInteger(C.Name, Name, 0);
    if (TempTag = 0) then Exit;
    Client := FindControlByTag(C, TempTag);
    if not(Assigned(Client)) then
      Client := NewPanel(TempTag);

    TPanel(Client).Caption := IntToStr(TempTag);

    Rect.Left := Settings.ReadInteger(C.Name, Name+'_ClientRect_Left', 0);
    Rect.Top := Settings.ReadInteger(C.Name, Name+'_ClientRect_Top', 0) + 15;
    Rect.Right := Settings.ReadInteger(C.Name, Name+'_ClientRect_Right', 0);
    Rect.Bottom := Settings.ReadInteger(C.Name, Name+'_ClientRect_Bottom', 0) + 15;

    S := Settings.ReadString(C.Name, Name+'_ClientOrientation', '');
    if (S <> '') then
      Client.DockOrientation := StrToDockOrientation(S);

    Client.Dock(DockSite, Rect);
    if TPanel(DockSite).UseDockManager and Assigned(TPanel(DockSite).DockManager) then
    begin
      if (Client.DockOrientation = doHorizontal) then
        TPanel(DockSite).DockManager.InsertControl(Client, alRight, nil)
      else if (Client.DockOrientation = doVertical) then
        TPanel(DockSite).DockManager.InsertControl(Client, alBottom, nil)
      else
        TPanel(DockSite).DockManager.InsertControl(Client, alClient, nil)
    end;
  end;

  procedure ReadDockClients(Co: TWinControl; Name: WideString; DockSite: TWinControl);
  var
    C: Integer;
    I: Integer;
  begin
    C := Settings.ReadInteger(Co.Name, Name+'_DockClientCount', 0);
    for I := 0 to C - 1 do
      ReadDockClient(Co, Name+'_DockClient_'+IntToStr(I), DockSite);
  end;

  procedure ReadPanel(C: TWinControl; Name: WideString);
  var
    Client: TWinControl;
    TempTag: Integer;
    Rect: TRect;
    S: WideString;
  begin
    TempTag := Settings.ReadInteger(C.Name, Name, 0);
    if (TempTag = 0) then Exit;
    Client := FindControlByTag(C, TempTag);
    if Assigned(Client) then Exit;

    Client := NewPanel(TempTag);
    TPanel(Client).Caption := IntToStr(TempTag);

    Rect.Left := Settings.ReadInteger(C.Name, Name+'_ClientRect_Left', 0);
    Rect.Top := Settings.ReadInteger(C.Name, Name+'_ClientRect_Top', 0) + 15;
    Rect.Right := Settings.ReadInteger(C.Name, Name+'_ClientRect_Right', 0);
    Rect.Bottom := Settings.ReadInteger(C.Name, Name+'_ClientRect_Bottom', 0) + 15;

    {Client.Dock(DockSite, Rect);
    if TPanel(DockSite).UseDockManager and Assigned(TPanel(DockSite).DockManager) then
      TPanel(DockSite).DockManager.InsertControl(Client, alClient, nil);}

    S := Settings.ReadString(C.Name, Name+'_ClientOrientation', '');
    if (S <> '') then
      Client.DockOrientation := StrToDockOrientation(S);
  end;

  procedure ReadPanels(Co: TWinControl);
  var
    C: Integer;
    I: Integer;
  begin
    C := Settings.ReadInteger(Co.Name, 'PanelCount', 0);
    for I := 0 to C - 1 do
      ReadPanel(Co, 'Panel'+IntToStr(I));
  end;
  *)

var
  MainForm: TForm;
  //S: AWideString;
begin
  MainForm := TForm(MainWindow);
  // UI_Window_LoadConfig(MainForm, Settings);
  //FNextTag := Settings.ReadInteger(FControl.Name, 'NextTag', 1);

  // Prof1983: 07.04.2011
  {MainForm.Left := 0;
  MainForm.Top := 0;}

  // Prof1983: 07.04.2011
  Form_LoadConfig3(MainForm, Config, MainForm.Name, DefWindowState);
  //UI_Window_LoadConfig(AControl(MainForm), Config);

  {$IFNDEF OLDMAINFORM}
  {
  LeftPanel.Width := Settings.ReadInteger(FControl.Name, 'LeftPanel_Width', 50);
  RightPanel.Width := Settings.ReadInteger(FControl.Name, 'RightPanel_Width', 50);
  BottomPanel.Height := Settings.ReadInteger(FControl.Name, 'BottomPanel_Height', 50);

  ReadPanels(MainForm);
  ReadDockClients(MainForm, 'LeftPanel', LeftPanel);
  ReadDockClients(MainForm, 'RightPanel', RightPanel);
  ReadDockClients(MainForm, 'BottomPanel', BottomPanel);
  }
  {$ENDIF}

  (*
  //      (Assistant32)
  if Settings.ReadBool(FControl.Name, 'NoStandartBorderStyle', False) then
  begin
    FControl.BorderStyle := bsNone;
    ToolBar.Visible := False;
    StatusBar.Visible := False;
  end
  else
  begin
    if Assigned(BottomPanel) then
      BottomPanel.Visible := False;
    //TopPanel.Visible := False;
    //pnlHead.Height := 130;
    {
    if Assigned(ToolBar) then
      ToolBar.Color := DefaultWinColor;
    if Assigned(StatusBar) then
      StatusBar.Color := DefaultWinColor;
    }
  end;
  *)

  {for I := 0 to Self.ComponentCount - 1 do
  begin
    if (Self.Components[I] is TPanel) and (Self.Components[I].Tag > 0) then
    begin
      TPanel(Self.Components[I]).Dra
    end;
  end;}
end;

procedure MainWindow_SaveConfig(Config: AConfig);

  (*
  procedure WriteDockClient(C: TWinControl; Name: WideString; Client: TControl);
  begin
    Settings.WriteInteger(C.Name, Name, Client.Tag);
    Settings.WriteInteger(C.Name, Name+'_ClientRect_Left', Client.ClientRect.Left);
    Settings.WriteInteger(C.Name, Name+'_ClientRect_Top', Client.ClientRect.Top);
    Settings.WriteInteger(C.Name, Name+'_ClientRect_Right', Client.ClientRect.Right);
    Settings.WriteInteger(C.Name, Name+'_ClientRect_Bottom', Client.ClientRect.Bottom);
    Settings.WriteInteger(C.Name, Name+'_UndockHeight', Client.UndockHeight);
    Settings.WriteInteger(C.Name, Name+'_UndockWidth', Client.UndockWidth);
    Settings.WriteString(C.Name, Name+'_ClientOrientation', STR_DockOrientation[Client.DockOrientation]);
  end;

  procedure WriteDockClients(Co: TWinControl; Name: WideString; DockSite: TWinControl);
  var
    C: Integer;
    I: Integer;
  begin
    if (DockSite.Align = alLeft) or (DockSite.Align = alRight) then
      Settings.WriteInteger(Co.Name, Name+'_Width', DockSite.Width)
    else if (DockSite.Align = alBottom) or (DockSite.Align = alTop) then
      Settings.WriteInteger(Co.Name, Name+'_Height', DockSite.Height);

    C := DockSite.DockClientCount;
    Settings.WriteInteger(Co.Name, Name+'_DockClientCount', C);
    for I := 0 to C - 1 do
      //WriteDockClient(Name+'_DockClient_'+IntToStr(I), DockSite.DockClients[I]);
      Settings.WriteInteger(Co.Name, Name+'_DockClient_'+IntToStr(I), DockSite.DockClients[I].Tag);
  end;

  procedure WritePanels(Co: TWinControl);
  var
    C: Integer;
    I: Integer;
    Component: TComponent;
  begin
    C := 0;
    for I := 0 to Co.ComponentCount - 1 do
    begin
      Component := Co.Components[I];
      if (Component is TPanel) and (Component.Tag > 0) then
      begin
        WriteDockClient(Co, 'Panel'+IntToStr(C), TControl(Component));
        Inc(C);
      end;
    end;
    Settings.WriteInteger(Co.Name, 'PanelCount', C);
  end;
  *)

begin
  //Settings.WriteInteger(FControl.Name, 'NextTag', FNextTag);
  UI_Window_SaveConfig(MainWindow, Config);

  {$IFNDEF OLDMAINFORM}
  {WritePanels(FControl);
  WriteDockClients(FControl, 'LeftPanel', LeftPanel);
  WriteDockClients(FControl, 'RightPanel', RightPanel);
  WriteDockClients(FControl, 'BottomPanel', BottomPanel);}
  {$ENDIF}
end;

procedure MainWindow_Set(Window: AWindow; ToolBar, StatusBar: AControl; Config: AConfig);
begin
  MainWindow := Window;
  FConfig := Config;
  FStatusBar := StatusBar;
  FMainToolBar := ToolBar;
end;

(*procedure TAMainWindow.ShowAll;
begin
  if Assigned(FContain) then               // 2                 // 54
  begin
    FContain.SetAllocateSize(FControl.Width - 15, FControl.Height - 64);
    {$IFDEF MSWINDOWS}
    IAUIclPanel(FContain).Align := Integer(alClient);
    {$ENDIF}
  end;
end;*)

procedure MainWindow_Shutdown;
var
  MainForm: TForm;
begin
  MainForm := TForm(MainWindow);
  if not(Assigned(MainForm)) then Exit;

  //FControl.OnResize := nil;
  MainForm.OnCloseQuery := nil;

  if (FConfig <> 0) then
  begin
    MainWindow_SaveConfig(FConfig);
    FConfig := 0;
  end;

  MainForm.Close;
  // Prof1983: 11.01.2010
  MainForm := nil;
  UI_MainWindow_Set(0);

  Application.Terminate;
end;

function MainWindow_ToolBar: AControl;
begin
  Result := FMainToolBar;
end;

procedure MainWindow_ToolBar_Set(ToolBar: AControl);
begin
  FMainToolBar := ToolBar;
end;

(*function TAMainWindow.NewPanel(PanelTag: Integer): TPanel;
begin
  Result := TPanel.Create(FControl);
  Result.Parent := FControl;
  {$IFNDEF UNIX}
  Result.DragKind := dkDock;
  Result.DragMode := dmAutomatic;
  {$ENDIF}
  if (PanelTag > 0) then
    Result.Tag := PanelTag
  else
  begin
    Result.Tag := FNextTag;
    if (FNextTag = High(Integer)) then
      FNextTag := 1
    else
      Inc(FNextTag);
  end;

  Result.Caption := IntToStr(Result.Tag);
end;*)

end.
