{
Author:  Prof1983 <prof1983@yandex.ru>
Created: 20.01.2010
LastMod: 05.06.2011
Version: 0.1.2+0.2.6+0.3.1
}
unit AUIForm;

{$IFDEF FPC}
  {$DEFINE A02}
{$ENDIF}

{$IFDEF A02}{$DEFINE A02UP}{$ENDIF}
{$IFDEF A03}{$DEFINE A02UP}{$ENDIF}

interface

uses
  Forms, ABase0, ASettings0(*{$IFDEF A02UP}ASettings0{$ELSE}ASettings01{$ENDIF}*){, AString0};

function Form_LoadConfig(Form: TForm; Config: AConfig): ABoolean;
function Form_LoadConfig2(Form: TForm; Config: AConfig; const ConfigKey: AWideString): ABoolean;
function Form_LoadConfig3(Form: TForm; Config: AConfig; const ConfigKey: AWideString; DefWindowState: TWindowState): ABoolean;
function Form_SaveConfig(Form: TForm; Config: AConfig): ABoolean;
function Form_SaveConfig2(Form: TForm; Config: AConfig; const ConfigKey: AWideString): ABoolean;

implementation

const
  SLeft = 'Left';
  STop = 'Top';
  SWidth = 'Width';
  SHeight = 'Height';
  SWindowState = 'WindowState';

function Form_LoadConfig(Form: TForm; Config: AConfig): ABoolean;
begin
  Result := Form_LoadConfig2(Form, Config, Form.Name);
end;

function Form_LoadConfig2(Form: TForm; Config: AConfig; const ConfigKey: AWideString): ABoolean;
begin
  Result := Form_LoadConfig3(Form, Config, ConfigKey, Form.WindowState);
end;

function Form_LoadConfig3(Form: TForm; Config: AConfig; const ConfigKey: AWideString; DefWindowState: TWindowState): ABoolean;
{$IFDEF A03}
var
  S: AWideString;
{$ENDIF A03}
begin
  try
    Form.WindowState := wsNormal;
    {IFDEF A03}
    {A_String_Clear(S);
    A_String_CopyW(S, SLeft);
    Form.Left := Settings.ReadInteger(Config, ConfigKey, S, Form.Left);
    A_String_CopyW(S, STop);
    Form.Top := Settings.ReadInteger(Config, ConfigKey, S, Form.Top);
    A_String_CopyW(S, SWidth);
    Form.Width := Settings.ReadInteger(Config, ConfigKey, S, Form.Width);
    A_String_CopyW(S, SHeight);
    Form.Height := Settings.ReadInteger(Config, ConfigKey, S, Form.Height);
    A_String_CopyW(S, SWindowState);
    Form.WindowState := TWindowState(Settings.ReadInteger(Config, ConfigKey, S, Integer(DefWindowState)));
    A_String_Free(S);}
    {ELSE}
    Form.Left := Settings_ReadInteger(Config, ConfigKey, SLeft, Form.Left);
    Form.Top := Settings_ReadInteger(Config, ConfigKey, STop, Form.Top);
    Form.Width := Settings_ReadInteger(Config, ConfigKey, SWidth, Form.Width);
    Form.Height := Settings_ReadInteger(Config, ConfigKey, SHeight, Form.Height);
    Form.WindowState := TWindowState(Settings_ReadInteger(Config, ConfigKey, SWindowState, Integer(DefWindowState)));
    {ENDIF}
    Result := True;
  except
    Result := False;
  end;
end;

function Form_SaveConfig(Form: TForm; Config: AConfig): ABoolean;
begin
  Result := Form_SaveConfig2(Form, Config, Form.Name);
end;

function Form_SaveConfig2(Form: TForm; Config: AConfig; const ConfigKey: AWideString): ABoolean;
{IFDEF A03}
{var
  S: AWideString;}
{ENDIF A03}
begin
  try
    if (Config <> 0) and (Form.WindowState <> wsMaximized) then
    begin
      {IFDEF A03}
      {String_AssignW(S, SLeft);
      Settings.WriteInteger(Config, ConfigKey, S, Form.Left);
      String_AssignW(S, STop);
      Settings.WriteInteger(Config, ConfigKey, S, Form.Top);
      String_AssignW(S, SWidth);
      Settings.WriteInteger(Config, ConfigKey, S, Form.Width);
      String_AssignW(S, SHeight);
      Settings.WriteInteger(Config, ConfigKey, S, Form.Height);}
      {ELSE}
      Settings_WriteInteger(Config, ConfigKey, SLeft, Form.Left);
      Settings_WriteInteger(Config, ConfigKey, STop, Form.Top);
      Settings_WriteInteger(Config, ConfigKey, SWidth, Form.Width);
      Settings_WriteInteger(Config, ConfigKey, SHeight, Form.Height);
      {ENDIF}
    end;
    Settings_WriteInteger(Config, ConfigKey, SWindowState, Integer(Form.WindowState));
    {String_AssignW(S, SWindowState);
    Settings_WriteInteger(Config, ConfigKey, S, Integer(Form.WindowState));
    String_Free(S);}
    Result := True;
  except
    Result := False;
  end;
end;

end.
 
