{
Author:  Prof1983 <prof1983@yandex.ru>
Created: 31.05.2011
LastMod: 06.06.2011
Version: 0.3.1
}
unit AUIDialogs031;

interface

uses
  ABase0, AStrings0, AUI0, AUI;

procedure A_UI_Dialog_About; stdcall;
function A_UI_Dialog_About_New: AWindow; stdcall;
function A_UI_Dialog_AddButton(Win: AWindow; Left, Width: AInteger; const Text: AString_Type; OnClick: ACallbackProc): AControl; stdcall;
function A_UI_Dialog_Color(var Color: AColor): ABoolean; stdcall;
function A_UI_Dialog_Calendar(var Date: TDateTime; CenterX, CenterY: AInteger): ABoolean; stdcall;
function A_UI_Dialog_DateFilter(var Group: Integer; var DateBegin, DateEnd: TDateTime): ABoolean; stdcall;
procedure A_UI_Dialog_Error(const Caption, UserMessage, ExceptMessage: AString_Type); stdcall;
function A_UI_Dialog_Font(var FontName: AString_Type; var FontSize: AInteger; FontColor: AColor): ABoolean; stdcall;
function A_UI_Dialog_InputBox(const Text: AString_Type; var Value: AString_Type): ABoolean; stdcall;
function A_UI_Dialog_InputBox2(const Caption, Text1, Text2: AString_Type; var Value1, Value2: AString_Type): ABoolean; stdcall;
function A_UI_Dialog_InputBoxA(const Caption, Text: AString_Type; var Value: AString_Type): ABoolean; stdcall;
function A_UI_Dialog_Login(var UserName, Password: AString_Type; IsSave: ABoolean): ABoolean; stdcall;
function A_UI_Dialog_Message(const Text, Caption: AString_Type; Flags: AMessageBoxFlags): ADialogBoxCommands; stdcall;
function A_UI_Dialog_New(Buttons: AUIWindowButtons): ADialog; stdcall;
function A_UI_Dialog_OpenFile(const InitialDir, Filter, Title: AString_Type; var FileName: AString_Type): ABoolean; stdcall;
function A_UI_Dialog_OpenFileA(const InitialDir, Filter, DefaultExt, Title: AString_Type; var FileName: AString_Type; var FilterIndex: AInteger): ABoolean; stdcall;
function A_UI_Dialog_SaveFile(const Dir, Ext, DefFileName: AString_Type; out Value: AString_Type): AInteger; stdcall;
function A_UI_Dialog_SaveFileA(const InitialDir, DefExt, DefFileName, Filter: AString_Type; var FilterIndex: AInteger; out Value: AString_Type): AInteger; stdcall;

function A_UI_Dialog_SelectDirectory(var Directory: AString_Type): ABoolean; stdcall;
function A_UI_Dialog_GetWindow(Dialog: ADialog): AWindow; stdcall;

implementation

{ Dialog }

procedure A_UI_Dialog_About; stdcall;
begin
  try
    UI_Dialog_About;
  except
  end;
end;

function A_UI_Dialog_About_New: AWindow; stdcall;
begin
  try
    Result := UI_Dialog_About_New;
  except
    Result := 0;
  end;
end;

function A_UI_Dialog_AddButton(Win: AWindow; Left, Width: AInteger; const Text: AString_Type;
    OnClick: ACallbackProc): AControl; stdcall;
begin
  try
    Result := UI_Dialog_AddButton(Win, Left, Width, AStrings.String_ToWideString(Text), OnClick);
  except
    Result := 0;
  end;
end;

function A_UI_Dialog_Calendar(var Date: TDateTime; CenterX, CenterY: AInteger): ABoolean; stdcall;
begin
  try
    Result := UI_Dialog_Calendar(Date, CenterX, CenterY);
  except
    Result := False;
  end;
end;

function A_UI_Dialog_Color(var Color: AColor): ABoolean; stdcall;
begin
  try
    Result := UI_Dialog_Color(Color);
  except
    Result := False;
  end;
end;

function A_UI_Dialog_DateFilter(var Group: Integer; var DateBegin, DateEnd: TDateTime): ABoolean; stdcall;
begin
  try
    Result := UI_Dialog_DateFilter(Group, DateBegin, DateEnd);
  except
    Result := False;
  end;
end;

procedure A_UI_Dialog_Error(const Caption, UserMessage, ExceptMessage: AString_Type); stdcall;
begin
  try
    UI_Dialog_Error(
        AStrings.String_ToWideString(Caption),
        AStrings.String_ToWideString(UserMessage),
        AStrings.String_ToWideString(ExceptMessage));
  except
  end;
end;

function A_UI_Dialog_Font(var FontName: AString_Type; var FontSize: AInteger; FontColor: AColor): ABoolean; stdcall;
var
  TmpFontName: AWideString;
begin
  try
    TmpFontName := AStrings.String_ToWideString(FontName);
    Result := UI_Dialog_Font(TmpFontName, FontSize, FontColor);
    AStrings.String_AssignW(FontName, TmpFontName);
  except
    Result := False;
  end;
end;

function A_UI_Dialog_GetWindow(Dialog: ADialog): AWindow; stdcall;
begin
  try
    Result := UI_Dialog_GetWindow(Dialog);
  except
    Result := 0;
  end;
end;

function A_UI_Dialog_InputBox(const Text: AString_Type; var Value: AString_Type): ABoolean; stdcall;
var
  S: AWideString;
begin
  try
    S := AStrings.String_ToWideString(Value);
    Result := UI_Dialog_InputBox(AStrings.String_ToWideString(Text), S);
    AStrings.String_AssignW(Value, S);
  except
    Result := False;
  end;
end;

function A_UI_Dialog_InputBox2(const Caption, Text1, Text2: AString_Type; var Value1,
    Value2: AString_Type): ABoolean; stdcall;
var
  TmpValue1: AWideString;
  TmpValue2: AWideString;
begin
  try
    TmpValue1 := AStrings.String_ToWideString(Value1);
    TmpValue2 := AStrings.String_ToWideString(Value2);
    Result := UI_Dialog_InputBox2(
        AStrings.String_ToWideString(Caption),
        AStrings.String_ToWideString(Text1),
        AStrings.String_ToWideString(Text2), TmpValue1, TmpValue2);
    AStrings.String_AssignW(Value1, TmpValue1);
    AStrings.String_AssignW(Value2, TmpValue2);
  except
    Result := False;
  end;
end;

function A_UI_Dialog_InputBoxA(const Caption, Text: AString_Type; var Value: AString_Type): ABoolean; stdcall;
var
  TmpValue: AWideString;
begin
  try
    TmpValue := AStrings.String_ToWideString(Value);
    Result := UI_Dialog_InputBoxA(
        AStrings.String_ToWideString(Caption),
        AStrings.String_ToWideString(Text),
        TmpValue);
    AStrings.String_AssignW(Value, TmpValue);
  except
    Result := False;
  end;
end;

function A_UI_Dialog_Login(var UserName, Password: AString_Type; IsSave: ABoolean): ABoolean; stdcall;
var
  TmpUserName: AWideString;
  TmpPassword: AWideString;
begin
  try
    TmpUserName := AStrings.String_ToWideString(UserName);
    TmpPassword := AStrings.String_ToWideString(Password);
    Result := UI_Dialog_Login(TmpUserName, TmpPassword, IsSave);
    AStrings.String_AssignW(UserName, TmpUserName);
    AStrings.String_AssignW(Password, TmpPassword);
  except
    Result := False;
  end;
end;

function A_UI_Dialog_Message(const Text, Caption: AString_Type; Flags: AMessageBoxFlags): ADialogBoxCommands; stdcall;
begin
  try
    Result := UI_Dialog_Message(
        AStrings.String_ToWideString(Text),
        AStrings.String_ToWideString(Caption),
        Flags);
  except
    Result := 0;
  end;
end;

function A_UI_Dialog_New(Buttons: AUIWindowButtons): ADialog; stdcall;
begin
  try
    Result := UI_Dialog_New(Buttons);
  except
    Result := 0;
  end;
end;

function A_UI_Dialog_OpenFile(const InitialDir, Filter, Title: AString_Type;
    var FileName: AString_Type): ABoolean; stdcall;
var
  S: AWideString;
begin
  try
    S := AStrings.String_ToWideString(FileName);
    Result := UI_Dialog_OpenFile(
        AStrings.String_ToWideString(InitialDir),
        AStrings.String_ToWideString(Filter),
        AStrings.String_ToWideString(Title), S);
    AStrings.String_AssignW(FileName, S);
  except
    Result := False;
  end;
end;

function A_UI_Dialog_OpenFileA(const InitialDir, Filter, DefaultExt, Title: AString_Type;
    var FileName: AString_Type; var FilterIndex: AInteger): ABoolean; stdcall;
var
  TmpFileName: AWideString;
begin
  try
    TmpFileName := AStrings.String_ToWideString(FileName);
    Result := UI_Dialog_OpenFileA(
        AStrings.String_ToWideString(InitialDir),
        AStrings.String_ToWideString(Filter),
        AStrings.String_ToWideString(DefaultExt),
        AStrings.String_ToWideString(Title),
        TmpFileName,
        FilterIndex);
    AStrings.String_AssignW(FileName, TmpFileName);
  except
    Result := False;
  end;
end;

function A_UI_Dialog_SaveFile(const Dir, Ext, DefFileName: AString_Type; out Value: AString_Type): AInteger; stdcall;
begin
  try
    Result := AStrings.String_AssignW(Value, UI_Dialog_SaveFile(
        AStrings.String_ToWideString(Dir),
        AStrings.String_ToWideString(Ext),
        AStrings.String_ToWideString(DefFileName)));
  except
    Result := -1;
  end;
end;

function A_UI_Dialog_SaveFileA(const InitialDir, DefExt, DefFileName, Filter: AString_Type;
    var FilterIndex: AInteger; out Value: AString_Type): AInteger; stdcall;
begin
  try
    Result := AStrings.String_AssignW(Value, UI_Dialog_SaveFileA(
        AStrings.String_ToWideString(InitialDir),
        AStrings.String_ToWideString(DefExt),
        AStrings.String_ToWideString(DefFileName),
        AStrings.String_ToWideString(Filter), FilterIndex));
  except
    Result := -1;
  end;
end;

function A_UI_Dialog_SelectDirectory(var Directory: AString_Type): ABoolean; stdcall;
var
  TmpDirectory: AWideString;
begin
  try
    TmpDirectory := AStrings.String_ToWideString(Directory);
    Result := UI_Dialog_SelectDirectory(TmpDirectory);
    AStrings.String_AssignW(Directory, TmpDirectory);
  except
    Result := False;
  end;
end;

end.
 