{
Author: Prof1983 <prof1983@yandex.ru>
Created: 16.02.2009
LastMod: 03.06.2011
Version: 0.1.2+0.2.6+0.3.1
}
unit AUIDialogs;

{DEFINE USE_JEDI}

interface

uses
  {$IFDEF USE_JEDI}JvBaseDlg, JvSelectDirectory,{$ENDIF}
  Dialogs, ABase0{, AString0};

function ExecuteColorDialog(var Color: AColor): ABoolean; stdcall;
function ExecuteFontDialog(var FontName: AWideString; var FontSize: AInteger; var FontColor: AColor): ABoolean; stdcall;
function ExecuteOpenDialogA(const InitialDir, Filter, DefaultExt, Title: AWideString; var FileName: AWideString; var FilterIndex: AInteger): ABoolean; stdcall;
function ExecuteSaveFileDialog(const InitialDir, DefExt, DefFileName: AWideString): AWideString; stdcall;
//function ExecuteSaveFileDialogA(const InitialDir, DefExt, DefFileName, Filter: AString_Type; var FilterIndex: AInteger; out Value: AString_Type): AInteger;
function ExecuteSaveFileDialogA(const InitialDir, DefExt, DefFileName, Filter: AWideString; var FilterIndex: AInteger): AWideString; stdcall;
//function ExecuteSelectDirectoryDialog(var Directory: AString): ABoolean;
function ExecuteSelectDirectoryDialog(var Directory: AWideString): ABoolean; stdcall;

implementation

function ExecuteColorDialog(var Color: AColor): ABoolean; stdcall;
var
  ColorDialog: TColorDialog;
begin
  ColorDialog := TColorDialog.Create(nil);
  try
    ColorDialog.Color := Color;
    Result := ColorDialog.Execute;
    if Result then
      Color := ColorDialog.Color;
  finally
    ColorDialog.Free;
  end;
end;

function ExecuteFontDialog(var FontName: AWideString; var FontSize: AInteger; var FontColor: AColor): ABoolean; stdcall;
var
  FontDialog: TFontDialog;
begin
  FontDialog := TFontDialog.Create(nil);
  try
    FontDialog.Font.Color := FontColor;
    FontDialog.Font.Name := FontName;
    FontDialog.Font.Size := FontSize;
    Result := FontDialog.Execute;
    if Result then
    begin
      FontColor := FontDialog.Font.Color;
      FontName := FontDialog.Font.Name;
      FontSize := FontDialog.Font.Size;
    end;
  finally
    FontDialog.Free;
  end;
end;

function ExecuteOpenDialogA(const InitialDir, Filter, DefaultExt, Title: AWideString; var FileName: AWideString; var FilterIndex: AInteger): ABoolean; stdcall;
var
  Open: TOpenDialog;
begin
  Open := TOpenDialog.Create(nil);
  try
    Open.Options := [ofNoChangeDir,ofFileMustExist,ofPathMustExist];
    Open.Initialdir := InitialDir;
    Open.Filter := Filter;
    Open.DefaultExt := DefaultExt;
    if (Length(Title) = 0) then
      Open.Title := ''
    else
      Open.Title := Title;
    Open.FilterIndex := FilterIndex;
    Result := Open.Execute;
    if Result then
    begin
      FileName := Open.FileName;
      FilterIndex := Open.FilterIndex;
    end;
  finally
    Open.Free;
  end;
end;

function ExecuteSaveFileDialog(const InitialDir, DefExt, DefFileName: AWideString): AWideString; stdcall;
var
  FilterIndex: Integer;
begin
  FilterIndex := 0;
  Result := ExecuteSaveFileDialogA(InitialDir, DefExt, DefFileName, '', FilterIndex);
end;

{
function ExecuteSaveFileDialogA(const InitialDir, DefExt, DefFileName, Filter: AString_Type; var FilterIndex: AInteger; out Value: AString_Type): AInteger;
begin
  Result := String_AssignW(Value, ExecuteSaveFileDialogAW(
      String_ToWideString(InitialDir),
      String_ToWideString(DefExt),
      String_ToWideString(DefFileName),
      String_ToWideString(Filter),
      FilterIndex));
end;
}

function ExecuteSaveFileDialogA(const InitialDir, DefExt, DefFileName, Filter: AWideString; var FilterIndex: AInteger): AWideString; stdcall;
var
  Dialog: TSaveDialog;
begin
  Dialog := TSaveDialog.Create(nil);
  try
    Dialog.InitialDir := InitialDir;
    Dialog.DefaultExt := DefExt;
    Dialog.Options := Dialog.Options + [ofNoChangeDir];
    Dialog.FileName := DefFileName;
    Dialog.Filter := Filter;
    Dialog.FilterIndex := FilterIndex;
    Dialog.Options := Dialog.Options + [ofOverwritePrompt];
    if Dialog.Execute then
    begin
      Result := Dialog.FileName;
      FilterIndex := Dialog.FilterIndex;
    end
    else
      Result := '';
  finally
    Dialog.Free();
  end;
end;

function ExecuteSelectDirectoryDialog(var Directory: AWideString): ABoolean; stdcall;
{$IFDEF USE_JEDI}
var
  Dialog: TJvSelectDirectory;
{$ENDIF USE_JEDI}
begin
  {$IFDEF USE_JEDI}
  Dialog := TJvSelectDirectory.Create(nil);
  try
    Dialog.InitialDir := Directory;
    if Dialog.Execute then
    begin
      Directory := Dialog.Directory;
      Result := True;
    end
    else
      Result := False;
  finally
    Dialog.Free;
  end;
  {$ELSE}
  Result := False;
  {$ENDIF USE_JEDI}
end;

end.
 
