{
Author:  Prof1983 <prof1983@yandex.ru>
Created: 31.05.2011
LastMod: 07.06.2011
Version: 0.3.1
}
unit AUIData;

interface

uses
  ABase0, AUI0;

{ Types }

type
  TAUICalendar = record
    Calendar: AControl;
    OnChange: ACallbackProc;
    OnChangeObj: AInteger;
  end;

type
  TAUIDataSource = record
    DataSource: PADataSource;
    OnDataChange: ACallbackProc;
  end;

type
  TAUIListBox = record
    ListBox: AControl;
    OnClick: ACallbackProc;
  end;

type
  TAUIMenuItem = record
    Parent: Integer;
    MenuItem: AMenuItem;
    OnClick: ACallbackProc;
    Weight: Integer;
  end;

type
  TAUIReport = record
    Parent: AControl;
    TextView: AControl;
    ToolsPanel: AControl;
  end;

type
  TAUIToolBarButton = record
    ToolBar: AControl;
    Button: AButton;
    Weight: Integer;
  end;

{ Varriables }

var
  FButtons: array of record
    Button: AControl;
    OnClick: ACallbackProc;
  end;
  FCalendars: array of TAUICalendar;
  FDataSources: array of TAUIDataSource;
  FListBoxs: array of TAUIListBox;
  FMenuItems: array of TAUIMenuItem;
  FObjects: array of TObject;
  FOnMainFormCreate: AProc;
  FPageControls: array of record
    PageControl: AControl;
    OnChange: ACallbackProc;
  end;
  FReports: array of TAUIReport;
  FIsShowApp: Boolean;
  FMainTrayIcon: AControl;
  FMainWindow: AWindow;
  FHideOnClose: Boolean;
  FToolBarButtons: array of TAUIToolBarButton;
  
var
  miMain: AInteger;
  miHelp: AInteger;
  miFile: AInteger;

function AddObject(Value: TObject): Integer;

implementation

function AddObject(Value: TObject): Integer;
var
  I: Integer;
begin
  I := Length(FObjects);
  SetLength(FObjects, I + 1);
  FObjects[I] := Value;
  Result := Integer(Value);
end;

end.
 