{
Author:  Prof1983 <prof1983@yandex.ru>
Created: 31.05.2011
LastMod: 05.06.2011
Version: 0.3.1
}
unit AUIControl;

interface

uses
  ABase0, AStrings0, AUI0, AUI;

procedure A_UI_Control_Free(Control: AControl); stdcall;
function A_UI_Control_GetColor(Control: AControl): AColor; stdcall;
function A_UI_Control_GetEnabled(Control: AControl): ABoolean; stdcall;
function A_UI_Control_GetHeight(Control: AControl): AInteger; stdcall;
function A_UI_Control_GetHint(Control: AControl; out Value: AString_Type): AInteger; stdcall;
function A_UI_Control_GetName(Control: AControl; out Value: AString_Type): AInteger; stdcall;
function A_UI_Control_GetText(Control: AControl; out Value: AString_Type): AInteger; stdcall;
function A_UI_Control_GetVisible(Control: AControl): ABoolean; stdcall;
function A_UI_Control_GetWidth(Control: AControl): AInteger; stdcall;
procedure A_UI_Control_SetAlign(Control: AControl; Align: TUIAlign); stdcall;
procedure A_UI_Control_SetClientSize(Control: AControl; ClientWidth, ClientHeight: AInteger); stdcall;
procedure A_UI_Control_SetColor(Control: AControl; Color: AColor); stdcall;
procedure A_UI_Control_SetEnabled(Control: AControl; Value: ABoolean); stdcall;
function A_UI_Control_SetFocus(Control: AControl): ABoolean; stdcall;
procedure A_UI_Control_SetFont1(Control: AControl; const FontName: AString_Type; FontSize: AInteger); stdcall;
//  FontColor = 1,    
procedure A_UI_Control_SetFont2(Control: AControl; const FontName: AString_Type; FontSize: AInteger; FontColor: AColor); stdcall;
function A_UI_Control_SetHeight(Control: AControl; Value: AInteger): AInteger; stdcall;
procedure A_UI_Control_SetHint(Control: AControl; const Value: AString_Type); stdcall;
procedure A_UI_Control_SetName(Control: AControl; const Value: AString_Type); stdcall;
procedure A_UI_Control_SetOnChange(Control: AControl; OnChange: ACallbackProc); stdcall;
procedure A_UI_Control_SetOnClick(Control: AControl; Value: ACallbackProc); stdcall;
procedure A_UI_Control_SetPosition(Control: AControl; Left, Top: AInteger); stdcall;
procedure A_UI_Control_SetSize(Control: AControl; Width, Height: AInteger); stdcall;
procedure A_UI_Control_SetText(Control: AControl; const Value: AString_Type); stdcall;
procedure A_UI_Control_SetVisible(Control: AControl; Value: ABoolean); stdcall;
function A_UI_Control_SetWidth(Control: AControl; Value: AInteger): AInteger; stdcall;

implementation

{ A_UI_Control }

procedure A_UI_Control_Free(Control: AControl); stdcall;
begin
  try
    UI_Control_Free(Control);
  except
  end;
end;

function A_UI_Control_GetColor(Control: AControl): AColor; stdcall;
begin
  try
    Result := UI_Control_GetColor(Control);
  except
    Result := 0;
  end;
end;

function A_UI_Control_GetEnabled(Control: AControl): ABoolean; stdcall;
begin
  try
    Result := UI_Control_GetEnabled(Control);
  except
    Result := False;
  end;
end;

function A_UI_Control_GetHeight(Control: AControl): AInteger; stdcall;
begin
  try
    Result := UI_Control_GetHeight(Control);
  except
    Result := 0;
  end;
end;

function A_UI_Control_GetHint(Control: AControl; out Value: AString_Type): AInteger; stdcall;
begin
  try
    AStrings.String_AssignW(Value, UI_Control_GetHint(Control));
    Result := 0;
  except
    Result := -1;
  end;
end;

function A_UI_Control_GetName(Control: AControl; out Value: AString_Type): AInteger; stdcall;
begin
  try
    AStrings.String_AssignW(Value, UI_Control_GetName(Control));
    Result := 0;
  except
    Result := -1;
  end;
end;

function A_UI_Control_GetText(Control: AControl; out Value: AString_Type): AInteger; stdcall;
begin
  try
    AStrings.String_AssignW(Value, UI_Control_GetText(Control));
    Result := 0;
  except
    Result := -1;
  end;
end;

function A_UI_Control_GetVisible(Control: AControl): ABoolean; stdcall;
begin
  try
    Result := UI_Control_GetVisible(Control);
  except
    Result := False;
  end;
end;

function A_UI_Control_GetWidth(Control: AControl): AInteger; stdcall;
begin
  try
    Result := UI_Control_GetWidth(Control);
  except
    Result := 0;
  end;
end;

procedure A_UI_Control_SetAlign(Control: AControl; Align: TUIAlign); stdcall;
begin
  try
    UI_Control_SetAlign(Control, Align);
  except
  end;
end;

procedure A_UI_Control_SetClientSize(Control: AControl; ClientWidth, ClientHeight: AInteger); stdcall;
begin
  try
    UI_Control_SetClientSize(Control, ClientWidth, ClientHeight);
  except
  end;
end;

procedure A_UI_Control_SetColor(Control: AControl; Color: AColor); stdcall;
begin
  try
    UI_Control_SetColor(Control, Color);
  except
  end;
end;

procedure A_UI_Control_SetEnabled(Control: AControl; Value: ABoolean); stdcall;
begin
  try
    UI_Control_SetEnabled(Control, Value);
  except
  end;
end;

function A_UI_Control_SetFocus(Control: AControl): ABoolean; stdcall;
begin
  try
    Result := UI_Control_SetFocus(Control);
  except
    Result := False;
  end;
end;

procedure A_UI_Control_SetFont1(Control: AControl; const FontName: AString_Type; FontSize: AInteger); stdcall;
begin
  try
    UI_Control_SetFont1(Control, AStrings.String_ToWideString(FontName), FontSize);
  except
  end;
end;

procedure A_UI_Control_SetFont2(Control: AControl; const FontName: AString_Type;
    FontSize: AInteger; FontColor: AColor); stdcall;
begin
  try
    UI_Control_SetFont2(Control, AStrings.String_ToWideString(FontName), FontSize, FontColor);
  except
  end;
end;

function A_UI_Control_SetHeight(Control: AControl; Value: AInteger): AInteger; stdcall;
begin
  try
    Result := UI_Control_SetHeight(Control, Value);
  except
    Result := -1;
  end;
end;

procedure A_UI_Control_SetHint(Control: AControl; const Value: AString_Type); stdcall;
begin
  try
    UI_Control_SetHint(Control, AStrings.String_ToWideString(Value));
  except
  end;
end;

procedure A_UI_Control_SetName(Control: AControl; const Value: AString_Type); stdcall;
begin
  try
    UI_Control_SetName(Control, AStrings.String_ToWideString(Value));
  except
  end;
end;

procedure A_UI_Control_SetOnChange(Control: AControl; OnChange: ACallbackProc); stdcall;
begin
  try
    UI_Control_SetOnChange(Control, OnChange);
  except
  end;
end;

procedure A_UI_Control_SetOnChange2(Control: AControl; OnChange: ACallbackProc; Obj: AInteger); stdcall;
begin
  try
    UI_Control_SetOnChange2(Control, OnChange, Obj);
  except
  end;
end;

procedure A_UI_Control_SetOnClick(Control: AControl; Value: ACallbackProc); stdcall;
begin
  try
    UI_Control_SetOnClick(Control, Value);
  except
  end;
end;

procedure A_UI_Control_SetPosition(Control: AControl; Left, Top: Integer); stdcall;
begin
  try
    UI_Control_SetPosition(Control, Left, Top);
  except
  end;
end;

procedure A_UI_Control_SetSize(Control: AControl; Width, Height: Integer); stdcall;
begin
  try
    UI_Control_SetSize(Control, Width, Height);
  except
  end;
end;

procedure A_UI_Control_SetText(Control: AControl; const Value: AString_Type); stdcall;
begin
  try
    UI_Control_SetText(Control, AStrings.String_ToWideString(Value));
  except
  end;
end;

procedure A_UI_Control_SetVisible(Control: AControl; Value: Boolean); stdcall;
begin
  try
    UI_Control_SetVisible(Control, Value);
  except
  end;
end;

function A_UI_Control_SetWidth(Control: AControl; Value: AInteger): AInteger; stdcall;
begin
  try
    Result := UI_Control_SetWidth(Control, Value);
  except
    Result := -1;
  end;
end;

end.
 