{
Abstract: User Interface - Common functions
Author:  Prof1983 <prof1983@yandex.ru>
Created: 06.06.2011
LastMod: 08.06.2011
Version: 0.1.2+0.2.6+0.3.1
}
unit AUICommon;

interface

uses
  Forms, Menus, SysUtils, Windows,
  ABase0, ARuntime0, ASystem0,
  AUIData, AUIMainWindow, AUITrayIcon;

function A_UI_ApplicationHandle: AInteger; stdcall;
function A_UI_HideOnClose: ABoolean; stdcall;
function A_UI_InitMainMenu: AInteger; stdcall;
function A_UI_InitMainTrayIcon: AInteger; stdcall;
function A_UI_InitMenus: AInteger; stdcall;
function A_UI_IsShowApp: ABoolean; stdcall;
procedure A_UI_IsShowApp_Set(Value: ABoolean); stdcall;
procedure A_UI_OnMainFormCreate_Set(Value: AProc); stdcall;
function A_UI_ProcessMessages: AInteger; stdcall;
function A_UI_ShowHelp: AInteger; stdcall;
function A_UI_Shutdown: AInteger; stdcall;

function UI_ApplicationHandle: AInteger;
function UI_HideOnClose: ABoolean;
function UI_InitMainMenu: AInteger; stdcall;
function UI_InitMainTrayIcon: AInteger; stdcall;
function UI_InitMenus: AInteger; stdcall;
procedure UI_InitMenus02; stdcall;
function UI_IsShowApp: ABoolean; stdcall;
procedure UI_IsShowApp_Set(Value: ABoolean); stdcall;
procedure UI_OnMainFormCreate_Set(Value: AProc); stdcall;
function UI_ProcessMessages: AInteger; stdcall;
procedure UI_ShowHelp; stdcall;
function UI_Shutdown: AInteger; stdcall;

implementation

uses
  AUI;

{$IFDEF LangEN}
  {$I 'AUI.en.inc'}
{$ELSE}
  {$I 'AUI.ru.inc'}
{$ENDIF}

{ Events }

procedure miAboutClick(Obj, Data: Integer); stdcall;
begin
  if Assigned(UIAboutClick) then
    UIAboutClick
  else
    UI_Dialog_About;
end;

procedure miExitClick(Obj, Data: Integer); stdcall;
begin
  ARuntime.Shutdown;
end;

{ A_UI }

function A_UI_ApplicationHandle: AInteger; stdcall;
begin
  try
    Result := UI_ApplicationHandle;
  except
    Result := 0;
  end;
end;

function A_UI_HideOnClose: ABoolean; stdcall;
begin
  Result := FHideOnClose;
end;

function A_UI_InitMainMenu: AInteger; stdcall;
begin
  try
    Result := UI_InitMainMenu;
  except
    Result := -1;
  end;
end;

function A_UI_InitMainTrayIcon: AInteger; stdcall;
begin
  try
    Result := UI_InitMainTrayIcon;
  except
    Result := -1;
  end;
end;

function A_UI_InitMenus: AInteger; stdcall;
begin
  try
    Result := UI_InitMenus;
  except
    Result := -1;
  end;
end;

function A_UI_IsShowApp: ABoolean; stdcall;
begin
  Result := FIsShowApp;
end;

procedure A_UI_IsShowApp_Set(Value: ABoolean); stdcall;
begin
  try
    UI_IsShowApp_Set(Value);
  except
  end;
end;

procedure A_UI_OnMainFormCreate_Set(Value: AProc); stdcall;
begin
  FOnMainFormCreate := Value;
end;

function A_UI_ProcessMessages: AInteger; stdcall;
begin
  try
    Result := UI_ProcessMessages;
  except
    Result := -1;
  end;
end;

function A_UI_ShowHelp: AInteger; stdcall;
begin
  try
    UI_ShowHelp;
    Result := 0;
  except
    Result := -1;
  end;
end;

function A_UI_Shutdown: AInteger; stdcall;
begin
  try
    Result := UI_Shutdown;
  except
    Result := -1;
  end;
end;

{ UI }

function UI_ApplicationHandle: AInteger;
begin
  {$IFDEF FPC}
  Result := 0;
  {$ELSE}
  Result := Application.Handle;
  {$ENDIF}
end;

function UI_HideOnClose: ABoolean;
begin
  Result := FHideOnClose;
end;

function UI_InitMainMenu: AInteger; stdcall;
begin
  if (FMainWindow <> 0) then
  begin
    if not(Assigned(TForm(FMainWindow).Menu)) then
      TForm(FMainWindow).Menu := TMainMenu.Create(TForm(FMainWindow));
    miMain := AddObject(TForm(FMainWindow).Menu.Items);
  end;
  Result := 0;
end;

function UI_InitMainTrayIcon: AInteger; stdcall;
begin
  {IFNDEF UNIX}
  if (FMainTrayIcon = 0) then
  begin
    {$IFDEF FPC}
    FMainTrayIcon := AddObject(TAUITrayIcon.Create(nil));
    {$ELSE}
    FMainTrayIcon := AddObject(TAUITrayIcon.Create);
    {$ENDIF}
  end;
  {ENDIF}
  Result := FMainTrayIcon;
end;

function UI_InitMenus: AInteger; stdcall;
begin
  UI_InitMainMenu;
  miFile := UI_MenuItem_Add(miMain, 'File', miFileText, nil, 0, 100);
    UI_MenuItem_Add(miFile, 'Exit', miExitText, miExitClick, 0, 10000);
  miHelp := UI_MenuItem_Add(miMain, 'Help', miHelpText, nil, 0, 1000);
    UI_MenuItem_Add(miHelp, 'About', miAboutText, miAboutClick, 0, 1000);
  Result := miMain;
end;

procedure UI_InitMenus02; stdcall;
begin
  UI_InitMenus;
end;

function UI_IsShowApp: ABoolean; stdcall;
//function UI_GetIsShowApp: ABoolean; stdcall;
begin
  Result := FIsShowApp;
end;

procedure UI_IsShowApp_Set(Value: ABoolean); stdcall;
begin
  if (Value <> FIsShowApp) then
    FIsShowApp := Value;

  if Value then
  begin
    {$IFNDEF FPC}
    ShowWindow(Application.Handle, SW_SHOW);
    {$ENDIF}
    Application.Restore;
    Application.ShowMainForm := True;
    if Assigned(Application.MainForm) then
      Application.MainForm.Show;
    Application.BringToFront;
  end
  else
  begin
    if Assigned(Application.MainForm) then
      Application.MainForm.Hide;
    Application.ShowMainForm := False;
    Application.Minimize;
    {$IFNDEF FPC}
    ShowWindow(Application.Handle, SW_HIDE);
    {$ENDIF}
  end;
end;

procedure UI_OnMainFormCreate_Set(Value: AProc); stdcall;
begin
  FOnMainFormCreate := Value;
end;

function UI_ProcessMessages: AInteger; stdcall;
begin
  Application.ProcessMessages;
  Result := 0;
end;

procedure UI_ShowHelp; stdcall;
begin
{$IFNDEF UNIX}
  Application.HelpFile := ASystem.GetExePath + ChangeFileExt(ASystem.GetExeName, '.hlp');
  Application.HelpCommand(HELP_FINDER, 1);
  //FProjectsApp.ShowHelpWindow;
{$ENDIF}
end;

function UI_Shutdown: AInteger; stdcall;
begin
  MainWindow_Shutdown;
  if (FMainWindow <> 0) then
  begin
    //TForm(FMainWindow).OnCloseQuery := nil;
    TForm(FMainWindow).Close;
    FMainWindow := 0;
    //Application.Terminate;
  end;
  //MainForm.OnCloseQuery := nil;
  //FHideOnClose := False;
  Result := 0;
end;

end.
 