{
Abstract: User Interface
Author:  Prof1983 <prof1983@yandex.ru>
Created: 25.10.2008
LastMod: 09.06.2011
Version: 0.3.1
}
unit AUI03;

{$IFDEF FPC}
  {$mode delphi}{$h+}
{$ENDIF}

{$IFDEF OLDMAINFORM2}
  {$DEFINE OLDMAINFORM}
{$ENDIF}

{$IFDEF FPC}
  {$DEFINE LangEN}
{$ENDIF}

interface

uses
  ABase0, ARuntime0, AStrings0, AUI0, ASystem0,
  AUI, AUICommon, AUIControl, AUIData;

// --- Procs ---

{
  BoxType
    0 - Simple
    1 - HBox
    2 - VBox }
function A_UI_Box_New(Parent: AControl; BoxType: AInteger): AControl; stdcall;

function A_UI_Button_New(Parent: AControl): AButton; stdcall;
// (protected)
procedure A_UI_Button_SetKind(Button: AButton; Kind: TAUIButtonKind); stdcall;

function A_UI_Calendar_GetDate(Calendar: AControl): TDateTime; stdcall;
function A_UI_Calendar_New(Parent: AControl): AControl; stdcall;
procedure A_UI_Calendar_SetMonth(Calendar: AControl; Value: AInteger); stdcall;

function A_UI_ComboBox_Add(ComboBox: AControl; const Value: AString_Type): AInteger; stdcall;
function A_UI_ComboBox_GetItemIndex(ComboBox: AControl): AInteger; stdcall;
function A_UI_ComboBox_New(Parent: AControl): AControl; stdcall;
function A_UI_ComboBox_NewA(Parent: AControl; Left, Top, Width: AInteger): AControl; stdcall;
procedure A_UI_ComboBox_SetItemIndex(ComboBox: AControl; Value: AInteger); stdcall;

function A_UI_DataSource_New: PADataSource; stdcall;
procedure A_UI_DataSource_SetOnDataChange(DataSource: PADataSource; OnDataChange: ACallbackProc); stdcall;

procedure A_UI_Grid_AddColumn(Grid: AControl; const FieldName, Title: AString_Type; Width: Integer); stdcall;
{ GridType
    0 - StringGrid
    1 - DBGrid }
function A_UI_Grid_New(Parent: AControl; GridType: AInteger): AControl; stdcall;
//   DBGrid
procedure A_UI_Grid_RestoreColProps(Grid: AControl; Config: AConfig; const Key: AString_Type; Delimer: AChar = '\'); stdcall;
//   DBGrid
procedure A_UI_Grid_SaveColProps(Grid: AControl; Config: AConfig; const Key: AString_Type; Delimer: AChar = '\'); stdcall;
//     DBGrid
procedure A_UI_Grid_SetColumnWidth(Grid: AControl; ColumnIndex, Width, Persent, MinWidth: AInteger); stdcall;
procedure A_UI_Grid_SetColumnWidthA(Grid: AControl; ColumnIndex, Width, Persent, MinWidth, MaxWidth: AInteger); stdcall;
procedure A_UI_Grid_SetDataSource(Grid: AControl; Value: PADataSource); stdcall;

function A_UI_Image_New(Parent: AControl): AControl; stdcall;
function A_UI_Image_LoadFromFile(Image: AControl; const FileName: AString_Type): ABoolean; stdcall;

function A_UI_Label_New(Parent: AControl): AControl; stdcall;

function A_UI_ListBox_Add(ListBox: AControl; const Text: AString_Type): Integer; stdcall;
procedure A_UI_ListBox_Clear(ListBox: AControl); stdcall;
function A_UI_ListBox_New(Parent: AControl): AControl; stdcall;
{ Typ:
  0 - ListBox
  1 - RadioGroup }
function A_UI_ListBox_NewA(Parent: AControl; Typ: AInteger): AControl; stdcall;
function A_UI_ListBox_GetCount(ListBox: AControl): AInteger; stdcall;
function A_UI_ListBox_GetItem(ListBox: AControl; Index: AInteger; out Value: AString_Type): AInteger; stdcall;
function A_UI_ListBox_GetItemIndex(ListBox: AControl): AInteger; stdcall;
procedure A_UI_ListBox_SetItemIndex(ListBox: AControl; Index: AInteger); stdcall;
procedure A_UI_ListBox_DeleteItem(ListBox: AControl; Index: AInteger); stdcall;
procedure A_UI_ListBox_SetItem(ListBox: AControl; Index: AInteger; const Value: AString_Type); stdcall;

function A_UI_MainToolBar: AControl; stdcall;

function A_UI_MainTrayIcon: ATrayIcon; stdcall;

function A_UI_MainWindow: AWindow; stdcall;
function A_UI_MainWindow_AddMenuItem(const ParentItemName, Name, Text: AString_Type; OnClick: ACallbackProc; ImageID, Weight: Integer): AMenuItem; stdcall;
function A_UI_MainWindow_AddMenuItem2(const ParentItemName, Name, Text: AString_Type; OnClick: ACallbackProc; ImageID, Weight: Integer): AMenuItem; stdcall;
procedure A_UI_MainWindow_Set(Value: AWindow); stdcall;
procedure A_UI_MainWindow_SetA(Value: AWindow; ToolBar, StatusBar: AControl; Config: AConfig); stdcall;

function A_UI_Menu_GetItems(Menu: AMenu): AMenuItem; stdcall;
function A_UI_Menu_New(MenuType: AInteger): AMenu; stdcall;

function A_UI_MenuItem_Add(MenuItem: AMenuItem; const Name, Text: AString_Type; OnClick: ACallbackProc; ImageID, Weight: Integer): AMenuItem; stdcall;
function A_UI_MenuItem_Add2(Parent: AMenuItem; MenuItem: AMenuItem; Weight: AInteger): AMenuItem; stdcall;
function A_UI_MenuItem_FindByName(MenuItem: AMenuItem; const Name: AString_Type): AMenuItem; stdcall;

{   . :
  0 -   ,     (   ) }
function A_UI_PageControl_AddPage(PageControl: AControl; const Name, Text: AString_Type): AControl; stdcall;
function A_UI_PageControl_New(Parent: AControl): AControl; stdcall;

function A_UI_ProgressBar_New(Parent: AControl; Max: AInteger): AControl; stdcall;
function A_UI_ProgressBar_StepIt(ProgressBar: AControl): AInteger; stdcall;

function A_UI_PropertyBox_Add(PropertyBox: AControl; const Caption: AString_Type): Integer; stdcall;
function A_UI_PropertyBox_AddA(PropertyBox: AControl; const Caption, Text, Hint: AString_Type; EditWidth: AInteger): AInteger; stdcall;
function A_UI_PropertyBox_Item_GetValue(PropertyBox: AControl; Index: Integer; out Value: AString_Type): AInteger; stdcall;
procedure A_UI_PropertyBox_Item_SetValue(PropertyBox: AControl; Index: Integer; const Value: AString_Type); stdcall;
function A_UI_PropertyBox_New(Parent: AControl): AControl; stdcall;

function A_UI_SpinButton_New(Parent: AControl): AControl; stdcall;
function A_UI_SpinEdit_New(Parent: AControl): AControl; stdcall;
function A_UI_SpinEdit_NewA(Parent: AControl; Value, MinValue, MaxValue: AInteger): AControl; stdcall;

{ SplitterType
    0 - HSplitter (Align=alTop)
    1 - VSplitter (Align=alLeft)
    2 - HSplitter (Align=alBottom)
    3 - VSplitter (Align=alRight) }
function A_UI_Splitter_New(Parent: AControl; SplitterType: AUISplitterType): AControl; stdcall;

function A_UI_ToolBar_AddButton(ToolBar: AControl; const Name, Text, Hint: AString_Type; OnClick: ACallbackProc; ImageID, Weight: AInteger): AButton; stdcall;
function A_UI_ToolBar_New(Parent: AControl): AControl; stdcall;

{$IFNDEF UNIX}
function A_UI_TrayIcon_GetMenuItems(TrayIcon: ATrayIcon): AMenuItem; stdcall;
{$ENDIF}

function A_UI_TreeView_AddItem(TreeView: AControl; Parent: ATreeNode; Text: AString_Type): ATreeNode; stdcall;
function A_UI_TreeView_New(Parent: AControl): AControl; stdcall;

procedure A_UI_Window_Free(Window: AWindow); stdcall;
function A_UI_Window_GetMenu(Window: AWindow): AMenu; stdcall;
function A_UI_Window_LoadConfig(Window: AWindow; Config: AConfig): ABoolean; stdcall;
function A_UI_Window_LoadConfig2(Window: AWindow; Config: AConfig; const ConfigKey: AString_Type): ABoolean; stdcall;
function A_UI_Window_New: AControl; stdcall;
function A_UI_Window_SaveConfig(Window: AWindow; Config: AConfig): ABoolean; stdcall;
function A_UI_Window_SaveConfig2(Window: AWindow; Config: AConfig; const ConfigKey: AString_Type): ABoolean; stdcall;
procedure A_UI_Window_SetPosition(Window: AWindow; Position: AInteger); stdcall;
function A_UI_Window_ShowModal(Window: AWindow): ABoolean; stdcall;

{ Reports }

function A_UI_Report_New(Parent: AControl): AReport; stdcall;
procedure A_UI_Report_SetText(Report: AReport; const Value: AString_Type); stdcall;

function A_UI_ReportWin_New: AWindow; stdcall;
// ReportWinType -   : 0-TReportForm; 1-SimpleReport
function A_UI_ReportWin_NewA(ReportWinType: AInteger; const Text: AString_Type): AWindow; stdcall;

function A_UI_WaitWin_New(const Caption, Text: AString_Type; MaxPosition: AInteger): AWindow; stdcall;
function A_UI_WaitWin_StepBy(Window: AWindow; Step: AInteger): AInteger; stdcall;

{ Testing }

procedure A_UI_SetHideOnClose(Value: ABoolean); stdcall;
function A_UI_Run: AInteger; stdcall;
function A_UI_MainMenuItem: AMenuItem; stdcall;

//     TextView
function A_UI_TextView_AddLine(TextView: AControl; const Text: AString_Type): AInteger; stdcall;
{     
  ViewType
    0 - TMemo
    1 - RichEdit }
function A_UI_TextView_New(Parent: AControl; ViewType: AInteger): AControl; stdcall;
procedure A_UI_TextView_SetFont(TextView: AControl; const FontName: AString_Type; FontSize: AInteger); stdcall;
procedure A_UI_TextView_SetReadOnly(TextView: AControl; ReadOnly: ABoolean); stdcall;
{ ScrollBars
    0 - ssNone
    1 - ssHorizontal
    2 - ssVertical
    3 - ssBoth }
procedure A_UI_TextView_SetScrollBars(TextView: AControl; ScrollBars: AInteger); stdcall;
procedure A_UI_TextView_SetWordWrap(TextView: AControl; Value: ABoolean); stdcall;

procedure A_UI_Window_FreeAndNil(var Window: AWindow); stdcall;
procedure A_UI_Window_SetBorderStyle(Window: AWindow; BorderStyle: AInteger); stdcall;
procedure A_UI_Window_SetFormStyle(Window: AWindow; FormStyle: AInteger); stdcall;

function A_UI_ShellExecute(const Operation, FileName, Parameters, Directory: AString_Type): AInteger; stdcall;
function A_UI_Object_Add(Value: AInteger): AInteger; stdcall;

function A_UI_MainWindow_GetLeftContainer: AControl; stdcall;
function A_UI_MainWindow_GetMainContainer: AControl; stdcall;
function A_UI_MainWindow_GetRightContainer: AControl; stdcall;

{ Protected }

function UI_Boot: AInteger; stdcall;
function UI_Done: AInteger; stdcall;
function UI_Init: AInteger; stdcall;

implementation

uses
  AUIEdit, AUIExp;
(*
  //LResources,
  {$IFDEF UNIX}
    {$IFDEF UseCThreads}
    cthreads,
    {$ENDIF}
  {$ENDIF}
  {$IFDEF FPC}Interfaces,{$ELSE}Mask,{$ENDIF}
  Buttons, Classes, Controls, ComCtrls, DB, DBGrids, ExtCtrls, Forms, Graphics, Grids, Menus, StdCtrls, SysUtils,
  {$IFDEF MSWINDOWS}ShellApi, Windows,{$ENDIF}
  AUICalendar, AUIEdit, AUIGrids, AUIForm, AUISpin, AUITrayIcon,
  {$IFDEF MSWINDOWS}
  fError, fInputDialog, fLogin, fMessage, fPasswordDialog, {$IFNDEF FPC}fSimpleReport,{$ENDIF} fWait,
  {$ENDIF}
  {$IFNDEF FPC}fCalendar, fDateFilter, fReport,{$ENDIF}
  {$IFDEF OLDMAINFORM}fMain,{$ENDIF}
  ASettings0, AUIDialog, AUIDialogs, AUIMainWindow, AUIPropertyBox, fAbout;
*)

{$IFDEF LangEN}
  {$I 'AUI.en.inc'}
{$ELSE}
  {$I 'AUI.ru.inc'}
{$ENDIF}

const
  UIProcs: AUIProcs_Type = (
    IsShowApp: A_UI_IsShowApp;
    InitMainTrayIcon: A_UI_InitMainTrayIcon;
    InitMenus: A_UI_InitMenus;
    ProcessMessages: A_UI_ProcessMessages;
    IsShowApp_Set: A_UI_IsShowApp_Set;
    ShowHelp: A_UI_ShowHelp;
    Shutdown: A_UI_Shutdown;

    Box_New: A_UI_Box_New; {07}
    Button_New: A_UI_Button_New;

    Control_Free: A_UI_Control_Free;
    Control_FreeAndNil: UI_Control_FreeAndNil;
    Control_GetEnabled: A_UI_Control_GetEnabled;
    Control_GetHeight: A_UI_Control_GetHeight;
    Control_GetHintW: UI_Control_GetHint;
    Control_GetNameW: UI_Control_GetName;
    Control_GetTextW: UI_Control_GetText;
    Control_GetVisible: A_UI_Control_GetVisible;
    Control_GetWidth: A_UI_Control_GetWidth;
    Control_SetAlign: A_UI_Control_SetAlign;
    Control_SetClientSize: A_UI_Control_SetClientSize;
    Control_SetColor: A_UI_Control_SetColor;
    Control_SetEnabled: A_UI_Control_SetEnabled;
    Control_SetFocus: A_UI_Control_SetFocus;
    Control_SetHintW: UI_Control_SetHint;
    Control_SetNameW: UI_Control_SetName;
    Control_SetOnChange: A_UI_Control_SetOnChange;
    Control_SetOnClick: A_UI_Control_SetOnClick;
    Control_SetPosition: A_UI_Control_SetPosition;
    Control_SetSize: A_UI_Control_SetSize;
    Control_SetTextW: UI_Control_SetText;
    Control_SetVisible: A_UI_Control_SetVisible;
    Control_SetWidth: A_UI_Control_SetWidth;

    DataSource_New: A_UI_DataSource_New;
    DataSource_SetOnDataChange: A_UI_DataSource_SetOnDataChange;

    Dialog_About: UI_Dialog_About;
    Dialog_Calendar: UI_Dialog_Calendar;
    Dialog_Color: UI_Dialog_Color;
    Dialog_DateFilter: UI_Dialog_DateFilter;
    Dialog_Error: UI_Dialog_Error;
    Dialog_Font: UI_Dialog_Font;
    Dialog_GetWindow: UI_Dialog_GetWindow;
    Dialog_InputBox: UI_Dialog_InputBox;
    Dialog_InputBox2: UI_Dialog_InputBox2;
    Dialog_InputBoxA: UI_Dialog_InputBoxA;
    Dialog_Login: UI_Dialog_Login;
    Dialog_Message: UI_Dialog_Message;
    Dialog_New: UI_Dialog_New;
    Dialog_OpenFile: UI_Dialog_OpenFile;
    Dialog_OpenFileA: UI_Dialog_OpenFileA;
    Dialog_SaveFile: UI_Dialog_SaveFile;
    Dialog_SaveFileA: UI_Dialog_SaveFileA;

    Edit_CheckDate: A_UI_Edit_CheckDate;
    Edit_CheckFloat: A_UI_Edit_CheckFloat;
    Edit_CheckInt: A_UI_Edit_CheckInt;
    Edit_New: A_UI_Edit_New;
    Edit_NewA: A_UI_Edit_NewA;

    Grid_AddColumn: UI_Grid_AddColumn;
    Grid_New: A_UI_Grid_New;
    Grid_RestoreColProps: UI_Grid_RestoreColProps;
    Grid_SaveColProps: UI_Grid_SaveColProps;
    Grid_SetColumnWidth: A_UI_Grid_SetColumnWidth;
    Grid_SetColumnWidthA: A_UI_Grid_SetColumnWidthA;
    Grid_SetDataSource: A_UI_Grid_SetDataSource;

    Image_New: A_UI_Image_New;
    Image_LoadFromFile: UI_Image_LoadFromFile;

    Label_New: A_UI_Label_New;
    Reserved0: 0; //Label_SetFont: AUI_Control_SetFont1;

    ListBox_Add: UI_ListBox_Add;
    ListBox_Clear: A_UI_ListBox_Clear;
    ListBox_New: A_UI_ListBox_New;

    MainToolBar: A_UI_MainToolBar;
    Reserved1: 0; //MainToolBar_Set: AUI_MainToolBar_Set;

    MainTrayIcon: A_UI_MainTrayIcon;

    MainWindow: A_UI_MainWindow;
    MainWindow_AddMenuItem: UI_MainWindow_AddMenuItem;
    MainWindow_AddMenuItem2: UI_MainWindow_AddMenuItem2;
    MainWindow_GetLeftContainer: A_UI_MainWindow_GetLeftContainer;
    MainWindow_GetMainContainer: A_UI_MainWindow_GetMainContainer;
    MainWindow_GetRightContainer: A_UI_MainWindow_GetRightContainer;
    MainWindow_Set: A_UI_MainWindow_Set;

    Menu_GetItems: A_UI_Menu_GetItems;
    Menu_New: A_UI_Menu_New;

    MenuItem_Add: UI_MenuItem_Add;
    MenuItem_Add2: A_UI_MenuItem_Add2;
    MenuItem_FindByName: UI_MenuItem_FindByName;

    PageControl_AddPageW: UI_PageControl_AddPage;
    PageControl_New: A_UI_PageControl_New;

    ProgressBar_New: A_UI_ProgressBar_New;
    ProgressBar_StepIt: A_UI_ProgressBar_StepIt;

    PropertyBox_Add: UI_PropertyBox_Add;
    PropertyBox_AddA: UI_PropertyBox_AddA;
    PropertyBox_Item_GetValue: UI_PropertyBox_Item_GetValue;
    PropertyBox_Item_SetValue: UI_PropertyBox_Item_SetValue;
    PropertyBox_New: A_UI_PropertyBox_New;

    Splitter_New: A_UI_Splitter_New;

    TextView_AddLine: UI_TextView_AddLine;
    TextView_New: A_UI_TextView_New;
    TextView_SetFont: UI_TextView_SetFont;
    TextView_SetReadOnly: A_UI_TextView_SetReadOnly;
    TextView_SetScrollBars: A_UI_TextView_SetScrollBars;
    TextView_SetWordWrap: A_UI_TextView_SetWordWrap;

    ToolBar_AddButton: UI_ToolBar_AddButton;
    ToolBar_New: A_UI_ToolBar_New;

    TrayIcon_GetMenuItems: A_UI_TrayIcon_GetMenuItems;

    TreeView_AddItem: UI_TreeView_AddItem;
    TreeView_New: A_UI_TreeView_New;

    Window_Free: UI_Window_Free;
    Window_GetMenu: A_UI_Window_GetMenu;
    Window_LoadConfig: A_UI_Window_LoadConfig;
    Window_LoadConfig2: UI_Window_LoadConfig2;
    Window_New: A_UI_Window_New;
    Window_SaveConfig: A_UI_Window_SaveConfig;
    Window_SaveConfig2: UI_Window_SaveConfig2;
    Window_SetBorderStyle: A_UI_Window_SetBorderStyle;
    Window_SetFormStyle: A_UI_Window_SetFormStyle;
    Window_SetPosition: A_UI_Window_SetPosition;
    Window_ShowModal: A_UI_Window_ShowModal;

    ReportWin_New: A_UI_ReportWin_New;
    WaitWin_New: UI_WaitWin_New;
    WaitWin_StepBy: A_UI_WaitWin_StepBy;
    OnMainFormCreate_Set: A_UI_OnMainFormCreate_Set;
    MainWindow_SetA: A_UI_MainWindow_SetA;

    ReportWin_NewA: UI_ReportWin_NewA;
    Calendar_GetDate: A_UI_Calendar_GetDate;
    Calendar_New: A_UI_Calendar_New;
    Calendar_SetMonth: A_UI_Calendar_SetMonth;
    Report_New: A_UI_Report_New;
    Report_SetText: UI_Report_SetText;
    InitMainMenu: A_UI_InitMainMenu;
    Control_SetFont1: UI_Control_SetFont1;
    Control_SetFont2: UI_Control_SetFont2;
    Dialog_About_New: UI_Dialog_About_New;
    Dialog_AddButton: UI_Dialog_AddButton;

    Reserved132: 0;
    Reserved133: 0;
    Reserved134: 0;
    Reserved135: 0;
    Reserved136: 0;
    Reserved137: 0;
    Reserved138: 0;
    Reserved139: 0;
    Reserved140: 0;
    Reserved141: 0;
    Reserved142: 0;
    Reserved143: 0;

    Reserved144: 0;
    Reserved145: 0;
    Reserved146: 0;
    Reserved147: 0;
    Reserved148: 0;
    Reserved149: 0;
    Reserved150: 0;
    Reserved151: 0;
    Reserved152: 0;
    Reserved153: 0;
    Reserved154: 0;
    Reserved155: 0;
    Reserved156: 0;
    Reserved157: 0;
    Reserved158: 0;
    Reserved159: 0;

    Reserved160: 0;
    Reserved161: 0;
    Reserved162: 0;
    Reserved163: 0;
    Reserved164: 0;
    Reserved165: 0;
    Reserved166: 0;
    Reserved167: 0;
    Reserved168: 0;
    Reserved169: 0;
    Reserved170: 0;
    Reserved171: 0;
    Reserved172: 0;
    Reserved173: 0;
    Reserved174: 0;
    Reserved175: 0;

    Reserved176: 0;
    Reserved177: 0;
    Reserved178: 0;
    Reserved179: 0;
    Reserved180: 0;
    Reserved181: 0;
    Reserved182: 0;
    Reserved183: 0;
    Reserved184: 0;
    Reserved185: 0;
    Reserved186: 0;
    Reserved187: 0;
    Reserved188: 0;
    Reserved189: 0;
    Reserved190: 0;
    Reserved191: 0;

    Reserved192: 0;
    Reserved193: 0;
    Reserved194: 0;
    Reserved195: 0;
    Reserved196: 0;
    Reserved197: 0;
    Reserved198: 0;
    Reserved199: 0;
    Reserved200: 0;
    Reserved201: 0;
    Reserved202: 0;
    Reserved203: 0;
    Reserved204: 0;
    Reserved205: 0;
    Reserved206: 0;
    Reserved207: 0;

    Reserved208: 0;
    Reserved209: 0;
    Reserved210: 0;
    Reserved211: 0;
    Reserved212: 0;
    Reserved213: 0;
    Reserved214: 0;
    Reserved215: 0;
    Reserved216: 0;
    Reserved217: 0;
    Reserved218: 0;
    Reserved219: 0;
    Reserved220: 0;
    Reserved221: 0;
    Reserved222: 0;
    Reserved223: 0;

    Reserved224: 0;
    Reserved225: 0;
    Reserved226: 0;
    Reserved227: 0;
    Reserved228: 0;
    Reserved229: 0;
    Reserved230: 0;
    Reserved231: 0;
    Reserved232: 0;
    Reserved233: 0;
    Reserved234: 0;
    Reserved235: 0;
    Reserved236: 0;
    Reserved237: 0;
    Reserved238: 0;
    Reserved239: 0;

    Reserved240: 0;
    Reserved241: 0;
    Reserved242: 0;
    Reserved243: 0;
    Reserved244: 0;
    Reserved245: 0;
    Reserved246: 0;
    Reserved247: 0;
    Reserved248: 0;
    Reserved249: 0;
    Reserved250: 0;
    Reserved251: 0;
    Reserved252: 0;
    Reserved253: 0;
    Reserved254: 0;
    Reserved255: 0;
    );

const
  Module: AModule_Type = (
    Version: AUI_Version;
    Uid: AUI_Uid;
    Name: AUI_Name;
    Description: nil;
    Init: UI_Init;
    Done: UI_Done;
    Reserved06: 0;
    Procs: Addr(UIProcs);
    );

{ Module }

function UI_Boot: AInteger; stdcall;
begin
  Result := ARuntime.Module_Register(Addr(Module));
end;

function UI_Done: AInteger; stdcall;
begin
  Result := UI_DoneA;
end;

function UI_Init: AInteger; stdcall;
begin
  if (ARuntime.Modules_InitByUid(ASystem_Uid) < 0) then
  begin
    Result := -1;
    Exit;
  end;

  //ARuntime.Modules_InitByUid(ASystem_Uid);

  Result := UI_InitA;
end;

{ UI Public }

function A_UI_Run: AInteger; stdcall;
begin
  try
    Result := UI_Run;
  except
    Result := -1;
  end;
end;

procedure A_UI_SetHideOnClose(Value: ABoolean); stdcall;
begin
  FHideOnClose := Value;
end;

function A_UI_ShellExecute(const Operation, FileName, Parameters, Directory: AString_Type): AInteger; stdcall;
begin
  try
    Result := UI_ShellExecute(
        AStrings.String_ToWideString(Operation),
        AStrings.String_ToWideString(FileName),
        AStrings.String_ToWideString(Parameters),
        AStrings.String_ToWideString(Directory));
  except
    Result := -1;
  end;
end;

{ Box }

function A_UI_Box_New(Parent: AControl; BoxType: AInteger): AControl; stdcall;
begin
  try
    Result := UI_Box_New(Parent, BoxType);
  except
    Result := 0;
  end;
end;

{ Button }

function A_UI_Button_New(Parent: AControl): AButton; stdcall;
begin
  try
    Result := UI_Button_New(Parent);
  except
    Result := 0;
  end;
end;

procedure A_UI_Button_SetKind(Button: AButton; Kind: TAUIButtonKind); stdcall;
begin
  try
    UI_Button_SetKind(Button, Kind);
  except
  end;
end;

{ Calendar }

function A_UI_Calendar_GetDate(Calendar: AControl): TDateTime; stdcall;
begin
  try
    Result := UI_Calendar_GetDate(Calendar);
  except
    Result := 0;
  end;
end;

function A_UI_Calendar_New(Parent: AControl): AControl; stdcall;
begin
  try
    Result := UI_Calendar_New(Parent);
  except
    Result := 0;
  end;
end;

procedure A_UI_Calendar_SetMonth(Calendar: AControl; Value: AInteger); stdcall;
begin
  try
    UI_Calendar_SetMonth(Calendar, Value);
  except
  end;
end;

{ ComboBox }

function A_UI_ComboBox_Add(ComboBox: AControl; const Value: AString_Type): AInteger; stdcall;
begin
  try
    Result := UI_ComboBox_Add(ComboBox, AStrings.String_ToWideString(Value));
  except
    Result := -1;
  end;
end;

function A_UI_ComboBox_GetItemIndex(ComboBox: AControl): AInteger; stdcall;
begin
  try
    Result := UI_ComboBox_GetItemIndex(ComboBox);
  except
    Result := -1;
  end;
end;

function A_UI_ComboBox_New(Parent: AControl): AControl; stdcall;
begin
  try
    Result := UI_ComboBox_New(Parent);
  except
    Result := 0;
  end;
end;

function A_UI_ComboBox_NewA(Parent: AControl; Left, Top, Width: AInteger): AControl; stdcall;
begin
  try
    Result := UI_ComboBox_NewA(Parent, Left, Top, Width);
  except
    Result := 0;
  end;
end;

procedure A_UI_ComboBox_SetItemIndex(ComboBox: AControl; Value: AInteger); stdcall;
begin
  try
    UI_ComboBox_SetItemIndex(ComboBox, Value);
  except
  end;
end;

{ DataSource }

function A_UI_DataSource_New: PADataSource; stdcall;
begin
  try
    Result := UI_DataSource_New;
  except
    Result := 0;
  end;
end;

procedure A_UI_DataSource_SetOnDataChange(DataSource: PADataSource; OnDataChange: ACallbackProc); stdcall;
begin
  try
    UI_DataSource_SetOnDataChange(DataSource, OnDataChange);
  except
  end;
end;

{ Grid }

procedure A_UI_Grid_AddColumn(Grid: AControl; const FieldName, Title: AString_Type; Width: Integer);
begin
  try
    UI_Grid_AddColumn(Grid,
        AStrings.String_ToWideString(FieldName),
        AStrings.String_ToWideString(Title),
        Width);
  except
  end;
end;

function A_UI_Grid_New(Parent: AControl; GridType: AInteger): AControl; stdcall;
begin
  try
    Result := UI_Grid_New(Parent, GridType);
  except
    Result := 0;
  end;
end;

procedure A_UI_Grid_RestoreColProps(Grid: AControl; Config: AConfig; const Key: AString_Type; Delimer: AChar); stdcall;
begin
  try
    UI_Grid_RestoreColProps(Grid, Config, AStrings.String_ToWideString(Key), Delimer);
  except
  end;
end;

procedure A_UI_Grid_SaveColProps(Grid: AControl; Config: AConfig; const Key: AString_Type; Delimer: AChar); stdcall;
begin
  try
    UI_Grid_SaveColProps(Grid, Config, AStrings.String_ToWideString(Key), Delimer);
  except
  end;
end;

procedure A_UI_Grid_SetColumnWidth(Grid: AControl; ColumnIndex, Width, Persent, MinWidth: AInteger); stdcall;
begin
  try
    UI_Grid_SetColumnWidth(Grid, ColumnIndex, Width, Persent, MinWidth);
  except
  end;
end;

procedure A_UI_Grid_SetColumnWidthA(Grid: AControl; ColumnIndex, Width, Persent, MinWidth, MaxWidth: AInteger); stdcall;
begin
  try
    UI_Grid_SetColumnWidthA(Grid, ColumnIndex, Width, Persent, MinWidth, MaxWidth);
  except
  end;
end;

procedure A_UI_Grid_SetDataSource(Grid: AControl; Value: PADataSource); stdcall;
begin
  try
    UI_Grid_SetDataSource(Grid, Value);
  except
  end;
end;

{ Image }

function A_UI_Image_New(Parent: AControl): AControl; stdcall;
begin
  try
    Result := UI_Image_New(Parent);
  except
    Result := 0;
  end;
end;

function A_UI_Image_LoadFromFile(Image: AControl; const FileName: AString_Type): ABoolean; stdcall;
begin
  try
    Result := UI_Image_LoadFromFile(Image, AStrings.String_ToWideString(FileName));
  except
    Result := False;
  end;
end;

{ Label }

function A_UI_Label_New(Parent: AControl): AControl; stdcall;
begin
  try
    Result := UI_Label_New(Parent);
  except
    Result := 0;
  end;
end;

{ ListBox }

function A_UI_ListBox_Add(ListBox: AControl; const Text: AString_Type): Integer; stdcall;
begin
  try
    Result := UI_ListBox_Add(ListBox, AStrings.String_ToWideString(Text));
  except
    Result := -1;
  end;
end;

procedure A_UI_ListBox_Clear(ListBox: AControl); stdcall;
begin
  try
    UI_ListBox_Clear(ListBox);
  except
  end;
end;

procedure A_UI_ListBox_DeleteItem(ListBox: AControl; Index: AInteger); stdcall;
begin
  try
    UI_ListBox_DeleteItem(ListBox, Index);
  except
  end;
end;

function A_UI_ListBox_GetCount(ListBox: AControl): AInteger; stdcall;
begin
  try
    Result := UI_ListBox_GetCount(ListBox);
  except
    Result := 0;
  end;
end;

function A_UI_ListBox_GetItem(ListBox: AControl; Index: AInteger; out Value: AString_Type): AInteger; stdcall;
begin
  try
    Result := AStrings.String_AssignW(Value, UI_ListBox_GetItem(ListBox, Index));
  except
    Result := 0;
  end;
end;

function A_UI_ListBox_GetItemIndex(ListBox: AControl): AInteger; stdcall;
begin
  try
    Result := UI_ListBox_GetItemIndex(ListBox);
  except
    Result := 0;
  end;
end;

function A_UI_ListBox_New(Parent: AControl): AControl; stdcall;
begin
  Result := A_UI_ListBox_NewA(Parent, 0);
end;

function A_UI_ListBox_NewA(Parent: AControl; Typ: AInteger): AControl; stdcall;
begin
  try
    Result := UI_ListBox_NewA(Parent, Typ);
  except
    Result := 0;
  end;
end;

procedure A_UI_ListBox_SetItem(ListBox: AControl; Index: AInteger; const Value: AString_Type); stdcall;
begin
  try
    UI_ListBox_SetItem(ListBox, Index, AStrings.String_ToWideString(Value));
  except
  end;
end;

procedure A_UI_ListBox_SetItemIndex(ListBox: AControl; Index: AInteger); stdcall;
begin
  try
    UI_ListBox_SetItemIndex(ListBox, Index);
  except
  end;
end;

{ MainMenuItem }

function A_UI_MainMenuItem: AMenuItem; stdcall;
begin
  Result := miMain;
end;

{ MainToolBar }

function A_UI_MainToolBar: AControl; stdcall;
begin
  try
    Result := UI_MainToolBar;
  except
    Result := 0;
  end;
end;

{ MainTrayIcon }

function A_UI_MainTrayIcon: ATrayIcon;
begin
  Result := FMainTrayIcon;
end;

{ MainWindow }

function A_UI_MainWindow: AWindow; stdcall;
begin
  Result := FMainWindow;
end;

function A_UI_MainWindow_AddMenuItem(const ParentItemName, Name, Text: AString_Type;
    OnClick: ACallbackProc; ImageID, Weight: Integer): AMenuItem; stdcall;
begin
  Result := A_UI_MainWindow_AddMenuItem2(ParentItemName, Name, Text, OnClick, ImageID, Weight);
end;

function A_UI_MainWindow_AddMenuItem2(const ParentItemName, Name, Text: AString_Type;
    OnClick: ACallbackProc; ImageID, Weight: Integer): AMenuItem; stdcall;
begin
  try
    Result := UI_MainWindow_AddMenuItem2(
        AStrings.String_ToWideString(ParentItemName),
        AStrings.String_ToWideString(Name),
        AStrings.String_ToWideString(Text),
        OnClick, ImageID, Weight);
  except
    Result := 0;
  end;
end;

function A_UI_MainWindow_GetLeftContainer: AControl; stdcall;
begin
  try
    Result := UI_MainWindow_GetLeftContainer;
  except
    Result := 0;
  end;
end;

function A_UI_MainWindow_GetMainContainer: AControl; stdcall;
begin
  try
    Result := UI_MainWindow_GetMainContainer;
  except
    Result := 0;
  end;
end;

function A_UI_MainWindow_GetRightContainer: AControl; stdcall;
begin
  try
    Result := UI_MainWindow_GetRightContainer;
  except
    Result := 0;
  end;
end;

procedure A_UI_MainWindow_Set(Value: AWindow); stdcall;
begin
  A_UI_MainWindow_SetA(Value, 0, 0, 0);
end;

procedure A_UI_MainWindow_SetA(Value: AWindow; ToolBar, StatusBar: AControl; Config: AConfig); stdcall;
begin
  try
    UI_MainWindow_SetA(Value, ToolBar, StatusBar, Config);
  except
  end;
end;

{ Menu }

function A_UI_Menu_GetItems(Menu: AMenu): AMenuItem; stdcall;
begin
  try
    Result := UI_Menu_GetItems(Menu);
  except
    Result := 0;
  end;
end;

function A_UI_Menu_New(MenuType: AInteger): AMenu; stdcall;
begin
  try
    Result := UI_Menu_New(MenuType);
  except
    Result := 0;
  end;
end;

{ MenuItem }

function A_UI_MenuItem_Add(MenuItem: AMenuItem; const Name, Text: AString_Type;
    OnClick: ACallbackProc; ImageID, Weight: Integer): AMenuItem; stdcall;
begin
  try
    Result := UI_MenuItem_Add(MenuItem,
        AStrings.String_ToWideString(Name),
        AStrings.String_ToWideString(Text),
        OnClick, ImageID, Weight);
  except
    Result := 0;
  end;
end;

function A_UI_MenuItem_Add2(Parent: AMenuItem; MenuItem: AMenuItem; Weight: Integer): AMenuItem; stdcall;
begin
  try
    Result := UI_MenuItem_Add2(Parent, MenuItem, Weight);
  except
    Result := 0;
  end;
end;

function A_UI_MenuItem_FindByName(MenuItem: AMenuItem; const Name: AString_Type): AMenuItem; stdcall;
begin
  try
    Result := UI_MenuItem_FindByName(MenuItem, AStrings.String_ToWideString(Name));
  except
    Result := 0;
  end;
end;

{ Objects }

function A_UI_Object_Add(Value: AInteger): AInteger; stdcall;
begin
  try
    Result := UI_Object_Add(Value);
  except
    Result := 0;
  end;
end;

{ PageControl }

function A_UI_PageControl_AddPage(PageControl: AControl; const Name, Text: AString_Type): AControl; stdcall;
begin
  try
    Result := UI_PageControl_AddPage(PageControl, AStrings.String_ToWideString(Name), AStrings.String_ToWideString(Text));
  except
    Result := 0;
  end;
end;

function A_UI_PageControl_New(Parent: AControl): AControl; stdcall;
begin
  try
    Result := UI_PageControl_New(Parent);
  except
    Result := 0;
  end;
end;

{ ProgressBar }

function A_UI_ProgressBar_New(Parent: AControl; Max: AInteger): AControl; stdcall;
begin
  try
    Result := UI_ProgressBar_New(Parent, Max);
  except
    Result := 0;
  end;
end;

function A_UI_ProgressBar_StepIt(ProgressBar: AControl): AInteger; stdcall;
begin
  try
    Result := UI_ProgressBar_StepIt(ProgressBar);
  except
    Result := 0;
  end;
end;

{ PropertyBox }

function A_UI_PropertyBox_Add(PropertyBox: AControl; const Caption: AString_Type): Integer; stdcall;
begin
  try
    Result := UI_PropertyBox_Add(PropertyBox, AStrings.String_ToWideString(Caption));
  except
    Result := 0;
  end;
end;

function A_UI_PropertyBox_AddA(PropertyBox: AControl; const Caption, Text, Hint: AString_Type;
    EditWidth: AInteger): AInteger; stdcall;
begin
  try
    Result := UI_PropertyBox_AddA(PropertyBox,
        AStrings.String_ToWideString(Caption),
        AStrings.String_ToWideString(Text),
        AStrings.String_ToWideString(Hint),
        EditWidth);
  except
    Result := 0;
  end;
end;

function A_UI_PropertyBox_Item_GetValue(PropertyBox: AControl; Index: Integer; out Value: AString_Type): AInteger; stdcall;
begin
  try
    Result := AStrings.String_AssignW(Value, UI_PropertyBox_Item_GetValue(PropertyBox, Index));
  except
    Result := 0;
  end;
end;

procedure A_UI_PropertyBox_Item_SetValue(PropertyBox: AControl; Index: Integer; const Value: AString_Type); stdcall;
begin
  try
    UI_PropertyBox_Item_SetValue(PropertyBox, Index, AStrings.String_ToWideString(Value));
  except
  end;
end;

function A_UI_PropertyBox_New(Parent: AControl): AControl; stdcall;
begin
  try
    Result := UI_PropertyBox_New(Parent);
  except
    Result := 0;
  end;
end;

{ Report }

function A_UI_Report_New(Parent: AControl): AReport; stdcall;
begin
  try
    Result := UI_Report_New(Parent);
  except
    Result := 0;
  end;
end;

procedure A_UI_Report_SetText(Report: AReport; const Value: AString_Type); stdcall;
begin
  try
    UI_Report_SetText(Report, AStrings.String_ToWideString(Value));
  except
  end;
end;

{ ReportWin }

function A_UI_ReportWin_New: AWindow; stdcall;
begin
  Result := UI_ReportWin_NewA(0, '');
end;

function A_UI_ReportWin_NewA(ReportWinType: AInteger; const Text: AString_Type): AWindow; stdcall;
begin
  try
    Result := UI_ReportWin_NewA(ReportWinType, AStrings.String_ToWideString(Text));
  except
    Result := 0;
  end;
end;

{ SpinButton }

function A_UI_SpinButton_New(Parent: AControl): AControl; stdcall;
begin
  try
    Result := UI_SpinButton_New(Parent);
  except
    Result := 0;
  end;
end;

{ SpinEdit }

function A_UI_SpinEdit_New(Parent: AControl): AControl; stdcall;
begin
  try
    Result := UI_SpinEdit_New(Parent);
  except
    Result := 0;
  end;
end;

function A_UI_SpinEdit_NewA(Parent: AControl; Value, MinValue, MaxValue: AInteger): AControl; stdcall;
begin
  try
    Result := UI_SpinEdit_NewA(Parent, Value, MinValue, MaxValue);
  except
    Result := 0;
  end;
end;

{ Splitter }

function A_UI_Splitter_New(Parent: AControl; SplitterType: AUISplitterType): AControl; stdcall;
begin
  try
    Result := UI_Splitter_New(Parent, SplitterType);
  except
    Result := 0;
  end;
end;

{ TextView }

function A_UI_TextView_AddLine(TextView: AControl; const Text: AString_Type): AInteger; stdcall;
begin
  try
    Result := UI_TextView_AddLine(TextView, AStrings.String_ToWideString(Text));
  except
    Result := -1;
  end;
end;

function A_UI_TextView_New(Parent: AControl; ViewType: AInteger): AControl; stdcall;
begin
  try
    Result := UI_TextView_New(Parent, ViewType);
  except
    Result := 0;
  end;
end;

procedure A_UI_TextView_SetFont(TextView: AControl; const FontName: AString_Type; FontSize: AInteger); stdcall;
begin
  try
    UI_TextView_SetFont(TextView, AStrings.String_ToWideString(FontName), FontSize);
  except
  end;
end;

procedure A_UI_TextView_SetReadOnly(TextView: AControl; ReadOnly: ABoolean); stdcall;
begin
  try
    UI_TextView_SetReadOnly(TextView, ReadOnly);
  except
  end;
end;

procedure A_UI_TextView_SetScrollBars(TextView: AControl; ScrollBars: AInteger); stdcall;
begin
  try
    UI_TextView_SetScrollBars(TextView, ScrollBars);
  except
  end;
end;

procedure A_UI_TextView_SetWordWrap(TextView: AControl; Value: ABoolean); stdcall;
begin
  try
    UI_TextView_SetWordWrap(TextView, Value);
  except
  end;
end;

{ ToolBar }

function A_UI_ToolBar_AddButton(ToolBar: AControl; const Name, Text, Hint: AString_Type;
    OnClick: ACallbackProc; ImageID, Weight: AInteger): AButton; stdcall;
begin
  try
    Result := UI_ToolBar_AddButton(ToolBar,
        AStrings.String_ToWideString(Name),
        AStrings.String_ToWideString(Text),
        AStrings.String_ToWideString(Hint),
        OnClick, ImageId, Weight);
  except
    Result := 0;
  end;
end;

function A_UI_ToolBar_New(Parent: AControl): AControl; stdcall;
begin
  try
    Result := UI_ToolBar_New(Parent);
  except
    Result := 0;
  end;
end;

{ TrayIcon }

function A_UI_TrayIcon_GetMenuItems(TrayIcon: ATrayIcon): AMenuItem; stdcall;
begin
  try
    Result := UI_TrayIcon_GetMenuItems(TrayIcon);
  except
    Result := 0;
  end;
end;

{ TreeView }

function A_UI_TreeView_AddItem(TreeView: AControl; Parent: ATreeNode; Text: AString_Type): ATreeNode; stdcall;
begin
  try
    Result := UI_TreeView_AddItem(TreeView, Parent, AStrings.String_ToWideString(Text));
  except
    Result := 0;
  end;
end;

function A_UI_TreeView_New(Parent: AControl): AControl; stdcall;
begin
  try
    Result := UI_TreeView_New(Parent);
  except
    Result := 0;
  end;
end;

{ WaitWin }

function A_UI_WaitWin_New(const Caption, Text: AString_Type; MaxPosition: AInteger): AWindow; stdcall;
begin
  try
    Result := UI_WaitWin_New(
        AStrings.String_ToWideString(Caption),
        AStrings.String_ToWideString(Text),
        MaxPosition);
  except
    Result := 0;
  end;
end;

function A_UI_WaitWin_StepBy(Window: AWindow; Step: AInteger): AInteger; stdcall;
begin
  try
    Result := UI_WaitWin_StepBy(Window, Step);
  except
    Result := 0;
  end;
end;

{ Window }

procedure A_UI_Window_Free(Window: AWindow); stdcall;
begin
  A_UI_Control_Free(Window);
end;

procedure A_UI_Window_FreeAndNil(var Window: AWindow); stdcall;
begin
  A_UI_Window_Free(Window);
  Window := 0;
end;

function A_UI_Window_GetMenu(Window: AWindow): AMenu; stdcall;
begin
  try
    Result := UI_Window_GetMenu(Window);
  except
    Result := 0;
  end;
end;

function A_UI_Window_LoadConfig(Window: AWindow; Config: AConfig): ABoolean; stdcall;
begin
  try
    Result := UI_Window_LoadConfig(Window, Config);
  except
    Result := False;
  end;
end;

function A_UI_Window_LoadConfig2(Window: AWindow; Config: AConfig; const ConfigKey: AString_Type): ABoolean; stdcall;
begin
  try
    Result := UI_Window_LoadConfig2(Window, Config, AStrings.String_ToWideString(ConfigKey));
  except
    Result := False;
  end;
end;

function A_UI_Window_New: AControl; stdcall;
begin
  try
    Result := UI_Window_New;
  except
    Result := -1;
  end;
end;

function A_UI_Window_SaveConfig(Window: AWindow; Config: AConfig): ABoolean; stdcall;
begin
  try
    Result := UI_Window_SaveConfig(Window, Config);
  except
    Result := False;
  end;
end;

function A_UI_Window_SaveConfig2(Window: AWindow; Config: AConfig; const ConfigKey: AString_Type): ABoolean; stdcall;
begin
  try
    Result := UI_Window_SaveConfig2(Window, Config, AStrings.String_ToWideString(ConfigKey));
  except
    Result := False;
  end;
end;

procedure A_UI_Window_SetBorderStyle(Window: AWindow; BorderStyle: AInteger); stdcall;
begin
  try
    UI_Window_SetBorderStyle(Window, BorderStyle);
  except
  end;
end;

procedure A_UI_Window_SetFormStyle(Window: AWindow; FormStyle: AInteger); stdcall;
begin
  try
    UI_Window_SetFormStyle(Window, FormStyle);
  except
  end;
end;

procedure A_UI_Window_SetPosition(Window: AWindow; Position: AInteger); stdcall;
begin
  try
    UI_Window_SetPosition(Window, Position);
  except
  end;
end;

function A_UI_Window_ShowModal(Window: AWindow): ABoolean; stdcall;
begin
  try
    Result := UI_Window_ShowModal(Window);
  except
    Result := False;
  end;
end;

initialization
  UI_SetProcs(Addr(UIProcs));
end.
