{
Abstract: User Interface
Author:  Prof1983 <prof1983@yandex.ru>
Created: 25.10.2008
LastMod: 08.06.2011
Version: 0.2.6+0.3.1
}
unit AUI;

{$IFDEF FPC}
  {$mode delphi}{$h+}
{$ENDIF}

{$IFDEF OLDMAINFORM2}
  {$DEFINE OLDMAINFORM}
{$ENDIF}

{$IFDEF FPC}
  {$DEFINE LangEN}
{$ENDIF}

interface

uses
  ABase0, ARuntime0, AUI0, ASystem0, AUIData;

// --- Procs ---

{
  BoxType
    0 - Simple
    1 - HBox
    2 - VBox }
function UI_Box_New(Parent: AControl; BoxType: AInteger): AControl; stdcall;

function UI_Button_New(Parent: AControl): AButton; stdcall;
// (protected)
procedure UI_Button_SetKind(Button: AButton; Kind: TAUIButtonKind); stdcall;

function UI_Calendar_GetDate(Calendar: AControl): TDateTime; stdcall;
function UI_Calendar_New(Parent: AControl): AControl; stdcall;
procedure UI_Calendar_SetMonth(Calendar: AControl; Value: AInteger); stdcall;

function UI_ComboBox_Add(ComboBox: AControl; const Value: AWideString): AInteger; stdcall;
function UI_ComboBox_GetItemIndex(ComboBox: AControl): AInteger; stdcall;
function UI_ComboBox_New(Parent: AControl): AControl; stdcall;
function UI_ComboBox_NewA(Parent: AControl; Left, Top, Width: AInteger): AControl; stdcall;
procedure UI_ComboBox_SetItemIndex(ComboBox: AControl; Value: AInteger); stdcall;

procedure UI_Control_Free(Control: AControl); stdcall;
procedure UI_Control_FreeAndNil(var Control: AControl); stdcall;
function UI_Control_GetColor(Control: AControl): AColor; stdcall;
function UI_Control_GetEnabled(Control: AControl): ABoolean; stdcall;
function UI_Control_GetHeight(Control: AControl): AInteger; stdcall;
function UI_Control_GetHint(Control: AControl): AWideString; stdcall;
function UI_Control_GetName(Control: AControl): AWideString; stdcall;
function UI_Control_GetText(Control: AControl): AWideString; stdcall;
function UI_Control_GetVisible(Control: AControl): ABoolean; stdcall;
function UI_Control_GetWidth(Control: AControl): AInteger; stdcall;
procedure UI_Control_SetAlign(Control: AControl; Align: TUIAlign); stdcall;
procedure UI_Control_SetClientSize(Control: AControl; ClientWidth, ClientHeight: AInteger); stdcall;
procedure UI_Control_SetColor(Control: AControl; Color: AColor); stdcall;
procedure UI_Control_SetEnabled(Control: AControl; Value: ABoolean); stdcall;
function UI_Control_SetFocus(Control: AControl): ABoolean; stdcall;
procedure UI_Control_SetFont1(Control: AControl; const FontName: AWideString; FontSize: AInteger); stdcall;
//  FontColor = 1,    
procedure UI_Control_SetFont2(Control: AControl; const FontName: AWideString; FontSize: AInteger; FontColor: AColor); stdcall;
function UI_Control_SetHeight(Control: AControl; Value: AInteger): AInteger; stdcall;
procedure UI_Control_SetHint(Control: AControl; const Value: AWideString); stdcall;
procedure UI_Control_SetName(Control: AControl; const Value: AWideString); stdcall;
procedure UI_Control_SetOnChange(Control: AControl; OnChange: ACallbackProc); stdcall;
procedure UI_Control_SetOnClick(Control: AControl; Value: ACallbackProc); stdcall;
procedure UI_Control_SetPosition(Control: AControl; Left, Top: AInteger); stdcall;
procedure UI_Control_SetSize(Control: AControl; Width, Height: AInteger); stdcall;
procedure UI_Control_SetText(Control: AControl; const Value: AWideString); stdcall;
procedure UI_Control_SetVisible(Control: AControl; Value: ABoolean); stdcall;
function UI_Control_SetWidth(Control: AControl; Value: AInteger): AInteger; stdcall;

function UI_DataSource_New: PADataSource; stdcall;
//procedure UI_DataSource_SetDataSet(DataSource: PADataSource; Value: PADataSet); stdcall;
procedure UI_DataSource_SetOnDataChange(DataSource: PADataSource; OnDataChange: ACallbackProc); stdcall;

procedure UI_Dialog_About; stdcall;
function UI_Dialog_About_New: AWindow; stdcall;
function UI_Dialog_AddButton(Win: AWindow; Left, Width: AInteger; const Text: AWideString; OnClick: ACallbackProc): AControl; stdcall;
function UI_Dialog_Calendar(var Date: TDateTime; CenterX, CenterY: AInteger): ABoolean; stdcall;
function UI_Dialog_DateFilter(var Group: Integer; var DateBegin, DateEnd: TDateTime): Boolean; stdcall;
procedure UI_Dialog_Error(const Caption, UserMessage, ExceptMessage: AWideString); stdcall;
function UI_Dialog_Font(var FontName: AWideString; var FontSize: AInteger; FontColor: AColor): ABoolean; stdcall;
function UI_Dialog_InputBox(const Text: AWideString; var Value: AWideString): ABoolean; stdcall;
function UI_Dialog_InputBox2(const Caption, Text1, Text2: AWideString; var Value1, Value2: AWideString): ABoolean; stdcall;
function UI_Dialog_InputBoxA(const Caption, Text: AWideString; var Value: AWideString): ABoolean; stdcall;
function UI_Dialog_Login(var UserName, Password: AWideString; IsSave: ABoolean): ABoolean; stdcall;
function UI_Dialog_Message(const Text, Caption: AWideString; Flags: AMessageBoxFlags): ADialogBoxCommands; stdcall;
function UI_Dialog_New(Buttons: AUIWindowButtons): ADialog; stdcall;
function UI_Dialog_OpenFile(const InitialDir, Filter, Title: AWideString; var FileName: AWideString): ABoolean; stdcall;
function UI_Dialog_OpenFileA(const InitialDir, Filter, DefaultExt, Title: AWideString; var FileName: AWideString; var FilterIndex: AInteger): ABoolean; stdcall;
function UI_Dialog_SaveFile(const Dir, Ext, DefFileName: AWideString): AWideString; stdcall;
function UI_Dialog_SaveFileA(const InitialDir, DefExt, DefFileName, Filter: AWideString; var FilterIndex: AInteger): AWideString; stdcall;

procedure UI_Grid_AddColumn(Grid: AControl; const FieldName, Title: AWideString; Width: Integer); stdcall;
{ GridType
    0 - StringGrid
    1 - DBGrid }
function UI_Grid_New(Parent: AControl; GridType: AInteger): AControl; stdcall;
//   DBGrid
procedure UI_Grid_RestoreColProps(Grid: AControl; Config: AConfig; const Key: AWideString; Delimer: AChar = '\'); stdcall;
//   DBGrid
procedure UI_Grid_SaveColProps(Grid: AControl; Config: AConfig; const Key: AWideString; Delimer: AChar = '\'); stdcall;
//     DBGrid
procedure UI_Grid_SetColumnWidth(Grid: AControl; ColumnIndex, Width, Persent, MinWidth: AInteger); stdcall;
procedure UI_Grid_SetColumnWidthA(Grid: AControl; ColumnIndex, Width, Persent, MinWidth, MaxWidth: AInteger); stdcall;
procedure UI_Grid_SetDataSource(Grid: AControl; Value: PADataSource); stdcall;

function UI_Image_New(Parent: AControl): AControl; stdcall;
function UI_Image_LoadFromFile(Image: AControl; const FileName: AWideString): ABoolean; stdcall;

function UI_Label_New(Parent: AControl): AControl; stdcall;

function UI_ListBox_Add(ListBox: AControl; const Text: AWideString): Integer; stdcall;
procedure UI_ListBox_Clear(ListBox: AControl); stdcall;
function UI_ListBox_New(Parent: AControl): AControl; stdcall;
{ Typ:
  0 - ListBox
  1 - RadioGroup }
function UI_ListBox_NewA(Parent: AControl; Typ: AInteger): AControl; stdcall;
function UI_ListBox_GetCount(ListBox: AControl): AInteger; stdcall;
function UI_ListBox_GetItem(ListBox: AControl; Index: AInteger): AWideString; stdcall;
//function A_UI_ListBox_GetItem(ListBox: AControl; Index: AInteger; out Value: AWideString): AInteger; stdcall;
function UI_ListBox_GetItemIndex(ListBox: AControl): AInteger; stdcall;
procedure UI_ListBox_SetItemIndex(ListBox: AControl; Index: AInteger); stdcall;
procedure UI_ListBox_DeleteItem(ListBox: AControl; Index: AInteger); stdcall;
procedure UI_ListBox_SetItem(ListBox: AControl; Index: AInteger; const Value: AWideString); stdcall;

function UI_MainToolBar: AControl; stdcall;
//procedure UI_MainToolBar_Set(ToolBar: AControl); stdcall; deprecated;

function UI_MainTrayIcon: ATrayIcon; stdcall;

function UI_MainWindow: AWindow; stdcall;
function UI_MainWindow_AddMenuItem(const ParentItemName, Name, Text: AWideString; OnClick: ACallbackProc; ImageID, Weight: Integer): AMenuItem; stdcall;
function UI_MainWindow_AddMenuItem2(const ParentItemName, Name, Text: AWideString; OnClick: ACallbackProc; ImageID, Weight: Integer): AMenuItem; stdcall;
procedure UI_MainWindow_Set(Value: AWindow); stdcall;
procedure UI_MainWindow_SetA(Value: AWindow; ToolBar, StatusBar: AControl; Config: AConfig); stdcall;

function UI_Menu_GetItems(Menu: AMenu): AMenuItem; stdcall;
function UI_Menu_New(MenuType: AInteger): AMenu; stdcall;

function UI_MenuItem_Add(MenuItem: AMenuItem; const Name, Text: AWideString; OnClick: ACallbackProc; ImageID, Weight: Integer): AMenuItem; stdcall;
function UI_MenuItem_Add2(Parent: AMenuItem; MenuItem: AMenuItem; Weight: AInteger): AMenuItem; stdcall;
function UI_MenuItem_FindByName(MenuItem: AMenuItem; const Name: AWideString): AMenuItem; stdcall;

{   . :
  0 -   ,     (   ) }
function UI_PageControl_AddPage(PageControl: AControl; const Name, Text: AWideString): AControl; stdcall;
function UI_PageControl_New(Parent: AControl): AControl; stdcall;

function UI_ProgressBar_New(Parent: AControl; Max: AInteger): AControl; stdcall;
function UI_ProgressBar_StepIt(ProgressBar: AControl): AInteger; stdcall;

function UI_PropertyBox_Add(PropertyBox: AControl; const Caption: AWideString): Integer; stdcall;
function UI_PropertyBox_AddA(PropertyBox: AControl; const Caption, Text, Hint: AWideString; EditWidth: AInteger): AInteger; stdcall;
function UI_PropertyBox_Item_GetValue(PropertyBox: AControl; Index: Integer): AWideString; stdcall;
//function UI_PropertyBox_Item_GetValue(PropertyBox: AControl; Index: Integer; out Value: AWideString): AInteger; stdcall;
procedure UI_PropertyBox_Item_SetValue(PropertyBox: AControl; Index: Integer; const Value: AWideString); stdcall;
function UI_PropertyBox_New(Parent: AControl): AControl; stdcall;

function UI_SpinButton_New(Parent: AControl): AControl; stdcall;
function UI_SpinEdit_New(Parent: AControl): AControl; stdcall;
function UI_SpinEdit_NewA(Parent: AControl; Value, MinValue, MaxValue: AInteger): AControl; stdcall;

{ SplitterType
    0 - HSplitter (Align=alTop)
    1 - VSplitter (Align=alLeft)
    2 - HSplitter (Align=alBottom)
    3 - VSplitter (Align=alRight) }
function UI_Splitter_New(Parent: AControl; SplitterType: AUISplitterType): AControl; stdcall;

function UI_ToolBar_AddButton(ToolBar: AControl; const Name, Text, Hint: AWideString; OnClick: ACallbackProc; ImageID, Weight: AInteger): AButton; stdcall;
function UI_ToolBar_New(Parent: AControl): AControl; stdcall;

{$IFNDEF UNIX}
function UI_TrayIcon_GetMenuItems(TrayIcon: ATrayIcon): AMenuItem; stdcall;
{$ENDIF}

function UI_TreeView_AddItem(TreeView: AControl; Parent: ATreeNode; Text: AWideString): ATreeNode; stdcall;
function UI_TreeView_New(Parent: AControl): AControl; stdcall;

procedure UI_Window_Free(Window: AWindow); stdcall;
function UI_Window_GetMenu(Window: AWindow): AMenu; stdcall;
function UI_Window_LoadConfig(Window: AWindow; Config: AConfig): ABoolean; stdcall;
function UI_Window_LoadConfig2(Window: AWindow; Config: AConfig; const ConfigKey: AWideString): ABoolean; stdcall;
function UI_Window_New: AControl; stdcall;
function UI_Window_SaveConfig(Window: AWindow; Config: AConfig): ABoolean; stdcall;
function UI_Window_SaveConfig2(Window: AWindow; Config: AConfig; const ConfigKey: AWideString): ABoolean; stdcall;
procedure UI_Window_SetPosition(Window: AWindow; Position: AInteger); stdcall;
function UI_Window_ShowModal(Window: AWindow): ABoolean; stdcall;

{ Reports }

function UI_Report_New(Parent: AControl): AReport; stdcall;
procedure UI_Report_SetText(Report: AReport; const Value: AWideString); stdcall;

function UI_ReportWin_New: AWindow; stdcall;
// ReportWinType -   : 0-TReportForm; 1-SimpleReport
function UI_ReportWin_NewA(ReportWinType: AInteger; const Text: AWideString): AWindow; stdcall;

function UI_WaitWin_New(const Caption, Text: AWideString; MaxPosition: Integer): AWindow; stdcall;
function UI_WaitWin_StepBy(Window: AWindow; Step: AInteger): AInteger; stdcall;

{ Testing }

procedure UI_SetHideOnClose(Value: ABoolean); stdcall;
function UI_Run: AInteger; stdcall;
function UI_MainMenuItem: AMenuItem; stdcall;

//     TextView
function UI_TextView_AddLine(TextView: AControl; const Text: AWideString): AInteger; stdcall;
{     
  ViewType
    0 - TMemo
    1 - RichEdit }
function UI_TextView_New(Parent: AControl; ViewType: AInteger): AControl; stdcall;
procedure UI_TextView_SetFont(TextView: AControl; const FontName: AWideString; FontSize: AInteger); stdcall;
procedure UI_TextView_SetReadOnly(TextView: AControl; ReadOnly: ABoolean); stdcall;
{ ScrollBars
    0 - ssNone
    1 - ssHorizontal
    2 - ssVertical
    3 - ssBoth }
procedure UI_TextView_SetScrollBars(TextView: AControl; ScrollBars: AInteger); stdcall;
procedure UI_TextView_SetWordWrap(TextView: AControl; Value: ABoolean); stdcall;

procedure UI_Window_FreeAndNil(var Window: AWindow); stdcall;
procedure UI_Window_SetBorderStyle(Window: AWindow; BorderStyle: AInteger); stdcall;
procedure UI_Window_SetFormStyle(Window: AWindow; FormStyle: AInteger); stdcall;

function UI_ShellExecute(const Operation, FileName, Parameters, Directory: AWideString): AInteger; stdcall;
function UI_Object_Add(Value: AInteger): AInteger; stdcall;

function UI_Dialog_Color(var Color: AColor): ABoolean; stdcall;
function UI_Dialog_SelectDirectory(var Directory: AWideString): ABoolean; stdcall;

{ Old }

procedure UI_Control_SetOnChange2(Control: AControl; OnChange: ACallbackProc; Obj: AInteger = 0); stdcall;

{ Protected }

function UI_Dialog_GetWindow(Dialog: ADialog): AWindow; stdcall;
function UI_MainWindow_GetLeftContainer: AControl; stdcall;
function UI_MainWindow_GetMainContainer: AControl; stdcall;
function UI_MainWindow_GetRightContainer: AControl; stdcall;

function UI_DoneA: AInteger; stdcall;
function UI_InitA: AInteger; stdcall;

{ Private }

var
  UIAboutClick: AProc;
  UIAboutWinMemoHeightDefault: Integer = 0;
  UIAboutWinMemoWidthDefault: Integer = 0;

implementation

uses
  //LResources,
  {$IFDEF UNIX}
    {$IFDEF UseCThreads}
    cthreads,
    {$ENDIF}
  {$ENDIF}
  {$IFDEF FPC}Interfaces,{$ELSE}Mask,{$ENDIF}
  Buttons, Classes, Controls, ComCtrls, DB, DBGrids, ExtCtrls, Forms, Graphics, Grids, Menus, StdCtrls, SysUtils,
  {$IFDEF MSWINDOWS}ShellApi, Windows,{$ENDIF}
  AUICalendar, AUIEdit, AUIGrids, AUIForm, AUISpin, AUITrayIcon,
  {$IFDEF MSWINDOWS}
  fError, fInputDialog, fLogin, fMessage, fPasswordDialog, {$IFNDEF FPC}fSimpleReport,{$ENDIF} fWait,
  {$ENDIF}
  {$IFNDEF FPC}fCalendar, fDateFilter, fReport,{$ENDIF}
  {$IFDEF OLDMAINFORM}fMain,{$ENDIF}
  ASettings0, AUIDialog, AUIDialogs, AUIMainWindow, AUIPropertyBox, fAbout;

{$IFDEF LangEN}
  {$I 'AUI.en.inc'}
{$ELSE}
  {$I 'AUI.ru.inc'}
{$ENDIF}

{ Types }

type
  TAUIColumn = {$IFDEF UNIX}TGridColumn{$ELSE}TColumn{$ENDIF};

{ Classes }

type
  TUI_ = class
  public
    procedure ButtonClick(Sender: TObject);
    procedure CalendarChange(Sender: TObject);
    procedure DataSourceDataChange(Sender: TObject; Field: TField);
    procedure ListBoxClick(Sender: TObject);
    procedure MainFormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure MenuItemClick(Sender: TObject);
    procedure PageControlChange(Sender: TObject);
  end;

var
  UI_: TUI_;

{ Private }

function FindButton(Button: AControl): Integer;
var
  I: Integer;
begin
  for I := 0 to High(FButtons) do
  begin
    if (FButtons[I].Button = Button) then
    begin
      Result := I;
      Exit;
    end;
  end;
  Result := -1;
end;

function FindCalendar(Calendar: AControl): Integer;
var
  i: Integer;
begin
  for i := 0 to High(FCalendars) do
  begin
    if (FCalendars[i].Calendar = Calendar) then
    begin
      Result := i;
      Exit;
    end;
  end;
  Result := -1;
end;

function FindDataSource(DataSource: PADataSource): Integer;
var
  i: Integer;
begin
  for i := 0 to High(FDataSources) do
  begin
    if (FDataSources[i].DataSource = DataSource) then
    begin
      Result := i;
      Exit;
    end;
  end;
  Result := -1;
end;

function FindListBox(ListBox: AControl): Integer;
var
  I: Integer;
begin
  for I := 0 to High(FListBoxs) do
  begin
    if (FListBoxs[I].ListBox = ListBox) then
    begin
      Result := I;
      Exit;
    end;
  end;
  Result := -1;
end;

function FindMenuItem(MenuItem: AMenuItem): Integer;
var
  I: Integer;
begin
  for I := 0 to High(FMenuItems) do
  begin
    if (FMenuItems[I].MenuItem = MenuItem) then
    begin
      Result := I;
      Exit;
    end;
  end;
  Result := -1;
end;

function FindPageControl(PageControl: AControl): Integer;
var
  I: Integer;
begin
  for I := 0 to High(FPageControls) do
  begin
    if (FPageControls[I].PageControl = PageControl) then
    begin
      Result := I;
      Exit;
    end;
  end;
  Result := -1;
end;

function GetObject(Value: Integer): TObject;
var
  I: Integer;
begin
  for I := 0 to High(FObjects) do
  begin
    if (Integer(FObjects[I]) = Value) then
    begin
      Result := FObjects[I];
      Exit;
    end;
  end;
  Result := nil;
end;

{ TUI_ }

procedure TUI_.ButtonClick(Sender: TObject);
var
  i: Integer;
begin
  i := FindButton(AControl(Sender));
  if (i >= 0) then
  begin
    if Assigned(FButtons[i].OnClick) then
      FButtons[i].OnClick(FButtons[i].Button, Integer(Sender));
  end;
end;

procedure TUI_.CalendarChange(Sender: TObject);
var
  i: Integer;
begin
  i := FindCalendar(AControl(Sender));
  if (i >= 0) then
  begin
    if Assigned(FCalendars[i].OnChange) then
      FCalendars[i].OnChange(FCalendars[i].OnChangeObj, Integer(Sender));
  end;
end;

procedure TUI_.DataSourceDataChange(Sender: TObject; Field: TField);
var
  I: Integer;
begin
  I := FindDataSource(PADataSource(Sender));
  if (I >= 0) then
  begin
    if Assigned(FDataSources[I].OnDataChange) then
      FDataSources[I].OnDataChange(Integer(Sender), Integer(Field));
  end;
end;

procedure TUI_.ListBoxClick(Sender: TObject);
var
  I: Integer;
begin
  I := FindListBox(AControl(Sender));
  if (I >= 0) then
  begin
    if Assigned(FListBoxs[I].OnClick) then
      FListBoxs[I].OnClick(AInteger(Sender), 0);
  end;
end;

procedure TUI_.MainFormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  if FHideOnClose then
  begin
    CanClose := ARuntime.IsShutdown;
    if not(CanClose) then
      UI_IsShowApp_Set(False);
  end
  else
    UI_Shutdown;
end;

procedure TUI_.MenuItemClick(Sender: TObject);
var
  I: Integer;
begin
  for I := 0 to High(FMenuItems) do
  begin
    if (FMenuItems[I].MenuItem = Integer(Sender)) then
    begin
      if Assigned(FMenuItems[I].OnClick) then
        FMenuItems[I].OnClick(FMenuItems[I].MenuItem, 0{Integer(Sender)});
      Exit;
    end;
  end;
end;

procedure TUI_.PageControlChange(Sender: TObject);
var
  I: Integer;
begin
  for I := 0 to High(FPageControls) do
  begin
    if (FPageControls[I].PageControl = AControl(Sender)) then
    begin
      if Assigned(FPageControls[I].OnChange) then
        FPageControls[I].OnChange(AControl(FPageControls[I].PageControl), 0);
    end;
  end;
end;

{}

function ToolBar_GetButtonIndexByWeight(ToolBar: AControl; Weight: Integer): Integer;
var
  I: Integer;
  Min: Integer;
  //Max: Integer;
  MinIndex: Integer;
  //MaxIndex: Integer;
  W: Integer;
begin
  Min := Low(Integer);
  //Max := High(Integer);
  MinIndex := -1;
  //MaxIndex := -1;
  for I := 0 to High(FToolBarButtons) do
  if (FToolBarButtons[I].ToolBar = ToolBar) then
  begin
    W := FToolBarButtons[I].Weight;
    if (W > Min) and (W < Weight) then
    begin
      Min := W;
      MinIndex := I;
    end;
    {if (W < Max) and (W > Weight) then
    begin
      Max := W;
      MaxIndex := I;
    end;}
  end;
  Result := MinIndex;
end;

{ Events }

procedure DoMainFormCreate; stdcall;
var
  MainForm: TForm;
begin
  Application.CreateForm({$IFDEF OLDMAINFORM}TMainForm{$ELSE}TForm{$ENDIF}, MainForm);
  MainForm.Left := 0;
  MainForm.Top := 0;
  {$IFDEF OLDMAINFORM}
    {$IFDEF OLDMAINFORM2}
    MainWindow_Create(MainForm, 0, Runtime_GetConfig);
    {$ELSE}
    MainWindow_Create(MainForm, MainWindowFormatCreateMenu or MainWindowFormatCreateToolBar or MainWindowFormatCreateStatusBar, Runtime_GetConfig);
    {$ENDIF}
    FMainWindow := AddObject(MainForm);
  {$ELSE}
    FMainWindow := AddObject(MainForm);
    MainForm.Name := 'MainForm';
    {$IFDEF A03}
    MainForm.Caption := ASystem.GetProgramName;
    MainWindow_Create(MainForm, MainWindowFormatCreateAll, ASystem.GetConfig);
    {$ELSE}
    MainForm.Caption := Runtime_GetProgramName;
    MainWindow_Create(MainForm, MainWindowFormatCreateAll, Runtime_GetConfig);
    {$ENDIF}
    MainForm.OnCloseQuery := UI_.MainFormCloseQuery;
  {$ENDIF}
  AddObject(MainForm.Menu);
end;

{ Module }

function UI_DoneA: AInteger; stdcall;
begin
  try
    if (FMainTrayIcon <> 0) then
    begin
      {$IFNDEF FPC}
      TrayIcon_Free(FMainTrayIcon);
      {$ENDIF}
      FMainTrayIcon := 0;
    end;
    SetLength(FObjects, 0);
    SetLength(FMenuItems, 0);
  except
  end;

  FMainWindow := 0;

  {$IFDEF A03}
  ASystem.SetOnProcessMessages(nil);
  ASystem.SetOnShowMessage(nil);
  {$ELSE}
  Runtime_SetOnProcessMessages(nil);
  Runtime_SetOnShowMessage(nil);
  {$ENDIF}
  ARuntime.OnShutdown_Set(nil);
  ARuntime.OnRun_Set(nil);

  //Runtime_Event_FreeAndNil(FMainWindowOnAfterInit);

  //Application := nil;
  Result := 0;
end;

function UI_InitA: AInteger; stdcall;
var
  S: string;
begin
  if (FMainWindow <> 0) then
  begin
    Result := 0;
    Exit;
  end;

  FHideOnClose := False;
  FIsShowApp := True;

  {$IFDEF A03}
  ASystem.SetOnProcessMessages(UI_ProcessMessages);
  ASystem.SetOnShowError(UI_Dialog_Error);
  ASystem.SetOnShowMessage(UI_Dialog_Message);
  {$ELSE}
  Runtime_SetOnProcessMessages(UI_ProcessMessages);
  Runtime_SetOnShowError(UI_Dialog_Error);
  Runtime_SetOnShowMessage(UI_Dialog_Message);
  {$ENDIF}
  ARuntime.OnShutdown_Set(UI_Shutdown);
  ARuntime.OnRun_Set(UI_Run);

  {$IFNDEF FPC}
  Application.CreateHandle;
  {$ENDIF}

  Application.Initialize;
  {$IFDEF A03}
  Application.Title := ASystem.GetTitle;
  S := ASystem.GetDataPath+ASystem.GetProgramName+'.ico';
  {$ELSE}
  Application.Title := Runtime_GetTitle;
  S := Runtime_GetDataPath+Runtime_GetProgramName+'.ico';
  {$ENDIF}
  if FileExists(S) then
  try
    Application.Icon.LoadFromFile(S);
  except
    {$IFDEF A03}
    ASystem.ShowMessage('    '+S);
    {$ELSE}
    Runtime_ShowMessage('    '+S);
    {$ENDIF}
  end;

  try
    if Assigned(FOnMainFormCreate) then
      FOnMainFormCreate
    else
      DoMainFormCreate;
  except
    Runtime_ShowMessage('     ');
    Result := -100;
    Exit;
  end;
  {
  if (FMainWindow <> 0) then
    miMain := AddObject(TForm(FMainWindow).Menu.Items);
  }

  Result := 0;
end;

{ UI Public }

function UI_Dialog_OpenFile(const InitialDir, Filter, Title: AWideString; var FileName: AWideString): Boolean; stdcall;
var
  FilterIndex: Integer;
begin
  FilterIndex := 0;
  Result := AUIDialogs.ExecuteOpenDialogA(InitialDir, Filter, '', Title, FileName, FilterIndex);
end;

function UI_Dialog_OpenFileA(const InitialDir, Filter, DefaultExt, Title: AWideString; var FileName: AWideString; var FilterIndex: AInteger): ABoolean; stdcall;
begin
  Result := AUIDialogs.ExecuteOpenDialogA(InitialDir, Filter, DefaultExt, Title, FileName, FilterIndex);
end;

function UI_Dialog_SaveFile(const Dir, Ext, DefFileName: AWideString): AWideString; stdcall;
begin
  Result := AUIDialogs.ExecuteSaveFileDialog(Dir, Ext, DefFileName);
end;

function UI_Dialog_SaveFileA(const InitialDir, DefExt, DefFileName, Filter: AWideString; var FilterIndex: AInteger): AWideString; stdcall;
begin
  Result := ExecuteSaveFileDialogA(InitialDir, DefExt, DefFileName, Filter, FilterIndex);
end;

function UI_Run: AInteger; stdcall;
begin
  MainWindow_Init;
  Application.Run;
  Result := 0;
end;

procedure UI_SetHideOnClose(Value: Boolean); stdcall;
begin
  FHideOnClose := Value;
end;

function UI_ShellExecute(const Operation, FileName, Parameters, Directory: AWideString): AInteger; stdcall;
begin
  {$IFNDEF UNIX}
  Result := ShellExecute(0{Handle}, PChar(string(Operation)), PChar(string(FileName)), PChar(string(Parameters)), PChar(string(Directory)), SW_SHOW);
  {$ENDIF}
end;

{ Box }

function UI_Box_New(Parent: AControl; BoxType: AInteger): AControl; stdcall;
var
  Panel: TPanel;
begin
  Panel := TPanel.Create(TWinControl(Parent));
  Panel.Parent := TWinControl(Parent);
  AddObject(Panel);
  Result := AControl(Panel);
end;

{ Button }

function UI_Button_New(Parent: AControl): AButton; stdcall;
var
  Button: TBitBtn;
  I: Integer;
begin
  Button := TBitBtn.Create(TWinControl(Parent));
  Button.Parent := TWinControl(Parent);
  Button.OnClick := UI_.ButtonClick;
  Result := AddObject(Button);

  I := Length(FButtons);
  SetLength(FButtons, I + 1);
  FButtons[I].Button := Result;
end;

procedure UI_Button_SetKind(Button: AButton; Kind: TAUIButtonKind); stdcall;
begin
  TBitBtn(Button).Kind := TBitBtnKind(Kind);
end;

{ Calendar }

function UI_Calendar_GetDate(Calendar: AControl): TDateTime; stdcall;
begin
  {$IFDEF FPC}
  Result := TCalendar(Calendar).DateTime;
  {$ELSE}
  Result := TCalendar(Calendar).CalendarDate;
  {$ENDIF}
end;

function UI_Calendar_New(Parent: AControl): AControl; stdcall;
var
  Calendar: TCalendar;
begin
  Calendar := TCalendar.Create(TWinControl(Parent));
  Calendar.Parent := TWinControl(Parent);
  {$IFNDEF FPC}
  Calendar.StartOfWeek := 0;
  {$ENDIF}
  Result := AControl(Calendar);
end;

procedure UI_Calendar_SetMonth(Calendar: AControl; Value: AInteger); stdcall;
begin
  {$IFNDEF FPC}
  TCalendar(Calendar).Month := Value;
  {$ENDIF}
end;

{ ComboBox }

function UI_ComboBox_Add(ComboBox: AControl; const Value: AWideString): AInteger; stdcall;
begin
  Result := TComboBox(ComboBox).Items.Add(Value);
end;

function UI_ComboBox_GetItemIndex(ComboBox: AControl): AInteger; stdcall;
begin
  Result := TComboBox(ComboBox).ItemIndex;
end;

function UI_ComboBox_New(Parent: AControl): AControl; stdcall;
var
  ComboBox: TComboBox;
begin
  ComboBox := TComboBox.Create(TWinControl(Parent));
  ComboBox.Parent := TWinControl(Parent);
  Result := AddObject(ComboBox);
end;

function UI_ComboBox_NewA(Parent: AControl; Left, Top, Width: AInteger): AControl; stdcall;
var
  ComboBox: TComboBox;
begin
  ComboBox := TComboBox.Create(TWinControl(Parent));
  ComboBox.Parent := TWinControl(Parent);
  ComboBox.Left := Left;
  ComboBox.Top := Top;
  ComboBox.Width := Width;
  Result := AddObject(ComboBox);
end;

procedure UI_ComboBox_SetItemIndex(ComboBox: AControl; Value: AInteger); stdcall;
begin
  TComboBox(ComboBox).ItemIndex := Value;
end;

{ Control }

// TODO:    UI_Control_*  TMenuItem  TrayIcon

procedure UI_Control_Free(Control: AControl); stdcall;
begin
  if (Control <> 0) then
    TObject(Control).Free;
end;

procedure UI_Control_FreeAndNil(var Control: AControl); stdcall;
begin
  UI_Control_Free(Control);
  Control := 0;
end;

function UI_Control_GetColor(Control: AControl): AColor; stdcall;
begin
  if (TObject(Control) is TLabel) then
    Result := TLabel(Control).Color
  else if (TObject(Control) is TPanel) then
    Result := TPanel(Control).Color
  else if (TObject(Control) is TForm) then
    Result := TForm(Control).Color
  else
    Result := $000000;
end;

function UI_Control_GetEnabled(Control: AControl): ABoolean; stdcall;
begin
  if (TObject(Control) is TControl) then
    Result := TControl(Control).Enabled
  else if (TObject(Control) is TMenuItem) then
    Result := TMenuItem(Control).Enabled
  else
    Result := False;
end;

function UI_Control_GetHeight(Control: AControl): AInteger; stdcall;
begin
  Result := TControl(Control).Height;
end;

function UI_Control_GetHint(Control: AControl): AWideString; stdcall;
begin
  if (TObject(Control) is TControl) then
    Result := TControl(Control).Hint
  else if (TObject(Control) is TMenuItem) then
    Result := TMenuItem(Control).Hint
  else
    Result := '';
end;

function UI_Control_GetName(Control: AControl): AWideString; stdcall;
begin
  if (TObject(Control) is TComponent) then
    Result := TComponent(Control).Name
  else
    Result := '';
end;

function UI_Control_GetText(Control: AControl): AWideString; stdcall;
begin
  if (TObject(Control) is TForm) then
    Result := TForm(Control).Caption
  else if (TObject(Control) is TMenuItem) then
    Result := TMenuItem(Control).Caption
  else if (TObject(Control) is TEdit) then
    Result := TEdit(Control).Text
  else
    Result := '';
end;

function UI_Control_GetVisible(Control: AControl): ABoolean; stdcall;
begin
  if (TObject(Control) is TControl) then
    Result := TControl(Control).Visible
  else if (TObject(Control) is TMenuItem) then
    Result := TMenuItem(Control).Visible
  else
    Result := False;
end;

function UI_Control_GetWidth(Control: AControl): AInteger; stdcall;
begin
  Result := TControl(Control).Width;
end;

procedure UI_Control_SetAlign(Control: AControl; Align: TUIAlign); stdcall;
begin
  if (TObject(Control) is TControl) then
    TControl(Control).Align := TAlign(Align);
end;

procedure UI_Control_SetClientSize(Control: AControl; ClientWidth, ClientHeight: AInteger); stdcall;
begin
  TWinControl(Control).ClientWidth := ClientWidth;
  TWinControl(Control).ClientHeight := ClientHeight;
end;

procedure UI_Control_SetColor(Control: AControl; Color: AColor); stdcall;
begin
  if (TObject(Control) is TComboBox) then
    TComboBox(Control).Color := Color
  else if (TObject(Control) is TLabel) then
  begin
    TLabel(Control).Color := Color;
    (*if (Color = clBlack) then
      TLabel(Control).Font.Color := clWhite //UI_Control_SetFont(ColorLineTipV, '', 0, $FFFFFF{clWhite})
    else
      TLabel(Control).Font.Color := clBlack; //UI_Control_SetFont(ColorLineTipV, '', 0, $000000{clBlack}); *)
  end
  else if (TObject(Control) is TPanel) then
    TPanel(Control).Color := Color
  else if (TObject(Control) is TForm) then
    TForm(Control).Color := Color;
end;

procedure UI_Control_SetEnabled(Control: AControl; Value: ABoolean); stdcall;
begin
  if (TObject(Control) is TControl) then
    TControl(Control).Enabled := Value
  else if (TObject(Control) is TMenuItem) then
    TMenuItem(Control).Enabled := Value;
end;

function UI_Control_SetFocus(Control: AControl): ABoolean; stdcall;
begin
  Result := False;
  try
    if (TObject(Control) is TWinControl) then
    begin
      TWinControl(Control).SetFocus;
      Result := True;
    end;
  except
  end;
end;

procedure UI_Control_SetFont1(Control: AControl; const FontName: AWideString; FontSize: AInteger); stdcall;
begin
  if (TObject(Control) is TLabel) then
  begin
    if (FontName <> '') then
      TLabel(Control).Font.Name := FontName;
    if (FontSize <> 0) then
      TLabel(Control).Font.Size := FontSize;
  end;
end;

procedure UI_Control_SetFont2(Control: AControl; const FontName: AWideString; FontSize: AInteger; FontColor: AColor); stdcall;
begin
  if (TObject(Control) is TLabel) then
  begin
    if (FontName <> '') then
      TLabel(Control).Font.Name := FontName;
    if (FontSize <> 0) then
      TLabel(Control).Font.Size := FontSize;
    if (FontColor <> 1) then
      TLabel(Control).Font.Color := FontColor;
  end;
end;

function UI_Control_SetHeight(Control: AControl; Value: AInteger): AInteger; stdcall;
begin
  try
    TControl(Control).Height := Value;
    Result := Value;
  except
    Result := -1;
  end;
end;

procedure UI_Control_SetHint(Control: AControl; const Value: AWideString); stdcall;
begin
  if (TObject(Control) is TControl) then
    TControl(Control).Hint := Value
  else if (TObject(Control) is TMenuItem) then
    TMenuItem(Control).Hint := Value;
end;

procedure UI_Control_SetName(Control: AControl; const Value: AWideString); stdcall;
begin
  if (TObject(Control) is TControl) then
    TControl(Control).Name := Value
  else if (TObject(Control) is TMenuItem) then
    TMenuItem(Control).Name := Value;
end;

procedure UI_Control_SetOnChange(Control: AControl; OnChange: ACallbackProc); stdcall;
var
  i: Integer;
begin
  if (Control = 0) then Exit;

  if (TObject(Control) is TCalendar) then
  begin
    i := FindCalendar(Control);
    if (i >= 0) then
    begin
      FCalendars[i].OnChange := OnChange;
      FCalendars[i].OnChangeObj := 0;
    end;
  end
  else if (TObject(Control) is TPageControl) then
  begin
    i := FindPageControl(Control);
    if (i >= 0) then
    begin
      TPageControl(FPageControls[i].PageControl).OnChange := UI_.PageControlChange;
      FPageControls[i].OnChange := OnChange;
    end;
  end;
end;

procedure UI_Control_SetOnChange2(Control: AControl; OnChange: ACallbackProc; Obj: AInteger); stdcall;
var
  I: Integer;
begin
  if (Control = 0) then Exit;

  if (TObject(Control) is TCalendar) then
  begin
    I := FindCalendar(Control);
    if (I >= 0) then
    begin
      FCalendars[I].OnChange := OnChange;
      FCalendars[I].OnChangeObj := Obj;
    end;
  end;
end;

procedure UI_Control_SetOnClick(Control: AControl; Value: ACallbackProc); stdcall;
var
  I: Integer;
begin
  if (TObject(Control) is TBitBtn) then
  begin
    I := FindButton(Control);
    if (I >= 0) then
      FButtons[I].OnClick := Value;
  end
  else if (TObject(Control) is TMenuItem) then
  begin
    I := FindMenuItem(Control);
    if (I >= 0) then
      FMenuItems[I].OnClick := Value;
  end
  else if (TObject(Control) is TListBox) then
  begin
    I := FindListBox(Control);
    if (I >= 0) then
      FListBoxs[I].OnClick := Value;
  end;
end;

procedure UI_Control_SetPosition(Control: AControl; Left, Top: Integer); stdcall;
var
  O: TObject;
  C: TControl;
begin
  O := GetObject(Control);
  if Assigned(O) and (O is TControl) then
  begin
    C := TControl(O);
    C.Left := Left;
    C.Top := Top;
  end;
end;

procedure UI_Control_SetSize(Control: AControl; Width, Height: Integer); stdcall;
var
  O: TObject;
  C: TControl;
begin
  O := GetObject(Control);
  if Assigned(O) and (O is TControl) then
  begin
    C := TControl(O);
    C.Width := Width;
    C.Height := Height;
  end;
end;

procedure UI_Control_SetText(Control: AControl; const Value: AWideString); stdcall;
var
  obj: TObject;
begin
  obj := GetObject(Control);
  if not(Assigned(obj)) then Exit;
  if (obj is TControl) then
  begin
    if (obj is TForm) then
      TForm(obj).Caption := Value
    else if (obj is TLabel) then
      TLabel(obj).Caption := Value
    else if (obj is TEdit) then
      TEdit(obj).Text := Value
    else if (obj is TButton) then
      TButton(obj).Caption := Value
    else if (obj is TBitBtn) then
      TBitBtn(obj).Caption := Value
    else if (obj is TMemo) then
      TMemo(obj).Text := Value
    {$IFNDEF FPC}
    else if (obj is TRichEdit) then
      TRichEdit(obj).Text := Value;
    {$ENDIF}
  end
  else if (obj is TMenuItem) then
    TMenuItem(obj).Caption := Value;
end;

procedure UI_Control_SetVisible(Control: AControl; Value: Boolean); stdcall;
var
  O: TObject;
begin
  O := GetObject(Control);
  if Assigned(O) and (O is TControl) then
  begin
    TControl(O).Visible := Value;
    if (O is TForm) then
      TControl(O).BringToFront;
    Exit;
  end;
  if (TObject(Control) is TMenuItem) then
    TMenuItem(Control).Visible := Value;
end;

function UI_Control_SetWidth(Control: AControl; Value: AInteger): AInteger; stdcall;
begin
  try
    TControl(Control).Width := Value;
    Result := Value;
  except
    Result := -1;
  end;
end;

{ DataSource }

function UI_DataSource_New: PADataSource; stdcall;
var
  DataSource: TDataSource;
  i: Integer;
begin
  DataSource := TDataSource.Create(nil);
  DataSource.OnDataChange := UI_.DataSourceDataChange;
  Result := PADataSource(DataSource);
  i := Length(FDataSources);
  SetLength(FDataSources, i + 1);
  FDataSources[i].DataSource := Result;
end;

{procedure UI_DataSource_SetDataSet(DataSource: PADataSource; Value: PADataSet);
begin
  TDataSource(DataSource).DataSet := TDataSet(DataSet);
end;}

procedure UI_DataSource_SetOnDataChange(DataSource: PADataSource; OnDataChange: ACallbackProc); stdcall;
var
  i: Integer;
begin
  i := FindDataSource(DataSource);
  if (i >= 0) then
  begin
    FDataSources[i].OnDataChange := OnDataChange;
  end;
end;

{ Dialog }

procedure UI_Dialog_About; stdcall;
begin
  ShowAboutWinA(UIAboutWinMemoWidthDefault, UIAboutWinMemoHeightDefault);
end;

function UI_Dialog_About_New: AWindow; stdcall;
var
  Form: TAboutForm;
begin
  Form := TAboutForm.Create(nil);
  try
    Form.InitA(UIAboutWinMemoWidthDefault, UIAboutWinMemoHeightDefault);
  except
    Form.Free;
    Form := nil;
  end;
  Result := AWindow(Form);
end;

function UI_Dialog_AddButton(Win: AWindow; Left, Width: AInteger; const Text: AWideString; OnClick: ACallbackProc): AControl; stdcall;
begin
  if (Win <> 0) and (TObject(Win) is TAboutForm) then
    Result := TAboutForm(Win).AddButton(Left, Width, Text, OnClick)
  else
    Result := 0;
end;

function UI_Dialog_Calendar(var Date: TDateTime; CenterX, CenterY: AInteger): ABoolean; stdcall;
begin
  {$IFNDEF FPC}
  Result := ShowCalendarWin(Date, CenterX, CenterY);
  {$ENDIF}
end;

function UI_Dialog_Color(var Color: AColor): ABoolean; stdcall;
begin
  Result := AUIDialogs.ExecuteColorDialog(Color);
end;

function UI_Dialog_DateFilter(var Group: Integer; var DateBegin, DateEnd: TDateTime): Boolean; stdcall;
{$IFNDEF FPC}
var
  FilterForm: TFilterForm;
{$ENDIF}
begin
  {$IFNDEF FPC}
  FilterForm := TFilterForm.Create(nil);
  try
    FilterForm.RadioGroup1.ItemIndex := Group;
    FilterForm.DateTimePicker1.DateTime := DateBegin;
    FilterForm.DateTimePicker2.DateTime := DateEnd;
    Result := (FilterForm.ShowModal = mrOk);
    if Result then
    begin
      Group := FilterForm.RadioGroup1.ItemIndex;
      DateBegin := FilterForm.DateTimePicker1.DateTime;
      DateEnd := FilterForm.DateTimePicker2.DateTime;
    end;
  finally
    FilterForm.Free;
  end;
  {$ENDIF}
end;

procedure UI_Dialog_Error(const Caption, UserMessage, ExceptMessage: AWideString); stdcall;
begin
  {$IFNDEF FPC}
  fError.ShowErrorA(Caption, UserMessage, ExceptMessage);
  {$ENDIF}
end;

function UI_Dialog_Font(var FontName: AWideString; var FontSize: AInteger; FontColor: AColor): ABoolean; stdcall;
begin
  Result := ExecuteFontDialog(FontName, FontSize, FontColor);
end;

function UI_Dialog_GetWindow(Dialog: ADialog): AWindow; stdcall;
begin
  Result := TAUIDialog(Dialog).GetWindow;
end;

function UI_Dialog_InputBox(const Text: AWideString; var Value: AWideString): Boolean; stdcall;
begin
  Result := UI_Dialog_InputBoxA(Runtime_GetTitle, Text, Value);
end;

function UI_Dialog_InputBox2(const Caption, Text1, Text2: AWideString; var Value1, Value2: AWideString): ABoolean; stdcall;
begin
  {$IFNDEF FPC}
  Result := fPasswordDialog.InputBox2(Caption, Text1, Text2, Value1, Value2);
  {$ENDIF}
end;

function UI_Dialog_InputBoxA(const Caption, Text: AWideString; var Value: AWideString): Boolean; stdcall;
begin
  {$IFNDEF FPC}
  Result := fInputDialog.InputBox(Caption, Text, Value);

  {InputForm := TInputForm.Create(nil);
  try
    InputForm.Caption := Caption;
    InputForm.Value := Value;
    Result := (InputForm.ShowModal = mrOk);
    if Result then
      Value := InputForm.Value;
  finally
    InputForm.Free;
  end;}
  {$ENDIF}
end;

function UI_Dialog_Login(var UserName, Password: AWideString; IsSave: ABoolean): ABoolean; stdcall;
{$IFNDEF FPC}
var
  fmLogin: TLoginForm;
{$ENDIF}
begin
  {$IFNDEF FPC}
  fmLogin := TLoginForm.Create(nil);
  try
    //if ArchiveCore_GetIsDebug then
    //  fmLogin.SavePasswordCheckBox.Visible := True;
    fmLogin.UserName := UserName;
    Result := (fmLogin.ShowModal = mrOk);
    if Result then
    begin
      UserName := fmLogin.UserName;
      Password := fmLogin.UserPassword;
    end;
  finally
    fmLogin.Free;
  end;
  {$ENDIF}
end;

function UI_Dialog_Message(const Text, Caption: AWideString; Flags: AMessageBoxFlags): ADialogBoxCommands; stdcall;
var
  PrevCursor: TCursor;
begin
  PrevCursor := Screen.Cursor;
  Screen.Cursor := crDefault;
  Result := Application.MessageBox(PAnsiChar(string(Text)), PAnsiChar(string(Caption)), Flags);
  {$IFNDEF UNIX}
  //Result := Windows.MessageBox(Application.Handle{0}, PChar(string(Text)), PChar(string(Caption)), Flags);
  {$ENDIF}
  Screen.Cursor := PrevCursor;
end;

function UI_Dialog_New(Buttons: AUIWindowButtons): ADialog; stdcall;
var
  Button: AControl;
  Dialog: TAUIDialog;
  Window: AControl;
  Box: AControl;
begin
  Dialog := TAUIDialog.Create;
  Box := Dialog.GetButtonsBox;
  Window := UI_Dialog_GetWindow(ADialog(Dialog));
  if (Buttons = MB_OK) then
  begin
    Button := UI_Button_New(Window);
    UI_Control_SetText(Button, cOkText);
    UI_Control_SetPosition(Button, 5, 5);
    UI_Button_SetKind(Button, uibkOk);
  end
  else if (Buttons = MB_OKCANCEL) then
  begin
    Button := UI_Button_New(Box);
    UI_Control_SetText(Button, cOkText);
    UI_Control_SetPosition(Button, 5, 5);
    UI_Button_SetKind(Button, uibkOk);

    Button := UI_Button_New(Box);
    UI_Control_SetText(Button, cCancelText);
    UI_Control_SetPosition(Button, 90, 5);
    UI_Button_SetKind(Button, uibkCancel);
  end
  else if (Buttons = MB_ApplyOkCancel) then
  begin
    Button := UI_Button_New(Box);
    UI_Control_SetPosition(Button, 5, 5);
    UI_Control_SetText(Button, cApplyText);

    Button := UI_Button_New(Box);
    UI_Control_SetPosition(Button, 90, 5);
    UI_Button_SetKind(Button, uibkOk);
    UI_Control_SetText(Button, cOkText);

    Button := UI_Button_New(Box);
    UI_Control_SetPosition(Button, 175, 5);
    UI_Button_SetKind(Button, uibkCancel);
    UI_Control_SetText(Button, cCancelText);
  end;
  Result := ADialog(Dialog);
end;

function UI_Dialog_SelectDirectory(var Directory: AWideString): ABoolean; stdcall;
begin
  {$IFNDEF FPC}
  Result := ExecuteSelectDirectoryDialog(Directory);
  {$ENDIF}
end;

{ Grid }

procedure UI_Grid_AddColumn(Grid: AControl; const FieldName, Title: AWideString; Width: Integer);
var
  Column: TAUIColumn;
begin
  {$IFNDEF FPC}
  Column := TDBGrid(Grid).Columns.Add;
  Column.FieldName := FieldName;
  Column.Title.Caption := Title;
  Column.Width := Width;
  {$ENDIF}
end;

function UI_Grid_New(Parent: AControl; GridType: AInteger): AControl; stdcall;
begin
  if (GridType = 0) then
    Result := AControl(StringGrid_New(TWinControl(Parent)))
  else if (GridType = 1) then
    Result := AControl(DBGrid_New(TWinControl(Parent)))
  else
    Result := 0;
end;

procedure UI_Grid_RestoreColProps(Grid: AControl; Config: AConfig; const Key: AWideString; Delimer: AChar); stdcall;
begin
  DBGrid_RestoreColProps(TDBGrid(Grid), Config, Key, Delimer);
end;

procedure UI_Grid_SaveColProps(Grid: AControl; Config: AConfig; const Key: AWideString; Delimer: AChar); stdcall;
{var
  I: Integer;
  C: TColumn;
  SectionName: string;
  Grid1: TDBGrid;}
begin
  DBGrid_SaveColProps(TDBGrid(Grid), Config, Key, Delimer);

  {$IFNDEF FPC}
  {Grid1 := TDBGrid(Grid);
  for I := 0 to Grid1.Columns.Count - 1 do
  begin
    C := Grid1.Columns.Items[I];
    SectionName := Key+Delimer+Grid1.Name+Delimer+C.FieldName;
    Settings_WriteInteger(Config, SectionName, 'Index', I);
    Settings_WriteInteger(Config, SectionName, 'Width', C.Width);
  end;}
  {$ENDIF}
end;

procedure UI_Grid_SetColumnWidth(Grid: AControl; ColumnIndex, Width, Persent, MinWidth: AInteger); stdcall;
{var
  tmpWidth: Integer;
  Column: TColumn;}
begin
  DBGrid_SetColumnWidth(TDBGrid(Grid), ColumnIndex, Width, Persent, MinWidth);

  {$IFNDEF FPC}
  {Column := TDBGrid(Grid).Columns.Items[ColumnIndex];
  tmpWidth := (Width * Persent) div 100;
  if (tmpWidth >= MinWidth) then
    Column.Width := tmpWidth
  else
    Column.Width := MinWidth;}
  {$ENDIF}
end;

procedure UI_Grid_SetColumnWidthA(Grid: AControl; ColumnIndex, Width, Persent, MinWidth, MaxWidth: AInteger); stdcall;
{var
  tmpWidth: Integer;
  Column: TColumn;}
begin
  DBGrid_SetColumnWidthA(TDBGrid(Grid), ColumnIndex, Width, Persent, MinWidth, MaxWidth);

  {$IFNDEF FPC}
  {Column := TDBGrid(Grid).Columns.Items[ColumnIndex];
  tmpWidth := Round((Width - 30) * Persent / 100) - 4;
  if (tmpWidth < MinWidth) then
    tmpWidth := MinWidth
  else if (tmpWidth > MaxWidth) then
    tmpWidth := MaxWidth;
  Column.Width := tmpWidth;}
  {$ENDIF}
end;

procedure UI_Grid_SetDataSource(Grid: AControl; Value: PADataSource); stdcall;
begin
  TDBGrid(Grid).DataSource := TDataSource(Value);
end;

{ Image }

function UI_Image_New(Parent: AControl): AControl; stdcall;
var
  Image: TImage;
begin
  Image := TImage.Create(TWinControl(Parent));
  Image.Parent := TWinControl(Parent);
  Result := AddObject(Image);
end;

function UI_Image_LoadFromFile(Image: AControl; const FileName: AWideString): ABoolean; stdcall;
begin
  try
    TImage(Image).Picture.LoadFromFile(FileName);
    Result := True;
  except
    Result := False;
  end;
end;

{ Label }

function UI_Label_New(Parent: AControl): AControl; stdcall;
var
  L: TLabel;
begin
  L := TLabel.Create(TWinControl(Parent));
  L.Parent := TWinControl(Parent);
  Result := AddObject(L);
end;

{ ListBox }

function UI_ListBox_Add(ListBox: AControl; const Text: AWideString): Integer; stdcall;
var
  O: TObject;
begin
  O := GetObject(ListBox);
  if Assigned(O) and (O is TListBox) then
    Result := TListBox(O).Items.Add(Text)
  else if Assigned(O) and (O is TRadioGroup) then
    Result := TRadioGroup(O).Items.Add(Text)
  else
    Result := -1;
end;

procedure UI_ListBox_Clear(ListBox: AControl); stdcall;
var
  O: TObject;
begin
  O := GetObject(ListBox);
  if Assigned(O) and (O is TListBox) then
    TListBox(O).Clear
  else if Assigned(O) and (O is TRadioGroup) then
    TRadioGroup(O).Items.Clear;
  {if (ListBox <> 0) then
    TListBox(ListBox).Clear;}
end;

procedure UI_ListBox_DeleteItem(ListBox: AControl; Index: AInteger); stdcall;
begin
  TListBox(ListBox).Items.Delete(Index);
  if (TListBox(ListBox).Items.Count > Index) then
    TListBox(ListBox).ItemIndex := Index
  else
    TListBox(ListBox).ItemIndex := Index-1;
end;

function UI_ListBox_GetCount(ListBox: AControl): AInteger; stdcall;
var
  Obj: TObject;
begin
  Obj := GetObject(ListBox);
  if Assigned(Obj) and (Obj is TListBox) then
    Result := TListBox(Obj).Items.Count
  else if Assigned(Obj) and (Obj is TRadioGroup) then
    Result := TRadioGroup(Obj).Items.Count
  else
    Result := 0;
end;

function UI_ListBox_GetItem(ListBox: AControl; Index: AInteger): AWideString; stdcall;
var
  O: TObject;
begin
  O := GetObject(ListBox);
  if Assigned(O) and (O is TListBox) then
    Result := TListBox(O).Items[Index]
  else if Assigned(O) and (O is TRadioGroup) then
    Result := TRadioGroup(O).Items[Index]
  else
    Result := '';
end;

function UI_ListBox_GetItemIndex(ListBox: AControl): AInteger; stdcall;
var
  O: TObject;
begin
  O := GetObject(ListBox);
  if Assigned(O) and (O is TListBox) then
    Result := TListBox(O).ItemIndex
  else if Assigned(O) and (O is TRadioGroup) then
    Result := TRadioGroup(O).ItemIndex
  else
    Result := 0;
end;

function UI_ListBox_New(Parent: AControl): AControl; stdcall;
begin
  Result := UI_ListBox_NewA(Parent, 0);
end;

function UI_ListBox_NewA(Parent: AControl; Typ: AInteger): AControl; stdcall;
var
  O: TObject;
  ListBox: TListBox;
  RadioGroup: TRadioGroup;
  I: Integer;
begin
  O := GetObject(Parent);
  if Assigned(O) and (O is TWinControl) then
  begin
    if (Typ = 1) then
    begin
      RadioGroup := TRadioGroup.Create(TWinControl(O));
      RadioGroup.Parent := TWinControl(O);
      Result := AddObject(RadioGroup);
    end
    else
    begin
      ListBox := TListBox.Create(TWinControl(O));
      ListBox.Parent := TWinControl(O);
      ListBox.Align := alClient;
      Result := AddObject(ListBox);

      I := Length(FListBoxs);
      SetLength(FListBoxs, I+1);
      FListBoxs[I].ListBox := Result;
      ListBox.OnClick := UI_.ListBoxClick;
      FListBoxs[I].OnClick := nil;
    end;
  end
  else
    Result := 0;
end;

procedure UI_ListBox_SetItem(ListBox: AControl; Index: AInteger; const Value: AWideString); stdcall;
begin
  TListBox(ListBox).Items[Index] := Value;
end;

procedure UI_ListBox_SetItemIndex(ListBox: AControl; Index: AInteger); stdcall;
var
  Obj: TObject;
begin
  Obj := GetObject(ListBox);
  if Assigned(Obj) and (Obj is TListBox) then
    TListBox(Obj).ItemIndex := Index
  else if Assigned(Obj) and (Obj is TRadioGroup) then
    TRadioGroup(Obj).ItemIndex := Index;
end;

{ MainMenuItem }

function UI_MainMenuItem: AMenuItem; stdcall;
begin
  Result := miMain;
end;

{ MainToolBar }

function UI_MainToolBar: AControl; stdcall;
begin
  Result := MainWindow_ToolBar;
end;

{procedure UI_MainToolBar_Set(ToolBar: AControl); stdcall; deprecated;
begin
  MainWindow_ToolBar_Set(ToolBar);
end;}

{ MainTrayIcon }

function UI_MainTrayIcon: ATrayIcon;
begin
  Result := FMainTrayIcon;
end;

{ MainWindow }

function UI_MainWindow: AWindow; stdcall;
begin
  Result := FMainWindow;
end;

function UI_MainWindow_AddMenuItem(const ParentItemName, Name, Text: AWideString; OnClick: ACallbackProc; ImageID, Weight: Integer): AMenuItem; stdcall;
{var
  Items: AMenuItem;
  Parent: AMenuItem;}
begin
  // Prof1983: 21.02.2011
  Result := UI_MainWindow_AddMenuItem2(ParentItemName, Name, Text, OnClick, ImageID, Weight);
  {if (FMainWindow = 0) then
  begin
    Result := 0;
    Exit;
  end;
  if not(Assigned(TForm(FMainWindow).Menu)) then
  begin
    Result := 0;
    Exit;
  end;
  Items := AMenuItem(TForm(FMainWindow).Menu.Items);
  if (ParentItemName = '') then
  begin
    Result := UI_MenuItem_Add(Items, Name, Text, OnClick, ImageID, Weight);
    Exit;
  end;
  Parent := UI_MenuItem_FindByName(Items, 'mi'+ParentItemName);
  if (Parent <> 0) then
  begin
    Result := UI_MenuItem_Add(Parent, Name, Text, OnClick, ImageID, Weight);
    Exit;
  end;
  Result := 0;}
end;

function UI_MainWindow_AddMenuItem2(const ParentItemName, Name, Text: AWideString; OnClick: ACallbackProc; ImageID, Weight: Integer): AMenuItem; stdcall;
var
  Items: AMenuItem;
  Parent: AMenuItem;
begin
  if (FMainWindow = 0) then
  begin
    Result := 0;
    Exit;
  end;
  if not(Assigned(TForm(FMainWindow).Menu)) then
  begin
    Result := 0;
    Exit;
  end;

  Items := AMenu(TForm(FMainWindow).Menu.Items);
  if (ParentItemName = '') then
  begin
    Result := UI_MenuItem_FindByName(Items, 'mi'+Name);
    Parent := Items;
  end
  else
  begin
    Parent := UI_MenuItem_FindByName(Items, 'mi'+ParentItemName);
    if (Parent = 0) then
    begin
      Result := 0;
      Exit;
    end;
    Result := UI_MenuItem_FindByName(Parent, 'mi'+Name)
  end;

  if (Result = 0) then
    //Result := UI_MainWindow_AddMenuItem(ParentItemName, Name, Text, OnClick, ImageID, Weight);
    Result := UI_MenuItem_Add(Parent, Name, Text, OnClick, ImageID, Weight);
end;

function UI_MainWindow_GetLeftContainer: AControl; stdcall;
begin
  Result := MainWindow_GetLeftContainer;
end;

function UI_MainWindow_GetMainContainer: AControl; stdcall;
begin
  Result := MainWindow_GetMainContainer;
end;

function UI_MainWindow_GetRightContainer: AControl; stdcall;
begin
  Result := MainWindow_GetRightContainer;
end;

procedure UI_MainWindow_Set(Value: AWindow); stdcall;
begin
  UI_MainWindow_SetA(Value, 0, 0, 0);
end;

procedure UI_MainWindow_SetA(Value: AWindow; ToolBar, StatusBar: AControl; Config: AConfig); stdcall;
begin
  if (Value = 0) then
    FMainWindow := 0
  else
  begin
    FMainWindow := AddObject(TForm(Value));
    if Assigned(TForm(Value).Menu) then
    begin
      {FMainMenu :=} AddObject(TForm(Value).Menu);
      miMain := AMenuItem(TForm(Value).Menu.Items);
    end;
    //FMainWindow := Value;

    MainWindow_Set(Value, ToolBar, StatusBar, Config);
  end;
end;

{ Menu }

function UI_Menu_GetItems(Menu: AMenu): AMenuItem; stdcall;
var
  O: TObject;
begin
  O := GetObject(Menu);
  if Assigned(O) and (O is TMenu) then
  begin
    Result := Integer(TMenu(O).Items);
  end
  else
    Result := 0;
end;

function UI_Menu_New(MenuType: AInteger): AMenu; stdcall;
begin
  Result := AMenu(TPopupMenu.Create(nil));
end;

{ MenuItem }

function UI_MenuItem_Add(MenuItem: AMenuItem; const Name, Text: AWideString; OnClick: ACallbackProc; ImageID, Weight: Integer): AMenuItem; stdcall;
var
  I: Integer;
  Index: Integer;
  IndexMax: Integer;
  WeightMax: Integer;
  Item: TMenuItem;
  mi: TMenuItem;
begin
  //Item := TMenuItem(GetObject(MenuItem));
  Item := TMenuItem(MenuItem);
  if Assigned(Item) then
  begin
    Result := UI_MenuItem_FindByName(MenuItem, 'mi'+Name);

    if (Result = 0) then
    begin
      //     
      IndexMax := -1;
      WeightMax := High(Integer);
      for I := 0 to High(FMenuItems) do
      begin
        if (FMenuItems[I].Parent = MenuItem) and (FMenuItems[I].Weight > Weight) and (FMenuItems[I].Weight < WeightMax) then
        begin
          IndexMax := I;
          WeightMax := FMenuItems[I].Weight;
        end;
      end;
      Index := IndexMax;

      mi := TMenuItem.Create(nil);
      mi.Name := 'mi'+Name;
      mi.Caption := Text;
      mi.OnClick := UI_.MenuItemClick;

      //UI_MenuItem_GetMenuIndex(FMenuItems[Index].MenuItem)

      if (Index >= 0) then
        Item.Insert(TMenuItem(FMenuItems[Index].MenuItem).MenuIndex, mi)
      else
        Item.Add(mi);

      //Result := AddMenuItem(MenuItem, Weight);
      //Item.Add(mi);
      Result := AddObject(mi);

      I := Length(FMenuItems);
      SetLength(FMenuItems, I + 1);
      FMenuItems[I].Parent := MenuItem;
      FMenuItems[I].MenuItem := Result;
      FMenuItems[I].OnClick := OnClick;
      FMenuItems[I].Weight := Weight;
    end;
  end
  else
    Result := 0;
end;

function UI_MenuItem_Add2(Parent: AMenuItem; MenuItem: AMenuItem; Weight: Integer): AMenuItem; stdcall;
var
  I: Integer;
begin
  Result := AddObject(TMenuItem(MenuItem));

  I := Length(FMenuItems);
  SetLength(FMenuItems, I + 1);
  FMenuItems[I].Parent := Parent;
  FMenuItems[I].MenuItem := Result;
  //FMenuItems[I].OnClick := OnClick;
  FMenuItems[I].Weight := Weight;
end;

function UI_MenuItem_FindByName(MenuItem: AMenuItem; const Name: AWideString): AMenuItem; stdcall;
var
  I: Integer;
begin
  for I := 0 to TMenuItem(MenuItem).Count - 1 do
    if (TMenuItem(MenuItem).Items[I].Name = Name) then
    begin
      Result := AMenuItem(TMenuItem(MenuItem).Items[I]);
      Exit;
    end;
  Result := 0;
end;

{ Objects }

function UI_Object_Add(Value: AInteger): AInteger; stdcall;
begin
  Result := AddObject(TObject(Value));
end;

{ PageControl }

function UI_PageControl_AddPage(PageControl: AControl; const Name, Text: AWideString): AControl; stdcall;
var
  O: TObject;
  TabSheet: TTabSheet;
begin
  O := GetObject(PageControl);
  if Assigned(O) and (O is TPageControl) then
  begin
    TabSheet := TTabSheet.Create(TPageControl(O));
    TabSheet.PageControl := TPageControl(O);
    TabSheet.Name := Name;
    TabSheet.Caption := Text;
    Result := AddObject(TabSheet);
  end
  else
    Result := 0;
end;

function UI_PageControl_New(Parent: AControl): AControl; stdcall;
var
  O: TObject;
  PageControl: TPageControl;
  I: Integer;
begin
  O := GetObject(Parent);
  if Assigned(O) and (O is TWinControl) then
  begin
    PageControl := TPageControl.Create(TWinControl(O));
    PageControl.Parent := TWinControl(O);
    PageControl.Align := alClient;
    Result := AddObject(PageControl);

    I := Length(FPageControls);
    SetLength(FPageControls, I+1);
    FPageControls[I].PageControl := Result;
    FPageControls[I].OnChange := nil;
  end
  else
    Result := 0;
end;

{ ProgressBar }

function UI_ProgressBar_New(Parent: AControl; Max: AInteger): AControl; stdcall;
var
  ProgressBar: TProgressBar;
begin
  ProgressBar := TProgressBar.Create(TWinControl(Parent));
  ProgressBar.Parent := TWinControl(Parent);
  ProgressBar.Max := Max;
  Result := AddObject(ProgressBar);
end;

function UI_ProgressBar_StepIt(ProgressBar: AControl): AInteger; stdcall;
begin
  TProgressBar(ProgressBar).StepIt;
  Result := TProgressBar(ProgressBar).Position;
end;

{ PropertyBox }

function UI_PropertyBox_Add(PropertyBox: AControl; const Caption: AWideString): Integer; stdcall;
begin
  Result := TPropertyBox1(PropertyBox).Add(Caption);
end;

function UI_PropertyBox_AddA(PropertyBox: AControl; const Caption, Text, Hint: AWideString; EditWidth: AInteger): AInteger; stdcall;
begin
  Result := TPropertyBox1(PropertyBox).AddA(Caption, Text, Hint, EditWidth);
end;

function UI_PropertyBox_Item_GetValue(PropertyBox: AControl; Index: Integer): AWideString; stdcall;
begin
  Result := TPropertyBox1(PropertyBox).GetText(Index);
end;

procedure UI_PropertyBox_Item_SetValue(PropertyBox: AControl; Index: Integer; const Value: AWideString); stdcall;
begin
  TPropertyBox1(PropertyBox).SetText(Index, Value);
end;

function UI_PropertyBox_New(Parent: AControl): AControl; stdcall;
begin
  Result := AControl(TPropertyBox1.Create(TWinControl(Parent)));
end;

{ Report }

function UI_Report_New(Parent: AControl): AReport; stdcall;
var
  I: Integer;
begin
  I := Length(FReports);
  SetLength(FReports, I + 1);
  Result := I+1;
  FReports[I].Parent := Parent;
  FReports[I].ToolsPanel := UI_Box_New(Parent, 0);
  UI_Control_SetSize(FReports[I].ToolsPanel, 100, 25);
  UI_Control_SetAlign(FReports[I].ToolsPanel, uiAlignTop);
  FReports[I].TextView := UI_TextView_New(Parent, 1);
  UI_Control_SetAlign(FReports[I].TextView, uiAlignClient);
  UI_TextView_SetScrollBars(FReports[I].TextView, AInteger(ssBoth));
  UI_TextView_SetFont(FReports[I].TextView, 'Courier New', 10);
  UI_TextView_SetReadOnly(FReports[I].TextView, True);
end;

procedure UI_Report_SetText(Report: AReport; const Value: AWideString); stdcall;
begin
  UI_Control_SetText(FReports[Report-1].TextView, Value);
end;

{ ReportWin }

function UI_ReportWin_New: AWindow; stdcall;
begin
  Result := UI_ReportWin_NewA(0, '');
end;

function UI_ReportWin_NewA(ReportWinType: AInteger; const Text: AWideString): AWindow; stdcall;
{$IFNDEF FPC}
var
  ReportForm: TReportForm;
  Form: TSimpleReportForm;
{$ENDIF}
begin
  if (ReportWinType = 0) then
  begin
    {$IFNDEF FPC}
    ReportForm := TReportForm.Create(nil);
    ReportForm.Editor.Text := Text;
    Result := AWindow(ReportForm);
    {$ENDIF}
  end
  else if (ReportWinType = 1) then
  begin
    {$IFNDEF FPC}
    Form := TSimpleReportForm.Create(nil);
    Form.Memo.Lines.Text := Text;
    Result := AWindow(Form);
    {$ENDIF}
  end
  else
    Result := 0;
end;

{function UI_ReportWin_Simple_New: AWindow; stdcall;
begin
  Result := UI_ReportWin_NewA(1);
end;}

{ SpinButton }

function UI_SpinButton_New(Parent: AControl): AControl; stdcall;
{$IFNDEF FPC}
var
  Spin: TSpinButton;
{$ENDIF}
begin
  {$IFNDEF FPC}
  Spin := TSpinButton.Create(TWinControl(Parent));
  Spin.Parent := TWinControl(Parent);
  Result := AControl(Spin);
  {$ENDIF}
end;

{ SpinEdit }

function UI_SpinEdit_New(Parent: AControl): AControl; stdcall;
var
  SpinEdit: TSpinEdit;
begin
  SpinEdit := TSpinEdit.Create(TWinControl(Parent));
  SpinEdit.Parent := TWinControl(Parent);
  Result := AControl(SpinEdit);
end;

function UI_SpinEdit_NewA(Parent: AControl; Value, MinValue, MaxValue: AInteger): AControl; stdcall;
var
  SpinEdit: TSpinEdit;
begin
  SpinEdit := TSpinEdit.Create(TWinControl(Parent));
  SpinEdit.Parent := TWinControl(Parent);
  SpinEdit.Value := Value;
  SpinEdit.MinValue := MinValue;
  SpinEdit.MaxValue := MaxValue;
  Result := AControl(SpinEdit);
end;

{ Splitter }

function UI_Splitter_New(Parent: AControl; SplitterType: AUISplitterType): AControl; stdcall;
var
  O: TObject;
  Splitter: TSplitter;
begin
  O := GetObject(Parent);
  if Assigned(O) and (O is TWinControl) then
  begin
    Splitter := TSplitter.Create(TWinControl(O));
    Splitter.Parent := TWinControl(O);
    Splitter.Left := 200;
    case SplitterType of
      AUISplitter_HSplitter: Splitter.Align := alTop;
      AUISplitter_VSplitter: Splitter.Align := alLeft;
      AUISplitter_HSplitterBottom: Splitter.Align := alBottom;
      AUISplitter_VSplitterRight: Splitter.Align := alRight;
    end;
    Result := AddObject(Splitter);
  end
  else
    Result := 0;
end;

{ TextView }

function UI_TextView_AddLine(TextView: AControl; const Text: AWideString): AInteger; stdcall;
begin
  if (TObject(TextView) is TMemo) then
    Result := TMemo(TextView).Lines.Add(Text)
  {$IFNDEF FPC}
  else if (TObject(TextView) is TRichEdit) then
    Result := TRichEdit(TextView).Lines.Add(Text)
  {$ENDIF}
  else
    Result := -1;
end;

function UI_TextView_New(Parent: AControl; ViewType: AInteger): AControl; stdcall;
var
  Memo: TMemo;
  {$IFNDEF FPC}
  Rich: TRichEdit;
  {$ENDIF}
begin
  if (ViewType = 0) then
  begin
    Memo := TMemo.Create(TWinControl(Parent));
    Memo.Parent := TWinControl(Parent);
    Result := AddObject(Memo);
  end
  else
  begin
    {$IFNDEF FPC}
    Rich := TRichEdit.Create(TWinControl(Parent));
    Rich.Parent := TWinControl(Parent);
    Result := AddObject(Rich);
    {$ENDIF}
  end;
end;

procedure UI_TextView_SetFont(TextView: AControl; const FontName: AWideString; FontSize: AInteger); stdcall;

  procedure SetFont(Font: TFont);
  begin
    if (FontName <> '') then
      Font.Name := FontName;
    if (FontSize <> 0) then
      Font.Size := FontSize;
  end;

begin
  {$IFNDEF FPC}
  if (TObject(TextView) is TRichEdit) then
    SetFont(TRichEdit(TextView).Font)
  {$ENDIF}
end;

procedure UI_TextView_SetReadOnly(TextView: AControl; ReadOnly: ABoolean); stdcall;
begin
  if (TObject(TextView) is TMemo) then
    TMemo(TextView).ReadOnly := ReadOnly
  {$IFNDEF FPC}
  else if (TObject(TextView) is TRichEdit) then
    TRichEdit(TextView).ReadOnly := ReadOnly;
  {$ENDIF}
end;

procedure UI_TextView_SetScrollBars(TextView: AControl; ScrollBars: AInteger); stdcall;
begin
  if (TObject(TextView) is TMemo) then
    TMemo(TextView).ScrollBars := TScrollStyle(ScrollBars)
  {$IFNDEF FPC}
  else if (TObject(TextView) is TRichEdit) then
    TRichEdit(TextView).ScrollBars := TScrollStyle(ScrollBars);
  {$ENDIF}
end;

procedure UI_TextView_SetWordWrap(TextView: AControl; Value: ABoolean); stdcall;
begin
  if (TObject(TextView) is TMemo) then
    TMemo(TextView).WordWrap := Value
  {$IFNDEF FPC}
  else if (TObject(TextView) is TRichEdit) then
    TRichEdit(TextView).WordWrap := Value;
  {$ENDIF}
end;

{ ToolBar }

function UI_ToolBar_AddButton(ToolBar: AControl; const Name, Text, Hint: AWideString; OnClick: ACallbackProc; ImageID, Weight: AInteger): AButton; stdcall;
var
  Button: AButton; //TBitBtn;
  I: Integer;
begin
  Button := UI_Button_New(ToolBar);
  UI_Control_SetName(Button, Name);
  UI_Control_SetSize(Button, 24, 24);
  UI_Control_SetText(Button, Text);
  UI_Control_SetHint(Button, Hint);
  UI_Control_SetOnClick(Button, OnClick);
  //if Assigned(Image) then
  //  IAUIclImage(Image).GetBitmap(Button.Glyph);

  //        
  i := ToolBar_GetButtonIndexByWeight(ToolBar, Weight);
  if (i >= 0) then
    UI_Control_SetPosition(Button, TBitBtn(FToolBarButtons[i].Button).Left + 10, TBitBtn(FToolBarButtons[i].Button).Top);

  Result := Button;


  {
  Button := TBitBtn.Create(TWinControl(ToolBar));
  Button.Parent := TWinControl(ToolBar);
  Button.Name := Name;
  //Button.Height := 24; //FControl.ButtonHeight;
  //Button.Width := 24;  //FControl.ButtonWidth;
  Button.Caption := Text;
  Button.Hint := Hint;
  Button.OnClick := UI_.ButtonClick;
  //if Assigned(Image) then
  //  IAUIclImage(Image).GetBitmap(Button.Glyph);

  //        
  I := ToolBar_GetButtonIndexByWeight(ToolBar, Weight);
  if (I >= 0) then
    Button.Left := TBitBtn(FToolBarButtons[I].Button).Left + 10;

  I := Length(FButtons);
  SetLength(FButtons, I + 1);
  FButtons[I].Button := PAControl(Button);
  FButtons[I].OnClick := OnClick;
  //Result := AddObject(Button);
  Result := PAButton(Button);
  }

  {
  Result := TAUIButton.Create(FUI, Button);
  AddButtonItem(Result, Weight);

  if Assigned(Result) then
  begin
    if (Hint <> '') then
      Result.Hint := Hint;
    Result.OnClick.Connect(OnClick, nil, High(AInteger));
  end;
  }
end;

function UI_ToolBar_New(Parent: AControl): AControl; stdcall;
var
  ToolBar: TToolBar;
begin
  ToolBar := TToolBar.Create(TWinControl(Parent));
  ToolBar.Parent := TWinControl(Parent);
  ToolBar.Align := alTop;
  Result := AddObject(ToolBar);
  //Result := PAControl(ToolBar);
end;

{ TrayIcon }

{$IFNDEF UNIX}
function UI_TrayIcon_GetMenuItems(TrayIcon: ATrayIcon): AMenuItem; stdcall;
var
  Tray: TAUITrayIcon;
begin
  Tray := TAUITrayIcon(TrayIcon);
  if Assigned(Tray) then
  begin
    if not(Assigned(Tray.PopupMenu)) then
      Tray.PopupMenu := TPopupMenu.Create(nil);
    Result := AMenuItem(Tray.PopupMenu.Items);
  end
  else
    Result := 0;
end;
{$ENDIF}

{ TreeView }

function UI_TreeView_AddItem(TreeView: AControl; Parent: ATreeNode; Text: AWideString): ATreeNode; stdcall;
var
  tmpTreeView: TTreeView;
begin
  tmpTreeView := TTreeView(TreeView);
  Result := ATreeNode(tmpTreeView.Items.AddChild(TTreeNode(Parent), Text));
end;

function UI_TreeView_New(Parent: AControl): AControl; stdcall;
var
  O: TObject;
  TreeView: TTreeView;
begin
  O := GetObject(Parent);
  if Assigned(O) and (O is TWinControl) then
  begin
    TreeView := TTreeView.Create(TWinControl(O));
    TreeView.Parent := TWinControl(O);
    TreeView.Align := alLeft;
    Result := AddObject(TreeView);
  end
  else
    Result := 0;
end;

{ WaitWin }

function UI_WaitWin_New(const Caption, Text: AWideString; MaxPosition: Integer): AWindow; stdcall;
{$IFNDEF FPC}
var
  WaitForm: TWaitForm;
{$ENDIF}
begin
  {$IFNDEF FPC}
  WaitForm := TWaitForm.Create(nil);
  WaitForm.Init(Caption, Text, MaxPosition);
  Result := AWindow(WaitForm);
  {$ENDIF}
end;

function UI_WaitWin_StepBy(Window: AWindow; Step: AInteger): AInteger; stdcall;
begin
  {$IFNDEF FPC}
  TWaitForm(Window).Step;
  Result := 0;
  {$ENDIF}
end;

{ Window }

procedure UI_Window_Free(Window: AWindow); stdcall;
begin
  UI_Control_Free(Window);
end;

procedure UI_Window_FreeAndNil(var Window: AWindow); stdcall;
begin
  UI_Window_Free(Window);
  Window := 0;
end;

function UI_Window_GetMenu(Window: AWindow): AMenu; stdcall;
var
  O: TObject;
begin
  O := GetObject(Window);
  if Assigned(O) and (O is TForm) then
  begin
    Result := Integer(TForm(O).Menu);
  end
  else
    Result := 0;
end;

function UI_Window_LoadConfig(Window: AWindow; Config: AConfig): ABoolean; stdcall;
begin
  Result := Form_LoadConfig(TForm(Window), Config);
end;

function UI_Window_LoadConfig2(Window: AWindow; Config: AConfig; const ConfigKey: AWideString): ABoolean; stdcall;
begin
  Result := Form_LoadConfig2(TForm(Window), Config, ConfigKey);
end;

function UI_Window_New: AControl; stdcall;
begin
  Result := AddObject(TForm.Create(nil));
end;

function UI_Window_SaveConfig(Window: AWindow; Config: AConfig): ABoolean; stdcall;
begin
  Result := Form_SaveConfig(TForm(Window), Config);
end;

function UI_Window_SaveConfig2(Window: AWindow; Config: AConfig; const ConfigKey: AWideString): ABoolean; stdcall;
begin
  Result := Form_SaveConfig2(TForm(Window), Config, ConfigKey);
end;

procedure UI_Window_SetBorderStyle(Window: AWindow; BorderStyle: AInteger); stdcall;
begin
  TForm(Window).BorderStyle := TBorderStyle(BorderStyle);
end;

procedure UI_Window_SetFormStyle(Window: AWindow; FormStyle: AInteger); stdcall;
begin
  TForm(Window).FormStyle := TFormStyle(FormStyle);
end;

procedure UI_Window_SetPosition(Window: AWindow; Position: AInteger); stdcall;
begin
  TForm(Window).Position := TPosition(poScreenCenter);
end;

function UI_Window_ShowModal(Window: AWindow): ABoolean; stdcall;
begin
  Result := (TForm(Window).ShowModal = mrOk);
end;

end.
