{
Author:  Prof1983 <prof1983@yandex.ru>
Created: 19.08.2009
LastMod: 09.06.2011
Version: 0.3.1
}
unit ASystem03;

{DEFINE NoRuntimeConfig}

{$I Defines.inc}

{$IFDEF UNIX}
  {$DEFINE NoRuntimeSysUtils}
{$ENDIF}

{$IFDEF NoSysUtils}
  {$DEFINE NoRuntimeSysUtils}
{$ENDIF NoSysUtils}

{$IFNDEF NoRuntimeConfig}
  {$DEFINE USE_CONFIG}
{$ENDIF NoRuntimeConfig}

{$IFNDEF NoRuntimeEvents}
  {$DEFINE USE_EVENTS}
{$ENDIF NoRuntimeEvents}

{$IFNDEF NoRuntimeSysUtils}
  {$DEFINE USE_SYSUTILS}
{$ENDIF NoRuntimeSysUtils}

interface

uses
  ABase0, ARuntime0, AStrings0, ASystem0,
  ALibrary0, ASystem, ASystemData, ASystemResourceString;
(*
  {$IFNDEF FPC}
    {$IFNDEF UNIX}ShellApi,{$ENDIF}
  {$ENDIF}

  {$IFDEF USE_SYSUTILS}SysUtils,{$ENDIF}
  {$IFNDEF UNIX}Windows,{$ENDIF}
  {$IFDEF USE_EVENTS}AEvents0,{$ENDIF}

  ASystemResourceString, ASystemUtils;
*)

// --- My.Application.Info functions ---
{ Gets the name, without the extension, of the assembly file for the application.
     (Runtime_GetProgramName). }
function A_Application_Info_Name(out Value: AString_Type): AInteger; stdcall;

{ Gets the company name associated with the application.
     (Runtime_GetCompanyName). }
function A_Application_Info_CompanyName(out Value: AString_Type): AInteger; stdcall;

{ Gets the copyright notice associated with the application.
      (Runtime_GetCopyright). }
function A_Application_Info_Copyright(out Value: AString_Type): AInteger; stdcall;

{ Gets the description associated with the application.
     (Runtime_GetDescription). }
function A_Application_Info_Description(out Value: AString_Type): AInteger; stdcall;

{ Gets the directory where the application is stored.
  (Runtime_GetExePath) }
function A_Application_DirectoryPath(out Value: AString_Type): AInteger; stdcall;

{ Gets the product name associated with the application.
     (Runtime_GetProductName). }
function A_Application_Info_ProductName(out Value: AString_Type): AInteger; stdcall;

{    (Runtime_GetProductVersion). }
function A_Application_Info_ProductVersion: AVersion; stdcall;

{ Gets the title associated with the application.
    ( )  (Runtime_GetTitle). }
function A_Application_Info_Title(out Value: AString_Type): AInteger; stdcall;

{       (Runtime_GetUrl). }
function A_Application_Info_Url(out Value: AString_Type): AInteger; stdcall;

{ Gets the version number of the application.
     (Runtime_GetProgramVersion). }
function A_Application_Info_Version: AVersion; stdcall;

function A_Application_DataPath(out Value: AString_Type): AInteger; stdcall;
function A_Application_ExeName(out Value: AString_Type): AInteger; stdcall;

function A_Runtime_GetConfig: AConfig; stdcall;
procedure A_Runtime_ProcessMessages; stdcall;
procedure A_Runtime_SetConfig(Value: AConfig); stdcall;
//procedure Runtime_ShowError(const UserMessage, ExceptMessage: AString); stdcall;
//function Runtime_ShowMessage(const Msg: AString): ADialogBoxCommands; stdcall;
//function Runtime_ShowMessageA(const Text, Caption: AString; Flags: AMessageBoxFlags): ADialogBoxCommands; stdcall;

// --- Set event functions ---
procedure A_Runtime_SetOnProcessMessages(Value: ARuntimeProc); stdcall;
procedure A_Runtime_SetOnShowError(Value: TAShowErrorProc); stdcall;
procedure A_Runtime_SetOnShowMessage(Value: TAShowMessageProc); stdcall;

{ Testing }

{$IFDEF USE_EVENTS}
{
function A_Runtime_OnAfterRun: AEvent; stdcall;
function A_Runtime_OnBeforeRun: AEvent; stdcall;
function A_Runtime_OnAfterRun_Connect(Callback: ACallbackProc; Weight: AInteger = High(AInteger)): Integer; stdcall;
function A_Runtime_OnAfterRun_Disconnect(Callback: ACallbackProc): AInteger; stdcall;
function A_Runtime_OnBeforeRun_Connect(Callback: ACallbackProc; Weight: AInteger = High(AInteger)): AInteger; stdcall;
function A_Runtime_OnBeforeRun_Disconnect(Callback: ACallbackProc): AInteger; stdcall;
}
{$ENDIF USE_EVENTS}
function A_Runtime_ParamCount: AInteger; stdcall;
function A_Runtime_ParamStr(Index: AInteger; out Value: AString_Type): AInteger; stdcall;
function A_Runtime_ShellExecute(const Operation, FileName, Parameters, Directory: AString_Type): AInteger; stdcall;

// Initialize Core (for Linux)
function A_System_Prepare(const Title, ProgramName: AString_Type; ProgramVersion: AVersion;
    ProductName: AString_Type; ProductVersion: AVersion;
    CompanyName, Copyright, Url, Description, DataPath: AString_Type): AInteger; stdcall;

// --- Module ---

function System_Boot: AInteger; stdcall;

// Initialise system
function System_Init: AInteger; stdcall;

// Finalize Core
function System_Done: AInteger; stdcall;

implementation

(*
exports
  Runtime_GetCompanyName,
  Runtime_GetCopyright,
  Runtime_GetDescription,
  Runtime_GetExeName,
  Runtime_GetExePath,
  Runtime_GetProductName,
  Runtime_GetProductVersion,
  Runtime_GetProgramName,
  Runtime_GetProgramVersion,
  Runtime_GetTitle,
  Runtime_GetUrl,
  Runtime_GetResourceString,
  Runtime_GetConfig,
  {$IFDEF USE_EVENTS}
  Runtime_OnAfterRun_Connect,
  Runtime_OnAfterRun_Disconnect,
  Runtime_OnBeforeRun_Connect,
  Runtime_OnBeforeRun_Disconnect,
  {$ENDIF USE_EVENTS}
  Runtime_ProcessMessages,
  Runtime_SetConfig,
  //Runtime_ShowError,
  //Runtime_ShowMessage,
  //Runtime_ShowMessageA,
  Runtime_Shutdown,
  Runtime_SetOnProcessMessages,
  Runtime_SetOnShowError,
  Runtime_SetOnShowMessage;
*)

const
  SystemProcs: ASystemProcs_Type = (
    // --- Info functions (Old) ---
    GetCompanyName: Runtime_GetCompanyName;
    GetCopyright: Runtime_GetCopyright;
    GetDescription: Runtime_GetDescription;
    GetExeName: Runtime_GetExeName;
    GetExePath: Runtime_GetExePath;
    GetProductName: Runtime_GetProductName;
    GetProductVersion: Runtime_GetProductVersion;
    GetProgramName: Runtime_GetProgramName;
    GetProgramVersion: Runtime_GetProgramVersion;
    GetTitle: Runtime_GetTitle;
    GetUrl: Runtime_GetUrl;

    // --- (Old) ---
    GetConfig: A_Runtime_GetConfig;
    GetResourceString: Runtime_GetResourceString;
    ProcessMessages: A_Runtime_ProcessMessages;
    SetConfig: A_Runtime_SetConfig;
    ShowError: Runtime_ShowError;
    ShowMessage: Runtime_ShowMessage;
    ShowMessageA: Runtime_ShowMessageA;
    Reserved: 0; //Shutdown: Runtime_Shutdown;

    // --- Set event functions ---
    SetOnProcessMessages: ASystem03.A_Runtime_SetOnProcessMessages;
    SetOnShowError: ASystem03.A_Runtime_SetOnShowError;
    SetOnShowMessage: ASystem03.A_Runtime_SetOnShowMessage;

    // --- Events and tools ---
    {$IFDEF USE_EVENTS}
    OnAfterRun: ASystem.Runtime_OnAfterRun;
    OnBeforeRun: ASystem.Runtime_OnBeforeRun;
    OnAfterRun_Connect: ASystem.Runtime_OnAfterRun_Connect;
    OnAfterRun_Disconnect: ASystem.Runtime_OnAfterRun_Disconnect;
    OnBeforeRun_Connect: ASystem.Runtime_OnBeforeRun_Connect;
    OnBeforeRun_Disconnect: ASystem.Runtime_OnBeforeRun_Disconnect;
    {$ELSE}
    OnAfterRun: nil;
    OnBeforeRun: nil;
    OnAfterRun_Connect: nil;
    OnAfterRun_Disconnect: nil;
    OnBeforeRun_Connect: nil;
    OnBeforeRun_Disconnect: nil;
    {$ENDIF USE_EVENTS}

    // --- (Old) ---
    ParamStr: ASystem.Runtime_ParamStr;
    ShellExecute: ASystem.Runtime_ShellExecute;
    GetDataPath: ASystem.Runtime_GetDataPath;

    // --- Info functions ---
    Application_DataPath: ASystem03.A_Application_DataPath;
    Application_DirectoryPath: ASystem03.A_Application_DirectoryPath;
    Application_ExeName: ASystem03.A_Application_ExeName;

    Application_Info_CompanyName: ASystem03.A_Application_Info_CompanyName;
    Application_Info_Copyright: ASystem03.A_Application_Info_Copyright;
    Application_Info_Description: ASystem03.A_Application_Info_Description;
    Application_Info_ProductName: ASystem03.A_Application_Info_ProductName;
    Application_Info_ProductVersion: ASystem03.A_Application_Info_ProductVersion;
    Application_Info_Name: ASystem03.A_Application_Info_Name;
    Application_Info_Version: ASystem03.A_Application_Info_Version;
    Application_Info_Title: ASystem03.A_Application_Info_Title;
    Application_Info_Url: ASystem03.A_Application_Info_Url;

    //GetResourceString: ASystem03.System_GetResourceString;
    //ShowError: ASystem03.System_ShowError;
    //ShowMessage: ASystem03.System_ShowMessage;
    //ShowMessageA: ASystem03.System_ShowMessageA;

    PrepareW: System_PrepareA; //Reserved43: 0;

    Library_OpenW: Library_OpenW; //Reserved44: 0;
    Library_Close: Library_Close; //Reserved45: 0;
    Library_BuildPathW: Library_BuildPathW; //Reserved46: 0;
    Library_GetNameW: Library_GetNameW; //Reserved47: 0;
    Library_GetProcAddressW: Library_GetProcAddressW; {48} //Reserved48: 0;
    Library_GetSymbolW: Library_GetSymbolW; //Reserved49: 0;

    Reserved50: 0;
    Reserved51: 0;
    Reserved52: 0;
    Reserved53: 0;
    Reserved54: 0;
    Reserved55: 0;
    Reserved56: 0;
    Reserved57: 0;
    Reserved58: 0;
    Reserved59: 0;
    Reserved60: 0;
    Reserved61: 0;
    Reserved62: 0;
    Reserved63: 0;
    Reserved64: 0; {64}
    Reserved65: 0;
    Reserved66: 0;
    Reserved67: 0;
    Reserved68: 0;
    Reserved69: 0;
    Reserved70: 0;
    Reserved71: 0;
    Reserved72: 0;
    Reserved73: 0;
    Reserved74: 0;
    Reserved75: 0;
    Reserved76: 0;
    Reserved77: 0;
    Reserved78: 0;
    Reserved79: 0;
    Reserved80: 0; {80}
    Reserved81: 0;
    Reserved82: 0;
    Reserved83: 0;
    Reserved84: 0;
    Reserved85: 0;
    Reserved86: 0;
    Reserved87: 0;
    Reserved88: 0;
    Reserved89: 0;
    Reserved90: 0;
    Reserved91: 0;
    Reserved92: 0;
    Reserved93: 0;
    Reserved94: 0;
    Reserved95: 0;
    Reserved96: 0; {96}
    Reserved97: 0;
    Reserved98: 0;
    Reserved99: 0;
    Reserved100: 0;
    Reserved101: 0;
    Reserved102: 0;
    Reserved103: 0;
    Reserved104: 0;
    Reserved105: 0;
    Reserved106: 0;
    Reserved107: 0;
    Reserved108: 0;
    Reserved109: 0;
    Reserved110: 0;
    Reserved111: 0;
    Reserved112: 0; {112}
    Reserved113: 0;
    Reserved114: 0;
    Reserved115: 0;
    Reserved116: 0;
    Reserved117: 0;
    Reserved118: 0;
    Reserved119: 0;
    Reserved120: 0;
    Reserved121: 0;
    Reserved122: 0;
    Reserved123: 0;
    Reserved124: 0;
    Reserved125: 0;
    Reserved126: 0;
    Reserved127: 0;
    );

const
  SystemModule: AModule_Type = (
    Version: ASystem_Version;
    Uid: ASystem_Uid;
    Name: ASystem_Name;
    Description: nil;
    Init: System_Init;
    Done: System_Done;
    Reserved06: 0;
    Procs: Addr(SystemProcs);
    );

{ System public procs }

function A_System_Prepare(const Title, ProgramName: AString_Type; ProgramVersion: AVersion;
    ProductName: AString_Type; ProductVersion: AVersion;
    CompanyName, Copyright, Url, Description, DataPath: AString_Type): AInteger;
begin
  try
    System_PrepareA(
        AStrings.String_ToWideString(Title),
        AStrings.String_ToWideString(ProgramName),
        ProgramVersion,
        AStrings.String_ToWideString(ProductName),
        ProductVersion,
        AStrings.String_ToWideString(CompanyName),
        AStrings.String_ToWideString(Copyright),
        AStrings.String_ToWideString(Url),
        AStrings.String_ToWideString(Description),
        AStrings.String_ToWideString(DataPath));
    Result := 0;
  except
    Result := -1;
  end;
end;

{ A_Application }

function A_Application_DataPath(out Value: AString_Type): AInteger; stdcall;
begin
  Result := AStrings.String_AssignW(Value, FDataPath);
end;

function A_Application_DirectoryPath(out Value: AString_Type): AInteger; stdcall;
begin
  Result := AStrings.String_AssignW(Value, FExePath);
end;

function A_Application_ExeName(out Value: AString_Type): AInteger; stdcall;
begin
  Result := AStrings.String_AssignW(Value, FExeName);
end;

function A_Application_Info_CompanyName(out Value: AString_Type): AInteger; stdcall;
begin
  Result := AStrings.String_AssignW(Value, FCompanyName);
end;

function A_Application_Info_Copyright(out Value: AString_Type): AInteger; stdcall;
begin
  Result := AStrings.String_AssignW(Value, FCopyright);
end;

function A_Application_Info_Description(out Value: AString_Type): AInteger; stdcall;
begin
  Result := AStrings.String_AssignW(Value, FDescription);
end;

function A_Application_Info_Name(out Value: AString_Type): AInteger; stdcall;
begin
  Result := AStrings.String_AssignW(Value, FProgramName);
end;

function A_Application_Info_ProductName(out Value: AString_Type): AInteger; stdcall;
begin
  Result := AStrings.String_AssignW(Value, FProductName);
end;

function A_Application_Info_ProductVersion: AVersion; stdcall;
begin
  Result := FProductVersion;
end;

function A_Application_Info_Title(out Value: AString_Type): AInteger; stdcall;
begin
  Result := AStrings.String_AssignW(Value, FTitle);
end;

function A_Application_Info_Url(out Value: AString_Type): AInteger; stdcall;
begin
  Result := AStrings.String_AssignW(Value, FUrl);
end;

function A_Application_Info_Version: AVersion; stdcall;
begin
  Result := FProgramVersion;
end;

{ --- }

function A_Runtime_GetConfig: AConfig; stdcall;
begin
  Result := FConfig;
end;

(*
{$IFDEF USE_EVENTS}
function Runtime_OnAfterRun: AEvent; stdcall;
begin
  Result := FOnAfterRunEvent;
end;
{$ENDIF USE_EVENTS}

{$IFDEF USE_EVENTS}
function Runtime_OnAfterRun_Connect(Callback: ACallbackProc; Weight: AInteger): Integer; stdcall;
begin
  Result := Event_Connect(FOnAfterRunEvent, Callback, Weight);
end;
{$ENDIF USE_EVENTS}

{$IFDEF USE_EVENTS}
function Runtime_OnAfterRun_Disconnect(Callback: ACallbackProc): Integer; stdcall;
begin
  Result := Event_Disconnect(FOnAfterRunEvent, Callback);
end;
{$ENDIF USE_EVENTS}

{$IFDEF USE_EVENTS}
function Runtime_OnBeforeRun: AEvent; stdcall;
begin
  Result := FOnBeforeRunEvent;
end;
{$ENDIF USE_EVENTS}

{$IFDEF USE_EVENTS}
function Runtime_OnBeforeRun_Connect(Callback: ACallbackProc; Weight: AInteger = High(AInteger)): AInteger; stdcall;
begin
  Result := Event_Connect(FOnBeforeRunEvent, Callback, Weight);
end;
{$ENDIF USE_EVENTS}

{$IFDEF USE_EVENTS}
function Runtime_OnBeforeRun_Disconnect(Callback: ACallbackProc): Integer; stdcall;
begin
  Result := Event_Disconnect(FOnBeforeRunEvent, Callback);
end;
{$ENDIF USE_EVENTS}
*)

function A_Runtime_ParamCount: AInteger; stdcall;
begin
  Result := ParamCount;
end;

function A_Runtime_ParamStr(Index: AInteger; out Value: AString_Type): AInteger; stdcall;
begin
  Result := AStrings.String_AssignW(Value, ParamStr(Index));
end;

procedure A_Runtime_ProcessMessages; stdcall;
begin
  if Assigned(FOnProcessMessages) then
    FOnProcessMessages;
end;

procedure A_Runtime_SetConfig(Value: AConfig); stdcall;
begin
  FConfig := Value;
end;

procedure A_Runtime_SetOnProcessMessages(Value: ARuntimeProc); stdcall;
begin
  FOnProcessMessages := Value;
end;

procedure A_Runtime_SetOnShowError(Value: TAShowErrorProc); stdcall;
begin
  FOnShowError := Value;
end;

procedure A_Runtime_SetOnShowMessage(Value: TAShowMessageProc); stdcall;
begin
  FOnShowMessage := Value;
end;

function A_Runtime_ShellExecute(const Operation, FileName, Parameters, Directory: AString_Type): AInteger; stdcall;
begin
  try
    Result := Runtime_ShellExecute(
        AStrings.String_ToWideString(Operation),
        AStrings.String_ToWideString(FileName),
        AStrings.String_ToWideString(Parameters),
        AStrings.String_ToWideString(Directory));
  except
    Result := -1;
  end;
end;

{procedure Runtime_ShowError(const UserMessage, ExceptMessage: AString); stdcall;
begin
  if Assigned(FOnShowError) then
    FOnShowError(FTitle, UserMessage, ExceptMessage);
end;}

{function Runtime_ShowMessage(const Msg: AString): ADialogBoxCommands; stdcall;
begin
  Result := Runtime_ShowMessageA(Msg, FTitle, MB_OK);
end;}

{function Runtime_ShowMessageA(const Text, Caption: AString; Flags: AMessageBoxFlags): ADialogBoxCommands; stdcall;
begin
  if Assigned(FOnShowMessage) then
    Result := FOnShowMessage(Text, Caption, Flags)
  else
    Result := 0;
end;}

{ Module }

function System_Boot: AInteger; stdcall;
begin
  System_SetProcs(Addr(SystemProcs));
  Result := ARuntime.Module_Register(Addr(SystemModule));
end;

function System_Done: AInteger; stdcall;
begin
  Result := System_DoneA;
end;

function System_Init: AInteger; stdcall;
begin
  Result := System_InitA;
end;

initialization
  System_SetProcs(Addr(SystemProcs));
end.
