{
Author:  Prof1983 <prof1983@yandex.ru>
Created: 19.08.2009
LastMod: 09.06.2011
Version: 0.2.6+0.3.1
}
unit ASystem;

{DEFINE NoRuntimeConfig}

{$I Defines.inc}

{$IFDEF UNIX}
  {$DEFINE NoRuntimeSysUtils}
{$ENDIF}

{$IFDEF NoSysUtils}
  {$DEFINE NoRuntimeSysUtils}
{$ENDIF NoSysUtils}

{$IFNDEF NoRuntimeConfig}
  {$DEFINE USE_CONFIG}
{$ENDIF NoRuntimeConfig}

{$IFNDEF NoRuntimeEvents}
  {$DEFINE USE_EVENTS}
{$ENDIF NoRuntimeEvents}

{$IFNDEF NoRuntimeSysUtils}
  {$DEFINE USE_SYSUTILS}
{$ENDIF NoRuntimeSysUtils}

interface

uses
  {$IFNDEF FPC}
    {$IFNDEF UNIX}ShellApi,{$ENDIF}
  {$ENDIF}

  {$IFDEF USE_SYSUTILS}SysUtils,{$ENDIF}
  {$IFNDEF UNIX}Windows,{$ENDIF}
  {$IFDEF USE_EVENTS}AEvents0,{$ENDIF}
  {$IFDEF USE_CONFIG}ASystemConfig,{$ENDIF}
  ABase0, ARuntime0, ASettings0, AStrings0, {ASystem0,}
  ABaseUtils, ASystemData, ASystemResourceString, ASystemUtils;

// --- Info functions ---
{ Gets the name, without the extension, of the assembly file for the application.
     (Runtime_GetProgramName). }
function Application_Info_AssemblyName: AWideString; stdcall;

{ Gets the company name associated with the application.
     (Runtime_GetCompanyName). }
function Application_Info_CompanyName: AWideString; stdcall;

{ Gets the copyright notice associated with the application.
      (Runtime_GetCopyright). }
function Application_Info_Copyright: AWideString; stdcall;

{ Gets the description associated with the application.
     (Runtime_GetDescription). }
function Application_Info_Description: AWideString; stdcall;

{ Gets the directory where the application is stored.
  (Runtime_GetExePath) }
function Application_Info_DirectoryPath: AWideString; stdcall;

{ Gets a collection of all assemblies loaded by the application. }
//function Application_Info_LoadedAssemblies;

{ Gets the product name associated with the application.
     (Runtime_GetProductName). }
function Application_Info_ProductName: AWideString; stdcall;

{    (Runtime_GetProductVersion). }
function Application_Info_ProductVersion: AVersion; stdcall;

{ Gets the current stack trace information. }
//function StackTrace

{ Gets the title associated with the application.
    ( )  (Runtime_GetTitle). }
function Application_Info_Title: AWideString; stdcall;

{ Gets the trademark notice associated with the application. }
//function Trademark

{       (Runtime_GetUrl). }
function Application_Info_Url: AWideString; stdcall;

{ Gets the version number of the application.
     (Runtime_GetProgramVersion). }
function Application_Info_Version: AVersion; stdcall;

{ Gets the amount of physical memory mapped to the process context. }
//function WorkingSet

{ Old }

function Runtime_GetCompanyName(): AWideString; stdcall; {deprecated}
function Runtime_GetCopyright(): AWideString; stdcall; {deprecated}
function Runtime_GetDescription(): AWideString; stdcall; {deprecated}
function Runtime_GetExeName(): AWideString; stdcall;
function Runtime_GetExePath(): AWideString; stdcall; {deprecated}
function Runtime_GetProductName(): AWideString; stdcall; {deprecated}
function Runtime_GetProductVersion(): AWideString; stdcall; {deprecated}
function Runtime_GetProgramName(): AWideString; stdcall; {deprecated}
function Runtime_GetProgramVersion(): AWideString; stdcall; {deprecated}
function Runtime_GetTitle(): AWideString; stdcall; {deprecated}
function Runtime_GetUrl(): AWideString; stdcall; {deprecated}

function Runtime_GetConfig: AConfig; stdcall;
//function Runtime_GetResourceString(const Section, Name, Default: AWideString): AWideString; stdcall;
procedure Runtime_ProcessMessages; stdcall;
procedure Runtime_SetConfig(Value: AConfig); stdcall;
procedure Runtime_ShowError(const UserMessage, ExceptMessage: AWideString); stdcall;
function Runtime_ShowMessage(const Msg: AWideString): ADialogBoxCommands; stdcall;
function Runtime_ShowMessageA(const Text, Caption: AWideString; Flags: AMessageBoxFlags): ADialogBoxCommands; stdcall;

// --- Set event functions ---
procedure Runtime_SetOnProcessMessages(Value: ARuntimeProc); stdcall;
procedure Runtime_SetOnShowError(Value: TAShowErrorProc); stdcall;
procedure Runtime_SetOnShowMessage(Value: TAShowMessageProc); stdcall;

{ Testing }

{$IFDEF USE_EVENTS}
function Runtime_OnAfterRun: AEvent; stdcall;
function Runtime_OnBeforeRun: AEvent; stdcall;
function Runtime_OnAfterRun_Connect(Callback: ACallbackProc; Weight: AInteger = High(AInteger)): Integer; stdcall;
function Runtime_OnAfterRun_Disconnect(Callback: ACallbackProc): AInteger; stdcall;
function Runtime_OnBeforeRun_Connect(Callback: ACallbackProc; Weight: AInteger = High(AInteger)): AInteger; stdcall;
function Runtime_OnBeforeRun_Disconnect(Callback: ACallbackProc): AInteger; stdcall;
{$ENDIF USE_EVENTS}
function Runtime_ParamCount: AInteger; stdcall;
function Runtime_ParamStr(Index: AInteger): AWideString; stdcall;
function Runtime_ShellExecute(const Operation, FileName, Parameters, Directory: AWideString): AInteger; stdcall;
function Runtime_GetDataPath: AWideString; stdcall;

// --- Module ---

// Prepare Core (for Linux)
procedure System_Prepare; stdcall;
procedure System_PrepareA(const Title, ProgramName: AWideString; ProgramVersion: AVersion;
    ProductName: AWideString; ProductVersion: AVersion;
    CompanyName, Copyright, Url, Description, DataPath: AWideString); stdcall;

// Initialise system
function System_InitA: AInteger; stdcall;

// Finalize Core
function System_DoneA: AInteger; stdcall;

implementation

{ Private }

function TryStrToVersion(const S: AWideString; out Version: AVersion): ABoolean;
begin
  // ...
  Result := False;
end;

{ Events }

{$IFDEF USE_EVENTS}
function DoAfterRun: AInteger; stdcall;
begin
  Result := Event_Invoke(FOnAfterRunEvent, 0);
end;
{$ENDIF USE_EVENTS}

{$IFDEF USE_EVENTS}
function DoBeforeRun: AInteger; stdcall;
begin
  Result := Event_Invoke(FOnBeforeRunEvent, 0);
end;
{$ENDIF USE_EVENTS}

{ Application.Info }

function Application_Info_AssemblyName: AWideString; stdcall;
begin
  Result := FProgramName;
end;

function Application_Info_CompanyName: AWideString; stdcall;
begin
  Result := FCompanyName;
end;

function Application_Info_Copyright: AWideString; stdcall;
begin
  Result := FCopyright;
end;

function Application_Info_Description: AWideString; stdcall;
begin
  Result := FDescription;
end;

function Application_Info_DirectoryPath: AWideString; stdcall;
begin
  Result := FExePath;
end;

function Application_Info_ProductName: AWideString; stdcall;
begin
  Result := FProductName;
end;

function Application_Info_ProductVersion: AVersion; stdcall;
begin
  Result := FProductVersion;
end;

function Application_Info_Title: AWideString; stdcall;
begin
  Result := FTitle;
end;

function Application_Info_Url: AWideString; stdcall;
begin
  Result := FUrl;
end;

function Application_Info_Version: AVersion; stdcall;
begin
  Result := FProgramVersion;
end;

{ System public procs }

procedure System_Prepare; stdcall;
begin
  System_PrepareA('', '', $00000000, '', $00000000, '', '', '', '', '');
end;

procedure System_PrepareA(const Title, ProgramName: AWideString; ProgramVersion: AVersion;
    ProductName: AWideString; ProductVersion: AVersion;
    CompanyName, Copyright, Url, Description, DataPath: AWideString); stdcall;
{$IFNDEF UNIX}
type
  arrc = array[0..$ffff] of Char;
var
  Wnd: DWORD;
  InfoSize: DWORD;
  VersionInfo: Pointer;

  function ReadVer(BlockName: string): AnsiString;
  var
    st: ShortString;
    p: ^arrc; // absolute VersionInfo
    Size: DWORD;
  begin
    if (VerQueryValue(VersionInfo, PChar(BlockName), Pointer(p), Size)) and (Size > 1) then
    begin
      SetLength(st, Size);
      st := Copy(p^,1,Size);
      Result := st;
    end
    else
      Result := '';
  end;
{$ENDIF}

var
  S: string;
begin
  {$IFDEF USE_EVENTS}
  FOnAfterRunEvent := Event_NewW(0, 'AfterRun');
  FOnBeforeRunEvent := Event_NewW(0, 'BeforeRun');
  ARuntime.OnAfterRun_Set(DoAfterRun);
  ARuntime.OnBeforeRun_Set(DoBeforeRun);
  {$ENDIF USE_EVENTS}

  FCompanyName := CompanyName;
  FCopyright := Copyright;
  FDescription := Description;
  FProductName := ProductName;
  FProductVersion := ProductVersion;
  FProgramName := ProgramName;
  FProgramVersion := ProgramVersion;
  FTitle := Title;
  FUrl := Url;

  FExeFileName := ParamStr(0);
  ExtractFileNameAndPathW(FExeFileName, FExeName, FExePath);

  FDataPath := NormalizePath(DataPath);

  if (FProgramName = '') then
  begin
    // Set default ProgramName
    if (Length(FExeName) > 4) and (Copy(FExeName, Length(FExeName) - 4, 4) = '.exe') then
      FProgramName := Copy(FExeName, 1, Length(FExeName) - 4)
    else
      FProgramName := FExeName;
  end;

  if (FTitle = '') then
    FTitle := FProgramName;

  {$IFNDEF UNIX}
  InfoSize := GetFileVersionInfoSize(PChar(Paramstr(0)), Wnd);
  if (InfoSize <> 0) then
  begin
    GetMem(VersionInfo, InfoSize);
    try
      if GetFileVersionInfo(PChar(Paramstr(0)), Wnd, InfoSize, VersionInfo) then
      begin
        S := ReadVer('\StringFileInfo\041904E3\ProductName');
        if (S <> '') then FProductName := S;
        S := ReadVer('\StringFileInfo\041904E3\ProductVersion');
        if (S <> '') then TryStrToVersion(S, FProductVersion);
        S := ReadVer('\StringFileInfo\041904E3\InternalName');
        if (S <> '') then FProgramName := S;
        S := ReadVer('\StringFileInfo\041904E3\FileVersion');
        if (S <> '') then TryStrToVersion(S, FProgramVersion); //FProgramVersion := S;
        S := ReadVer('\StringFileInfo\041904E3\LegalCopyright');
        if (S <> '') then FCopyright := S;
        S := ReadVer('\StringFileInfo\041904E3\CompanyName');
        if (S <> '') then FCompanyName := S;
        S := ReadVer('\StringFileInfo\041904E3\FileDescription');
        if (S <> '') then FDescription := S;
        //S := ReadVer('\StringFileInfo\041904E3\OriginalFilename');
        //if (S <> '') then Memo.Lines.Add(' : '+S);
      end;
    finally
      FreeMem(VersionInfo);
    end;
  end;
  {$ENDIF}
end;

function System_DoneA: AInteger; stdcall;
begin
  {$IFDEF USE_CONFIG}
  DoneConfig;
  //...
  if (FConfig <> 0) then
    Settings_Close(FConfig);
  {$ENDIF USE_CONFIG}
  Result := 0;
end;

{ --- }

function Runtime_GetCompanyName: AWideString; stdcall;
begin
  Result := FCompanyName;
end;

function Runtime_GetConfig: AConfig; stdcall;
begin
  Result := FConfig;
end;

function Runtime_GetCopyright: AWideString; stdcall;
begin
  Result := FCopyright;
end;

function Runtime_GetDataPath: AWideString; stdcall;
begin
  Result := FDataPath;
end;

function Runtime_GetDescription: AWideString; stdcall;
begin
  Result := FDescription;
end;

function Runtime_GetExeName: AWideString; stdcall;
begin
  Result := FExeName;
end;

function Runtime_GetExePath: AWideString; stdcall;
begin
  Result := FExePath;
end;

function Runtime_GetProductName: AWideString; stdcall;
begin
  Result := FProductName;
end;

function Runtime_GetProductVersion: AWideString; stdcall;
begin
  Result := VersionToStr(FProductVersion);
end;

function Runtime_GetProgramName: AWideString; stdcall;
begin
  Result := FProgramName;
end;

function Runtime_GetProgramVersion: AWideString; stdcall;
begin
  Result := VersionToStr(FProgramVersion);
end;

(*
function Runtime_GetResourceString(const Section, Name, Default: AWideString): AWideString; stdcall;
begin
  Result := GetResourceString(
          Section,
          Name,
          Default));
  {
  Result := Default;
  if (Section = 'About') then
  begin
    if (Name = 'MenuText') then
      Result := cAbout;
  end
  else if (Section = 'Tools') then
  begin
    if (Name = 'Options') then
      Result := cSettings;
  end
  else if (Section = '') then
  begin
    if (Name = 'Modules') then
      Result := cModules;
  end;
  }
end;
*)

function Runtime_GetTitle: AWideString; stdcall;
begin
  Result := FTitle;
end;

function Runtime_GetUrl: AWideString; stdcall;
begin
  Result := FUrl;
end;

function System_InitA: AInteger; stdcall;
begin
  {$IFDEF USE_CONFIG}
  InitConfig;
  {$ENDIF USE_CONFIG}
  Result := 0;
end;

{$IFDEF USE_EVENTS}
function Runtime_OnAfterRun: AEvent; stdcall;
begin
  Result := FOnAfterRunEvent;
end;
{$ENDIF USE_EVENTS}

{$IFDEF USE_EVENTS}
function Runtime_OnAfterRun_Connect(Callback: ACallbackProc; Weight: AInteger): Integer; stdcall;
begin
  Result := Event_Connect(FOnAfterRunEvent, Callback, Weight);
end;
{$ENDIF USE_EVENTS}

{$IFDEF USE_EVENTS}
function Runtime_OnAfterRun_Disconnect(Callback: ACallbackProc): Integer; stdcall;
begin
  Result := Event_Disconnect(FOnAfterRunEvent, Callback);
end;
{$ENDIF USE_EVENTS}

{$IFDEF USE_EVENTS}
function Runtime_OnBeforeRun: AEvent; stdcall;
begin
  Result := FOnBeforeRunEvent;
end;
{$ENDIF USE_EVENTS}

{$IFDEF USE_EVENTS}
function Runtime_OnBeforeRun_Connect(Callback: ACallbackProc; Weight: AInteger = High(AInteger)): AInteger; stdcall;
begin
  Result := Event_Connect(FOnBeforeRunEvent, Callback, Weight);
end;
{$ENDIF USE_EVENTS}

{$IFDEF USE_EVENTS}
function Runtime_OnBeforeRun_Disconnect(Callback: ACallbackProc): Integer; stdcall;
begin
  Result := Event_Disconnect(FOnBeforeRunEvent, Callback);
end;
{$ENDIF USE_EVENTS}

function Runtime_ParamCount: AInteger; stdcall;
begin
  Result := ParamCount;
end;

function Runtime_ParamStr(Index: AInteger): AWideString; stdcall;
begin
  Result := ParamStr(Index);
end;

procedure Runtime_ProcessMessages; stdcall;
begin
  if Assigned(FOnProcessMessages) then
    FOnProcessMessages;
end;

procedure Runtime_SetConfig(Value: AConfig); stdcall;
begin
  FConfig := Value;
end;

procedure Runtime_SetOnProcessMessages(Value: ARuntimeProc); stdcall;
begin
  FOnProcessMessages := Value;
end;

procedure Runtime_SetOnShowError(Value: TAShowErrorProc); stdcall;
begin
  FOnShowError := Value;
end;

procedure Runtime_SetOnShowMessage(Value: TAShowMessageProc); stdcall;
begin
  FOnShowMessage := Value;
end;

function Runtime_ShellExecute(const Operation, FileName, Parameters, Directory: AWideString): AInteger; stdcall;
begin
  Result := ShellExecute(0{DrawWin.Handle}, nil, 'Calc', nil, nil, SW_SHOW);
  //Result := -1;
end;

procedure Runtime_ShowError(const UserMessage, ExceptMessage: AWideString); stdcall;
begin
  if Assigned(FOnShowError) then
    FOnShowError(FTitle, UserMessage, ExceptMessage);
end;

function Runtime_ShowMessage(const Msg: AWideString): ADialogBoxCommands; stdcall;
begin
  Result := Runtime_ShowMessageA(Msg, FTitle, MB_OK);
end;

function Runtime_ShowMessageA(const Text, Caption: AWideString; Flags: AMessageBoxFlags): ADialogBoxCommands; stdcall;
begin
  if Assigned(FOnShowMessage) then
    Result := FOnShowMessage(Text, Caption, Flags)
  else
    Result := 0;
end;

end.
