{
      ( .dll, .so)
Author:  Prof1983 <prof1983@yandex.ru>
Created: 02.10.2005
LastMod: 08.06.2011
Version: 0.1.2+0.2.6+0.3.1
}
unit ALibraries;

{$I Defines.inc}

interface

uses
  ABase0, ALibrary0, AStrings0, ASystem0;

//   ().  .
function A_Library_Open(const FileName: AString_Type; Flags: ALibraryFlags): ALibrary; stdcall;
//   ()
function A_Library_Close(Lib: ALibrary): ABoolean; stdcall;
function A_Library_BuildPath(const Directory, LibraryName: AString_Type; out Value: AString_Type): AInteger; stdcall;
function A_Library_GetName(Lib: ALibrary; out Value: AString_Type): AInteger; stdcall;
//   
function A_Library_GetProcAddress(Lib: ALibrary; const Name: AString_Type): Pointer; stdcall;
//   
function A_Library_GetSymbol(Lib: ALibrary; const SymbolName: AString_Type; var Symbol: Pointer): ABoolean; stdcall;

implementation

{ Public Functions }

function A_Library_BuildPath(const Directory, LibraryName: AString_Type; out Value: AString_Type): AInteger; stdcall;
begin
  try
    Result := AStrings.String_AssignW(Value, Library_BuildPathW(
        AStrings.String_ToWideString(Directory),
        AStrings.String_ToWideString(LibraryName)));
  except
    Result := 0;
  end;
end;

function A_Library_Close(Lib: ALibrary): ABoolean; stdcall;
begin
  try
    Result := Library_Close(Lib);
  except
    Result := False;
  end;
end;

function A_Library_GetName(Lib: ALibrary; out Value: AString_Type): AInteger; stdcall;
var
  TmpValue: AWideString;
begin
  try
    TmpValue := Library_GetNameW(Lib);
    Result := AStrings.String_AssignW(Value, TmpValue);
  except
    Result := 0;
  end;
end;

function A_Library_GetProcAddress(Lib: ALibrary; const Name: AString_Type): Pointer; stdcall;
begin
  try
    Result := Library_GetProcAddressW(Lib, AStrings.String_ToWideString(Name));
  except
    Result := nil;
  end;
end;

function A_Library_GetSymbol(Lib: ALibrary; const SymbolName: AString_Type; var Symbol: Pointer): ABoolean; stdcall;
begin
  try
    Result := Library_GetSymbolW(Lib, AStrings.String_ToWideString(SymbolName), Symbol);
  except
    Result := False;
  end;
end;

function A_Library_Open(const FileName: AString_Type; Flags: ALibraryFlags): ALibrary; stdcall;
begin
  try
    Result := Library_OpenW(AStrings.String_ToWideString(FileName), Flags);
  except
    Result := 0;
  end;
end;

end.
