{
Abstract: 
Author:  Prof1983 <prof1983@yandex.ru>
Created: 20.10.2005
LastMod: 08.06.2011
Version: 0.1.2+0.2.6+0.3.1
}
unit AEvents;

interface

uses
  ABase0, AEvents0, AStrings0;

function A_Event_New(Obj: Integer; const Name: AString_Type): AEvent; stdcall;
function A_Event_Free(Event: AEvent): AError; stdcall;
function A_Event_Clear(Event: AEvent): AError; stdcall;
function A_Event_GetListenersCount(Event: AEvent): AInteger; stdcall;
function A_Event_Name(Event: AEvent; out Value: AString_Type): AInteger; stdcall;
function A_Event_Connect(Event: AEvent; Callback: ACallbackProc; Weight: AInteger = High(AInteger)): AInteger; stdcall;
function A_Event_Disconnect(Event: AEvent; Callback: ACallbackProc): AInteger; stdcall;
function A_Event_Invoke(Event: AEvent; Data: AInteger): AInteger; stdcall;

implementation

{ A_Event }

function A_Event_Clear(Event: AEvent): AError; stdcall;
begin
  try
    Result := Event_Clear(Event);
  except
    Result := -1;
  end;
end;

function A_Event_Connect(Event: AEvent; Callback: ACallbackProc; Weight: AInteger): AInteger; stdcall;
begin
  try
    Result := Event_Connect(Event, Callback, Weight);
  except
    Result := 0;
  end;
end;

function A_Event_Disconnect(Event: AEvent; Callback: ACallbackProc): AInteger; stdcall;
begin
  try
    Result := Event_Disconnect(Event, Callback);
  except
    Result := 0;
  end;
end;

function A_Event_Free(Event: AEvent): AError; stdcall;
begin
  try
    Event_Free(Event);
    Result := 0;
  except
    Result := -1;
  end;
end;

function A_Event_GetListenersCount(Event: AEvent): AInteger; stdcall;
begin
  try
    Result := Event_GetListenersCount(Event);
  except
    Result := 0;
  end;
end;

function A_Event_Invoke(Event: AEvent; Data: AInteger): AInteger; stdcall;
begin
  try
    Result := Event_Invoke(Event, Data);
  except
    Result := 0;
  end;
end;

function A_Event_Name(Event: AEvent; out Value: AString_Type): AInteger; stdcall;
begin
  try
    Result := AStrings.String_AssignW(Value, Event_GetNameW(Event));
  except
    Result := 0;
  end;
end;

function A_Event_New(Obj: Integer; const Name: AString_Type): AEvent; stdcall;
begin
  try
    Result := Event_NewW(Obj, AStrings.String_ToWideString(Name));
  except
    Result := 0;
  end;
end;

end.
