{
Author:  Prof1983 <prof1983@yandex.ru>
Created: 24.05.2011
LastMod: 06.06.2011
Version: 0.2.6+0.3.1
}
unit AStrings;

{
Null-terminated string functions 
Function       Description
StrAlloc       Allocates a character buffer of a given size on the heap.
StrBufSize     Returns the size of a character buffer allocated using StrAlloc or StrNew.
StrCat         Concatenates two strings.
StrComp        Compares two strings.
StrCopy        Copies a string.
StrDispose     Disposes a character buffer allocated using StrAlloc or StrNew.
StrECopy       Copies a string and returns a pointer to the end of the string.
StrEnd         Returns a pointer to the end of a string.
StrFmt         Formats one or more values into a string.
StrIComp       Compares two strings without case sensitivity.
StrLCat        Concatenates two strings with a given maximum length of the resulting string.
StrLComp       Compares two strings for a given maximum length.
StrLCopy       Copies a string up to a given maximum length.
StrLen         Returns the length of a string.
StrLFmt        Formats one or more values into a string with a given maximum length.
StrLIComp      Compares two strings for a given maximum length without case sensitivity.
StrLower       Converts a string to lowercase.
StrMove        Moves a block of characters from one string to another.
StrNew         Allocates a string on the heap.
StrPCopy       Copies a Pascal string to a null-terminated string.
StrPLCopy      Copies a Pascal string to a null-terminated string with a given maximum length.
StrPos         Returns a pointer to the first occurrence of a given substring within a string.
StrRScan       Returns a pointer to the last occurrence of a given character within a string.
StrScan        Returns a pointer to the first occurrence of a given character within a string.
StrUpper       Converts a string to uppercase.

 14.    
    isalnum
    isalpha
    isblank
    iscntrl
    isdigit
    isgraph
    islower
    isprint
    ispunct
    isspace
    isupper
    isxdigit
    memchr
    memcmp
    memcpy
    memmove
    memset
    strcat
    strchr
    strcmp
    strcoll
    strcpy -  strcpy()    str2   str1.  str2        .  strcpy()    str1. 
    strcspn
    strerror
    strlen
    strncat
    strncmp
    strncpy
    strpbrk
    strrchr
    strspn
    strstr
    strtok
    strxfrm
    tolower
    toupper
}

interface

uses
  ABase0;

function A_String_Assign(var S: AString_Type; const Value: AString_Type): ASize; stdcall;
function A_String_AssignC(var S: AString_Type; Value: PAnsiChar): ASize; stdcall;
function A_String_Copy(var S: AString_Type; const Value: AString_Type): ASize; stdcall;
function A_String_Length(const S: AString_Type): AInteger; stdcall;
function A_String_Free(var S: AString_Type): AInteger; stdcall;

function String_Assign(var S: AString_Type; const Value: AString_Type): ASize; stdcall;
function String_AssignC(var S: AString_Type; Value: PChar): ASize; stdcall;
function String_AssignW(var S: AString_Type; const Value: WideString): ASize; stdcall;
function String_Copy(var S: AString_Type; const Value: AString_Type): ASize; stdcall;
function String_CopyA(var S: AString_Type; const Value: AnsiString): ASize; stdcall;
function String_CopyW(var S: AString_Type; const Value: WideString): ASize; stdcall;
function String_Length(const S: AString_Type): AInteger; stdcall;
//function String_NewC(Value: PChar): AString;
//function String_NewW(const Value: AWideString): AString;
function String_ToUtf8String(const S: AString_Type): UTF8String; stdcall;
function String_ToWideString(const S: AString_Type): WideString; stdcall;
function String_Free(var S: AString_Type): AInteger; stdcall;

(*
{$IFDEF A03}
function A_String_AssignW(var S: AString; const Value: WideString): ASize;
function A_String_Clear(var S: AString_Type): AInteger; stdcall;
function A_String_Copy(var S: AString_Type; const Value: AString_Type): ASize; stdcall;
function A_String_CopyA(var S: AString_Type; const Value: string{AnsiString}): ASize; stdcall;
function A_String_CopyUtf8(var S: AString_Type; const Value: UTF8String{UnicodeString}): ASize; stdcall;
//function A_String_CopyUtf32(var S: AString_Type; const Value: UCS4String{UnicodeString}): ASize; stdcall;
function A_String_CopyW(var S: AString_Type; const Value: WideString): ASize; stdcall;
function A_String_Free(var S: AString_Type): AInteger; stdcall;
function A_String_Length(const S: AString_Type): AInteger; stdcall;
function A_String_Realloc(var S: AString_Type; NewAllocSize: ASize): ASize; stdcall;
function A_String_ToUtf8String(const S: AString_Type): UTF8String; stdcall;
function A_String_ToWideString(const S: AString_Type): WideString; stdcall;
{$ENDIF A03}
*)

implementation

{ A_String }

function A_String_Assign(var S: AString_Type; const Value: AString_Type): ASize; stdcall;
begin
  try
    Result := String_Assign(S, Value);
  except
    Result := 0;
  end;
end;

function A_String_AssignC(var S: AString_Type; Value: PAnsiChar): ASize; stdcall;
begin
  try
    Result := String_AssignC(S, Value);
  except
    Result := 0;
  end;
end;

function A_String_Copy(var S: AString_Type; const Value: AString_Type): ASize; stdcall;
begin
  try
    Result := String_Copy(S, Value);
  except
    Result := 0;
  end;
end;

function A_String_Free(var S: AString_Type): AInteger; stdcall;
begin
  try
    Result := String_Free(S);
  except
    Result := 0;
  end;
end;

function A_String_Length(const S: AString_Type): AInteger; stdcall;
begin
  try
    Result := String_Length(S);
  except
    Result := 0;
  end;
end;

{ String }

function String_Assign(var S: AString_Type; const Value: AString_Type): ASize; stdcall;
begin
  {$IFDEF A02}
  S := Value;
  {$ELSE}
  S.Str := Value.Str;
  {$ENDIF}
  Result := 0;
end;

function String_AssignC(var S: AString_Type; Value: PChar): ASize; stdcall;
begin
  {$IFDEF A02}
  S := Value;
  {$ELSE}
  S.Str := Value;
  {$ENDIF}
  Result := 0;
end;

function String_AssignW(var S: AString_Type; const Value: WideString): ASize; stdcall;
begin
  {$IFDEF A02}
  S := Value;
  {$ELSE}
  S.Str := Value; //Result := A_String_AssignW(S, Value);
  {$ENDIF}
  Result := 0;
end;

function String_Copy(var S: AString_Type; const Value: AString_Type): ASize; stdcall;
begin
  {$IFDEF A02}
  S := Value;
  {$ELSE}
  S.Str := Value.Str; //Result := A_String_Copy(S, Value);
  {$ENDIF}
  Result := 0;
end;

function String_CopyA(var S: AString_Type; const Value: AnsiString): ASize; stdcall;
begin
  {$IFDEF A02}
  S := Value;
  {$ELSE}
  S.Str := Value; //Result := A_String_CopyUtf8(S, AnsiToUtf8(Value));
  {$ENDIF}
  Result := 0;
end;

function String_CopyW(var S: AString_Type; const Value: WideString): ASize; stdcall;
begin
  {$IFDEF A02}
  S := Value;
  {$ELSE}
  S.Str := Value; //Result := A_String_CopyUtf8(S, UTF8Encode(Value));
  {$ENDIF}
  Result := 0;
end;

function String_Free(var S: AString_Type): AInteger; stdcall;
begin
  {$IFDEF A02}
  S := '';
  {$ELSE}
  S.Str := ''; //Result := A_String_Free(S);
  {$ENDIF}
  Result := 0;
end;

function String_Length(const S: AString_Type): AInteger; stdcall;
begin
  {$IFDEF A02}
  Result := Length(S);
  {$ELSE}
  Result := Length(S.Str); //Result := S.Len;
  {$ENDIF}
end;

(*
function String_NewC(Value: PChar): AString;
begin
  {$IFDEF A03}
  ...
  {$ELSE}
  Result := Value;
  {$ENDIF}
end;
*)

(*
function String_NewW(const Value: AWideString): AString;
begin
  {$IFDEF A03}
  ...
  {$ELSE}
  Result := Value;
  {$ENDIF}
end;
*)

function String_ToUtf8String(const S: AString_Type): UTF8String; stdcall;
begin
  {$IFDEF A02}
  Result := Utf8Encode(S);
  {$ELSE}
  Result := Utf8Encode(S.Str); //Result := A_String_ToUtf8String(S);
  {$ENDIF}
end;

function String_ToWideString(const S: AString_Type): WideString; stdcall;
begin
  {$IFDEF A02}
  Result := S;
  {$ELSE}
  Result := S.Str; //Result := A_String_ToWideString(S);
  {$ENDIF}
end;

{ A_String }

(*
{$IFDEF A03}
function A_String_AssignW(var S: AString; const Value: WideString): ASize;
begin
  A_String_Clear(S);
  Result := A_String_CopyW(S, Value);
end;

function A_String_Clear(var S: AString): AInteger; stdcall;
begin
  FillChar(S, SizeOf(S), 0);
end;

function A_String_Copy(var S: AString_Type; const Value: AString_Type): ASize; stdcall;
begin
  A_String_Realloc(S, Value.Len);
  Move(Value.Str^, S.Str^, Value.AllocSize);
  S.Len := Value.Len;
  S.Code := Value.Code;
  Result := S.AllocSize;
end;

function A_String_CopyA(var S: AString_Type; const Value: string{AnsiString}): ASize; stdcall;
begin
  Result := A_String_CopyUtf8(S, AnsiToUtf8(Value));
  //Result := String_CopyW(S, WideString(Value));
end;

function A_String_CopyUtf8(var S: AString_Type; const Value: UTF8String{UnicodeString}): ASize; stdcall;
var
  W: WideString;
begin
  W := Utf8Decode(Value);
  A_String_Realloc(S, Length(Value)+1);
  Move(Value, S.Str^, Length(Value));
  S.Str[Length(Value)] := #0;
  S.Len := Length(W);
  S.Code := 1;
  Result := S.AllocSize;
end;

function A_String_CopyW(var S: AString_Type; const Value: WideString): ASize; stdcall;
{var
  I: Integer;}
begin
  Result := A_String_CopyUtf8(S, UTF8Encode(Value));
  {
  if (String_Realloc(S, Length(Value)) <> Length(Value)) then
  begin
    Result := 0;
    Exit;
  end;
  for I := 0 to Length(Value) do
  begin
    WideChar(Pointer(Integer(S.Str)+I*2)^) := WideChar(Value[I]);
  end;
  S.Str[Length(Value)+1] := #0;
  Result := S.Len;
  }
end;

function A_String_Free(var S: AString): AInteger; stdcall;
begin
  if Assigned(S.Str) then
    FreeMem(S.Str, S.AllocSize);
  A_String_Clear(S);
end;

function A_String_Length(const S: AString_Type): AInteger; stdcall;
begin
  Result := S.Len;
end;

function A_String_Realloc(var S: AString_Type; NewAllocSize: ASize): ASize; stdcall;
begin
  if not(Assigned(S.Str)) then
    GetMem(S.Str, NewAllocSize)
  else
  begin
    FreeMem(S.Str, S.AllocSize);
    GetMem(S.Str, NewAllocSize);
  end;
  S.Len := 0;
  S.AllocSize := NewAllocSize;
  Result := S.AllocSize;
end;

function A_String_ToUtf8String(const S: AString_Type): UTF8String; stdcall;
begin
  SetLength(Result, S.AllocSize);
  Move(S.Str^, Result, S.AllocSize);
end;

function A_String_ToWideString(const S: AString_Type): WideString; stdcall;
var
  U: UTF8String;
begin
  U := A_String_ToUTF8String(S);
  Result := Utf8Decode(U);
end;
{$ENDIF A03}
*)

end.
