{
Abstract:     
Author:  Prof1983 <prof1983@yandex.ru>
Created: 06.03.2008
LastMod: 06.06.2011
Version: 0.1.2+0.2.6+0.3.1
}
unit ASettings;

interface

uses
  {$IFDEF MSWINDOWS}Windows, ARegistrySettings,{$ENDIF}
  ABase0, ACollections0, ASettings0, AStrings0,
  AAbstractSettings, AIniSettings;

function Settings_IniConfig_New(const FileName: AWideString): AConfig; stdcall;
function Settings_RegConfig_New(const Prefix: AWideString): AConfig; stdcall;
function Settings_RegConfig_NewA(const Prefix: AWideString; HKEY: Integer): AConfig; stdcall;

procedure Settings_Close(Config: AConfig); stdcall;
function Settings_DeleteKey(Config: AConfig; const Section, Name: AWideString): ABoolean; stdcall;
function Settings_DeleteSection(Config: AConfig; const Section: AWideString): ABoolean; stdcall;
function Settings_ReadBool(Config: AConfig; const Section, Name: AWideString; DefValue: ABoolean): ABoolean; stdcall;
function Settings_ReadInteger(Config: AConfig; const Section, Name: AWideString; DefValue: AInteger): AInteger; stdcall;
function Settings_ReadFloat(Config: AConfig; const Section, Name: AWideString; DefValue: AFloat): AFloat; stdcall;
function Settings_ReadSection(Config: AConfig; const Section: AWideString; Strings: AStringList): ABoolean; stdcall;
function Settings_ReadString(Config: AConfig; const Section, Name, DefValue: AWideString): AWideString; stdcall;
function Settings_ReadStringA(Config: AConfig; const Section, Name, DefValue: AWideString; out Value: AWideString): AInteger; stdcall;
function Settings_ReadDateTime(Config: AConfig; const Section, Name: AWideString; DefValue: TDateTime): TDateTime; stdcall;
function Settings_WriteBool(Config: AConfig; const Section, Name: AWideString; Value: Boolean): ABoolean; stdcall;
function Settings_WriteInteger(Config: AConfig; const Section, Name: AWideString; Value: Integer): ABoolean; stdcall;
function Settings_WriteFloat(Config: AConfig; const Section, Name: AWideString; Value: AFloat): ABoolean; stdcall;
function Settings_WriteString(Config: AConfig; const Section, Name, Value: AWideString): ABoolean; stdcall;
function Settings_WriteDateTime(Config: AConfig; const Section, Name: AWideString; Value: TDateTime): ABoolean; stdcall;


function A_Settings_IniConfig_New(const FileName: AString_Type): AConfig; stdcall;
function A_Settings_RegConfig_New(const Prefix: AString_Type): AConfig; stdcall;
function A_Settings_RegConfig_NewA(const Prefix: AString_Type; HKEY: Integer): AConfig; stdcall;

procedure A_Settings_Close(Config: AConfig); stdcall;
function A_Settings_DeleteKey(Config: AConfig; const Section, Name: AString_Type): ABoolean; stdcall;
function A_Settings_DeleteSection(Config: AConfig; const Section: AString_Type): ABoolean; stdcall;
function A_Settings_ReadBool(Config: AConfig; const Section, Name: AString_Type; DefValue: ABoolean): ABoolean; stdcall;
function A_Settings_ReadInteger(Config: AConfig; const Section, Name: AString_Type; DefValue: AInteger): AInteger; stdcall;
function A_Settings_ReadFloat(Config: AConfig; const Section, Name: AString_Type; DefValue: AFloat): AFloat; stdcall;
function A_Settings_ReadSection(Config: AConfig; const Section: AString_Type; Strings: AStringList): ABoolean; stdcall;
function A_Settings_ReadString(Config: AConfig; const Section, Name, DefValue: AString_Type; out Value: AString_Type): AInteger; stdcall;
function A_Settings_ReadDateTime(Config: AConfig; const Section, Name: AString_Type; DefValue: TDateTime): TDateTime; stdcall;
function A_Settings_WriteBool(Config: AConfig; const Section, Name: AString_Type; Value: Boolean): ABoolean; stdcall;
function A_Settings_WriteInteger(Config: AConfig; const Section, Name: AString_Type; Value: Integer): ABoolean; stdcall;
function A_Settings_WriteFloat(Config: AConfig; const Section, Name: AString_Type; Value: AFloat): ABoolean; stdcall;
function A_Settings_WriteString(Config: AConfig; const Section, Name, Value: AString_Type): ABoolean; stdcall;
function A_Settings_WriteDateTime(Config: AConfig; const Section, Name: AString_Type; Value: TDateTime): ABoolean; stdcall;

(*
const
  Settings: ASettingsProcs_Type = (
    Close: A_Settings_Close;
    DeleteKeyW: Settings_DeleteKey;
    DeleteSectionW: Settings_DeleteSection;
    IniConfig_NewW: Settings_IniConfig_New;
    ReadBoolW: Settings_ReadBool;
    ReadIntegerW: Settings_ReadInteger;
    ReadFloatW: Settings_ReadFloat;
    ReadSectionW: Settings_ReadSection;
    ReadStringW: Settings_ReadString;
    ReadDateTimeW: Settings_ReadDateTime;
    RegConfig_NewW: Settings_RegConfig_New;
    RegConfig_NewAW: Settings_RegConfig_NewA;
    WriteBoolW: Settings_WriteBool;
    WriteIntegerW: Settings_WriteInteger;
    WriteFloatW: Settings_WriteFloat;
    WriteStringW: Settings_WriteString;
    WriteDateTimeW: Settings_WriteDateTime;

    {$IFDEF A02}
    Reserved17: 0;
    Reserved18: 0;
    Reserved19: 0;
    Reserved20: 0;
    Reserved21: 0;
    Reserved22: 0;
    Reserved23: 0;
    Reserved24: 0;
    Reserved25: 0;
    Reserved26: 0;
    Reserved27: 0;
    Reserved28: 0;
    Reserved29: 0;
    Reserved30: 0;
    Reserved31: 0;
    {$ELSE}
    DeleteKey: A_Settings_DeleteKey;
    DeleteSection: A_Settings_DeleteSection;
    IniConfig_New: A_Settings_IniConfig_New;
    ReadBool: A_Settings_ReadBool;
    ReadInteger: A_Settings_ReadInteger;
    ReadFloat: A_Settings_ReadFloat;
    ReadSection: A_Settings_ReadSection;
    ReadString: A_Settings_ReadString;
    ReadDateTime: A_Settings_ReadDateTime;
    RegConfig_New: A_Settings_RegConfig_New;
    RegConfig_NewA: A_Settings_RegConfig_NewA;
    WriteBool: A_Settings_WriteBool;
    WriteInteger: A_Settings_WriteInteger;
    WriteFloat: A_Settings_WriteFloat;
    WriteString: A_Settings_WriteString;
    {$ENDIF}

    {$IFNDEF A02}
    WriteDateTime: A_Settings_WriteDateTime;
    Reserved33: 0;
    Reserved34: 0;
    Reserved35: 0;
    Reserved36: 0;
    Reserved37: 0;
    Reserved38: 0;
    Reserved39: 0;
    Reserved40: 0;
    Reserved41: 0;
    Reserved42: 0;
    Reserved43: 0;
    Reserved44: 0;
    Reserved45: 0;
    Reserved46: 0;
    Reserved47: 0;
    Reserved48: 0;
    Reserved49: 0;
    Reserved50: 0;
    Reserved51: 0;
    Reserved52: 0;
    Reserved53: 0;
    Reserved54: 0;
    Reserved55: 0;
    Reserved56: 0;
    Reserved57: 0;
    Reserved58: 0;
    Reserved59: 0;
    Reserved60: 0;
    Reserved61: 0;
    Reserved62: 0;
    Reserved63: 0;
    {$ENDIF}
    );
*)

implementation

(*
uses
  ARuntime0, SysUtils, ;
*)

{ A_Settings }

procedure A_Settings_Close(Config: AConfig); stdcall;
begin
  try
    Settings_Close(Config);
  except
  end;
end;

function A_Settings_DeleteKey(Config: AConfig; const Section, Name: AString_Type): ABoolean; stdcall;
begin
  try
    Result := Settings_DeleteKey(Config, AStrings.String_ToWideString(Section), AStrings.String_ToWideString(Name));
  except
    Result := False;
  end;
end;

function A_Settings_DeleteSection(Config: AConfig; const Section: AString_Type): ABoolean; stdcall;
begin
  try
    Result := Settings_DeleteSection(Config, AStrings.String_ToWideString(Section));
  except
    Result := False;
  end;
end;

function A_Settings_IniConfig_New(const FileName: AString_Type): AConfig; stdcall;
begin
  try
    Result := Settings_IniConfig_New(AStrings.String_ToWideString(FileName));
  except
    Result := 0;
  end;
end;

function A_Settings_ReadBool(Config: AConfig; const Section, Name: AString_Type; DefValue: ABoolean): ABoolean; stdcall;
begin
  try
    Result := Settings_ReadBool(Config,
        AStrings.String_ToWideString(Section),
        AStrings.String_ToWideString(Name),
        DefValue);
  except
    Result := DefValue;
  end
end;

function A_Settings_ReadDateTime(Config: AConfig; const Section, Name: AString_Type; DefValue: TDateTime): TDateTime; stdcall;
begin
  try
    Result := Settings_ReadDateTime(Config, AStrings.String_ToWideString(Section), AStrings.String_ToWideString(Name), DefValue);
  except
    Result := DefValue;
  end;
end;

function A_Settings_ReadFloat(Config: AConfig; const Section, Name: AString_Type; DefValue: AFloat): AFloat; stdcall;
begin
  try
    Result := Settings_ReadFloat(Config, AStrings.String_ToWideString(Section), AStrings.String_ToWideString(Name), DefValue);
  except
    Result := DefValue;
  end;
end;

function A_Settings_ReadInteger(Config: AConfig; const Section, Name: AString_Type; DefValue: AInteger): AInteger; stdcall;
begin
  try
    Result := Settings_ReadInteger(Config, AStrings.String_ToWideString(Section), AStrings.String_ToWideString(Name), DefValue);
  except
    Result := DefValue;
  end;
end;

function A_Settings_ReadSection(Config: AConfig; const Section: AString_Type; Strings: AStringList): ABoolean; stdcall;
begin
  try
    Result := Settings_ReadSection(Config, AStrings.String_ToWideString(Section), Strings);
  except
    Result := False;
  end;
end;

function A_Settings_ReadString(Config: AConfig; const Section, Name, DefValue: AString_Type; out Value: AString_Type): AInteger; stdcall;
var
  TmpValue: AWideString;
begin
  try
    Result := Settings_ReadStringA(Config,
        AStrings.String_ToWideString(Section),
        AStrings.String_ToWideString(Name),
        AStrings.String_ToWideString(DefValue),
        TmpValue);
    AStrings.String_AssignW(Value, TmpValue);
  except
    AStrings.String_Assign(Value, DefValue);
    Result := 0;
  end;
end;

function A_Settings_RegConfig_New(const Prefix: AString_Type): AConfig; stdcall;
begin
  try
    Result := Settings_RegConfig_New(AStrings.String_ToWideString(Prefix));
  except
    Result := 0;
  end;
end;

function A_Settings_RegConfig_NewA(const Prefix: AString_Type; HKEY: Integer): AConfig; stdcall;
begin
  try
    Result := Settings_RegConfig_NewA(AStrings.String_ToWideString(Prefix), HKEY);
  except
    Result := 0;
  end;
end;

function A_Settings_WriteBool(Config: AConfig; const Section, Name: AString_Type; Value: ABoolean): ABoolean; stdcall;
begin
  try
    Result := Settings_WriteBool(Config, AStrings.String_ToWideString(Section), AStrings.String_ToWideString(Name), Value);
  except
    Result := False;
  end;
end;

function A_Settings_WriteDateTime(Config: AConfig; const Section, Name: AString_Type; Value: TDateTime): ABoolean; stdcall;
begin
  try
    Result := Settings_WriteDateTime(Config,
        AStrings.String_ToWideString(Section),
        AStrings.String_ToWideString(Name),
        Value);
  except
    Result := False;
  end;
end;

function A_Settings_WriteFloat(Config: AConfig; const Section, Name: AString_Type; Value: AFloat): ABoolean; stdcall;
begin
  try
    Result := Settings_WriteFloat(Config,
        AStrings.String_ToWideString(Section),
        AStrings.String_ToWideString(Name),
        Value);
  except
    Result := False;
  end;
end;

function A_Settings_WriteInteger(Config: AConfig; const Section, Name: AString_Type; Value: AInteger): ABoolean; stdcall;
begin
  try
    Result := Settings_WriteInteger(Config,
        AStrings.String_ToWideString(Section),
        AStrings.String_ToWideString(Name),
        Value);
  except
    Result := False;
  end;
end;

function A_Settings_WriteString(Config: AConfig; const Section, Name, Value: AString_Type): ABoolean; stdcall;
begin
  try
    Result := Settings_WriteString(Config,
        AStrings.String_ToWideString(Section),
        AStrings.String_ToWideString(Name),
        AStrings.String_ToWideString(Value));
  except
    Result := False;
  end;
end;

{ Settings }

procedure Settings_Close(Config: AConfig);
begin
  TAbstractSettings(Config).Close;
end;

function Settings_DeleteKey(Config: AConfig; const Section, Name: AWideString): ABoolean;
begin
  Result := TAbstractSettings(Config).DeleteKey(Section, Name);
end;

function Settings_DeleteSection(Config: AConfig; const Section: AWideString): ABoolean;
begin
  Result := TAbstractSettings(Config).DeleteSection(Section);
end;

function Settings_IniConfig_New(const FileName: AWideString): AConfig;
var
  S: TIniSettings;
begin
  S := TIniSettings.Create;
  S.OpenIniFile(FileName);
  Result := Integer(S);
end;

function Settings_ReadBool(Config: AConfig; const Section, Name: AWideString; DefValue: ABoolean): ABoolean;
begin
  if (Config <> 0) then
    Result := TAbstractSettings(Config).ReadBool(Section, Name, DefValue)
  else
    Result := DefValue;
end;

function Settings_ReadDateTime(Config: AConfig; const Section, Name: AWideString; DefValue: TDateTime): TDateTime;
begin
  if (Config <> 0) then
    Result := TAbstractSettings(Config).ReadDateTime(Section, Name, DefValue)
  else
    Result := DefValue;
end;

function Settings_ReadFloat(Config: AConfig; const Section, Name: AWideString; DefValue: AFloat): AFloat;
begin
  if (Config <> 0) then
    Result := TAbstractSettings(Config).ReadFloat(Section, Name, DefValue)
  else
    Result := DefValue;
end;

function Settings_ReadInteger(Config: AConfig; const Section, Name: AWideString; DefValue: AInteger): AInteger;
begin
  if (Config <> 0) then
    Result := TAbstractSettings(Config).ReadInteger(Section, Name, DefValue)
  else
    Result := DefValue;
end;

function Settings_ReadSection(Config: AConfig; const Section: AWideString; Strings: AStringList): ABoolean;
begin
  try
    Result := TAbstractSettings(Config).ReadSection(Section, Strings);
  except
    Result := False;
  end;
end;

function Settings_ReadString(Config: AConfig; const Section, Name, DefValue: AWideString): AWideString;
begin
  if (Config = 0) then
    Result := ''
  else
    TAbstractSettings(Config).ReadString(Section, Name, DefValue, Result);
end;

function Settings_ReadStringA(Config: AConfig; const Section, Name, DefValue: AWideString; out Value: AWideString): AInteger;
begin
  Result := TAbstractSettings(Config).ReadString(Section, Name, DefValue, Value);
end;

function Settings_RegConfig_New(const Prefix: AWideString): AConfig;
begin
  {$IFDEF MSWINDOWS}
  Result := Settings_RegConfig_NewA(Prefix, Integer(HKEY_CURRENT_USER));
  {$ELSE}
  Result := 0;
  {$ENDIF}
end;

function Settings_RegConfig_NewA(const Prefix: AWideString; HKEY: Integer): AConfig;
{$IFDEF MSWINDOWS}
var
  S: TARegistrySettings;
{$ENDIF}
begin
  {$IFDEF MSWINDOWS}
  S := TARegistrySettings.Create;
  S.Registry.RootKey := HKEY;
  S.Prefix := Prefix;
  Result := AConfig(S);
  {$ELSE}
  Result := 0;
  {$ENDIF}
end;

function Settings_WriteBool(Config: AConfig; const Section, Name: AWideString; Value: ABoolean): ABoolean;
begin
  if (Config <> 0) then
    Result := TAbstractSettings(Config).WriteBool(Section, Name, Value)
  else
    Result := False;
end;

function Settings_WriteDateTime(Config: AConfig; const Section, Name: AWideString; Value: TDateTime): ABoolean;
begin
  if (Config <> 0) then
    Result := TAbstractSettings(Config).WriteDateTime(Section, Name, Value)
  else
    Result := False;
end;

function Settings_WriteFloat(Config: AConfig; const Section, Name: AWideString; Value: AFloat): ABoolean;
begin
  if (Config <> 0) then
    Result := TAbstractSettings(Config).WriteFloat(Section, Name, Value)
  else
    Result := False;
end;

function Settings_WriteInteger(Config: AConfig; const Section, Name: AWideString; Value: AInteger): ABoolean;
begin
  if (Config <> 0) then
    Result := TAbstractSettings(Config).WriteInteger(Section, Name, Value)
  else
    Result := False;
end;

function Settings_WriteString(Config: AConfig; const Section, Name, Value: AWideString): ABoolean;
begin
  if (Config <> 0) then
    Result := TAbstractSettings(Config).WriteString(Section, Name, Value)
  else
    Result := False;
end;

{initialization
  ASettings_SetProcs(Addr(Settings));}
end.
