{
Abstract: Reading and writing settings from INI file
Author:  Prof1983 <prof1983@yandex.ru>
Created: 24.03.2008
LastMod: 09.06.2011
Version: 0.1.1+0.2.6+0.3.1
}
unit AIniSettings;

interface

uses
  Classes, IniFiles, SysUtils,
  ABase0, ACollections0, {$IFDEF A01}AUtils01{$ELSE}AUtils0{$ENDIF},
  AAbstractSettings;

type
  TIniSettings = class(TAbstractSettings)
  private
    FIniFile: TIniFile;
  public
    procedure Close; override;
    function DeleteKey(const Section, Name: AWideString): ABoolean; override;
    function DeleteSection(const Section: AWideString): ABoolean; override;
    procedure OpenIniFile(const FileName: AWideString);
    function ReadSection(const Section: AWideString; Strings: AStringList): ABoolean; override;
    function ReadString(const Section, Name, DefValue: AWideString; out Value: AWideString): AInteger; override;
    function WriteString(const Section, Name, Value: AWideString): ABoolean; override;
  end;

implementation

{ TIniSettings }

procedure TIniSettings.Close;
begin
  if Assigned(FIniFile) then
  try
    FIniFile.Free;
  finally
    FIniFile := nil;
  end;
end;

function TIniSettings.DeleteKey(const Section, Name: AWideString): ABoolean;
begin
  Result := False;
  if Assigned(FIniFile) then
  try
    FIniFile.DeleteKey(Section, Name);
    Result := True;
  except
  end;
end;

function TIniSettings.DeleteSection(const Section: AWideString): ABoolean;
begin
  Result := False;
  if Assigned(FIniFile) then
  try
    FIniFile.EraseSection(Section);
    Result := True;
  except
  end;
end;

procedure TIniSettings.OpenIniFile(const FileName: AWideString);
begin
  Close;
  try
    FIniFile := TIniFile.Create(FileName);
  except
    FIniFile := nil;
  end;
end;

function TIniSettings.ReadSection(const Section: AWideString; Strings: AStringList): ABoolean;
var
  Values: TStringList;
  I: Integer;
begin
  if not(Assigned(FIniFile)) then
  begin
    Result := False;
    Exit;
  end;
  ACollections.StringList_Clear(Strings);
  Values := TStringList.Create;
  try
    FIniFile.ReadSectionValues(Section, Values);
    for I := 0 to Values.Count - 1 do
      ACollections.StringList_AddW(Strings, Values.Strings[I]); //TStrings(Strings).Add(Values.Strings[I]);
  finally
    Values.Free;
  end;
  Result := True;
  {Result := Assigned(FIniFile);
  if Result then
  begin
    Values := TStringList.Create;
    try
      FIniFile.ReadSectionValues(Section, Values);
      for I := 0 to Values.Count - 1 do
        TStrings(Strings).Add(Values.Strings[I]);
    finally
      Values.Free;
    end;
  end;}
end;

function TIniSettings.ReadString(const Section, Name, DefValue: AWideString; out Value: AWideString): AInteger;
begin
  if Assigned(FIniFile) then
    Value := FIniFile.ReadString(Section, Name, DefValue)
  else
    Value := DefValue;
  Result := Length(Value);
end;

function TIniSettings.WriteString(const Section, Name, Value: AWideString): ABoolean;
begin
  Result := Assigned(FIniFile);
  if Result then
    FIniFile.WriteString(Section, Name, Value);
end;

end.
