{
Abstract:     
Author:  Prof1983 <prof1983@yandex.ru>
Created: 06.03.2008
LastMod: 04.06.2011
Version: 0.2.6+0.3.1
}
unit AAbstractSettings;

{DEFINE USE_AUTILS}

interface

uses
  SysUtils, ABase0, ACollections0{$IFDEF USE_AUTILS}, AUtils0{$ENDIF};

type
  {
    @abstract(     )
       Boolean, DateTime, Float, Integer  .
        -   ReadString  WriteString
          .
        TSettings  TIniSettings.
  }
  TAbstractSettings = class
  private
    FFormatSettings: TFormatSettings;
  public
    procedure Close; virtual;
    function DeleteKey(const Section, Name: AWideString): ABoolean; virtual;
    function DeleteSection(const Section: AWideString): ABoolean; virtual;
    function ReadBool(const Section, Name: AWideString; DefValue: ABoolean): ABoolean; virtual;
    function ReadInteger(const Section, Name: AWideString; DefValue: AInteger): AInteger; virtual;
    function ReadFloat(const Section, Name: AWideString; DefValue: AFloat): AFloat; virtual;
    function ReadSection(const Section: AWideString; Strings: AStringList): ABoolean; virtual;
    function ReadString(const Section, Name, DefValue: AWideString; out Value: AWideString): AInteger; virtual;
    function ReadDateTime(const Section, Name: AWideString; DefValue: TDateTime): TDateTime; virtual;
    function WriteBool(const Section, Name: AWideString; Value: Boolean): ABoolean; virtual;
    function WriteInteger(const Section, Name: AWideString; Value: Integer): ABoolean; virtual;
    function WriteFloat(const Section, Name: AWideString; Value: Double): ABoolean; virtual;
    function WriteString(const Section, Name, Value: AWideString): ABoolean; virtual;
    function WriteDateTime(const Section, Name: AWideString; Value: TDateTime): ABoolean; virtual;
  public
    constructor Create;
  end;

(*
type
  {
    @abstract(    )
              (WideString).
           TSettingsLoader  TSettingsSaver.
  }
  TSettings = class(TAbstractSettings)
  private
    //    
    FRoot: TANode;
  protected
    function GetRoot(): IANode; override;
  public
    function DeleteKey(const Section, Name: AString): ABoolean; override;
    function DeleteSection(const Section: AString): ABoolean; override;
    function ReadString(const Section, Name, DefValue: AString): AString; override;
    function WriteString(const Section, Name, Value: AString): ABoolean; override;
  public
    constructor Create();
  public
    //    
    property Root: TANode read FRoot;
  end;
*)

implementation

{ TAbstractSettings }

procedure TAbstractSettings.Close;
begin
end;

constructor TAbstractSettings.Create;
begin
  inherited;
  {IFNDEF UNIX}
  //   
  {$IFDEF FPC}
  GetFormatSettings;
  FFormatSettings := DefaultFormatSettings;
  {$ELSE}
  GetLocaleFormatSettings(0, FFormatSettings);
  {$ENDIF}
  FFormatSettings.DecimalSeparator := '.';
  FFormatSettings.DateSeparator := '.';
  FFormatSettings.TimeSeparator := ':';
  FFormatSettings.ShortDateFormat := 'dd.MM.yyyy';
  FFormatSettings.ShortTimeFormat := 'h:mm:ss';
  FFormatSettings.LongTimeFormat := 'h:mm:ss.nnnn';
  {ENDIF}
end;

function TAbstractSettings.DeleteKey(const Section, Name: AWideString): ABoolean;
begin
  Result := False;
end;

function TAbstractSettings.DeleteSection(const Section: AWideString): ABoolean;
begin
  Result := False;
end;

function TAbstractSettings.ReadBool(const Section, Name: AWideString; DefValue: ABoolean): ABoolean;
var
  S: AWideString;
begin
  ReadString(Section, Name, '', S);
  if (S = STR_BOOL[True]) then
    Result := True
  else if (S = STR_BOOL[False]) then
    Result := False
  else
    Result := DefValue;
end;

function TAbstractSettings.ReadDateTime(const Section, Name: AWideString; DefValue: TDateTime): TDateTime;
var
  S: AWideString;
begin
  {IFNDEF UNIX}
  Result := DefValue;
  ReadString(Section, Name, '', S);
  if (S <> '') then
  begin
    {$IFDEF FPC}
    TryStrToDateTime(S, Result);
    {$ELSE}
    TryStrToDateTime(S, Result, FFormatSettings);
    {$ENDIF}
  end;
  {ENDIF}
end;

function TAbstractSettings.ReadFloat(const Section, Name: AWideString; DefValue: AFloat): AFloat;
var
  S: AWideString;
begin
  Result := DefValue;
  ReadString(Section, Name, '', S);
  {$IFDEF USE_AUTILS}
  if (S <> '') then
    Utils_TryStrToFloat(S, Result);
  {$ELSE}
  if (S <> '') then
    TryStrToFloat(S, Result, FFormatSettings);
  {$ENDIF}
end;

function TAbstractSettings.ReadInteger(const Section, Name: AWideString; DefValue: AInteger): AInteger;
var
  S: AWideString;
begin
  Result := DefValue;
  ReadString(Section, Name, '', S);
  if (S <> '') then
    TryStrToInt(S, Result);
end;

function TAbstractSettings.ReadSection(const Section: AWideString; Strings: AStringList): ABoolean;
begin
  Result := False;
end;

function TAbstractSettings.ReadString(const Section, Name, DefValue: AWideString; out Value: AWideString): AInteger;
begin
  Value := DefValue;
  Result := 0;
end;

function TAbstractSettings.WriteBool(const Section, Name: AWideString; Value: ABoolean): ABoolean;
begin
  Result := WriteString(Section, Name, STR_BOOL[Value]);
end;

function TAbstractSettings.WriteDateTime(const Section, Name: AWideString; Value: TDateTime): ABoolean;
begin
  {IFDEF UNIX}
  //Result := False;
  {ELSE}
  {$IFDEF FPC}
  Result := WriteString(Section, Name, DateTimeToStr(Value));
  {$ELSE}
  Result := WriteString(Section, Name, DateTimeToStr(Value, FFormatSettings));
  {$ENDIF}
  {ENDIF}
end;

function TAbstractSettings.WriteFloat(const Section, Name: AWideString; Value: AFloat): ABoolean;
begin
  {$IFDEF UNIX}
  Result := False;
  {$ELSE}
  Result := WriteString(Section, Name, FloatToStr(Value, FFormatSettings));
  {$ENDIF}
end;

function TAbstractSettings.WriteInteger(const Section, Name: AWideString; Value: AInteger): ABoolean;
begin
  Result := WriteString(Section, Name, IntToStr(Value));
end;

function TAbstractSettings.WriteString(const Section, Name, Value: AWideString): ABoolean;
begin
  Result := False;
end;

{ TSettings }

(*
constructor TSettings.Create;
begin
  inherited;
  FRoot := TANode.Create();
end;

function TSettings.DeleteKey(const Section, Name: AString): ABoolean;
var
  node: IANode;
begin
  Result := False;
  node := FRoot.GetChildNodeByName(Section);
  if Assigned(node) then
    Result := node.DeleteAttribute(Name);
end;

function TSettings.DeleteSection(const Section: AString): ABoolean;
begin
  Result := FRoot.DeleteChildNode(Section);
end;

function TSettings.GetRoot: IANode;
begin
  Result := FRoot;
end;

function TSettings.ReadString(const Section, Name, DefValue: AString): AString;
var
  attr: IAAttribute;
  node: IANode;
begin
  Result := DefValue;
  node := FRoot.GetChildNodeByName(Section);
  if Assigned(node) then
  begin
    attr := node.GetAttributeByName(Name);
    if Assigned(attr) then
      Result := attr.AttributeValue;
  end;
end;

function TSettings.WriteString(const Section, Name, Value: AString): ABoolean;
var
  attr: IAAttribute;
  node: IANode;
begin
  node := FRoot.GetChildNodeByName(Section);
  if not(Assigned(node)) then
  begin
    node := TANode.Create();
    node.NodeName := Section;
    FRoot.AddChildNode(node);
  end;
  attr := node.GetAttributeByName(Name);
  if not(Assigned(attr)) then
  begin
    attr := TAAttribute.Create();
    attr.AttributeName := Name;
    node.AddAttribute(attr);
  end;
  attr.AttributeValue := Value;
  Result := True;
end;
*)

end.
