{
Author:  Prof1983 <prof1983@yandex.ru>
Created: 19.08.2009
LastMod: 08.06.2011
Version: 0.3.1
}
unit ARuntime03;

interface

uses
  ABase0, ARuntime0;

function Runtime_IsShutdown: ABoolean; stdcall;
//   
function Runtime_Shutdown: AInteger; stdcall;

function Runtime_Module_Register(Module: AModule): AInteger; stdcall;

function Runtime_Modules_AddModule(Module: AModule): AInteger; stdcall;
function Runtime_Modules_Count: AInteger; stdcall;
function Runtime_Modules_DeleteByIndex(Index: AInteger): AInteger; stdcall;
function Runtime_Modules_DeleteByName(Name: PChar): AInteger; stdcall;
function Runtime_Modules_DeleteByUid(Uid: AModuleUid): AInteger; stdcall;
function Runtime_Modules_FindByName(Name: PChar): AInteger; stdcall;
function Runtime_Modules_FindByUid(Uid: AModuleUid): AInteger; stdcall;
function Runtime_Modules_GetByName(Name: PChar; Module: AModule): AInteger; stdcall; //deprecated;
//       -1   .
function Runtime_Modules_GetByUid(Uid: AModuleUid; Module: AModule): AInteger; stdcall; //deprecated;
function Runtime_Modules_GetNameByIndex(Index: AInteger; Name: PChar; MaxLen: AInteger): AInteger; stdcall;
function Runtime_Modules_GetProcsByUid(Uid: AModuleUid): Pointer; stdcall;
function Runtime_Modules_GetUidByIndex(Index: AInteger): AModuleUid; stdcall;
function Runtime_Modules_InitByName(Name: PChar): AInteger; stdcall;
function Runtime_Modules_InitByUid(Uid: AModuleUid): AInteger; stdcall;

// --- Set event functions ---
procedure Runtime_OnAfterRun_Set(Value: ARuntimeProc); stdcall;
procedure Runtime_OnBeforeRun_Set(Value: ARuntimeProc); stdcall;
procedure Runtime_OnRun_Set(Value: ARuntimeProc); stdcall;
procedure Runtime_OnShutdown_Set(Value: ARuntimeProc); stdcall;

// --- Module ---

// Preinitialize Runtime
function Runtime_Boot: AInteger; stdcall;
// Initialize Runtime
function Runtime_Init: AInteger; stdcall;
// Call OnBeforeRun, OnRun, OnAfterRun procs
function Runtime_Run: AInteger; stdcall;
// Done Runtime (Shutdown, Work end, Unloading of modules)
function Runtime_Done: AInteger; stdcall;

implementation

const // 64x4
  RuntimeProcs: ARuntimeProcs_Type = (
    OnAfterRun_Set: Runtime_OnAfterRun_Set;
    OnBeforeRun_Set: Runtime_OnBeforeRun_Set;
    OnRun_Set: Runtime_OnRun_Set;
    OnShutdown_Set: Runtime_OnShutdown_Set;

    Modules_AddModule: Runtime_Modules_AddModule;
    Modules_Count: Runtime_Modules_Count;
    Modules_FindByName: Runtime_Modules_FindByName;
    Modules_FindByUid: Runtime_Modules_FindByUid;
    Modules_DeleteByName: Runtime_Modules_DeleteByName;
    Modules_DeleteByUid: Runtime_Modules_DeleteByUid;
    Modules_GetByName: Runtime_Modules_GetByName;
    Modules_GetByUid: Runtime_Modules_GetByUid;
    Modules_GetNameByIndex: Runtime_Modules_GetNameByIndex;
    Modules_GetUidByIndex: Runtime_Modules_GetUidByIndex;
    Modules_InitByName: Runtime_Modules_InitByName;
    Modules_InitByUid: Runtime_Modules_InitByUid;

    IsShutdown: Runtime_IsShutdown;
    Shutdown: Runtime_Shutdown;
    Module_Register: Runtime_Module_Register;
    Modules_GetProcsByUid: Runtime_Modules_GetProcsByUid;
    Reserved20: 0;
    Reserved21: 0;
    Reserved22: 0;
    Reserved23: 0;
    Reserved24: 0;
    Reserved25: 0;
    Reserved26: 0;
    Reserved27: 0;
    Reserved28: 0;
    Reserved29: 0;
    Reserved30: 0;
    Reserved31: 0;

    Reserved32: 0;
    Reserved33: 0;
    Reserved34: 0;
    Reserved35: 0;
    Reserved36: 0;
    Reserved37: 0;
    Reserved38: 0;
    Reserved39: 0;
    Reserved40: 0;
    Reserved41: 0;
    Reserved42: 0;
    Reserved43: 0;
    Reserved44: 0;
    Reserved45: 0;
    Reserved46: 0;
    Reserved47: 0;
    Reserved48: 0;
    Reserved49: 0;
    Reserved50: 0;
    Reserved51: 0;
    Reserved52: 0;
    Reserved53: 0;
    Reserved54: 0;
    Reserved55: 0;
    Reserved56: 0;
    Reserved57: 0;
    Reserved58: 0;
    Reserved59: 0;
    Reserved60: 0;
    Reserved61: 0;
    Reserved62: 0;
    Reserved63: 0;
    );

var
  FIsShutdown: ABoolean;
  FModules: array of AModule_Type;
  FOnAfterRun: ARuntimeProc;
  FOnBeforeRun: ARuntimeProc;
  FOnRun: ARuntimeProc;
  FOnShutdown: ARuntimeProc;

exports
  Runtime_IsShutdown,
  Runtime_OnRun_Set,
  Runtime_OnShutdown_Set;

{ Private procs }

function FindModuleByUid(Uid: AModuleUid): AInteger;
var
  I: Integer;
begin
  for I := 0 to High(FModules) do
  begin
    if (FModules[I].UID = UID) then
    begin
      Result := I;
      Exit;
    end;
  end;
  Result := -1;
end;

function FindModuleByName(const Name: string): AInteger;
var
  I: Integer;
begin
  for I := 0 to High(FModules) do
  begin
    if (string(FModules[I].Name) = Name) then
    begin
      Result := I;
      Exit;
    end;
  end;
  Result := -1;
end;

{ Core Public }

function Runtime_Done: AInteger; stdcall;
var
  UID: AInteger;
begin
  while (Length(FModules) > 0) do
  begin
    UID := FModules[0].UID;
    if Assigned(FModules[0].Done) then
    try
      FModules[0].Done;
    except
    end;
    // , ..   Module.Done    Runtime_Modules_DeleteByUID  Runtime_Modules_DeleteByName
    if (Length(FModules) > 0) and (FModules[0].UID = UID) then
      Runtime_Modules_DeleteByIndex(0);
  end;
  Result := 0;
end;
{procedure Runtime_Done; stdcall;
var
  Name: AString;
begin
  while (Length(FModules) > 0) do
  begin
    Name := FModules[0].Name;
    if Assigned(FModules[0].Done) then
    try
      FModules[0].Done;
    except
    end;
    // , ..   Module.Done    Runtime_Module_DeleteByName
    if (Length(FModules) > 0) and (FModules[0].Name = Name) then
      Runtime_Module_Delete(0);
  end;
end;}

{ Runtime procs }

function Runtime_Boot: AInteger; stdcall;
begin
  Runtime_SetProcs(Addr(RuntimeProcs));
  Result := 0;
end;

function Runtime_Init: AInteger; stdcall;
begin
  Result := 0;
end;

function Runtime_IsShutdown: ABoolean; stdcall;
begin
  Result := FIsShutdown;
end;

{ Runtime_Module }

function Runtime_Module_Register(Module: AModule): AInteger; stdcall;
begin
  if not(Assigned(Module)) then
  begin
    Result := -1;
    Exit;
  end;
  if (FindModuleByUid(Module^.Uid) >= 0) then
  begin
    Result := -2;
    Exit;
  end;
  if (FindModuleByName(Module^.Name) >= 0) then
  begin
    Result := -3;
    Exit;
  end;
  Result := Runtime_Modules_AddModule(Module);
end;

{ Runtime_Modules }

function Runtime_Modules_AddModule(Module: AModule): AInteger; stdcall;
begin
  if Assigned(Module) then
  begin
    Result := Length(FModules);
    SetLength(FModules, Result+1);
    //FModules[Result] := Module^;
    FModules[Result].Version := Module^.Version;
    FModules[Result].Uid := Module^.Uid;
    FModules[Result].Name := Module^.Name;
    FModules[Result].Description := Module^.Description;
    FModules[Result].Init := Module^.Init;
    FModules[Result].Done := Module^.Done;
    FModules[Result].Reserved06 := Module^.Reserved06;
    FModules[Result].Procs := Module^.Procs;
  end
  else
    Result := -1;
end;

function Runtime_Modules_Count: AInteger; stdcall;
begin
  Result := Length(FModules);
end;

function Runtime_Modules_DeleteByIndex(Index: AInteger): AInteger; stdcall;
var
  I: Integer;
begin
  if (Index >= 0) and (Length(FModules) > 0) then
  begin
    for I := Index to High(FModules)-1 do
      FModules[I] := FModules[I+1];
    SetLength(FModules, High(FModules));
  end;
  Result := 0;
end;

function Runtime_Modules_DeleteByName(Name: PChar): AInteger; stdcall;
var
  Index: Integer;
begin
  Index := Runtime_Modules_FindByName(Name);
  Result := Runtime_Modules_DeleteByIndex(Index);
end;

function Runtime_Modules_DeleteByUid(Uid: AModuleUid): AInteger; stdcall;
var
  Index: Integer;
begin
  Index := Runtime_Modules_FindByUID(UID);
  Result := Runtime_Modules_DeleteByIndex(Index);
end;

function Runtime_Modules_FindByName(Name: PChar): AInteger; stdcall;
begin
  Result := FindModuleByName(Name);
end;

function Runtime_Modules_FindByUid(Uid: AModuleUid): AInteger; stdcall;
begin
  Result := FindModuleByUid(Uid);
end;

function Runtime_Modules_GetByName(Name: PChar; Module: AModule): AInteger; stdcall;
var
  I: Integer;
begin
  I := Runtime_Modules_FindByName(Name);
  if (I >= 0) then
  begin
    Module^ := FModules[I];
    Result := I;
  end
  else
    Result := 0;
end;

function Runtime_Modules_GetByUid(Uid: AModuleUid; Module: AModule): AInteger; stdcall;
var
  I: Integer;
begin
  I := Runtime_Modules_FindByUid(Uid);
  if (I >= 0) then
  begin
    Module^ := FModules[I];
    Result := I;
  end
  else
    Result := -1;
end;

function Runtime_Modules_GetNameByIndex(Index: AInteger; Name: PChar; MaxLen: AInteger): AInteger; stdcall;
begin
  FillChar(Name^, MaxLen, 0);
  if (Index >= 0) and (Index < Length(FModules)) then
  begin
    Result := Length(FModules[Index].Name);
    if (Result < MaxLen) then
      Move(FModules[Index].Name^, Name^, Result); //Name := PChar(FModules[Index].Name);
  end
  else
    Result := 0;
end;

function Runtime_Modules_GetNameByUid(Uid: AInteger; Name: PChar; MaxLen: AInteger): AInteger; stdcall;
var
  Index: Integer;
begin
  Index := Runtime_Modules_FindByUid(Uid);
  if (Index >= 0) and (Index < Length(FModules)) then
  begin
    Result := Length(FModules[Index].Name);
    if (Result < MaxLen) then
      Name := PChar(FModules[Index].Name);
  end
  else
  begin
    Name := PChar('');
    Result := 0;
  end;
end;

function Runtime_Modules_GetProcsByUid(Uid: AModuleUid): Pointer; stdcall;
var
  Index: Integer;
begin
  Index := Runtime_Modules_FindByUid(Uid);
  if (Index >= 0) and (Index < Length(FModules)) then
    Result := FModules[Index].Procs
  else
    Result := nil;
end;

function Runtime_Modules_GetUidByIndex(Index: AInteger): AModuleUid; stdcall;
begin
  if (Index >= 0) and (Index < Length(FModules)) then
    Result := FModules[Index].Uid
  else
    Result := 0;
end;

function Runtime_Modules_InitByName(Name: PChar): AInteger; stdcall;
var
  I: Integer;
begin
  I := Runtime_Modules_FindByName(Name);
  if (I < 0) then
  begin
    Result := -1;
    Exit;
  end;
  try
    Result := FModules[I].Init;
  except
    Result := -1;
  end;
end;

function Runtime_Modules_InitByUid(Uid: AModuleUid): AInteger; stdcall;
var
  I: Integer;
begin
  I := Runtime_Modules_FindByUid(Uid);
  if (I < 0) then
  begin
    Result := -1;
    Exit;
  end;
  try
    Result := FModules[I].Init;
  except
    Result := -1;
  end;
end;

procedure Runtime_OnAfterRun_Set(Value: ARuntimeProc); stdcall;
begin
  FOnAfterRun := Value;
end;

procedure Runtime_OnBeforeRun_Set(Value: ARuntimeProc); stdcall;
begin
  FOnBeforeRun := Value;
end;

procedure Runtime_OnRun_Set(Value: ARuntimeProc); stdcall;
begin
  FOnRun := Value;
end;

procedure Runtime_OnShutdown_Set(Value: ARuntimeProc); stdcall;
begin
  FOnShutdown := Value;
end;

function Runtime_Run: AInteger; stdcall;
begin
  if Assigned(FOnBeforeRun) then
    FOnBeforeRun;
  if Assigned(FOnRun) then
    FOnRun;
  if Assigned(FOnAfterRun) then
    FOnAfterRun;
  Result := 0;
end;

function Runtime_Shutdown: AInteger; stdcall;
begin
  FIsShutdown := True;
  if Assigned(FOnShutdown) then
    FOnShutdown;
  Result := 0;
end;

{initialization
  Runtime_Boot;}
end.
